/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.script.SV;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Font;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;

public class Draw
extends MeshCollection {
    private static final int PT_COORD = 1;
    private static final int PT_IDENTIFIER = 2;
    private static final int PT_BITSET = 3;
    private static final int PT_MODEL_INDEX = 4;
    private static final int PT_MODEL_BASED_POINTS = 5;
    DrawMesh[] dmeshes = new DrawMesh[4];
    private DrawMesh thisMesh;
    private P3[] ptList;
    private V3 offset = new V3();
    private int nPoints;
    private int diameter;
    private float width;
    private float newScale;
    private float length;
    private boolean isCurve;
    private boolean isArc;
    private boolean isArrow;
    private boolean isLine;
    private boolean isVector;
    private boolean isCircle;
    private boolean isPerpendicular;
    private boolean isCylinder;
    private boolean isVertices;
    private boolean isPlane;
    private boolean isReversed;
    private boolean isRotated45;
    private boolean isCrossed;
    private boolean isValid;
    private boolean noHead;
    private boolean isBarb;
    private int indicatedModelIndex = -1;
    private boolean indicatedModelOnly;
    private int[] modelInfo;
    private boolean makePoints;
    private P4 plane;
    private BS bsAllModels;
    private Lst<Object> polygon;
    private Lst<Object[]> vData;
    private String intersectID;
    private Lst<P3[]> lineData;
    public int defaultFontId0 = -1;
    public int defaultFontId = -1;
    private int thisFontID = -1;
    private Integer titleColor;
    private int imodel = -1;
    MeshSurface slabData;
    private final V3 vAB = new V3();
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();
    private float defaultFontSize = 16.0f;
    private Mesh pm2;
    private int dmin22;
    private int pmod2;
    private int pickedVertex2;
    private T3 pickedPoint2;

    public Draw() {
        this.htObjects = new Hashtable();
    }

    @Override
    public void allocMesh(String thisID, Mesh m) {
        int index = this.meshCount++;
        this.dmeshes = (DrawMesh[])AU.ensureLength(this.dmeshes, this.meshCount * 2);
        this.meshes = this.dmeshes;
        this.dmeshes[index] = m == null ? new DrawMesh(this.vwr, thisID, this.colix, index) : (DrawMesh)m;
        this.thisMesh = this.dmeshes[index];
        this.currentMesh = this.dmeshes[index];
        this.currentMesh.color = this.color;
        this.currentMesh.index = index;
        if (thisID != null && thisID != "+PREVIOUS_MESH+" && this.htObjects != null) {
            this.htObjects.put(thisID.toUpperCase(), this.currentMesh);
        }
    }

    private void setPropertySuper(String propertyName, Object value, BS bs) {
        this.currentMesh = this.thisMesh;
        this.setPropMC(propertyName, value, bs);
        this.thisMesh = (DrawMesh)this.currentMesh;
    }

    @Override
    public void initShape() {
        this.setMeshColor();
        this.myType = "draw";
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("set" == propertyName) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
                this.thisMesh.colix = this.colix;
                this.thisMesh.color = this.color;
            }
            boolean bl = this.thisMesh.isValid = this.isValid ? this.setDrawing((int[])value) : false;
            if (this.thisMesh.isValid) {
                if (this.thisMesh.vc > 2 && this.length != Float.MAX_VALUE && this.newScale == 1.0f) {
                    this.newScale = this.length;
                }
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
                Draw.setAxes(this.thisMesh);
                this.thisMesh.title = this.title;
                this.thisMesh.titleColor = this.titleColor;
                this.thisMesh.fontID = this.thisFontID;
                this.thisMesh.visible = true;
            }
            this.nPoints = -1;
            this.vData = null;
            this.lineData = null;
            return;
        }
        if ("init" == propertyName) {
            this.initDraw();
            this.setPropertySuper("init", value, bs);
            return;
        }
        if ("font" == propertyName) {
            this.defaultFontId = value == null ? -1 : ((Font)value).fid;
            this.defaultFontSize = value == null ? 16.0f : ((Font)value).fontSize;
            return;
        }
        if ("myfont" == propertyName) {
            this.thisFontID = ((Font)value).fid;
            if (this.thisMesh != null) {
                this.thisMesh.fontID = this.thisFontID;
            }
            return;
        }
        if ("length" == propertyName) {
            this.length = ((Number)value).floatValue();
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            return;
        }
        if ("intersect" == propertyName) {
            this.intersectID = (String)value;
            return;
        }
        if ("slab" == propertyName) {
            int meshIndex = this.getIndexFromName((String)value);
            if (meshIndex < 0) {
                return;
            }
            Mesh m = this.meshes[meshIndex];
            if (m.checkByteCount != 1) {
                return;
            }
            MeshSurface ms = new MeshSurface();
            ms.vs = m.vs;
            ms.vvs = new float[m.vc];
            ms.vc = m.vc;
            ms.pis = m.pis;
            ms.pc = m.pc;
            ms.dataOnly = true;
            this.slabData = ms;
        }
        if ("lineData" == propertyName) {
            this.lineData = new Lst();
            if (this.indicatedModelIndex < 0) {
                this.indicatedModelIndex = this.vwr.am.cmi;
            }
            if (this.modelInfo == null) {
                this.modelInfo = new int[]{this.indicatedModelIndex, 0};
            }
            float[] fdata = (float[])value;
            int n = fdata.length / 6;
            int pt = 0;
            for (int i = 0; i < n; ++i) {
                this.lineData.addLast(new P3[]{P3.new3(fdata[pt++], fdata[pt++], fdata[pt++]), P3.new3(fdata[pt++], fdata[pt++], fdata[pt++])});
            }
            return;
        }
        if ("imodel" == propertyName) {
            this.imodel = (Integer)value;
            return;
        }
        if ("modelIndex" == propertyName) {
            this.indicatedModelIndex = (Integer)value;
            if (this.indicatedModelIndex < 0 || this.indicatedModelIndex >= this.ms.mc) {
                return;
            }
            this.modelInfo = new int[]{this.indicatedModelIndex, 0};
            this.vData.addLast(new Object[]{4, this.modelInfo});
            if (this.thisMesh.thisID.startsWith("_!_")) {
                this.indicatedModelOnly = true;
            }
            return;
        }
        if ("planedef" == propertyName) {
            this.plane = (P4)value;
            if (this.intersectID != null || this.slabData != null) {
                return;
            }
            if (this.isCircle || this.isArc) {
                this.isPlane = true;
            }
            this.vData.addLast(new Object[]{1, P3.new3(Float.NaN, Float.NaN, Float.NaN)});
            return;
        }
        if ("perp" == propertyName) {
            this.isPerpendicular = true;
            return;
        }
        if ("cylinder" == propertyName) {
            this.isCylinder = true;
            return;
        }
        if ("plane" == propertyName) {
            this.isPlane = true;
            return;
        }
        if ("curve" == propertyName) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == propertyName) {
            this.isArrow = true;
            return;
        }
        if ("line" == propertyName) {
            this.isLine = true;
            this.isCurve = true;
            return;
        }
        if ("arc" == propertyName) {
            this.isCurve = true;
            this.isArc = true;
            if (this.isArrow) {
                this.isArrow = false;
                this.isVector = true;
            }
            return;
        }
        if ("circle" == propertyName) {
            this.isCircle = true;
            return;
        }
        if ("vector" == propertyName) {
            this.isArrow = true;
            this.isVector = true;
            return;
        }
        if ("vertices" == propertyName) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == propertyName) {
            this.isReversed = true;
            return;
        }
        if ("nohead" == propertyName) {
            this.noHead = true;
            return;
        }
        if ("isbarb" == propertyName) {
            this.isBarb = true;
            return;
        }
        if ("rotate45" == propertyName) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == propertyName) {
            this.isCrossed = true;
            return;
        }
        if ("points" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.thisMesh != null) {
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
            }
            return;
        }
        if ("diameter" == propertyName) {
            this.diameter = ((Number)value).intValue();
            return;
        }
        if ("width" == propertyName) {
            this.width = ((Number)value).floatValue();
            return;
        }
        if ("identifier" == propertyName) {
            String thisID = (String)value;
            int meshIndex = this.getIndexFromName(thisID);
            if (meshIndex >= 0) {
                this.vData.addLast(new Object[]{2, new int[]{meshIndex, this.isReversed ? 1 : 0, this.isVertices ? 1 : 0}});
                this.isVertices = false;
                this.isReversed = false;
            } else {
                Logger.error("draw identifier " + value + " not found");
                this.isValid = false;
            }
            return;
        }
        if ("polygon" == propertyName) {
            this.polygon = (Lst)value;
            if (this.polygon == null) {
                this.polygon = new Lst();
            }
            return;
        }
        if ("coord" == propertyName) {
            this.vData.addLast(new Object[]{1, value});
            if (this.indicatedModelIndex >= 0) {
                if (this.modelInfo == null) {
                    this.modelInfo = new int[]{this.indicatedModelIndex, 0};
                }
                this.modelInfo[1] = this.modelInfo[1] + 1;
            }
            return;
        }
        if ("offset" == propertyName) {
            this.offset = V3.newV((P3)value);
            if (this.thisMesh != null) {
                this.thisMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == propertyName) {
            BS bsAtoms = (BS)value;
            if (bsAtoms.isEmpty()) {
                return;
            }
            this.vData.addLast(new Object[]{3, bsAtoms});
            if (this.isCircle && this.diameter == 0 && this.width == 0.0f) {
                this.width = this.ms.calcRotationRadiusBs(bsAtoms) * 2.0f;
            }
            return;
        }
        if ("coords" == propertyName) {
            this.addPoints(1, value);
            return;
        }
        if ("modelBasedPoints" == propertyName) {
            this.addPoints(5, value);
            return;
        }
        if ("hoverlabel" == propertyName) {
            propertyName = "title";
            value = "<hover>" + value;
        }
        if ("title" == propertyName && this.thisMesh != null) {
            this.thisMesh.title = this.setTitle(value);
            return;
        }
        if ("titlecolor" == propertyName) {
            Integer c;
            this.titleColor = c = (Integer)value;
            if (this.thisMesh != null) {
                this.thisMesh.titleColor = c;
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            this.deleteModels(((int[])((Object[])value)[2])[0]);
            return;
        }
        this.setPropertySuper(propertyName, value, bs);
    }

    private void deleteModels(int modelIndex) {
        int i = this.meshCount;
        while (--i >= 0) {
            boolean deleteMesh;
            DrawMesh m = this.dmeshes[i];
            if (m == null) continue;
            boolean bl = deleteMesh = m.modelIndex == modelIndex;
            if (m.modelFlags != null) {
                m.deleteAtoms(modelIndex);
                deleteMesh = m.modelFlags.length() == 0;
                if (!deleteMesh) continue;
            }
            if (deleteMesh) {
                --this.meshCount;
                this.deleteMeshElement(i);
                continue;
            }
            if (this.meshes[i].modelIndex <= modelIndex) continue;
            --this.meshes[i].modelIndex;
        }
        this.resetObjects();
    }

    @Override
    protected String[] setTitle(Object value) {
        String lines;
        if (value instanceof String && (lines = (String)value).startsWith("<hover>")) {
            String s = lines.substring(7);
            int i = s.indexOf("</hover>");
            if (i >= 0) {
                this.thisMesh.hoverLabel = s.substring(0, i);
                value = s.substring(i + 8);
            } else {
                this.thisMesh.hoverLabel = s;
                value = "";
            }
        }
        return super.setTitle(value);
    }

    private void deleteMeshElement(int i) {
        if (this.meshes[i] == this.currentMesh) {
            this.thisMesh = null;
            this.currentMesh = null;
        }
        this.dmeshes = (DrawMesh[])AU.deleteElements(this.meshes, i, 1);
        this.meshes = this.dmeshes;
    }

    private void initDraw() {
        this.bsAllModels = null;
        this.colix = (short)5;
        this.color = -1;
        this.diameter = 0;
        this.explicitID = false;
        this.thisFontID = -1;
        this.indicatedModelIndex = -1;
        this.indicatedModelOnly = false;
        this.intersectID = null;
        this.isLine = false;
        this.isCylinder = false;
        this.isCircle = false;
        this.isPlane = false;
        this.isArrow = false;
        this.isArc = false;
        this.isCurve = false;
        this.isBarb = false;
        this.noHead = false;
        this.isCrossed = false;
        this.isRotated45 = false;
        this.isReversed = false;
        this.isFixed = false;
        this.isVector = false;
        this.isVertices = false;
        this.isPerpendicular = false;
        this.isValid = true;
        this.length = Float.MAX_VALUE;
        this.lineData = null;
        this.newScale = 0.0f;
        this.offset = null;
        this.plane = null;
        this.polygon = null;
        this.slabData = null;
        this.titleColor = null;
        this.vData = new Lst();
        this.width = 0.0f;
        this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
    }

    @Override
    public boolean getPropertyData(String property, Object[] data) {
        String id;
        if (property == "id") {
            if (this.currentMesh != null) {
                data[0] = this.currentMesh.thisID;
            }
            return this.currentMesh != null;
        }
        if (property == "keys") {
            Lst keys = data[1] instanceof Lst ? (Lst)data[1] : new Lst();
            data[1] = keys;
            keys.addLast("getSpinAxis");
        }
        if (property == "getCenter") {
            id = (String)data[0];
            int index = (Integer)data[1];
            int modelIndex = (Integer)data[2];
            data[2] = this.getSpinCenter(id, index, modelIndex);
            return data[2] != null;
        }
        if (property == "getSpinAxis") {
            id = (String)data[0];
            int index = (Integer)data[1];
            data[2] = this.getSpinAxis(id, index);
            return data[2] != null;
        }
        return this.getPropDataMC(property, data);
    }

    @Override
    public Object getProperty(String property, int index) {
        DrawMesh m = this.thisMesh;
        if (index >= 0 && (index >= this.meshCount || (m = (DrawMesh)this.meshes[index]) == null)) {
            return null;
        }
        if (property.equals("font")) {
            if (this.defaultFontId < 0) {
                this.setProperty("font", this.vwr.gdata.getFont3DFSS("SansSerif", "Plain", this.vwr.getFloat(0x2200000B)), null);
                this.defaultFontId0 = this.defaultFontId;
            }
            return Font.getFont3D(index < 0 || m.fontID < 0 ? this.defaultFontId : m.fontID);
        }
        if (property == "command") {
            return this.getCommand(m);
        }
        if (property == "type") {
            return m == null ? EnumDrawType.NONE.id : m.drawType.id;
        }
        return this.getPropMC(property, index);
    }

    private T3 getSpinCenter(String axisID, int vertexIndex, int modelIndex) {
        DrawMesh m;
        String id;
        int pt = axisID.indexOf("[");
        if (pt > 0) {
            id = axisID.substring(0, pt);
            int pt2 = axisID.lastIndexOf("]");
            if (pt2 < pt) {
                pt2 = axisID.length();
            }
            try {
                vertexIndex = Integer.parseInt(axisID.substring(pt + 1, pt2));
            }
            catch (Exception exception) {}
        } else {
            id = axisID;
        }
        if ((m = (DrawMesh)this.getMesh(id)) == null || m.vs == null) {
            return null;
        }
        if (vertexIndex == Integer.MAX_VALUE) {
            return P3.new3(m.index + 1, this.meshCount, m.vc);
        }
        if (vertexIndex != Integer.MIN_VALUE) {
            vertexIndex = m.getVertexIndexFromNumber(vertexIndex);
        }
        return vertexIndex >= 0 ? m.vs[vertexIndex] : (m.ptCenters == null || modelIndex < 0 || modelIndex >= m.ptCenters.length ? m.ptCenter : m.ptCenters[modelIndex]);
    }

    private V3 getSpinAxis(String axisID, int modelIndex) {
        DrawMesh m = (DrawMesh)this.getMesh(axisID);
        return m == null || m.vs == null ? null : (m.ptCenters == null || modelIndex < 0 ? m.axis : m.axes[modelIndex]);
    }

    private boolean setDrawing(int[] connections) {
        if (this.thisMesh == null) {
            this.allocMesh(null, null);
        }
        this.thisMesh.clear("draw");
        this.thisMesh.diameter = this.diameter;
        this.thisMesh.width = this.width;
        if (this.plane != null) {
            if (this.intersectID != null) {
                Lst pts = new Lst();
                Object[] data = new Object[]{this.intersectID, this.plane, pts, null};
                this.vwr.shm.getShapePropertyData(24, "intersectPlane", data);
                if (pts.size() > 0) {
                    this.indicatedModelIndex = (Integer)data[3];
                    this.lineData = pts;
                }
            } else if (this.slabData != null) {
                this.slabData.getMeshSlicer().getIntersection(0.0f, this.plane, null, null, null, null, null, false, true, 134217750, false);
                this.polygon = new Lst();
                this.polygon.addLast(this.slabData.vs);
                this.polygon.addLast(this.slabData.pis);
            }
        }
        if (this.polygon == null && (this.lineData == null ? this.vData.size() == 0 == (connections == null) : this.lineData.size() == 0) || !this.isArrow && connections != null) {
            return false;
        }
        int modelCount = this.ms.mc;
        if (this.imodel >= 0 || this.polygon != null || this.lineData != null || this.indicatedModelIndex < 0 && (this.isFixed || this.isArrow || this.isCurve || this.isCircle || this.isCylinder || modelCount == 1)) {
            this.thisMesh.modelIndex = this.imodel >= 0 ? this.imodel : (this.lineData == null ? this.vwr.am.cmi : this.indicatedModelIndex);
            boolean bl = this.thisMesh.isFixed = this.isFixed || this.lineData == null && this.thisMesh.modelIndex < 0 && modelCount > 1;
            if (this.isFixed && modelCount > 1) {
                this.thisMesh.modelIndex = -1;
            } else if (this.lineData == null && this.thisMesh.modelIndex < 0) {
                this.thisMesh.modelIndex = 0;
            }
            this.thisMesh.ptCenters = null;
            this.thisMesh.modelFlags = null;
            this.thisMesh.drawTypes = null;
            this.thisMesh.drawVertexCounts = null;
            this.thisMesh.connectedAtoms = connections;
            if (this.polygon != null) {
                if (this.polygon.size() == 0) {
                    return false;
                }
                this.thisMesh.isDrawPolygon = true;
                this.thisMesh.vs = (P3[])this.polygon.get(0);
                this.thisMesh.pis = (int[][])this.polygon.get(1);
                this.thisMesh.drawVertexCount = this.thisMesh.vc = this.thisMesh.vs.length;
                this.thisMesh.pc = this.thisMesh.pis == null ? -1 : this.thisMesh.pis.length;
                for (int i = 0; i < this.thisMesh.pc; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (this.thisMesh.pis[i][j] < this.thisMesh.vc) continue;
                        return false;
                    }
                }
                this.thisMesh.drawType = EnumDrawType.POLYGON;
                this.thisMesh.checkByteCount = 1;
            } else if (this.lineData != null) {
                this.thisMesh.lineData = this.lineData;
            } else {
                this.thisMesh.setPolygonCount(1);
                if (this.setPoints(-1, -1)) {
                    this.setPoints(-1, this.nPoints);
                }
                this.setPolygon(0);
            }
        } else {
            this.thisMesh.modelIndex = -1;
            this.thisMesh.setPolygonCount(modelCount);
            this.thisMesh.ptCenters = new P3[modelCount];
            this.thisMesh.modelFlags = new BS();
            this.thisMesh.drawTypes = new EnumDrawType[modelCount];
            this.thisMesh.drawVertexCounts = new int[modelCount];
            this.thisMesh.vc = 0;
            if (this.indicatedModelIndex >= 0) {
                this.setPoints(-1, 0);
                this.thisMesh.thisModelOnly = this.indicatedModelOnly;
                this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                this.thisMesh.drawVertexCount = -1;
                this.thisMesh.modelFlags.set(this.indicatedModelIndex);
                this.indicatedModelIndex = -1;
            } else {
                BS bsModels = this.vwr.getVisibleFramesBitSet();
                for (int iModel = 0; iModel < modelCount; ++iModel) {
                    if (bsModels.get(iModel) && this.setPoints(iModel, -1)) {
                        this.setPoints(iModel, this.nPoints);
                        this.setPolygon(iModel);
                        this.thisMesh.setCenter(iModel);
                        this.thisMesh.drawTypes[iModel] = this.thisMesh.drawType;
                        this.thisMesh.drawVertexCounts[iModel] = this.thisMesh.drawVertexCount;
                        this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                        this.thisMesh.drawVertexCount = -1;
                        this.thisMesh.modelFlags.set(iModel);
                        continue;
                    }
                    this.thisMesh.drawTypes[iModel] = EnumDrawType.NONE;
                    this.thisMesh.pis[iModel] = new int[0];
                }
            }
        }
        this.thisMesh.isVector = this.isVector;
        this.thisMesh.noHead = this.noHead;
        this.thisMesh.isBarb = this.isBarb;
        this.thisMesh.width = this.thisMesh.drawType == EnumDrawType.CYLINDER || this.thisMesh.drawType == EnumDrawType.CIRCULARPLANE ? -Math.abs(this.width) : this.width;
        this.thisMesh.setCenter(-1);
        if (this.offset != null) {
            this.thisMesh.offset(this.offset);
        }
        if (this.thisMesh.thisID == null) {
            this.thisMesh.thisID = this.thisMesh.drawType.name + ++this.nUnnamed;
            this.htObjects.put(this.thisMesh.thisID, this.thisMesh);
        }
        this.clean();
        return true;
    }

    @Override
    protected void clean() {
        this.imodel = -1;
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i] != null && (this.meshes[i].vc != 0 || this.meshes[i].connectedAtoms != null || this.meshes[i].lineData != null)) continue;
            this.deleteMeshI(i);
        }
    }

    private void addPoints(int type, Object value) {
        boolean isModelPoints;
        Lst pts = (Lst)value;
        Integer key = type;
        boolean bl = isModelPoints = type == 5;
        if (isModelPoints) {
            this.vData.addLast(new Object[]{key, pts});
        }
        int n = pts.size();
        block4: for (int i = 0; i < n; ++i) {
            P3 pt;
            Object o = pts.get(i);
            if (o instanceof P3) {
                pt = (P3)o;
            } else {
                SV v = (SV)o;
                switch (v.tok) {
                    case 10: {
                        if (!isModelPoints && ((BS)v.value).isEmpty()) continue block4;
                        pt = this.ms.getAtomSetCenter((BS)v.value);
                        break;
                    }
                    case 8: {
                        if (isModelPoints) continue block4;
                    }
                    default: {
                        pt = SV.ptValue(v);
                    }
                }
            }
            if (isModelPoints) {
                pts.set(i, SV.getVariable(pt));
                continue;
            }
            this.vData.addLast(new Object[]{key, pt});
        }
    }

    private void addPoint(T3 newPt, int iModel) {
        if (this.makePoints) {
            if (newPt == null || iModel >= 0 && !this.bsAllModels.get(iModel)) {
                return;
            }
            this.ptList[this.nPoints] = P3.newP(newPt);
            if (Draw.is2DPoint(newPt)) {
                this.thisMesh.haveXyPoints = true;
            }
        } else if (iModel >= 0) {
            this.bsAllModels.set(iModel);
        }
        ++this.nPoints;
    }

    private boolean setPoints(int iModel, int n) {
        boolean bl = this.makePoints = n >= 0;
        if (this.makePoints) {
            this.ptList = new P3[Math.max(5, n)];
            if (this.bsAllModels == null) {
                this.bsAllModels = this.vwr.getVisibleFramesBitSet();
            }
        }
        this.nPoints = 0;
        int nData = this.vData.size();
        int modelIndex = 0;
        BS bsModel = iModel < 0 ? null : this.vwr.getModelUndeletedAtomsBitSet(iModel);
        block7: for (int i = 0; i < nData; ++i) {
            Object[] info = (Object[])this.vData.get(i);
            switch ((Integer)info[0]) {
                case 4: {
                    int j;
                    int[] modelInfo = (int[])info[1];
                    modelIndex = modelInfo[0];
                    this.nPoints = modelInfo[1];
                    int nVertices = Math.max(this.nPoints, 3);
                    int n0 = this.thisMesh.vc;
                    if (this.nPoints <= 0) continue block7;
                    this.thisMesh.pis[modelIndex] = new int[nVertices];
                    int[] p = this.thisMesh.pis[modelIndex];
                    P3 pt = null;
                    for (j = 0; j < this.nPoints; ++j) {
                        info = (Object[])this.vData.get(++i);
                        pt = (P3)info[1];
                        p[j] = this.thisMesh.addV(pt, false);
                    }
                    for (j = this.nPoints; j < 3; ++j) {
                        p[j] = n0 + this.nPoints - 1;
                    }
                    this.thisMesh.haveXyPoints = Draw.is2DPoint(pt);
                    this.thisMesh.drawTypes[modelIndex] = EnumDrawType.getType(this.nPoints);
                    this.thisMesh.drawVertexCounts[modelIndex] = this.nPoints;
                    this.thisMesh.modelFlags.set(modelIndex);
                    continue block7;
                }
                case 1: {
                    this.addPoint((P3)info[1], this.makePoints ? iModel : -1);
                    continue block7;
                }
                case 3: {
                    BS bs = BSUtil.copy((BS)info[1]);
                    if (bsModel != null) {
                        bs.and(bsModel);
                    }
                    if (bs.length() <= 0) continue block7;
                    this.addPoint(this.ms.getAtomSetCenter(bs), this.makePoints ? iModel : -1);
                    continue block7;
                }
                case 2: {
                    boolean isVertices;
                    int[] idInfo = (int[])info[1];
                    DrawMesh m = this.dmeshes[idInfo[0]];
                    boolean isReversed = idInfo[1] == 1;
                    boolean bl2 = isVertices = idInfo[2] == 1;
                    if (m.modelIndex > 0 && m.modelIndex != iModel) {
                        return false;
                    }
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    if (this.isPlane && !this.isCircle || this.isPerpendicular || isVertices) {
                        if (isReversed) {
                            if (iModel < 0 || iModel >= m.pc) {
                                int ipt = m.drawVertexCount;
                                while (--ipt >= 0) {
                                    this.addPoint(m.vs[ipt], iModel);
                                }
                                continue block7;
                            }
                            if (m.pis[iModel] == null) continue block7;
                            int ipt = m.drawVertexCounts[iModel];
                            while (--ipt >= 0) {
                                this.addPoint(m.vs[m.pis[iModel][ipt]], iModel);
                            }
                            continue block7;
                        }
                        if (iModel < 0 || iModel >= m.pc) {
                            for (int ipt = 0; ipt < m.drawVertexCount; ++ipt) {
                                this.addPoint(m.vs[ipt], iModel);
                            }
                            continue block7;
                        }
                        if (m.pis[iModel] == null) continue block7;
                        for (int ipt = 0; ipt < m.drawVertexCounts[iModel]; ++ipt) {
                            this.addPoint(m.vs[m.pis[iModel][ipt]], iModel);
                        }
                        continue block7;
                    }
                    if (iModel < 0 || m.ptCenters == null || m.ptCenters[iModel] == null) {
                        this.addPoint(m.ptCenter, iModel);
                        continue block7;
                    }
                    this.addPoint(m.ptCenters[iModel], iModel);
                    continue block7;
                }
                case 5: {
                    BS bs;
                    Lst modelBasedPoints = (Lst)info[1];
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    for (int j = 0; j < modelBasedPoints.size(); ++j) {
                        if (iModel >= 0 && j != iModel) continue;
                        Object point = modelBasedPoints.get(j);
                        this.bsAllModels.set(j);
                        if (point instanceof P3) {
                            this.addPoint((P3)point, j);
                            continue;
                        }
                        if (point instanceof BS) {
                            bs = (BS)point;
                            if (bsModel != null) {
                                bs.and(bsModel);
                            }
                            if (bs.length() <= 0) continue;
                            this.addPoint(this.ms.getAtomSetCenter(bs), j);
                            continue;
                        }
                        if (!(point instanceof SV)) continue;
                        this.addPoint(SV.ptValue((SV)point), j);
                    }
                    continue block7;
                }
            }
        }
        if (this.makePoints && this.isCrossed && this.nPoints == 4) {
            P3 pt = this.ptList[1];
            this.ptList[1] = this.ptList[2];
            this.ptList[2] = pt;
        }
        return this.nPoints > 0;
    }

    private void setPolygon(int nPoly) {
        int nVertices = this.nPoints;
        EnumDrawType drawType = EnumDrawType.POINT;
        if (this.isArc) {
            if (nVertices >= 2) {
                drawType = EnumDrawType.ARC;
            } else {
                this.isArc = false;
                this.isVector = false;
                this.isCurve = false;
                this.isArrow = true;
            }
        }
        if (this.isCircle) {
            this.length = 0.0f;
            if (nVertices == 2) {
                this.isPlane = true;
            }
            if (!this.isPlane) {
                drawType = EnumDrawType.CIRCLE;
            }
            if (this.width == 0.0f) {
                this.width = 1.0f;
            }
        } else if ((this.isCurve || this.isArrow) && nVertices >= 2 && !this.isArc) {
            EnumDrawType enumDrawType = this.isLine ? EnumDrawType.LINE_SEGMENT : (drawType = this.isCurve ? EnumDrawType.CURVE : EnumDrawType.ARROW);
        }
        if (this.isVector && !this.isArc) {
            if (nVertices > 2) {
                nVertices = 2;
            } else if (this.plane == null && nVertices != 2) {
                this.isVector = false;
            }
        }
        if (this.thisMesh.haveXyPoints) {
            this.isPerpendicular = false;
            if (nVertices == 3 && this.isPlane) {
                this.isPlane = false;
            }
            this.length = Float.MAX_VALUE;
            if (this.isVector) {
                this.thisMesh.diameter = 0;
            }
        } else if (nVertices == 2 && this.isVector) {
            this.ptList[1].add(this.ptList[0]);
        }
        float dist = 0.0f;
        if (this.isArc || this.plane != null && this.isCircle) {
            if (this.plane != null) {
                dist = Measure.distanceToPlane(this.plane, this.ptList[0]);
                V3 vAC = V3.new3(-this.plane.x, -this.plane.y, -this.plane.z);
                vAC.normalize();
                if (dist < 0.0f) {
                    vAC.scale(-1.0f);
                }
                if (this.isCircle) {
                    vAC.scale(0.005f);
                    this.ptList[0].sub(vAC);
                    vAC.scale(2.0f);
                }
                vAC.add(this.ptList[0]);
                this.ptList[1] = P3.newP(vAC);
                EnumDrawType enumDrawType = this.isArrow ? EnumDrawType.ARROW : (drawType = this.isArc ? EnumDrawType.ARC : EnumDrawType.CIRCULARPLANE);
            }
            if (this.isArc) {
                dist = Math.abs(dist);
                if (nVertices <= 3) {
                    if (nVertices == 3) {
                        this.ptList[3] = P3.newP(this.ptList[2]);
                        this.ptList[2] = Draw.randomPoint();
                    } else {
                        if (nVertices == 2) {
                            this.ptList[2] = Draw.randomPoint();
                        }
                        this.ptList[3] = P3.new3(0.0f, 360.0f, 0.0f);
                    }
                }
                if (this.plane != null) {
                    this.ptList[3].z *= dist;
                }
                nVertices = 4;
            }
            this.plane = null;
        } else if (drawType == EnumDrawType.POINT) {
            P3 pt;
            P3 center = new P3();
            V3 normal = new V3();
            if (nVertices == 2 && this.plane != null) {
                this.ptList[1] = P3.newP(this.ptList[0]);
                V3 vTemp = new V3();
                Measure.getPlaneProjection(this.ptList[1], this.plane, this.ptList[1], vTemp);
                nVertices = -2;
                if (this.isArrow) {
                    drawType = EnumDrawType.ARROW;
                }
                this.plane = null;
            }
            if (nVertices == 3 && this.isPlane && !this.isPerpendicular) {
                pt = P3.newP(this.ptList[1]);
                pt.sub(this.ptList[0]);
                pt.scale(0.5f);
                this.ptList[3] = P3.newP(this.ptList[2]);
                this.ptList[2].add(pt);
                this.ptList[3].sub(pt);
                nVertices = 4;
            } else if (nVertices >= 3 && !this.isPlane && this.isPerpendicular) {
                Measure.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB);
                center = new P3();
                Measure.calcAveragePointN(this.ptList, nVertices, center);
                dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                normal.scale(dist);
                this.ptList[0].setT(center);
                this.ptList[1].add2(center, normal);
                nVertices = 2;
            } else if (nVertices == 2 && this.isPerpendicular) {
                Measure.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                float f = dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    dist /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    dist *= 1.4142f;
                }
                Measure.getNormalToLine(this.ptList[0], this.ptList[1], normal);
                normal.scale(dist);
                if (this.isPlane) {
                    this.ptList[2] = P3.newP(center);
                    this.ptList[2].sub(normal);
                    pt = P3.newP(center);
                    pt.add(normal);
                    Measure.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB);
                    normal.scale(dist);
                    this.ptList[3] = P3.newP(center);
                    this.ptList[3].add(normal);
                    this.ptList[1].sub2(center, normal);
                    this.ptList[0].setT(pt);
                    if (this.isRotated45) {
                        Measure.calcAveragePoint(this.ptList[0], this.ptList[1], this.ptList[0]);
                        Measure.calcAveragePoint(this.ptList[1], this.ptList[2], this.ptList[1]);
                        Measure.calcAveragePoint(this.ptList[2], this.ptList[3], this.ptList[2]);
                        Measure.calcAveragePoint(this.ptList[3], pt, this.ptList[3]);
                    }
                    nVertices = 4;
                } else {
                    this.ptList[0].sub2(center, normal);
                    this.ptList[1].add2(center, normal);
                }
                if (this.isArrow && nVertices != -2) {
                    this.isArrow = false;
                }
            } else if (nVertices == 2 && this.length != Float.MAX_VALUE) {
                Measure.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                normal.sub2(this.ptList[1], center);
                normal.scale(0.5f / normal.length() * (this.length == 0.0f ? 0.01f : this.length));
                if (this.length == 0.0f) {
                    center.setT(this.ptList[0]);
                }
                this.ptList[0].sub2(center, normal);
                this.ptList[1].add2(center, normal);
            }
            if (nVertices > 4) {
                nVertices = 4;
            }
            switch (nVertices) {
                case -2: {
                    nVertices = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    drawType = this.isArc ? EnumDrawType.ARC : (this.isPlane && this.isCircle ? EnumDrawType.CIRCULARPLANE : (this.isCylinder ? EnumDrawType.CYLINDER : EnumDrawType.LINE));
                    break;
                }
                default: {
                    drawType = this.thisMesh.connectedAtoms == null ? EnumDrawType.PLANE : EnumDrawType.ARROW;
                }
            }
        }
        this.thisMesh.drawType = drawType;
        this.thisMesh.drawVertexCount = nVertices;
        if (nVertices == 0) {
            return;
        }
        int nVertices0 = this.thisMesh.vc;
        for (int i = 0; i < nVertices; ++i) {
            this.thisMesh.addV(this.ptList[i], false);
        }
        int npoints = nVertices < 3 ? 3 : nVertices;
        this.thisMesh.setPolygonCount(nPoly + 1);
        this.thisMesh.pis[nPoly] = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            this.thisMesh.pis[nPoly][i] = nVertices0 + (i < nVertices ? i : nVertices - 1);
        }
    }

    private void scale(Mesh mesh, float newScale) {
        DrawMesh dmesh = (DrawMesh)mesh;
        if (newScale == 0.0f || dmesh.vc == 0 && dmesh.connectedAtoms == null || dmesh.scale == newScale) {
            return;
        }
        float f = newScale / dmesh.scale;
        dmesh.scale = newScale;
        dmesh.isScaleSet = true;
        if (dmesh.isRenderScalable()) {
            return;
        }
        V3 diff = new V3();
        int iptlast = -1;
        int ipt = 0;
        try {
            int i = dmesh.pc;
            while (--i >= 0) {
                T3 center;
                T3 t3 = dmesh.isVector ? dmesh.vs[0] : (center = dmesh.ptCenters == null ? dmesh.ptCenter : dmesh.ptCenters[i]);
                if (center == null) {
                    return;
                }
                if (dmesh.pis[i] == null) continue;
                iptlast = -1;
                int iV = dmesh.pis[i].length;
                while (--iV >= 0) {
                    ipt = dmesh.pis[i][iV];
                    if (ipt == iptlast) continue;
                    iptlast = ipt;
                    diff.sub2(dmesh.vs[ipt], center);
                    diff.scale(f);
                    diff.add(center);
                    dmesh.vs[ipt].setT(diff);
                }
            }
        }
        catch (Exception e) {
            Logger.info("Error executing DRAW command: " + e);
            dmesh.isValid = false;
        }
    }

    private static final void setAxes(DrawMesh m) {
        m.axis = V3.new3(0.0f, 0.0f, 0.0f);
        m.axes = new V3[m.pc > 0 ? m.pc : 1];
        if (m.vs == null) {
            return;
        }
        int n = 0;
        int i = m.pc;
        while (--i >= 0) {
            int[] p = m.pis[i];
            m.axes[i] = new V3();
            if (p != null && p.length != 0) {
                if (m.drawVertexCount == 2 || m.drawVertexCount < 0 && m.drawVertexCounts[i] == 2) {
                    m.axes[i].sub2(m.vs[p[0]], m.vs[p[1]]);
                    ++n;
                } else {
                    Measure.calcNormalizedNormal(m.vs[p[0]], m.vs[p[1]], m.vs[p[2]], m.axes[i], m.vAB);
                    ++n;
                }
            }
            m.axis.add(m.axes[i]);
        }
        if (n == 0) {
            return;
        }
        m.axis.scale(1.0f / (float)n);
    }

    @Override
    public void setModelVisibilityFlags(BS bsModels) {
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh m = this.dmeshes[i];
            if (m == null) continue;
            int n = m.visibilityFlags = m.isValid && m.visible ? this.vf : 0;
            if (m.modelIndex >= 0 && !bsModels.get(m.modelIndex) || m.modelFlags != null && !BSUtil.haveCommon(bsModels, m.modelFlags)) {
                m.visibilityFlags = 0;
                continue;
            }
            if (m.modelFlags == null) continue;
            m.bsMeshesVisible.clearAll();
            m.bsMeshesVisible.or(m.modelFlags);
            m.bsMeshesVisible.and(bsModels);
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int x, int y, int action, BS bsVisible, boolean drawPicking) {
        boolean isSpinMode;
        boolean isPickingMode = this.vwr.getPickingMode() == 4;
        boolean bl = isSpinMode = this.vwr.getPickingMode() == 5;
        if (!isPickingMode && !drawPicking && !isSpinMode || C.isColixTranslucent(this.colix)) {
            return null;
        }
        if (!this.findPickedObject(x, y, false, bsVisible)) {
            return null;
        }
        T3 v = this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][this.pickedVertex]];
        int modelIndex = this.pickedMesh.modelIndex;
        BS bs = ((DrawMesh)this.pickedMesh).modelFlags;
        if (modelIndex < 0 && BSUtil.cardinalityOf(bs) == 1) {
            modelIndex = bs.nextSetBit(0);
        }
        Map<String, Object> map = null;
        if (action != 0) {
            map = this.getPickedPoint(v, modelIndex);
        }
        if (drawPicking && !isPickingMode) {
            if (action != 0) {
                this.setStatusPicked(-2, v, map);
            }
            return this.getPickedPoint(v, modelIndex);
        }
        if (action == 0 || this.pickedMesh.pis[this.pickedModel][0] == this.pickedMesh.pis[this.pickedModel][1]) {
            return map;
        }
        boolean isClockwise = this.vwr.isBound(action, 42);
        if (this.pickedVertex == 0) {
            this.vwr.startSpinningAxis(this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][1]], this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][0]], isClockwise);
        } else {
            this.vwr.startSpinningAxis(this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][0]], this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][1]], isClockwise);
        }
        return this.getPickedPoint(null, 0);
    }

    @Override
    public boolean checkObjectHovered(int x, int y, BS bsVisible) {
        String s;
        if (!this.vwr.getDrawHover()) {
            return false;
        }
        if (C.isColixTranslucent(this.colix)) {
            return false;
        }
        if (!this.findPickedObject(x, y, false, bsVisible)) {
            return false;
        }
        String string = ((DrawMesh)this.pickedMesh).hoverLabel != null ? ((DrawMesh)this.pickedMesh).hoverLabel : (s = this.pickedMesh.title == null ? this.pickedMesh.thisID : this.pickedMesh.title[0]);
        if (s.length() > 1 && s.charAt(0) == '>') {
            s = s.substring(1);
        }
        this.vwr.hoverOnPt(x, y, s, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    @Override
    public synchronized boolean checkObjectDragged(int prevX, int prevY, int x, int y, int dragAction, BS bsVisible) {
        if (this.vwr.getPickingMode() != 4) {
            return false;
        }
        boolean moveAll = this.vwr.isBound(dragAction, 8);
        boolean movePoint = this.vwr.isBound(dragAction, 9);
        if (!moveAll && !movePoint) {
            return false;
        }
        if (prevX == Integer.MIN_VALUE) {
            return this.findPickedObject(x, y, true, bsVisible);
        }
        if (prevX == Integer.MAX_VALUE) {
            this.pickedMesh = null;
            return false;
        }
        if (this.pickedMesh == null) {
            return false;
        }
        DrawMesh dm = (DrawMesh)this.pickedMesh;
        this.move2D(dm, dm.pis[this.pickedModel], this.pickedVertex, x, y, moveAll);
        this.thisMesh = dm;
        return true;
    }

    private void move2D(DrawMesh mesh, int[] vertexes, int iVertex, int x, int y, boolean moveAll) {
        int i;
        int action;
        if (vertexes == null || vertexes.length == 0) {
            return;
        }
        if (this.vwr.gdata.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        int n = action = moveAll ? 8 : 9;
        if (this.vwr.acm.userActionEnabled(action) && !this.vwr.acm.userAction(action, new Object[]{mesh.thisID, new int[]{x, y, iVertex}})) {
            return;
        }
        P3 pt = new P3();
        int ptVertex = vertexes[iVertex];
        P3 coord = P3.newP(mesh.altVertices == null ? mesh.vs[ptVertex] : (P3)mesh.altVertices[ptVertex]);
        P3 newcoord = new P3();
        V3 move = new V3();
        this.vwr.tm.transformPt3fSafe(coord, pt);
        pt.x = x;
        pt.y = y;
        this.vwr.tm.unTransformPoint(pt, newcoord);
        move.sub2(newcoord, coord);
        if (mesh.isDrawPolygon) {
            iVertex = ptVertex;
        }
        int n2 = !moveAll ? iVertex + 1 : (mesh.isDrawPolygon ? mesh.vs.length : vertexes.length);
        BS bsMoved = new BS();
        int n3 = i = moveAll ? 0 : iVertex;
        while (i < n2) {
            if (moveAll || i == iVertex) {
                int k;
                int n4 = k = mesh.isDrawPolygon ? i : vertexes[i];
                if (!bsMoved.get(k)) {
                    bsMoved.set(k);
                    mesh.vs[k].add(move);
                }
            }
            ++i;
        }
        if (mesh.altVertices != null) {
            mesh.recalcAltVertices = true;
        }
        mesh.setCenters();
    }

    private boolean findPickedObject(int x, int y, boolean isPicking, BS bsVisible) {
        V3 vTemp;
        int d1;
        int d2;
        int dmin2 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        this.pickedVertex = 0;
        this.pickedModel = 0;
        this.pickedMesh = null;
        this.pickedPt = null;
        this.pm2 = null;
        this.pickedPoint2 = null;
        this.pickedVertex2 = -1;
        this.pmod2 = -1;
        this.dmin22 = -1;
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh m = this.dmeshes[i];
            if (m.visibilityFlags == 0) continue;
            dmin2 = this.pickClosestPoint(dmin2, x, y, m, -1, -1, this.ptXY, null);
        }
        if (dmin2 != 0 && this.dmin22 == dmin2 && this.pickedMesh != null && this.pm2 != null && (d2 = this.pickClosestPoint(d1 = this.pickClosestPoint(Integer.MAX_VALUE, x, y, (DrawMesh)this.pickedMesh, this.pickedModel, this.pickedVertex, this.ptXY, vTemp = new V3()), x, y, (DrawMesh)this.pm2, this.pmod2, this.pickedVertex2, this.ptXY, vTemp)) < d1) {
            this.pickedMesh = this.pm2;
            this.pickedModel = this.pmod2;
            this.pickedVertex = this.pickedVertex2;
            this.pickedPt = this.pickedPoint2;
        }
        return this.pickedMesh != null;
    }

    private int pickClosestPoint(int dmin2, int x, int y, DrawMesh m, int model, int vnot, P3i ptXY, V3 vTemp) {
        int mCount;
        int iModel = mCount = m.isDrawPolygon ? m.pc : (m.modelFlags == null ? 1 : this.ms.mc);
        while (--iModel >= 0) {
            int iVertex;
            if (model < 0 ? m.modelFlags != null && !m.modelFlags.get(iModel) || m.pis == null || !m.isDrawPolygon && (iModel >= m.pis.length || m.pis[iModel] == null) : iModel != model) continue;
            int n = iVertex = m.isDrawPolygon ? 3 : m.pis[iModel].length;
            while (--iVertex >= 0) {
                if (iVertex == vnot) continue;
                try {
                    int d2;
                    T3 pt;
                    int iv = m.pis[iModel][iVertex];
                    T3 t3 = pt = m.altVertices == null ? m.vs[iv] : (P3)m.altVertices[iv];
                    if (vnot >= 0) {
                        vTemp.sub2(pt, this.pickedPt);
                        if (vTemp.length() == 0.0f) continue;
                        vTemp.normalize();
                        vTemp.add(this.pickedPt);
                    }
                    if ((d2 = this.coordinateInRange(x, y, vnot >= 0 ? vTemp : pt, dmin2, ptXY)) < 0) continue;
                    if (vnot < 0) {
                        if (this.pm2 == null) {
                            this.dmin22 = d2;
                            this.pmod2 = this.pickedModel;
                            this.pm2 = this.pickedMesh;
                            this.pickedVertex2 = this.pickedVertex;
                            this.pickedPoint2 = this.pickedPt;
                        }
                        this.pickedVertex = iVertex;
                        this.pickedPt = pt;
                        this.pickedMesh = m;
                        this.pickedModel = iModel;
                    }
                    dmin2 = d2;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        return dmin2;
    }

    private String getCommand(Mesh mesh) {
        if (mesh != null) {
            return this.getCommand2(mesh, mesh.modelIndex);
        }
        SB sb = new SB();
        String key = this.explicitID && this.previousMeshID != null && PT.isWild(this.previousMeshID) ? this.previousMeshID : null;
        Lst<Mesh> list = this.getMeshList(key, false);
        int i = list.size();
        while (--i >= 0) {
            Mesh m = (Mesh)list.get(i);
            sb.append(this.getCommand2(m, m.modelIndex));
        }
        return sb.toString();
    }

    private String getCommand2(Mesh mesh, int iModel) {
        DrawMesh dmesh = (DrawMesh)mesh;
        if (!dmesh.isValid || dmesh.drawType == EnumDrawType.NONE && dmesh.lineData == null && dmesh.drawVertexCount == 0 && dmesh.drawVertexCounts == null) {
            return "";
        }
        SB str = new SB();
        int modelCount = this.ms.mc;
        if (!dmesh.isFixed && iModel >= 0 && modelCount > 1) {
            Draw.appendCmd(str, "frame " + this.vwr.getModelNumberDotted(iModel));
        }
        str.append("  draw ID ").append(PT.esc(dmesh.thisID));
        if (dmesh.isFixed) {
            str.append(" fixed");
        }
        if (iModel < 0) {
            iModel = 0;
        }
        if (dmesh.noHead) {
            str.append(" noHead");
        } else if (dmesh.isBarb) {
            str.append(" barb");
        }
        if (dmesh.scale != 1.0f && dmesh.isScaleSet && (dmesh.haveXyPoints || dmesh.connectedAtoms != null || dmesh.drawType == EnumDrawType.CIRCLE || dmesh.drawType == EnumDrawType.ARC)) {
            str.append(" scale ").appendD(dmesh.scale);
        }
        if (dmesh.width != 0.0f) {
            float d;
            switch (dmesh.drawType) {
                case CYLINDER: {
                    d = Math.abs(dmesh.width);
                    break;
                }
                case CIRCULARPLANE: {
                    d = Math.abs(dmesh.width * dmesh.scale);
                    break;
                }
                case ARROW: {
                    if (dmesh.diameter != 0) {
                        str.append(" diameter ").appendI(dmesh.diameter);
                    }
                }
                default: {
                    d = dmesh.width;
                }
            }
            str.append(" diameter ").appendD(d);
        } else if (dmesh.diameter != 0) {
            str.append(" diameter ").appendI(dmesh.diameter);
        }
        if (dmesh.lineData != null) {
            str.append("  lineData [");
            int n = dmesh.lineData.size();
            int j = 0;
            while (j < n) {
                P3[] pts = (P3[])dmesh.lineData.get(j);
                String s = Escape.eP(pts[0]);
                str.append(s.substring(1, s.length() - 1));
                str.append(",");
                s = Escape.eP(pts[1]);
                str.append(s.substring(1, s.length() - 1));
                if (++j >= n) continue;
                str.append(", ");
            }
            str.append("]");
        } else {
            int nVertices = dmesh.drawVertexCount > 0 || dmesh.drawVertexCounts == null ? dmesh.drawVertexCount : dmesh.drawVertexCounts[iModel >= 0 ? iModel : 0];
            switch (dmesh.drawTypes == null || dmesh.drawTypes[iModel] == null ? dmesh.drawType : dmesh.drawTypes[iModel]) {
                case NONE: 
                case MULTIPLE: {
                    break;
                }
                case POLYGON: {
                    str.append(" POLYGON ").appendI(nVertices);
                    break;
                }
                case PLANE: {
                    if (nVertices != 4) break;
                    str.append(" PLANE");
                    break;
                }
                case LINE_SEGMENT: {
                    str.append(" LINE");
                    break;
                }
                case ARC: {
                    str.append(dmesh.isVector ? " ARROW ARC" : " ARC");
                    break;
                }
                case ARROW: {
                    str.append(dmesh.isVector ? " VECTOR" : " ARROW");
                    if (dmesh.connectedAtoms == null) break;
                    str.append(" connect ").append(Escape.eAI(dmesh.connectedAtoms));
                    break;
                }
                case CIRCLE: {
                    str.append(" CIRCLE");
                    break;
                }
                case CURVE: {
                    str.append(" CURVE");
                    break;
                }
                case CYLINDER: 
                case CIRCULARPLANE: {
                    str.append(" CYLINDER");
                    break;
                }
                case POINT: {
                    nVertices = 1;
                    break;
                }
                case LINE: {
                    nVertices = 2;
                }
            }
            if (dmesh.modelIndex < 0 && !dmesh.isFixed) {
                for (int i = 0; i < modelCount; ++i) {
                    if (!Draw.isPolygonDisplayable(dmesh, i)) continue;
                    if (nVertices == 0) {
                        nVertices = dmesh.drawVertexCounts[i];
                    }
                    str.append(" [ " + i);
                    String s = Draw.getVertexList(dmesh, i, nVertices);
                    if (s.indexOf("NaN") >= 0) {
                        return "";
                    }
                    str.append(s);
                    str.append(" ] ");
                }
            } else if (dmesh.drawType == EnumDrawType.POLYGON) {
                int i;
                for (i = 0; i < dmesh.vc; ++i) {
                    str.append(" ").append(Escape.eP(dmesh.vs[i]));
                }
                str.append(" ").appendI(dmesh.pc);
                for (i = 0; i < dmesh.pc; ++i) {
                    if (dmesh.pis[i] == null) {
                        str.append(" [0 0 0 0]");
                        continue;
                    }
                    str.append(" ").append(Escape.eAI(dmesh.pis[i]));
                }
            } else {
                String s = Draw.getVertexList(dmesh, iModel, nVertices);
                if (s.indexOf("NaN") >= 0) {
                    return "";
                }
                str.append(s);
            }
        }
        if (dmesh.mat4 != null) {
            V3 v = new V3();
            dmesh.mat4.getTranslation(v);
            str.append(" offset ").append(Escape.eP(v));
        }
        if (dmesh.titleColor != null) {
            str.append(" title color ").append(Escape.escapeColor(dmesh.titleColor));
        }
        String title = "";
        if (dmesh.title != null) {
            for (int i = 0; i < dmesh.title.length; ++i) {
                title = title + "|" + dmesh.title[i];
            }
        }
        if (dmesh.hoverLabel != null) {
            title = "|<hover>" + dmesh.hoverLabel + "</hover>" + (title == "" ? "" : title.substring(1));
        }
        if (title.length() > 1) {
            str.append(" ").append(PT.esc(title.substring(1)));
        }
        if (dmesh.fontID >= 0) {
            str.append(" font " + Font.getFont3D(dmesh.fontID).getInfo());
        }
        str.append(";\n");
        Draw.appendCmd(str, dmesh.getState("draw"));
        Draw.appendCmd(str, Draw.getColorCommandUnk("draw", dmesh.colix, this.translucentAllowed));
        return str.toString();
    }

    public static boolean isPolygonDisplayable(Mesh mesh, int i) {
        return i < mesh.pis.length && mesh.pis[i] != null && mesh.pis[i].length > 0;
    }

    private static String getVertexList(DrawMesh mesh, int iModel, int nVertices) {
        String str = "";
        try {
            if (iModel >= mesh.pis.length) {
                iModel = 0;
            }
            boolean adjustPt = mesh.isVector && mesh.drawType != EnumDrawType.ARC;
            for (int i = 0; i < nVertices; ++i) {
                T3 pt = mesh.vs[mesh.pis[iModel][i]];
                if (Draw.is2DPoint(pt)) {
                    str = str + (i == 0 ? " " : " ,") + "[" + (int)pt.x + " " + (int)pt.y + (pt.z < 0.0f ? " %]" : "]");
                    continue;
                }
                if (adjustPt && i == 1) {
                    P3 pt1 = P3.newP(pt);
                    pt1.sub(mesh.vs[mesh.pis[iModel][0]]);
                    str = str + " " + Escape.eP(pt1);
                    continue;
                }
                str = str + " " + Escape.eP(pt);
            }
        }
        catch (Exception e) {
            Logger.error("Unexpected error in Draw.getVertexList");
        }
        return str;
    }

    public static boolean is2DPoint(T3 pt) {
        return pt.z == Float.MAX_VALUE || pt.z == -3.4028235E38f;
    }

    @Override
    public Object getShapeDetail() {
        Lst V = new Lst();
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh mesh = this.dmeshes[i];
            if (mesh.vc == 0) continue;
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("visible", mesh.visible ? Boolean.TRUE : Boolean.FALSE);
            info.put("fixed", mesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
            info.put("drawType", mesh.drawType.name);
            if (mesh.hoverLabel != null) {
                info.put("hoverLabel", mesh.hoverLabel);
            }
            if (mesh.title != null) {
                info.put("title", mesh.title);
            }
            if (mesh.diameter > 0) {
                info.put("diameter", mesh.diameter);
            }
            if (mesh.width != 0.0f) {
                info.put("width", Float.valueOf(mesh.width));
            }
            info.put("scale", Float.valueOf(mesh.scale));
            if (mesh.drawType == EnumDrawType.MULTIPLE) {
                Lst m = new Lst();
                int modelCount = this.ms.mc;
                for (int k = 0; k < modelCount; ++k) {
                    if (mesh.ptCenters[k] == null) continue;
                    Hashtable<String, Object> mInfo = new Hashtable<String, Object>();
                    mInfo.put("modelIndex", k);
                    mInfo.put("command", this.getCommand2(mesh, k));
                    mInfo.put("center", mesh.ptCenters[k]);
                    int nPoints = mesh.drawVertexCounts[k];
                    mInfo.put("vertexCount", nPoints);
                    if (nPoints > 1) {
                        mInfo.put("axis", mesh.axes[k]);
                    }
                    Lst<T3> v = new Lst<T3>();
                    for (int ipt = 0; ipt < nPoints; ++ipt) {
                        v.addLast(mesh.vs[mesh.pis[k][ipt]]);
                    }
                    mInfo.put("vertices", v);
                    if (mesh.drawTypes[k] == EnumDrawType.LINE) {
                        float d = mesh.vs[mesh.pis[k][0]].distance(mesh.vs[mesh.pis[k][1]]);
                        mInfo.put("length_Ang", Float.valueOf(d));
                    }
                    m.addLast(mInfo);
                }
                info.put("models", m);
            } else {
                info.put("command", this.getCommand(mesh));
                info.put("center", mesh.ptCenter);
                if (mesh.drawVertexCount > 1) {
                    info.put("axis", mesh.axis);
                }
                Lst<T3> v = new Lst<T3>();
                for (int j = 0; j < mesh.vc; ++j) {
                    v.addLast(mesh.vs[j]);
                }
                info.put("vertices", v);
                if (mesh.drawType == EnumDrawType.LINE) {
                    info.put("length_Ang", Float.valueOf(mesh.vs[0].distance(mesh.vs[1])));
                }
            }
            V.addLast(info);
        }
        return V;
    }

    @Override
    public String getShapeState() {
        SB s = new SB();
        s.append("\n");
        Draw.appendCmd(s, this.myType + " delete");
        if (this.defaultFontId >= 0 && (this.defaultFontId != this.defaultFontId0 || this.defaultFontSize != 16.0f)) {
            Draw.appendCmd(s, Draw.getFontCommand("draw", (Font)this.getProperty("font", -1)));
        }
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh mesh = this.dmeshes[i];
            if (mesh.vc == 0 && mesh.lineData == null) continue;
            s.append(this.getCommand2(mesh, mesh.modelIndex));
            if (mesh.visible) continue;
            s.append(" " + this.myType + " ID " + PT.esc(mesh.thisID) + " off;\n");
        }
        return s.toString();
    }

    public static P3 randomPoint() {
        return P3.new3((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    public static enum EnumDrawType {
        MULTIPLE(-1, "multiple"),
        NONE(0, "none"),
        POINT(1, "point"),
        LINE(2, "line"),
        PLANE(4, "plane"),
        CYLINDER(14, "cylinder"),
        ARROW(15, "arrow"),
        CIRCLE(16, "circle"),
        CURVE(17, "curve"),
        CIRCULARPLANE(18, "circularPlane"),
        ARC(19, "arc"),
        LINE_SEGMENT(20, "lineSegment"),
        POLYGON(21, "polygon");

        final int id;
        final String name;

        private EnumDrawType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static EnumDrawType getType(int nPoints) {
            switch (nPoints) {
                case 1: {
                    return POINT;
                }
                case 2: {
                    return LINE;
                }
                case 4: {
                    return PLANE;
                }
            }
            return NONE;
        }
    }
}

