/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.GroupBy;
import org.jetbrains.kotlinx.dataframe.api.GroupedDataRow;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.RemoveKt;
import org.jetbrains.kotlinx.dataframe.api.RenameClause;
import org.jetbrains.kotlinx.dataframe.api.RenameKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnSet;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.AggregatableInternal;
import org.jetbrains.kotlinx.dataframe.impl.api.ConvertKt;
import org.jetbrains.kotlinx.dataframe.impl.api.GroupedDataRowImpl;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004Bo\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012J\u0010\t\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\nj\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003`\u0011\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013Jv\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001f0\u0003\"\u0004\b\u0002\u0010\u001f2Z\u0010 \u001aV\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u00060\nj\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u0006`!\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\"\u001a\u00020#H\u0016JF\u0010$\u001a@\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\nj\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`\u0011\u00a2\u0006\u0002\b\u0010H\u0016J[\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00032E\u0010&\u001aA\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'\u0012\u0004\u0012\u00020(0\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`)\u00a2\u0006\u0002\b\u0010H\u0016J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\u0010+\u001a\u0004\u0018\u00010#H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017RX\u0010\t\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\nj\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003`\u0011\u00a2\u0006\u0002\b\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/GroupByImpl;", "T", "G", "Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/AggregatableInternal;", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "groups", "Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "keyColumnsInGroups", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;Lkotlin/jvm/functions/Function2;)V", "getDf", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getGroups", "()Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "getKeyColumnsInGroups$core", "()Lkotlin/jvm/functions/Function2;", "keys", "getKeys", "keys$delegate", "Lkotlin/Lazy;", "updateGroups", "R", "transform", "Lorg/jetbrains/kotlinx/dataframe/Selector;", "toString", "", "remainingColumnsSelector", "filter", "predicate", "Lorg/jetbrains/kotlinx/dataframe/api/GroupedDataRow;", "", "Lorg/jetbrains/kotlinx/dataframe/api/GroupedRowFilter;", "toDataFrame", "groupedColumnName", "core"})
@SourceDebugExtension(value={"SMAP\nGroupByImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupByImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/GroupByImpl\n+ 2 convert.kt\norg/jetbrains/kotlinx/dataframe/api/ConvertKt\n+ 3 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n268#2,6:119\n460#2:128\n268#3:125\n37#4,2:126\n1#5:129\n774#6:130\n865#6,2:131\n*S KotlinDebug\n*F\n+ 1 GroupByImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/GroupByImpl\n*L\n47#1:119,6\n47#1:128\n47#1:125\n47#1:126,2\n55#1:130\n55#1:131,2\n*E\n"})
public final class GroupByImpl<T, G>
implements GroupBy<T, G>,
AggregatableInternal<G> {
    @NotNull
    private final DataFrame<T> df;
    @NotNull
    private final FrameColumn<G> groups;
    @NotNull
    private final Function2<ColumnsSelectionDsl<? extends G>, ColumnsSelectionDsl<? extends G>, ColumnsResolver<?>> keyColumnsInGroups;
    @NotNull
    private final Lazy keys$delegate;

    public GroupByImpl(@NotNull DataFrame<? extends T> df2, @NotNull FrameColumn<? extends G> groups, @NotNull Function2<? super ColumnsSelectionDsl<? extends G>, ? super ColumnsSelectionDsl<? extends G>, ? extends ColumnsResolver<?>> keyColumnsInGroups) {
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter(keyColumnsInGroups, (String)"keyColumnsInGroups");
        this.df = df2;
        this.groups = groups;
        this.keyColumnsInGroups = keyColumnsInGroups;
        this.keys$delegate = LazyKt.lazy(() -> GroupByImpl.keys_delegate$lambda$0(this));
    }

    @NotNull
    public final DataFrame<T> getDf() {
        return this.df;
    }

    @Override
    @NotNull
    public FrameColumn<G> getGroups() {
        return this.groups;
    }

    @NotNull
    public final Function2<ColumnsSelectionDsl<? extends G>, ColumnsSelectionDsl<? extends G>, ColumnsResolver<?>> getKeyColumnsInGroups$core() {
        return this.keyColumnsInGroups;
    }

    @Override
    @NotNull
    public DataFrame<T> getKeys() {
        Lazy lazy = this.keys$delegate;
        return (DataFrame)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <R> GroupBy<T, R> updateGroups(@NotNull Function2<? super DataFrame<? extends G>, ? super DataFrame<? extends G>, ? extends DataFrame<? extends R>> transform2) {
        void infer$iv$iv;
        void $this$with$iv$iv;
        void $this$convert_u24default$iv;
        Infer head$iv$iv;
        void cols$iv;
        void firstCol$iv;
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        DataFrame<T> dataFrame = this.df;
        ColumnReference columnReference = this.getGroups();
        ColumnReference[] columnReferenceArray = new ColumnReference[]{};
        Function2 expression$iv = (arg_0, arg_1) -> GroupByImpl.updateGroups$lambda$0(transform2, arg_0, arg_1);
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$convert = false;
        void var8_8 = firstCol$iv;
        void cols$iv$iv = cols$iv;
        boolean $i$f$headPlusArray = false;
        Collection $this$toTypedArray$iv$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)head$iv$iv)), (Iterable)ArraysKt.toList((Object[])cols$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv$iv = $this$toTypedArray$iv$iv$iv;
        Object object = thisCollection$iv$iv$iv.toArray(new ColumnReference[0]);
        object = org.jetbrains.kotlinx.dataframe.api.ConvertKt.convert($this$convert_u24default$iv, Arrays.copyOf(object, ((ColumnReference[])object).length));
        head$iv$iv = infer$iv;
        Function2 rowConverter$iv$iv = expression$iv;
        boolean $i$f$with = false;
        KTypeParameter kTypeParameter = Reflection.typeParameter((Object)new FunctionReferenceImpl(2, GroupByImpl.class, "updateGroups", "updateGroups(Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", 0), (String)"R", (KVariance)KVariance.INVARIANT, (boolean)false);
        Reflection.setUpperBounds((KTypeParameter)kTypeParameter, (KType)Reflection.nullableTypeOf(Object.class));
        GroupBy groupBy = TypeConversionsKt.asGroupBy(ConvertKt.withRowCellImpl($this$with$iv$iv, Reflection.typeOf(DataFrame.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf((KClassifier)kTypeParameter))), (Infer)infer$iv$iv, rowConverter$iv$iv), this.getGroups().name());
        Intrinsics.checkNotNull(groupBy, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.api.GroupBy<T of org.jetbrains.kotlinx.dataframe.impl.GroupByImpl, R of org.jetbrains.kotlinx.dataframe.impl.GroupByImpl.updateGroups>");
        return groupBy;
    }

    @NotNull
    public String toString() {
        return this.df.toString();
    }

    @Override
    @NotNull
    public Function2<ColumnsSelectionDsl<?>, ColumnsSelectionDsl<?>, ColumnsResolver<?>> remainingColumnsSelector() {
        ColumnSet<?> groupCols = ConstructorsKt.toColumnSet(this.keyColumnsInGroups);
        boolean bl = false;
        return (arg_0, arg_1) -> GroupByImpl.remainingColumnsSelector$lambda$0$0(groupCols, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GroupBy<T, G> filter(@NotNull Function2<? super GroupedDataRow<? extends T, ? extends G>, ? super GroupedDataRow<? extends T, ? extends G>, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)DataFrameKt.getNrow(this.df));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            GroupedDataRowImpl<T, G> row = new GroupedDataRowImpl<T, G>(this.df.get(it), this.getGroups());
            if (!((Boolean)predicate.invoke(row, row)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List indices = (List)destination$iv$iv;
        return TypeConversionsKt.asGroupBy(this.df.get(indices), (ColumnReference)this.getGroups());
    }

    @Override
    @NotNull
    public DataFrame<T> toDataFrame(@Nullable String groupedColumnName) {
        DataFrame<T> dataFrame;
        if (groupedColumnName == null || Intrinsics.areEqual((Object)groupedColumnName, (Object)this.getGroups().name())) {
            dataFrame = this.df;
        } else {
            Object[] objectArray = new ColumnReference[]{this.getGroups()};
            RenameClause renameClause = RenameKt.rename(this.df, objectArray);
            objectArray = new String[]{groupedColumnName};
            dataFrame = RenameKt.into(renameClause, (String[])objectArray);
        }
        return dataFrame;
    }

    private static final DataFrame keys_delegate$lambda$0(GroupByImpl this$0) {
        ColumnReference[] columnReferenceArray = new ColumnReference[]{this$0.getGroups()};
        return RemoveKt.remove(this$0.df, columnReferenceArray);
    }

    private static final DataFrame updateGroups$lambda$0(Function2 $transform, DataRow $this$convert, DataFrame it) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"$this$convert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (DataFrame)$transform.invoke((Object)it, (Object)it);
    }

    private static final ColumnSet remainingColumnsSelector$lambda$0$0(ColumnSet $groupCols, ColumnsSelectionDsl $this$let, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$let, (String)"$this$let");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $this$let.except($this$let.all($this$let), (ColumnsResolver<?>)$groupCols);
    }
}

