/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests.bazel;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.CompositeTestSource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

public final class IjSmTestExecutionListener
implements TestExecutionListener {
    private TestPlan testPlan;
    private final Map<String, TestIdentifier> nodesById = new HashMap<String, TestIdentifier>();
    private final Map<String, Long> testStartNanos = new HashMap<String, Long>();
    private final Set<String> startedSuites = new HashSet<String>();
    private final Set<String> startedTests = new HashSet<String>();
    private PrintStream originalOut;
    private PrintStream originalErr;
    private CapturingPrintStream capturingOut;
    private CapturingPrintStream capturingErr;
    private final ThreadLocal<String> currentTestIdTL = new ThreadLocal();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.nodesById.clear();
        for (TestIdentifier root : testPlan.getRoots()) {
            this.indexRecursively(root);
        }
        try {
            this.originalOut = System.out;
            this.originalErr = System.err;
            this.capturingOut = new CapturingPrintStream(this.originalOut, false, this);
            this.capturingErr = new CapturingPrintStream(this.originalErr, true, this);
            System.setOut(this.capturingOut);
            System.setErr(this.capturingErr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.serviceMessage("enteredTheMatrix", Collections.emptyMap());
        this.serviceMessage("testingStarted", Collections.emptyMap());
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.nodesById.put(this.getId(testIdentifier), testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        String id = this.getId(testIdentifier);
        if (testIdentifier.isContainer()) {
            if (!this.startedSuites.contains(id)) {
                Map<String, String> attrs = this.baseAttrs(testIdentifier);
                String location = IjSmTestExecutionListener.getLocationHint(testIdentifier);
                if (location != null) {
                    attrs.put("locationHint", location);
                }
                this.serviceMessage("testSuiteStarted", attrs);
                this.startedSuites.add(id);
            }
        } else if (testIdentifier.isTest()) {
            Map<String, String> attrs = this.baseAttrs(testIdentifier);
            String location = IjSmTestExecutionListener.getLocationHint(testIdentifier);
            if (location != null) {
                attrs.put("locationHint", location);
            }
            attrs.put("captureStandardOutput", "true");
            this.serviceMessage("testStarted", attrs);
            this.startedTests.add(id);
            this.testStartNanos.put(id, System.nanoTime());
            this.currentTestIdTL.set(id);
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            Map<String, String> attrs = this.baseAttrs(testIdentifier);
            if (reason != null && !reason.isEmpty()) {
                attrs.put("message", reason);
            }
            this.serviceMessage("testIgnored", attrs);
        } else if (testIdentifier.isContainer()) {
            this.executionStarted(testIdentifier);
            Map<String, String> attrs = this.baseAttrs(testIdentifier);
            if (reason != null && !reason.isEmpty()) {
                attrs.put("message", reason);
            }
            this.serviceMessage("testIgnored", attrs);
            this.executionFinished(testIdentifier, TestExecutionResult.successful());
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        String id = this.getId(testIdentifier);
        if (testIdentifier.isContainer()) {
            Optional throwable = testExecutionResult.getThrowable();
            if ((testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED || testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) && throwable.isPresent()) {
                String syntheticId = id + "/[suite-setup]";
                String parentId = id;
                String suiteSetupName = "<suite setup>";
                LinkedHashMap<String, String> start = new LinkedHashMap<String, String>();
                start.put("name", suiteSetupName);
                start.put("nodeId", syntheticId);
                start.put("parentNodeId", parentId);
                String loc = IjSmTestExecutionListener.getLocationHint(testIdentifier);
                if (loc != null) {
                    start.put("locationHint", loc);
                }
                start.put("captureStandardOutput", "true");
                this.serviceMessage("testStarted", start);
                Throwable t2 = (Throwable)throwable.get();
                LinkedHashMap<String, String> fail = new LinkedHashMap<String, String>();
                fail.put("name", suiteSetupName);
                fail.put("nodeId", syntheticId);
                fail.put("parentNodeId", parentId);
                String msg = t2.getMessage();
                if (msg != null && !msg.isEmpty()) {
                    fail.put("message", msg);
                }
                fail.put("details", IjSmTestExecutionListener.stackTraceToString(t2));
                this.serviceMessage("testFailed", fail);
                LinkedHashMap<String, String> fin = new LinkedHashMap<String, String>();
                fin.put("name", suiteSetupName);
                fin.put("nodeId", syntheticId);
                fin.put("parentNodeId", parentId);
                this.serviceMessage("testFinished", fin);
            }
            if (this.startedSuites.contains(id)) {
                Map<String, String> attrs = this.baseAttrs(testIdentifier);
                this.serviceMessage("testSuiteFinished", attrs);
                this.startedSuites.remove(id);
            }
            return;
        }
        if (testIdentifier.isTest()) {
            Optional throwable = testExecutionResult.getThrowable();
            if (this.capturingOut != null) {
                this.capturingOut.flushBufferForCurrentThread();
            }
            if (this.capturingErr != null) {
                this.capturingErr.flushBufferForCurrentThread();
            }
            this.currentTestIdTL.remove();
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED && throwable.isPresent()) {
                Throwable t3 = (Throwable)throwable.get();
                if (t3 instanceof MultipleFailuresError) {
                    for (Throwable sub : ((MultipleFailuresError)t3).getFailures()) {
                        AssertionFailedError afe;
                        Map<String, String> fail = this.baseAttrs(testIdentifier);
                        String message = sub.getMessage();
                        if (message != null && !message.isEmpty()) {
                            fail.put("message", message);
                        }
                        if (sub instanceof AssertionFailedError && ((afe = (AssertionFailedError)sub).isExpectedDefined() || afe.isActualDefined())) {
                            fail.put("type", "comparisonFailure");
                            String expected = afe.isExpectedDefined() && afe.getExpected() != null ? String.valueOf(afe.getExpected().getValue()) : "";
                            String actual = afe.isActualDefined() && afe.getActual() != null ? String.valueOf(afe.getActual().getValue()) : "";
                            fail.put("expected", expected);
                            fail.put("actual", actual);
                        }
                        fail.put("details", IjSmTestExecutionListener.stackTraceToString(sub));
                        this.serviceMessage("testFailed", fail);
                    }
                } else {
                    AssertionFailedError afe;
                    Map<String, String> fail = this.baseAttrs(testIdentifier);
                    String message = t3.getMessage();
                    if (message != null && !message.isEmpty()) {
                        fail.put("message", message);
                    }
                    if (t3 instanceof AssertionFailedError && ((afe = (AssertionFailedError)t3).isExpectedDefined() || afe.isActualDefined())) {
                        fail.put("type", "comparisonFailure");
                        String expected = afe.isExpectedDefined() && afe.getExpected() != null ? String.valueOf(afe.getExpected().getValue()) : "";
                        String actual = afe.isActualDefined() && afe.getActual() != null ? String.valueOf(afe.getActual().getValue()) : "";
                        fail.put("expected", expected);
                        fail.put("actual", actual);
                    }
                    fail.put("details", IjSmTestExecutionListener.stackTraceToString(t3));
                    this.serviceMessage("testFailed", fail);
                }
            } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
                Map<String, String> attrs = this.baseAttrs(testIdentifier);
                attrs.put("message", "Test aborted");
                testExecutionResult.getThrowable().ifPresent(t -> attrs.put("details", IjSmTestExecutionListener.stackTraceToString(t)));
                this.serviceMessage("testFailed", attrs);
            }
            Map<String, String> fin = this.baseAttrs(testIdentifier);
            Long startNs = this.testStartNanos.remove(id);
            if (startNs != null) {
                long durationMs = Math.max(0L, (System.nanoTime() - startNs) / 1000000L);
                fin.put("duration", Long.toString(durationMs));
            }
            this.serviceMessage("testFinished", fin);
            this.startedTests.remove(id);
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String text;
        if (!testIdentifier.isTest()) {
            return;
        }
        Map<String, String> attrs = this.baseAttrs(testIdentifier);
        Map kv = entry != null ? entry.getKeyValuePairs() : null;
        boolean emitted = false;
        if (kv != null && !kv.isEmpty()) {
            String stdout;
            String stderr = IjSmTestExecutionListener.firstNonEmpty(kv, Arrays.asList("stderr", "stdErr", "err"));
            if (stderr != null) {
                LinkedHashMap<String, String> a = new LinkedHashMap<String, String>(attrs);
                a.put("out", stderr);
                this.serviceMessage("testStdErr", a);
                emitted = true;
            }
            if ((stdout = IjSmTestExecutionListener.firstNonEmpty(kv, Arrays.asList("stdout", "stdOut", "out"))) != null) {
                LinkedHashMap<String, String> a = new LinkedHashMap<String, String>(attrs);
                a.put("out", stdout);
                this.serviceMessage("testStdOut", a);
                emitted = true;
            }
        }
        if (!emitted && !(text = IjSmTestExecutionListener.formatReportEntry(entry)).isEmpty()) {
            attrs.put("out", text);
            this.serviceMessage("testStdOut", attrs);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        Map<String, String> fin;
        for (String id : new ArrayList<String>(this.startedTests)) {
            fin = this.baseAttrsById(id);
            this.serviceMessage("testFinished", fin);
        }
        for (String id : new ArrayList<String>(this.startedSuites)) {
            fin = this.baseAttrsById(id);
            this.serviceMessage("testSuiteFinished", fin);
        }
        this.startedTests.clear();
        this.startedSuites.clear();
        this.serviceMessage("testingFinished", Collections.emptyMap());
        this.testPlan = null;
        this.tryRestoreStreams();
    }

    private Map<String, String> baseAttrs(TestIdentifier testIdentifier) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("name", testIdentifier.getDisplayName());
        String id = this.getId(testIdentifier);
        attrs.put("nodeId", id);
        String parentId = this.getParentId(testIdentifier);
        attrs.put("parentNodeId", parentId);
        String metainfo = IjSmTestExecutionListener.getMetaInfo(testIdentifier);
        attrs.put("metainfo", metainfo);
        return attrs;
    }

    private String getId(TestIdentifier id) {
        return id.getUniqueId();
    }

    private String getParentId(TestIdentifier id) {
        if (this.testPlan == null) {
            return "0";
        }
        return this.testPlan.getParent(id).map(this::getId).orElse("0");
    }

    private static String getMetaInfo(TestIdentifier id) {
        String type = id.isContainer() ? (id.isTest() ? "test+container" : "container") : (id.isTest() ? "test" : "unknown");
        return type;
    }

    private static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static String formatReportEntry(ReportEntry entry) {
        if (entry == null) {
            return "";
        }
        Map kv = entry.getKeyValuePairs();
        if (kv == null || kv.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry e : kv.entrySet()) {
            if (!first) {
                sb.append(" \u00b7 ");
            }
            sb.append((String)e.getKey()).append(": ").append((String)e.getValue());
            first = false;
        }
        return sb.toString();
    }

    private static String firstNonEmpty(Map<String, String> map, List<String> keys) {
        for (String k : keys) {
            String v = map.get(k);
            if (v == null || v.isEmpty()) continue;
            return v;
        }
        return null;
    }

    private static String getLocationHint(TestIdentifier id) {
        Optional source = id.getSource();
        if (source.isEmpty()) {
            return null;
        }
        TestSource s = (TestSource)source.get();
        if (s instanceof MethodSource) {
            MethodSource ms = (MethodSource)s;
            String className = ms.getClassName();
            String methodName = ms.getMethodName();
            if (className != null && methodName != null) {
                return "java:test://" + className + "/" + methodName;
            }
        } else if (s instanceof ClassSource) {
            ClassSource cs = (ClassSource)s;
            String className = cs.getClassName();
            if (className != null) {
                return "java:suite://" + className;
            }
        } else {
            if (s instanceof FileSource) {
                FileSource fs = (FileSource)s;
                return "file://" + String.valueOf(fs.getFile());
            }
            if (s instanceof CompositeTestSource) {
                for (TestSource child : ((CompositeTestSource)s).getSources()) {
                    ClassSource cs;
                    String className;
                    if (child instanceof MethodSource) {
                        MethodSource ms = (MethodSource)child;
                        className = ms.getClassName();
                        String methodName = ms.getMethodName();
                        if (className == null || methodName == null) continue;
                        return "java:test://" + className + "/" + methodName;
                    }
                    if (!(child instanceof ClassSource) || (className = (cs = (ClassSource)child).getClassName()) == null) continue;
                    return "java:suite://" + className;
                }
            }
        }
        return null;
    }

    private void indexRecursively(TestIdentifier id) {
        this.nodesById.put(this.getId(id), id);
        if (this.testPlan == null) {
            return;
        }
        for (TestIdentifier child : this.testPlan.getChildren(id)) {
            this.indexRecursively(child);
        }
    }

    private Map<String, String> baseAttrsById(String nodeId) {
        TestIdentifier id = this.nodesById.get(nodeId);
        if (id != null) {
            return this.baseAttrs(id);
        }
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("name", IjSmTestExecutionListener.deriveNameFromUniqueId(nodeId));
        attrs.put("nodeId", nodeId);
        String parent = IjSmTestExecutionListener.deriveParentIdFromUniqueId(nodeId);
        if (parent != null && !parent.isEmpty()) {
            attrs.put("parentNodeId", parent);
        }
        return attrs;
    }

    private static String deriveNameFromUniqueId(String uid) {
        if (uid == null || uid.isEmpty()) {
            return "unknown";
        }
        int end = uid.lastIndexOf(93);
        int start = uid.lastIndexOf("[");
        if (start >= 0 && end > start) {
            String seg = uid.substring(start + 1, end);
            int colon = seg.indexOf(58);
            String value2 = colon >= 0 ? seg.substring(colon + 1) : seg;
            int lastDot = value2.lastIndexOf(46);
            if (lastDot >= 0 && colon >= 0 && seg.startsWith("class:")) {
                return value2.substring(lastDot + 1);
            }
            return value2;
        }
        return uid;
    }

    private static String deriveParentIdFromUniqueId(String uid) {
        if (uid == null) {
            return null;
        }
        int slash = uid.lastIndexOf(47);
        if (slash < 0) {
            return null;
        }
        return uid.substring(0, slash);
    }

    private void emitStd(boolean err, String nodeId, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Map<String, String> attrs = this.baseAttrsById(nodeId);
        attrs.put("out", text);
        this.serviceMessage(err ? "testStdErr" : "testStdOut", attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeForInterrupt() {
        try {
            for (String id : new ArrayList<String>(this.startedTests)) {
                Map<String, String> fail = this.baseAttrsById(id);
                fail.put("message", "Interrupted");
                this.serviceMessage("testFailed", fail);
                Map<String, String> fin = this.baseAttrsById(id);
                this.serviceMessage("testFinished", fin);
            }
            this.startedTests.clear();
            for (String id : new ArrayList<String>(this.startedSuites)) {
                Map<String, String> fin = this.baseAttrsById(id);
                this.serviceMessage("testSuiteFinished", fin);
            }
            this.startedSuites.clear();
            this.serviceMessage("testingFinished", Collections.emptyMap());
        }
        catch (Throwable throwable) {
        }
        finally {
            this.tryRestoreStreams();
        }
    }

    private void tryRestoreStreams() {
        try {
            if (this.originalOut != null) {
                System.setOut(this.originalOut);
            }
            if (this.originalErr != null) {
                System.setErr(this.originalErr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void serviceMessage(String name, Map<String, String> attrs) {
        StringBuilder sb = new StringBuilder();
        sb.append("##teamcity[").append(name);
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            if (e.getValue() == null) continue;
            sb.append(' ').append(e.getKey()).append("='").append(IjSmTestExecutionListener.escapeTc(e.getValue())).append("'");
        }
        sb.append(']');
        PrintStream out = this.originalOut != null ? this.originalOut : System.out;
        out.println(sb);
    }

    private static String escapeTc(String s) {
        StringBuilder r = new StringBuilder();
        block11: for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            switch (c) {
                case '\n': {
                    r.append("|n");
                    continue block11;
                }
                case '\r': {
                    r.append("|r");
                    continue block11;
                }
                case '\u0085': {
                    r.append("|x");
                    continue block11;
                }
                case '\u2028': {
                    r.append("|l");
                    continue block11;
                }
                case '\u2029': {
                    r.append("|p");
                    continue block11;
                }
                case '|': {
                    r.append("||");
                    continue block11;
                }
                case '\'': {
                    r.append("|'");
                    continue block11;
                }
                case '[': {
                    r.append("|[");
                    continue block11;
                }
                case ']': {
                    r.append("|]");
                    continue block11;
                }
                default: {
                    r.append(c);
                }
            }
        }
        return r.toString();
    }

    private static final class CapturingPrintStream
    extends PrintStream {
        private final PrintStream original;
        private final boolean isErr;
        private final IjSmTestExecutionListener owner;
        private final ThreadLocal<StringBuilder> buffer = ThreadLocal.withInitial(StringBuilder::new);

        private CapturingPrintStream(PrintStream original, boolean isErr, IjSmTestExecutionListener owner) {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true);
            this.original = original;
            this.isErr = isErr;
            this.owner = owner;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            if (len <= 0) {
                return;
            }
            String s = new String(buf, off, len);
            this.handleText(s);
        }

        @Override
        public void write(int b) {
            this.handleText(new String(new byte[]{(byte)b}));
        }

        @Override
        public void flush() {
            this.flushBufferForCurrentThread();
            this.original.flush();
        }

        @Override
        public void close() {
            this.flushBufferForCurrentThread();
            this.original.close();
            super.close();
        }

        void flushBufferForCurrentThread() {
            String id = this.owner.currentTestIdTL.get();
            if (id == null) {
                return;
            }
            StringBuilder sb = this.buffer.get();
            if (sb.length() > 0) {
                this.owner.emitStd(this.isErr, id, sb.toString());
                sb.setLength(0);
            }
        }

        private void handleText(String s) {
            String id = this.owner.currentTestIdTL.get();
            if (id == null || !this.owner.startedTests.contains(id)) {
                this.original.print(s);
                return;
            }
            StringBuilder sb = this.buffer.get();
            int start = 0;
            for (int i2 = 0; i2 < s.length(); ++i2) {
                char c = s.charAt(i2);
                if (c != '\n') continue;
                sb.append(s, start, i2 + 1);
                this.owner.emitStd(this.isErr, id, sb.toString());
                sb.setLength(0);
                start = i2 + 1;
            }
            if (start < s.length()) {
                sb.append(s, start, s.length());
            }
        }
    }
}

