---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: External XML Entity Injection (XXE)
---

## Description

It is possible to cause the application's XML parser to include external resources.
This can include files or in some circumstances initiate requests to third party
servers.

## Remediation

Consult the documentation for the XML Parser used by the target application for security
guidelines and hardening steps. It is recommended that all XML parsers disable external
entity resolution and XML `xinclude` features. Most XML parsers based on `libxml` can also be
configured to disable network access.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 611.1 | false | 611 | Active | high |

## Links

- [OWASP](https://owasp.org/www-community/vulnerabilities/XML_External_Entity_(XXE)_Processing)
- [CWE](https://cwe.mitre.org/data/definitions/611.html)
