---
stage: Verify
group: CI Platform
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: CI/CDの分析
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

CI/CD分析を使用すると、パイプラインのパフォーマンスと成功率に関するインサイトを得られます。

CI/CD分析ページでは、重要なCI/CDパイプラインのメトリクスの視覚化がGitLab UIで直接提供されます。これらの視覚化は、開発チームがソフトウェア開発プロセスの健全性と効率性を迅速に理解するのに役立ちます。

## CI/CD分析を表示 {#view-cicd-analytics}

{{< history >}}

- 使用可能な場合は、データソースとしてClickHouseを使用して分析を改善するために、[更新](https://gitlab.com/gitlab-org/gitlab/-/issues/353607)がGitLab 18.0で行われました。

{{< /history >}}

CI/CD分析を表示するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **分析** > **CI/CD分析**を選択します。

## パイプラインのメトリクス {#pipeline-metrics}

パイプラインの成功と失敗の履歴、および各パイプラインの実行時間を確認できます。パイプラインの統計は、ステータスに関係なく、プロジェクトで利用可能なすべてのパイプラインを収集して収集されます。個々の日について利用可能なデータは、パイプラインが作成されたときに基づいています。

CI/CD分析は、パイプラインに関する主要なメトリクスを表示します:

- **総パイプライン実行数**: 選択した期間に実行されたパイプラインの合計数。総パイプライン計算には、子パイプラインと無効なYAMLで失敗したパイプラインが含まれます。他の属性に基づいてパイプラインをフィルタリングするには、[Pipelines API](../../api/pipelines.md#list-project-pipelines)を使用します。
- **期間の中央値**: パイプラインが完了するまでにかかる期間の中央値。
- **失敗率**: 失敗したパイプラインの割合。
- **成功率**: 正常に完了したパイプラインの割合。

## 結果を絞り込む {#filter-your-results}

分析データをフィルタリングして、特定の領域に焦点を当てることができます:

- **ソース**: パイプライントリガーソースでフィルタリングします。
- **ブランチ**: パイプラインが実行されたブランチでフィルタリングします。
- **日付範囲**: 分析する期間を選択します（たとえば、先週）。

フィルタリングを使用すると、特定のワークフローコンポーネントのパフォーマンスを分析したり、異なるブランチを比較したりできます。

## パイプライン継続時間チャート {#pipeline-duration-chart}

継続時間チャートは、パイプラインの実行時間が時間の経過とともにどのように変化したかを示しています。チャートには以下が表示されます:

- **中央(50パーセンタイル)**: 一般的なパイプライン期間。
- **95パーセンタイル**: 95%のパイプラインはこれより短い時間で完了しますが、5%だけがより長くかかります。

この視覚化は、パイプライン期間の傾向を特定するのに役立ち、CI/CDプロセスの効率性を時間の経過とともに判断するのに役立ちます。

## パイプラインステータスチャート {#pipeline-status-chart}

ステータスチャートは、パイプラインステータスの時間の経過に伴う分布を示しています:

- **成功**: エラーなしで完了したパイプライン。
- **失敗**: エラーが原因で正常に完了しなかったパイプライン。
- **その他**: 他のステータス（キャンセル、スキップ）のパイプライン。

この視覚化は、パイプラインの安定性を追跡し、失敗率が高い期間を特定するのに役立ちます。
