/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.services.MarkerSet;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.io.Serializable;
import java.util.Objects;

public class MarkerLocation
implements Serializable {
    private int x;
    private int y;
    private Address addr;
    private MarkerSet markers;
    private final Program program;

    public MarkerLocation(MarkerSet markers, Program program, Address addr, int x, int y) {
        this.markers = markers;
        this.program = program;
        this.addr = addr;
        this.x = x;
        this.y = y;
    }

    public Program getProgram() {
        return this.program;
    }

    public Address getAddr() {
        return this.addr;
    }

    public MarkerSet getMarkerManager() {
        return this.markers;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addr == null ? 0 : this.addr.hashCode());
        result = 31 * result + (this.markers == null ? 0 : this.markers.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkerLocation other = (MarkerLocation)obj;
        if (!Objects.equals(this.addr, other.addr)) {
            return false;
        }
        if (!Objects.equals(this.markers, other.markers)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

