/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.actions.KeyBindingUtils;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.plugin.importer.LanguageSortedTableModel;
import ghidra.plugin.importer.LcsSelectionEvent;
import ghidra.plugin.importer.LcsSelectionListener;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Processor;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableCellRenderer;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class NewLanguagePanel
extends JPanel {
    private static final String DEFAULT_DESCRIPTION_TEXT = " ";
    private LanguageSortedTableModel tableModel;
    private GhidraTable table;
    private GhidraTableFilterPanel<LanguageCompilerSpecPair> tableFilterPanel;
    private JLabel descriptionLabel;
    private JCheckBox recommendedCheckbox;
    private JLabel formatLabel;
    private boolean isOnShowAll = true;
    private List<LanguageCompilerSpecPair> allLcsPairsList;
    private List<LanguageCompilerSpecPair> recommendedLcsPairsList;
    private LanguageCompilerSpecPair recommendedLcsPair;
    private final Set<LcsSelectionListener> listeners = new HashSet<LcsSelectionListener>();

    public NewLanguagePanel() {
        this.constructEverything();
        this.layoutEverything();
        this.wireEverything();
        this.populateDefaultAllLcsPairsList();
        this.setVisible(true);
    }

    private void constructEverything() {
        this.tableModel = new LanguageSortedTableModel();
        this.table = new GhidraTable((TableModel)((Object)this.tableModel));
        GhidraTableCellRenderer renderer = new GhidraTableCellRenderer();
        this.table.setDefaultRenderer(Processor.class, (TableCellRenderer)((Object)renderer));
        this.table.setDefaultRenderer(Endian.class, (TableCellRenderer)((Object)renderer));
        this.table.setDefaultRenderer(CompilerSpecDescription.class, (TableCellRenderer)((Object)renderer));
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.tableModel);
        this.descriptionLabel = new GDLabel(DEFAULT_DESCRIPTION_TEXT);
        Gui.registerFont((JComponent)this.descriptionLabel, (int)2);
        this.descriptionLabel.getAccessibleContext().setAccessibleName("Description");
        this.recommendedCheckbox = new GCheckBox("Show Only Recommended Language/Compiler Specs");
        this.recommendedCheckbox.getAccessibleContext().setAccessibleName("Recomendation");
        this.recommendedCheckbox.addItemListener(e -> {
            switch (e.getStateChange()) {
                case 1: {
                    this.switchToRecommendedList();
                    break;
                }
                case 2: {
                    this.switchToAllList();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown checkbox state: " + e.getStateChange());
                }
            }
        });
        this.formatLabel = new GDLabel();
        this.formatLabel.getAccessibleContext().setAccessibleName("Format");
        this.formatLabel.setHorizontalAlignment(0);
        this.formatLabel.setForeground((Color)GThemeDefaults.Colors.Messages.NORMAL);
    }

    private void layoutEverything() {
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table)){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                if (preferredSize.width == 0) {
                    return preferredSize;
                }
                preferredSize.height = 150;
                return preferredSize;
            }
        };
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.getAccessibleContext().setAccessibleName("Description");
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Description");
        descriptionPanel.setBorder(titledBorder);
        descriptionPanel.setLayout(new BorderLayout());
        descriptionPanel.add((Component)this.descriptionLabel, "Center");
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)scrollPane, "Center");
        innerPanel.add((Component)((Object)this.tableFilterPanel), "South");
        innerPanel.getAccessibleContext().setAccessibleName("Table Filter");
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BorderLayout());
        middlePanel.add((Component)innerPanel, "Center");
        middlePanel.add((Component)descriptionPanel, "South");
        middlePanel.getAccessibleContext().setAccessibleName("Table Filter Panel and Description");
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)middlePanel, "Center");
        outerPanel.add((Component)this.recommendedCheckbox, "South");
        outerPanel.getAccessibleContext().setAccessibleName("Recommended Checkbox");
        this.setLayout(new BorderLayout());
        this.add((Component)outerPanel, "Center");
        this.add((Component)this.formatLabel, "South");
    }

    private void wireEverything() {
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.notifyLanguageSelected();
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewLanguagePanel.this.notfiyLanguagePicked();
                }
            }
        });
        KeyStroke enterKs = KeyBindingUtils.parseKeyStroke((String)"Enter");
        AbstractAction action = new AbstractAction("Pick Language"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewLanguagePanel.this.notfiyLanguagePicked();
            }
        };
        KeyBindingUtils.clearKeyBinding((JComponent)((Object)this.table), (KeyStroke)enterKs);
        KeyBindingUtils.registerAction((JComponent)((Object)this.table), (KeyStroke)enterKs, (Action)action, (int)0);
    }

    private void setDescriptionLabelText(String text) {
        if (text == null || "".equals(text)) {
            text = DEFAULT_DESCRIPTION_TEXT;
        }
        this.descriptionLabel.setText(text);
    }

    public void setFormatText(String text) {
        this.formatLabel.setText(text);
    }

    public void setShowRecommendedCheckbox(boolean show) {
        this.recommendedCheckbox.setVisible(show);
    }

    private boolean isAllLcsPairsTableShowing() {
        return this.isOnShowAll;
    }

    private boolean isRecommendedLcsPairsTableShowing() {
        return !this.isOnShowAll;
    }

    public void setShowAllLcsPairs(boolean show) {
        this.recommendedCheckbox.setSelected(!show);
    }

    private void setLanguages(List<LanguageCompilerSpecPair> lcsPairList) {
        this.tableModel.setLanguages(lcsPairList);
        this.notifyLanguageSelected();
    }

    private void switchToAllList() {
        if (this.isRecommendedLcsPairsTableShowing()) {
            LanguageCompilerSpecPair selectedLcsPair = this.getSelectedLcsPair();
            this.isOnShowAll = true;
            this.setLanguages(this.allLcsPairsList);
            if (selectedLcsPair != null) {
                this.setSelectedLcsPair(selectedLcsPair);
            }
        }
    }

    private void switchToRecommendedList() {
        if (this.isAllLcsPairsTableShowing()) {
            LanguageCompilerSpecPair selectedLcsPair = this.getSelectedLcsPair();
            this.isOnShowAll = false;
            this.setLanguages(this.recommendedLcsPairsList);
            if (this.recommendedLcsPair != null) {
                this.setSelectedLcsPair(this.recommendedLcsPair);
            } else if (selectedLcsPair != null) {
                this.setSelectedLcsPair(selectedLcsPair);
            }
        }
    }

    private void notifyLanguageSelected() {
        LanguageCompilerSpecPair lcs = this.getSelectedLcsPair();
        LcsSelectionEvent e = new LcsSelectionEvent(lcs, LcsSelectionEvent.Type.SELECTED);
        this.doNotify(e);
    }

    private void notfiyLanguagePicked() {
        LanguageCompilerSpecPair lcs = this.getSelectedLcsPair();
        LcsSelectionEvent e = new LcsSelectionEvent(lcs, LcsSelectionEvent.Type.PICKED);
        this.doNotify(e);
    }

    private void doNotify(LcsSelectionEvent event) {
        LanguageCompilerSpecPair selectedLcsPair = event.getLcs();
        if (selectedLcsPair == null) {
            this.descriptionLabel.setText(DEFAULT_DESCRIPTION_TEXT);
        } else {
            try {
                this.setDescriptionLabelText(selectedLcsPair.getLanguageDescription().getDescription());
            }
            catch (LanguageNotFoundException e) {
                this.descriptionLabel.setText("<LanguageNotFound>");
            }
        }
        for (LcsSelectionListener listener : this.listeners) {
            listener.valueChanged(event);
        }
    }

    private void populateDefaultAllLcsPairsList() {
        ArrayList<LanguageCompilerSpecPair> allPairs = new ArrayList<LanguageCompilerSpecPair>();
        List languageDescriptions = DefaultLanguageService.getLanguageService().getLanguageDescriptions(false);
        if (languageDescriptions != null) {
            for (LanguageDescription description : languageDescriptions) {
                Collection csDescriptions = description.getCompatibleCompilerSpecDescriptions();
                if (csDescriptions == null) continue;
                for (CompilerSpecDescription csDescription : csDescriptions) {
                    allPairs.add(new LanguageCompilerSpecPair(description.getLanguageID(), csDescription.getCompilerSpecID()));
                }
            }
        }
        this.setAllLcsPairsList(allPairs);
    }

    public void setAllLcsPairsList(List<LanguageCompilerSpecPair> allLcsPairsList) {
        this.allLcsPairsList = allLcsPairsList;
        if (this.isAllLcsPairsTableShowing()) {
            this.setLanguages(allLcsPairsList);
        }
    }

    public void setRecommendedLcsPairsList(List<LanguageCompilerSpecPair> recommendedLcsPairsList) {
        this.recommendedLcsPairsList = recommendedLcsPairsList;
        if (this.isRecommendedLcsPairsTableShowing()) {
            this.setLanguages(recommendedLcsPairsList);
        }
    }

    public LanguageCompilerSpecPair getSelectedLcsPair() {
        int selectedRow;
        LanguageCompilerSpecPair selectedLcsPair = null;
        int index = this.table.getSelectedRow();
        if (index != -1 && (selectedRow = this.tableFilterPanel.getModelRow(index)) != -1) {
            selectedLcsPair = this.tableModel.getLcsPairAtRow(selectedRow);
        }
        return selectedLcsPair;
    }

    private void scrollToViewRow(int viewRow) {
        Rectangle visibleRect = this.table.getVisibleRect();
        Rectangle cellRect = this.table.getCellRect(viewRow, 0, true);
        cellRect.width = 0;
        cellRect.x = visibleRect.x;
        if (visibleRect.contains(cellRect)) {
            return;
        }
        this.table.scrollRectToVisible(cellRect);
    }

    public void clearSelection() {
        this.table.getSelectionModel().clearSelection();
    }

    public void setRecommendedLcsPair(LanguageCompilerSpecPair lcsPair) {
        this.recommendedLcsPair = lcsPair;
        this.setSelectedLcsPair(this.recommendedLcsPair);
    }

    public boolean setSelectedLcsPair(LanguageCompilerSpecPair lcsPair) {
        if (lcsPair == null) {
            return false;
        }
        int index = this.tableModel.getFirstLcsPairIndex(lcsPair);
        if (index == -1) {
            return false;
        }
        int viewRow = this.tableFilterPanel.getViewRow(index);
        if (viewRow == -1) {
            return false;
        }
        this.table.selectRow(viewRow);
        this.scrollToViewRow(viewRow);
        return true;
    }

    public void addSelectionListener(LcsSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(LcsSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.tableFilterPanel.dispose();
        this.table.dispose();
        this.listeners.clear();
    }
}

