/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.memory.SetBaseCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.MiddleLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ImageBaseDialog
extends DialogComponentProvider {
    private JTextField textField;
    private Address addr;
    private Address currentAddr;
    private Program program;
    private PluginTool tool;

    ImageBaseDialog(PluginTool tool, Program program, Address currentAddr) {
        super("Base Image Address", true, true, true, false);
        this.program = program;
        this.currentAddr = currentAddr;
        this.tool = tool;
        this.addr = currentAddr;
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.rootPanel.setPreferredSize(new Dimension(240, 120));
        this.setHelpLocation(new HelpLocation("MemoryMapPlugin", "Set Image Base"));
        this.setFocusComponent(this.textField);
    }

    public void dispose() {
        super.dispose();
        this.tool = null;
        this.program = null;
    }

    private JComponent createWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new MiddleLayout());
        this.textField = new JTextField(20);
        this.textField.setText(this.currentAddr.toString());
        this.textField.getAccessibleContext().setAccessibleName("Image Base Address");
        this.textField.selectAll();
        this.textField.addActionListener(e -> {
            if (this.addr != null) {
                this.okCallback();
            }
        });
        panel.add(this.textField);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImageBaseDialog.this.updateAddress();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImageBaseDialog.this.updateAddress();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImageBaseDialog.this.updateAddress();
            }
        });
        return panel;
    }

    private void updateAddress() {
        this.clearStatusText();
        String addrString = this.textField.getText();
        this.addr = null;
        try {
            this.addr = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(addrString);
        }
        catch (AddressFormatException addressFormatException) {
            // empty catch block
        }
        if (this.addr == null) {
            this.setStatusText("Invalid Address");
        }
        this.setOkEnabled(this.addr != null);
    }

    protected void okCallback() {
        if (this.addr != null && !this.addr.equals((Object)this.currentAddr)) {
            Msg.info((Object)((Object)this), (Object)("old base = " + String.valueOf(this.program.getImageBase())));
            SetBaseCommand cmd = new SetBaseCommand(this.addr);
            if (!this.tool.execute((Command)cmd, (DomainObject)this.program)) {
                this.setStatusText(cmd.getStatusMsg());
                return;
            }
            Msg.info((Object)((Object)this), (Object)("new base = " + String.valueOf(((ProgramDB)this.program).getImageBase())));
        }
        this.close();
    }
}

