/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import generic.util.WindowUtilities;
import ghidra.app.merge.MergeManagerPlugin;
import ghidra.app.merge.MergeManagerProvider;
import ghidra.app.merge.MergeProgressPanel;
import ghidra.app.merge.MergeResolver;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.ModalPluginTool;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.PluginToolAccessUtils;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.program.model.listing.DomainObjectChangeSet;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.RunManager;
import ghidra.util.task.TaskDialog;
import ghidra.util.task.TaskMonitor;
import help.Help;
import help.HelpService;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class MergeManager
implements DomainObjectMergeManager {
    protected MergeResolver[] mergeResolvers;
    protected DomainObject resultDomainObject;
    protected DomainObject myDomainObject;
    protected DomainObject originalDomainObject;
    protected DomainObject latestDomainObject;
    protected DomainObjectChangeSet latestChangeSet;
    protected DomainObjectChangeSet myChangeSet;
    protected MergeManagerPlugin mergePlugin;
    protected RunManager runManager;
    protected TaskMonitor mergeMonitor;
    private volatile boolean isCancelled;
    protected int currentIndex;
    protected volatile boolean inputReceived;
    protected boolean mergeStatus;
    protected volatile boolean prompting;
    protected volatile boolean mergeCompleted;
    protected volatile boolean mergeToolIsVisible;
    protected volatile ModalPluginTool mergeTool;
    protected Hashtable<String, Object> resolveMap;
    protected MergeProgressPanel mergeProgressPanel;

    public MergeManager(DomainObject resultDomainObject, DomainObject myDomainObject, DomainObject originalDomainObject, DomainObject latestDomainObject, DomainObjectChangeSet latestChangeSet, DomainObjectChangeSet myChangeSet) {
        this.resultDomainObject = resultDomainObject;
        this.myDomainObject = myDomainObject;
        this.originalDomainObject = originalDomainObject;
        this.latestDomainObject = latestDomainObject;
        this.latestChangeSet = latestChangeSet;
        this.myChangeSet = myChangeSet;
        this.runManager = new RunManager();
        this.runManager.showCancelButton(false);
        this.resolveMap = new Hashtable();
        this.createMergeResolvers();
    }

    protected abstract void createMergeResolvers();

    public DomainObject getDomainObject(int version) {
        switch (version) {
            case 1: {
                return this.latestDomainObject;
            }
            case 2: {
                return this.myDomainObject;
            }
            case 3: {
                return this.originalDomainObject;
            }
            case 0: {
                return this.resultDomainObject;
            }
        }
        return null;
    }

    public boolean merge(TaskMonitor taskMonitor) throws CancelledException {
        this.isCancelled = false;
        this.mergeMonitor = taskMonitor;
        this.mergeMonitor.initialize((long)this.mergeResolvers.length);
        if (this.mergeMonitor instanceof TaskDialog) {
            ((TaskDialog)taskMonitor).setCancelEnabled(false);
        }
        this.mergeStatus = true;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MergeManager.this.runManager.showProgressIcon(false);
                    MergeManager.this.mergeProgressPanel = new MergeProgressPanel();
                    for (MergeResolver mergeResolver : MergeManager.this.mergeResolvers) {
                        String[][] phaseArray;
                        for (String[] element : phaseArray = mergeResolver.getPhases()) {
                            MergeManager.this.mergeProgressPanel.addInfo(element);
                        }
                    }
                    MergeManager.this.mergeTool = ModalPluginTool.createTool((String)this.getMergeTitle());
                    MergeManager.this.mergePlugin = MergeManager.this.createMergeManagerPlugin(MergeManager.this.mergeTool, MergeManager.this, MergeManager.this.resultDomainObject);
                    Dimension d = MergeManager.this.getPreferredMergeToolSize();
                    MergeManager.this.mergeTool.setSize(d.width, d.height);
                    Point centerLoc = WindowUtilities.centerOnScreen((Dimension)MergeManager.this.mergeTool.getSize());
                    MergeManager.this.mergeTool.setLocation(centerLoc.x, centerLoc.y);
                    MergeManager.this.initializeMerge();
                    try {
                        MergeManager.this.mergeTool.addPlugin((Plugin)MergeManager.this.mergePlugin);
                        JComponent monitorComp = MergeManager.this.runManager.getMonitorComponent();
                        Dimension monitorDim = monitorComp.getPreferredSize();
                        monitorDim.width = 500;
                        monitorComp.setPreferredSize(monitorDim);
                        MergeManager.this.mergeTool.addStatusComponent(monitorComp, true, false);
                    }
                    catch (PluginException e) {
                        Msg.error((Object)this, (Object)((Object)e));
                    }
                    SwingUtilities.invokeLater(() -> MergeManager.this.scheduleMerge());
                    MergeManager.this.mergeTool.setVisible(true);
                    MergeManager.this.conflictsResolveCompleted();
                    MergeManager.this.cleanupMerge();
                }

                private String getMergeTitle() {
                    DomainFile domainFile = MergeManager.this.resultDomainObject.getDomainFile();
                    return "Merge Tool: " + domainFile.toString();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CancelledException();
        }
        finally {
            this.mergeCompleted = true;
            if (this.mergeMonitor instanceof TaskDialog) {
                ((TaskDialog)taskMonitor).setCancelEnabled(true);
            }
        }
        MergeManagerProvider provider = this.mergePlugin.getProvider();
        if (taskMonitor.isCancelled() || provider.mergeWasCanceled()) {
            throw new CancelledException();
        }
        return this.mergeStatus;
    }

    protected abstract MergeManagerPlugin createMergeManagerPlugin(ModalPluginTool var1, MergeManager var2, DomainObject var3);

    protected abstract void initializeMerge();

    protected abstract void cleanupMerge();

    protected Dimension getPreferredMergeToolSize() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(screenDim.width - 200, screenDim.height - 200);
    }

    public boolean merge() throws CancelledException {
        return this.merge(TaskMonitor.DUMMY);
    }

    public static void showBlockingError(String title, String msg) {
        Swing.runNow(() -> Msg.showError(MergeManager.class, null, (String)title, (Object)msg));
    }

    public static void showBlockingError(String title, String msg, Exception e) {
        Swing.runNow(() -> Msg.showError(MergeManager.class, null, (String)title, (Object)msg, (Throwable)e));
    }

    public void setApplyEnabled(boolean enabled) {
        Swing.runNow(() -> this.mergePlugin.setApplyEnabled(enabled));
    }

    public void clearStatusText() {
        this.mergeTool.clearStatusInfo();
    }

    public void setStatusText(String msg) {
        this.mergeTool.setStatusInfo(msg);
    }

    public void showDefaultMergePanel(String description) {
        this.showComponent(null, null, null);
        SwingUtilities.invokeLater(() -> this.mergePlugin.updateMergeDescription(description));
    }

    public void showComponent(JComponent comp, String componentID, HelpLocation helpLoc) {
        HelpService help = Help.getHelpService();
        if (helpLoc != null && comp != null) {
            help.registerHelp((Object)comp, helpLoc);
        }
        SwingUtilities.invokeLater(() -> {
            this.showMergeTool();
            Dimension oldSize = this.mergeTool.getSize();
            if (comp == null) {
                this.mergePlugin.showDefaultComponent();
            } else {
                this.mergePlugin.setMergeComponent(comp, componentID);
            }
            Dimension newSize = this.mergeTool.getSize();
            if (!newSize.equals(oldSize)) {
                Point centerLoc = WindowUtilities.centerOnScreen((Dimension)this.mergeTool.getSize());
                this.mergeTool.setLocation(centerLoc.x, centerLoc.y);
            }
        });
        if (comp != null) {
            this.inputReceived = false;
            this.waitForInput();
        }
    }

    public void removeComponent(JComponent comp) {
        SwingUtilities.invokeLater(() -> this.mergePlugin.removeMergeComponent(comp));
    }

    protected void showMergeTool() {
        if (!this.mergeToolIsVisible) {
            this.mergeToolIsVisible = true;
            Point centerLoc = WindowUtilities.centerOnScreen((Dimension)this.mergeTool.getSize());
            this.mergeTool.setLocation(centerLoc.x, centerLoc.y);
        }
    }

    public void showMonitorComponent(boolean show) {
        if (show) {
            this.mergeTool.addStatusComponent(this.runManager.getMonitorComponent(), true, false);
        } else {
            this.mergeTool.removeStatusComponent(this.runManager.getMonitorComponent());
        }
    }

    public void showProgressIcon(boolean show) {
        this.runManager.showProgressIcon(show);
    }

    public synchronized boolean isPromptingUser() {
        return this.prompting;
    }

    public boolean processingCompleted() {
        return this.mergeCompleted;
    }

    synchronized void apply() {
        this.mergeResolvers[this.currentIndex].apply();
        this.inputReceived = true;
        this.notify();
        this.prompting = false;
    }

    synchronized void cancel() {
        this.isCancelled = true;
        this.runManager.cancelAllRunnables();
        if (this.currentIndex < this.mergeResolvers.length) {
            this.mergeResolvers[this.currentIndex].cancel();
        }
        this.notify();
    }

    private void scheduleMerge() {
        this.mergeMonitor.setProgress((long)(this.currentIndex + 1));
        SwingUtilities.invokeLater(() -> {
            if (this.currentIndex < this.mergeResolvers.length && !this.isCancelled) {
                this.mergePlugin.updateMergeDescription(this.mergeResolvers[this.currentIndex].getDescription());
            }
        });
        MonitoredRunnable r = monitor -> {
            monitor.initialize(0L);
            String description = this.mergeResolvers[this.currentIndex].getDescription();
            monitor.setMessage(description);
            this.mergeMonitor.setMessage(description);
            this.updateProgress(0, description);
            try {
                this.mergeResolvers[this.currentIndex].merge(monitor);
                if (this.mergeToolIsVisible) {
                    this.showDefaultMergePanel(description);
                }
                ++this.currentIndex;
                if (this.currentIndex == this.mergeResolvers.length || monitor.isCancelled()) {
                    this.conflictsResolveCompleted();
                } else {
                    this.scheduleMerge();
                }
            }
            catch (Exception e) {
                MergeManager.showBlockingError("Error During Merge", "Error occurred in " + this.mergeResolvers[this.currentIndex].getName(), e);
                this.mergeStatus = false;
                this.conflictsResolveCompleted();
            }
        };
        if (this.currentIndex < this.mergeResolvers.length && !this.isCancelled) {
            this.runManager.runLater(r, this.mergeResolvers[this.currentIndex].getName(), 250);
        }
    }

    protected synchronized void waitForInput() {
        while (!this.isCancelled && !this.inputReceived) {
            try {
                this.prompting = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private void conflictsResolveCompleted() {
        if (this.mergeTool != null) {
            SwingUtilities.invokeLater(() -> {
                this.mergeTool.setVisible(false);
                if (this.mergePlugin != null) {
                    this.mergePlugin.dispose();
                }
                PluginToolAccessUtils.dispose((PluginTool)this.mergeTool);
                this.mergeTool = null;
            });
        }
    }

    public Object getResolveInformation(String infoType) {
        return this.resolveMap.get(infoType);
    }

    public void setResolveInformation(String infoType, Object infoObject) {
        this.resolveMap.put(infoType, infoObject);
    }

    public MergeResolver getMergeResolverByName(String name) {
        for (MergeResolver mergeMgr : this.mergeResolvers) {
            if (!name.equals(mergeMgr.getName())) continue;
            return mergeMgr;
        }
        return null;
    }

    public PluginTool getMergeTool() {
        return this.mergeTool;
    }

    public boolean isMergeToolVisible() {
        return this.mergeToolIsVisible;
    }

    public MergeProgressPanel getMergeProgressPanel() {
        return this.mergeProgressPanel;
    }

    public JComponent getMonitorComponent() {
        return this.runManager.getMonitorComponent();
    }

    public void updateProgress(String description) {
        SwingUtilities.invokeLater(() -> {
            if (!this.isCancelled) {
                this.mergePlugin.updateProgressDetails(description);
            }
        });
    }

    public void updateProgress(int currentProgressPercentage) {
        if (currentProgressPercentage < 0 || currentProgressPercentage > 100) {
            System.out.println("Invalid progress value (" + currentProgressPercentage + "). Must be from 0 to 100.");
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (!this.isCancelled) {
                this.mergePlugin.setCurrentProgress(currentProgressPercentage);
            }
        });
    }

    public void updateProgress(int currentProgressPercentage, String progressMessage) {
        SwingUtilities.invokeLater(() -> {
            if (!this.isCancelled) {
                this.mergePlugin.setCurrentProgress(currentProgressPercentage);
                this.mergePlugin.updateProgressDetails(progressMessage);
            }
        });
    }

    public void setInProgress(String[] mergePhase) {
        this.mergeProgressPanel.setInProgress(mergePhase);
    }

    public void setCompleted(String[] mergePhase) {
        this.mergeProgressPanel.setCompleted(mergePhase);
        this.updateProgress(0, "");
        this.mergeMonitor.setMessage("");
        this.mergeMonitor.setProgress(0L);
    }
}

