/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntListIndexer;
import ghidra.util.datastruct.Prime;
import ghidra.util.exception.AssertException;
import java.io.Serializable;

public class IntKeyIndexer
implements Serializable {
    private static final int DEFAULT_CAPACITY = 13;
    private int[] keys;
    private IntListIndexer indexer;
    private int capacity;

    public IntKeyIndexer() {
        this(13);
    }

    public IntKeyIndexer(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new IntListIndexer(capacity, capacity);
        this.keys = new int[capacity];
    }

    public int put(int key) {
        int index = this.findKey(key);
        if (index == -1) {
            int hashcode;
            if (this.indexer.getSize() >= this.capacity) {
                this.grow();
            }
            if ((index = this.indexer.add(hashcode = (key & Integer.MAX_VALUE) % this.capacity)) < 0) {
                throw new IndexOutOfBoundsException("Maximum capacity reached");
            }
            this.keys[index] = key;
        }
        return index;
    }

    public int get(int key) {
        return this.findKey(key);
    }

    public int remove(int key) {
        int index = this.findKey(key);
        if (index == -1) {
            return -1;
        }
        int hashcode = (key & Integer.MAX_VALUE) % this.capacity;
        this.indexer.remove(hashcode, index);
        return index;
    }

    public int getSize() {
        return this.indexer.getSize();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void clear() {
        this.indexer.clear();
    }

    public int[] getKeys() {
        int[] keyArray = new int[this.getSize()];
        int pos = 0;
        int nLists = this.indexer.getNumLists();
        for (int i = 0; i < nLists; ++i) {
            int keyIndex = this.indexer.first(i);
            while (keyIndex >= 0) {
                keyArray[pos++] = this.keys[keyIndex];
                keyIndex = this.indexer.next(keyIndex);
            }
        }
        if (pos != this.getSize()) {
            throw new AssertException("Trouble in IntKeyIndexer.getKeys(), size = " + this.getSize() + "  pos= " + pos);
        }
        return keyArray;
    }

    private int findKey(int key) {
        int hashcode = (key & Integer.MAX_VALUE) % this.capacity;
        int p = this.indexer.first(hashcode);
        while (p != -1) {
            if (this.keys[p] == key) {
                return p;
            }
            p = this.indexer.next(p);
        }
        return -1;
    }

    private void grow() {
        int newCapacity = Prime.nextPrime(this.indexer.getNewCapacity());
        this.indexer.growCapacity(newCapacity);
        this.indexer.growNumLists(newCapacity);
        this.indexer.clear();
        int[] oldKeys = this.keys;
        this.keys = new int[newCapacity];
        this.capacity = newCapacity;
        for (int oldKey : oldKeys) {
            this.put(oldKey);
        }
    }
}

