/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutOptions;
import ghidra.framework.options.Options;
import ghidra.util.HelpLocation;

public class DNLayoutOptions
implements FGLayoutOptions {
    private static final String HELP_ANCHOR = "Nested Code Layout_Options";
    private static final String USE_EDGE_ROUTING_AROUND_VERTICES_KEY = "Route Edges Around Vertices";
    private static final String USE_EDGE_ROUTING_AROUND_VERTICES_DESCRIPTION = "Signals that edges should be routed around any intersecting vertex.  When toggled off, edges will pass through any intersecting vertices.";
    private static final String DIM_RETURN_EDGES_KEY = "Use Dim Return Edges";
    private static final String DIM_RETURN_EDGES_DESCRIPTION = "Signals to lighten the default return edges.";
    private boolean useEdgeRoutingAroundVertices;
    private boolean useDimmedReturnEdges = true;

    public void registerOptions(Options options) {
        HelpLocation help = new HelpLocation(OWNER, HELP_ANCHOR);
        options.registerOption(USE_EDGE_ROUTING_AROUND_VERTICES_KEY, (Object)this.useEdgeRoutingAroundVertices, help, USE_EDGE_ROUTING_AROUND_VERTICES_DESCRIPTION);
        options.registerOption(DIM_RETURN_EDGES_KEY, (Object)this.useDimmedReturnEdges, help, DIM_RETURN_EDGES_DESCRIPTION);
    }

    public void loadOptions(Options options) {
        this.useEdgeRoutingAroundVertices = options.getBoolean(USE_EDGE_ROUTING_AROUND_VERTICES_KEY, this.useEdgeRoutingAroundVertices);
        this.useDimmedReturnEdges = options.getBoolean(DIM_RETURN_EDGES_KEY, this.useDimmedReturnEdges);
    }

    public boolean useEdgeRoutingAroundVertices() {
        return this.useEdgeRoutingAroundVertices;
    }

    public boolean useDimmedReturnEdges() {
        return this.useDimmedReturnEdges;
    }

    public boolean optionChangeRequiresRelayout(String optionName) {
        return optionName.endsWith(USE_EDGE_ROUTING_AROUND_VERTICES_KEY) || optionName.endsWith(DIM_RETURN_EDGES_KEY);
    }
}

