/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results.apply;

import ghidra.features.bsim.gui.search.results.BSimApplyResult;
import ghidra.features.bsim.gui.search.results.BSimMatchResult;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.features.bsim.gui.search.results.apply.AbstractBSimApplyTask;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.FunctionUtility;
import java.util.List;

public class SignatureBSimApplyTask
extends AbstractBSimApplyTask {
    private boolean applyEmptyStructures;

    public SignatureBSimApplyTask(Program program, List<BSimMatchResult> results, boolean applyEmptyStructures, ServiceProvider serviceProvider) {
        super(program, "Function Signature", results, serviceProvider);
        this.applyEmptyStructures = applyEmptyStructures;
    }

    @Override
    protected boolean hasSameApplyData(List<Function> functions) {
        FunctionSignature firstSignature = functions.get(0).getSignature(false);
        for (int i = 1; i < functions.size(); ++i) {
            FunctionSignature signature = functions.get(i).getSignature(false);
            if (firstSignature.isEquivalentSignature(signature)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BSimApplyResult apply(Function target, Function source) {
        String defaultFunctionName = SymbolUtilities.getDefaultFunctionName((Address)source.getEntryPoint());
        if (defaultFunctionName.equals(source.getName())) {
            return new BSimApplyResult(target, source, BSimResultStatus.ERROR, "Can't apply default function names");
        }
        try {
            FunctionUtility.applySignature((Function)target, (Function)source, (boolean)this.applyEmptyStructures, (DataTypeConflictHandler)DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER);
            return new BSimApplyResult(target, source, BSimResultStatus.SIGNATURE_APPLIED, "");
        }
        catch (Exception e) {
            return new BSimApplyResult(target, source, BSimResultStatus.ERROR, "Apply signature failed (" + e.getMessage() + ")");
        }
    }
}

