/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.ViewBox;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.ext.awt.image.ConcreteComponentTransferFunction;
import io.sf.carte.echosvg.ext.awt.image.renderable.ComponentTransferRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.gvt.AbstractGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.PatternPaint;
import io.sf.carte.echosvg.gvt.RootGraphicsNode;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGPatternElementBridge
extends AnimatableGenericSVGBridge
implements PaintBridge,
ErrorConstants {
    @Override
    public String getLocalName() {
        return "pattern";
    }

    @Override
    public Paint createPaint(BridgeContext ctx, Element patternElement, Element paintedElement, GraphicsNode paintedNode, float opacity) {
        RootGraphicsNode patternContentNode = (RootGraphicsNode)ctx.getElementData(patternElement);
        if (patternContentNode == null) {
            patternContentNode = SVGPatternElementBridge.extractPatternContent(patternElement, ctx);
            ctx.setElementData(patternElement, patternContentNode);
        }
        if (patternContentNode == null) {
            return null;
        }
        Rectangle2D patternRegion = SVGUtilities.convertPatternRegion(patternElement, paintedElement, paintedNode, ctx);
        String s = SVGUtilities.getChainableAttributeNS(patternElement, null, "patternTransform", ctx);
        AffineTransform patternTransform = s.length() != 0 ? SVGUtilities.convertTransform(patternElement, "patternTransform", s, ctx) : new AffineTransform();
        boolean overflowIsHidden = CSSUtilities.convertOverflow(patternElement);
        s = SVGUtilities.getChainableAttributeNS(patternElement, null, "patternContentUnits", ctx);
        short contentCoordSystem = s.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(patternElement, "patternContentUnits", s, ctx);
        AffineTransform patternContentTransform = new AffineTransform();
        patternContentTransform.translate(patternRegion.getX(), patternRegion.getY());
        String viewBoxStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "viewBox", ctx);
        if (viewBoxStr.length() > 0) {
            float h;
            float w;
            String aspectRatioStr = SVGUtilities.getChainableAttributeNS(patternElement, null, "preserveAspectRatio", ctx);
            AffineTransform preserveAspectRatioTransform = ViewBox.getPreserveAspectRatioTransform(patternElement, viewBoxStr, aspectRatioStr, w = (float)patternRegion.getWidth(), h = (float)patternRegion.getHeight(), ctx);
            if (preserveAspectRatioTransform == null) {
                return null;
            }
            patternContentTransform.concatenate(preserveAspectRatioTransform);
        } else if (contentCoordSystem == 2) {
            AffineTransform patternContentUnitsTransform = new AffineTransform();
            Rectangle2D objectBoundingBox = paintedNode.getGeometryBounds();
            patternContentUnitsTransform.translate(objectBoundingBox.getX(), objectBoundingBox.getY());
            patternContentUnitsTransform.scale(objectBoundingBox.getWidth(), objectBoundingBox.getHeight());
            patternContentTransform.concatenate(patternContentUnitsTransform);
        }
        PatternGraphicsNode gn = new PatternGraphicsNode((GraphicsNode)patternContentNode);
        gn.setTransform(patternContentTransform);
        if (opacity != 1.0f) {
            Filter filter = gn.getGraphicsNodeRable(true);
            filter = new ComponentTransferRable8Bit(filter, ConcreteComponentTransferFunction.getLinearTransfer((float)opacity, (float)0.0f), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer());
            gn.setFilter(filter);
        }
        return new PatternPaint((GraphicsNode)gn, patternRegion, !overflowIsHidden, patternTransform);
    }

    protected static RootGraphicsNode extractPatternContent(Element patternElement, BridgeContext ctx) {
        LinkedList<ParsedURL> refs = new LinkedList<ParsedURL>();
        RootGraphicsNode content;
        while ((content = SVGPatternElementBridge.extractLocalPatternContent(patternElement, ctx)) == null) {
            String uri = XLinkSupport.getXLinkHref((Element)patternElement);
            if (uri.length() == 0) {
                return null;
            }
            SVGOMDocument doc = (SVGOMDocument)patternElement.getOwnerDocument();
            ParsedURL purl = new ParsedURL(doc.getURL(), uri);
            if (!purl.complete()) {
                BridgeException be = new BridgeException(ctx, patternElement, "uri.malformed", new Object[]{uri});
                SVGPatternElementBridge.displayErrorOrThrow(ctx, be);
                return null;
            }
            if (SVGPatternElementBridge.contains(refs, purl)) {
                BridgeException be = new BridgeException(ctx, patternElement, "xlink.href.circularDependencies", new Object[]{uri});
                SVGPatternElementBridge.displayErrorOrThrow(ctx, be);
                return null;
            }
            if ((patternElement = ctx.getReferencedElement(patternElement, uri)) == null) {
                return null;
            }
            refs.add(purl);
        }
        return content;
    }

    protected static RootGraphicsNode extractLocalPatternContent(Element e, BridgeContext ctx) {
        GVTBuilder builder = ctx.getGVTBuilder();
        RootGraphicsNode content = null;
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            GraphicsNode gn;
            if (n.getNodeType() != 1 || (gn = builder.build(ctx, (Element)n)) == null) continue;
            if (content == null) {
                content = new RootGraphicsNode();
            }
            content.getChildren().add(gn);
        }
        return content;
    }

    private static boolean contains(List<ParsedURL> urls, ParsedURL key) {
        for (ParsedURL url : urls) {
            if (!key.equals((Object)url)) continue;
            return true;
        }
        return false;
    }

    public static class PatternGraphicsNode
    extends AbstractGraphicsNode {
        GraphicsNode pcn;
        Rectangle2D pBounds;
        Rectangle2D gBounds;
        Rectangle2D sBounds;
        Shape oShape;

        public PatternGraphicsNode(GraphicsNode gn) {
            this.pcn = gn;
        }

        public void primitivePaint(Graphics2D g2d) {
            this.pcn.paint(g2d);
        }

        public Rectangle2D getPrimitiveBounds() {
            if (this.pBounds != null) {
                return this.pBounds;
            }
            this.pBounds = this.pcn.getTransformedBounds(IDENTITY);
            return this.pBounds;
        }

        public Rectangle2D getGeometryBounds() {
            if (this.gBounds != null) {
                return this.gBounds;
            }
            this.gBounds = this.pcn.getTransformedGeometryBounds(IDENTITY);
            return this.gBounds;
        }

        public Rectangle2D getSensitiveBounds() {
            if (this.sBounds != null) {
                return this.sBounds;
            }
            this.sBounds = this.pcn.getTransformedSensitiveBounds(IDENTITY);
            return this.sBounds;
        }

        public Shape getOutline() {
            if (this.oShape != null) {
                return this.oShape;
            }
            this.oShape = this.pcn.getOutline();
            AffineTransform tr = this.pcn.getTransform();
            if (tr != null) {
                this.oShape = tr.createTransformedShape(this.oShape);
            }
            return this.oShape;
        }

        protected void invalidateGeometryCache() {
            this.pBounds = null;
            this.gBounds = null;
            this.sBounds = null;
            this.oShape = null;
            super.invalidateGeometryCache();
        }
    }
}

