/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Disassembler;
import jogamp.graph.font.typecast.ot.Fmt;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfTable;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] _endPtsOfContours;
    private byte[] _flags;
    private short[] _xCoordinates;
    private short[] _yCoordinates;
    private int _count;

    public GlyfSimpleDescript(GlyfTable glyfTable, int n, short n2, DataInput dataInput) throws IOException {
        super(glyfTable, n, (short)n2, dataInput);
        int n3;
        this._endPtsOfContours = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            this._endPtsOfContours[n3] = dataInput.readUnsignedShort();
        }
        this._count = this._endPtsOfContours[n2 - 1] + 1;
        this._flags = new byte[this._count];
        this._xCoordinates = new short[this._count];
        this._yCoordinates = new short[this._count];
        n3 = dataInput.readUnsignedShort();
        this.readInstructions(dataInput, n3);
        this.readFlags(this._count, dataInput);
        this.readCoords(this._count, dataInput);
    }

    @Override
    public int getNumberOfContours() {
        return this._endPtsOfContours.length;
    }

    @Override
    public int getEndPtOfContours(int n) {
        return this._endPtsOfContours[n];
    }

    @Override
    public byte getFlags(int n) {
        return this._flags[n];
    }

    @Override
    public short getXCoordinate(int n) {
        return this._xCoordinates[n];
    }

    @Override
    public short getYCoordinate(int n) {
        return this._yCoordinates[n];
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getPointCount() {
        return this._count;
    }

    @Override
    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int n, DataInput dataInput) throws IOException {
        int n2;
        short s = 0;
        short s2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            byte by = this._flags[n2];
            if ((by & 0x10) != 0) {
                if ((by & 2) != 0) {
                    s = (short)(s + (short)dataInput.readUnsignedByte());
                }
            } else {
                s = (by & 2) != 0 ? (short)(s - (short)dataInput.readUnsignedByte()) : (short)(s + dataInput.readShort());
            }
            this._xCoordinates[n2] = s;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if ((this._flags[n2] & 0x20) != 0) {
                if ((this._flags[n2] & 4) != 0) {
                    s2 = (short)(s2 + (short)dataInput.readUnsignedByte());
                }
            } else {
                s2 = (this._flags[n2] & 4) != 0 ? (short)(s2 - (short)dataInput.readUnsignedByte()) : (short)(s2 + dataInput.readShort());
            }
            this._yCoordinates[n2] = s2;
        }
    }

    private void readFlags(int n, DataInput dataInput) throws IOException {
        try {
            for (int i = 0; i < n; ++i) {
                this._flags[i] = dataInput.readByte();
                if ((this._flags[i] & 8) == 0) continue;
                int n2 = dataInput.readUnsignedByte();
                for (int j = 1; j <= n2; ++j) {
                    this._flags[i + j] = this._flags[i];
                }
                i += n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("error: array index out of bounds");
        }
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("        Simple Glyph\n");
        stringBuilder.append("        ------------\n");
        stringBuilder.append(super.toString());
        stringBuilder.append("\n\n");
        stringBuilder.append("        EndPoints\n");
        stringBuilder.append("        ---------");
        for (n = 0; n < this._endPtsOfContours.length; ++n) {
            stringBuilder.append("\n          ").append(n).append(": ").append(this._endPtsOfContours[n]);
        }
        stringBuilder.append("\n\n");
        stringBuilder.append("        Instructions\n");
        stringBuilder.append("        ------------\n");
        stringBuilder.append("          length: ");
        stringBuilder.append(this.getInstructions().length).append("\n");
        stringBuilder.append(Disassembler.disassemble(this.getInstructions(), 10));
        stringBuilder.append("\n        Flags\n        -----");
        for (n = 0; n < this._flags.length; ++n) {
            stringBuilder.append("\n          ").append(Fmt.pad(3, n)).append(":  ");
            if ((this._flags[n] & 0x40) != 0) {
                stringBuilder.append("SOver ");
            } else {
                stringBuilder.append("      ");
            }
            if ((this._flags[n] & 0x20) != 0) {
                stringBuilder.append("YDual ");
            } else {
                stringBuilder.append("      ");
            }
            if ((this._flags[n] & 0x10) != 0) {
                stringBuilder.append("XDual ");
            } else {
                stringBuilder.append("      ");
            }
            if ((this._flags[n] & 8) != 0) {
                stringBuilder.append("Repeat ");
            } else {
                stringBuilder.append("       ");
            }
            if ((this._flags[n] & 4) != 0) {
                stringBuilder.append("Y-Short ");
            } else {
                stringBuilder.append("        ");
            }
            if ((this._flags[n] & 2) != 0) {
                stringBuilder.append("X-Short ");
            } else {
                stringBuilder.append("        ");
            }
            if ((this._flags[n] & 1) != 0) {
                stringBuilder.append("On");
                continue;
            }
            stringBuilder.append("  ");
        }
        stringBuilder.append("\n\n        Coordinates\n        -----------");
        n = 0;
        short s = 0;
        for (int i = 0; i < this._xCoordinates.length; ++i) {
            stringBuilder.append("\n          ").append(Fmt.pad(3, i)).append(": Rel (").append(this._xCoordinates[i] - n).append(", ").append(this._yCoordinates[i] - s).append(")  ->  Abs (").append(this._xCoordinates[i]).append(", ").append(this._yCoordinates[i]).append(")");
            n = this._xCoordinates[i];
            s = this._yCoordinates[i];
        }
        return stringBuilder.toString();
    }
}

