/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSNamespace;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class PostgreNamespace
implements DBSNamespace {
    private static final Log log = Log.getLog(PostgreNamespace.class);
    public static final DBSObjectType[] SUPPORTED_TYPES = new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_DATA_TYPE, RelationalObjectType.TYPE_INDEX, RelationalObjectType.TYPE_SEQUENCE};
    private final PostgreSchema schema;

    public static boolean supportsObjectType(DBSObjectType objectType) {
        for (DBSObjectType ot : SUPPORTED_TYPES) {
            if (ot != objectType) continue;
            return true;
        }
        for (DBSObjectType ot : SUPPORTED_TYPES) {
            if (!ot.isCompatibleWith(objectType)) continue;
            return true;
        }
        return false;
    }

    public PostgreNamespace(@NotNull PostgreSchema schema) {
        this.schema = schema;
    }

    @NotNull
    public DBSObjectType[] getNamespaceObjectTypes() {
        return SUPPORTED_TYPES;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public DBSObject getObjectByName(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 45[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public List<? extends DBSObject> getObjectsByType(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectType objectType) throws DBException {
        if (objectType == RelationalObjectType.TYPE_TABLE || objectType == RelationalObjectType.TYPE_VIEW) {
            return this.schema.getTables(monitor);
        }
        if (objectType == RelationalObjectType.TYPE_SEQUENCE) {
            return this.schema.getSequences(monitor);
        }
        if (objectType == RelationalObjectType.TYPE_DATA_TYPE) {
            return this.schema.getDataTypes(monitor);
        }
        if (objectType == RelationalObjectType.TYPE_INDEX) {
            return this.schema.getIndexes(monitor);
        }
        throw new DBException("Unsupported object type: " + objectType.getTypeName());
    }
}

