/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.erd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.erd.DiagramCollectSettings;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDUtils;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.utils.CommonUtils;

public class DiagramObjectCollector {
    private static final Log log = Log.getLog(DiagramObjectCollector.class);
    private final ERDDiagram diagram;
    private final List<ERDEntity> erdEntities = new ArrayList<ERDEntity>();
    private boolean showViews;
    private boolean showPartitions;

    public DiagramObjectCollector(ERDDiagram diagram) {
        this.diagram = diagram;
    }

    public static Collection<DBSEntity> collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, DiagramCollectSettings settings, boolean forceShowViews) throws DBException {
        LinkedHashSet<DBSEntity> tables = new LinkedHashSet<DBSEntity>();
        DiagramObjectCollector.collectTables(monitor, roots, tables, settings, forceShowViews);
        return tables;
    }

    public void setShowViews(boolean showViews) {
        this.showViews = showViews;
    }

    /*
     * WARNING - void declaration
     */
    private static void collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, Set<DBSEntity> tables, DiagramCollectSettings settings, boolean forceShowViews) throws DBException {
        boolean showPartitions = settings.isShowPartitions();
        boolean showViews = settings.isShowViews();
        for (DBSObject dBSObject : roots) {
            void var8_8;
            if (monitor.isCanceled()) break;
            DBSObject dBSObject2 = DBUtils.getPublicObject((DBSObject)dBSObject);
            if (dBSObject2 instanceof DBSAlias) {
                DBSObject dBSObject3 = ((DBSAlias)dBSObject2).getTargetObject(monitor);
            }
            if (var8_8 instanceof DBSFolder) {
                DiagramObjectCollector.collectTables(monitor, ((DBSFolder)var8_8).getChildrenObjects(monitor), tables, settings, false);
            } else if (var8_8 instanceof DBSEntity) {
                if (var8_8 instanceof DBSTablePartition && !showPartitions || DBUtils.isView((DBSEntity)((DBSEntity)var8_8)) && !showViews && !forceShowViews) continue;
                tables.add((DBSEntity)var8_8);
            }
            if (!(var8_8 instanceof DBSObjectContainer)) continue;
            DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)var8_8, tables, showViews, showPartitions);
        }
    }

    private static void collectTables(DBRProgressMonitor monitor, DBSObjectContainer container, Set<DBSEntity> tables, boolean showViews, boolean showPartitions) throws DBException {
        if (monitor.isCanceled()) {
            return;
        }
        container.cacheStructure(monitor, 7);
        Collection children = container.getChildren(monitor);
        if (!CommonUtils.isEmpty((Collection)children)) {
            Class childType = container.getPrimaryChildType(monitor);
            DBSObjectFilter objectFilter = container.getDataSource().getContainer().getObjectFilter(childType, (DBSObject)container, true);
            for (DBSObject entity : children) {
                if (monitor.isCanceled()) break;
                if (objectFilter != null && !objectFilter.matches(entity.getName())) continue;
                if (entity instanceof DBSEntity) {
                    DBSEntity entity1 = (DBSEntity)entity;
                    if (entity instanceof DBSTablePartition && !showPartitions || DBUtils.isView((DBSEntity)entity1) && !showViews || ERDUtils.skipSystemEntity(entity1)) continue;
                    tables.add(entity1);
                    continue;
                }
                if (!(entity instanceof DBSObjectContainer)) continue;
                DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)entity, tables, showViews, showPartitions);
            }
        }
    }

    public void generateDiagramObjects(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, DiagramCollectSettings settings) throws DBException {
        Collection<DBSEntity> tables = DiagramObjectCollector.collectTables(monitor, roots, settings, this.showViews);
        for (DBSEntity table : tables) {
            if (DBUtils.isHiddenObject((Object)table)) continue;
            this.addDiagramEntity(monitor, table);
        }
        for (ERDEntity erdEntity : this.erdEntities) {
            erdEntity.addModelRelations(monitor, this.diagram, true, false);
        }
    }

    private void addDiagramEntity(DBRProgressMonitor monitor, DBSEntity table) {
        if (this.diagram.containsTable(table) && !this.diagram.getContentProvider().allowEntityDuplicates()) {
            return;
        }
        ERDEntity erdEntity = ERDUtils.makeEntityFromObject(monitor, this.diagram, this.erdEntities, table, null);
        if (erdEntity != null) {
            this.erdEntities.add(erdEntity);
        }
    }

    private boolean aliasExist(String alias) {
        for (ERDEntity entity : this.erdEntities) {
            if (!CommonUtils.equalObjects((Object)entity.getAlias(), (Object)alias)) continue;
            return true;
        }
        return false;
    }

    public List<ERDEntity> getDiagramEntities() {
        return this.erdEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ERDEntity> generateEntityList(@NotNull DBRProgressMonitor monitor, @NotNull ERDDiagram diagram, @NotNull DBPProject diagramProject, @NotNull Collection<DBPNamedObject> objects, @NotNull DiagramCollectSettings settings, boolean forceShowViews, boolean enforceSameProject) {
        ArrayList<DBSObject> roots = new ArrayList<DBSObject>();
        for (DBPNamedObject list : objects) {
            if (!(list instanceof DBSObject)) continue;
            if (list instanceof DBPDataSourceContainer && !((DBPDataSourceContainer)list).isConnected()) {
                monitor.subTask("Connect to '" + list.getName() + "'");
                try {
                    ((DBPDataSourceContainer)list).connect(monitor, true, true);
                }
                catch (DBException dBException) {
                    log.debug((Object)dBException);
                    diagram.addErrorMessage("Can't connect to '" + list.getName() + "': " + dBException.getMessage());
                    continue;
                }
            }
            roots.add((DBSObject)list);
        }
        if (enforceSameProject) {
            Map<DBPProject, List<DBSObject>> foreignObjectsPerProject = roots.stream().filter(r -> r.getDataSource().getContainer().getProject() != diagramProject).collect(Collectors.groupingBy(r -> r.getDataSource().getContainer().getProject()));
            for (Map.Entry<DBPProject, List<DBSObject>> entry : foreignObjectsPerProject.entrySet()) {
                StringJoiner joiner = new StringJoiner(", ");
                DBPProject project = entry.getKey();
                List<DBSObject> values = entry.getValue();
                for (DBSObject value : values) {
                    joiner.add("'" + DBUtils.getObjectFullName((DBPNamedObject)value, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'");
                }
                diagram.addErrorMessage("Can't add object" + (values.size() > 1 ? "s" : "") + " " + String.valueOf(joiner) + " from a different project '" + project.getName() + "' (current project is '" + diagramProject.getName() + "')");
                roots.removeAll(values);
            }
        }
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        monitor.beginTask("Collect diagram objects", 1);
        DiagramObjectCollector collector = new DiagramObjectCollector(diagram);
        collector.setShowViews(forceShowViews);
        try {
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)((DBSObject)roots.getFirst()).getDataSource(), monitor1 -> collector.generateDiagramObjects((DBRProgressMonitor)monitor1, (Collection<? extends DBSObject>)roots, settings));
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        try {
            List<ERDEntity> list = collector.getDiagramEntities();
            return list;
        }
        finally {
            monitor.done();
        }
    }
}

