/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator.resultset;

import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetDataProvider;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryGeneratorUpdate;
import org.jkiss.dbeaver.model.sql.generator.resultset.SQLGeneratorResultSet;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorDeleteFromData
extends SQLGeneratorResultSet {
    @Override
    protected void generateSQL(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, @NotNull DBDResultSetDataProvider dataProvider) throws DBException {
        DBSEntity dbsEntity = dataProvider.getSingleSource();
        String entityName = this.getEntityName(dbsEntity);
        for (DBDValueRow firstRow : dataProvider.getSelectedRows()) {
            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, dataProvider);
            if (dbsEntity instanceof SQLQueryGeneratorUpdate) {
                sql.append(((SQLQueryGeneratorUpdate)dbsEntity).generateTableDeleteFrom(entityName));
            } else {
                sql.append("DELETE FROM ").append(entityName);
            }
            sql.append(this.getLineSeparator()).append("WHERE ");
            if (CommonUtils.isEmpty(keyAttributes)) {
                Collection<? extends DBSAttributeBase> allAttributes = this.getAllAttributes(monitor, dataProvider);
                for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                    DBDAttributeBinding binding;
                    if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase) || (binding = DBUtils.findBinding((DBDAttributeBinding[])dataProvider.getAttributes(), (DBSAttributeBase)dBSAttributeBase)) == null) continue;
                    keyAttributes.add(binding);
                }
            }
            this.appendKeyConditions(sql, keyAttributes, firstRow);
            sql.append(";\n");
        }
    }
}

