/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.utils.CommonUtils;

public class RowDataReceiver
implements DBDDataReceiver {
    private static final Log log = Log.getLog(RowDataReceiver.class);
    protected final DBDAttributeBinding[] curAttributes;
    protected Object[] rowValues;

    public RowDataReceiver(DBDAttributeBinding[] curAttributes) {
        this.curAttributes = curAttributes;
    }

    @Override
    public void fetchStart(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, long offset, long maxRows) {
    }

    @Override
    public void fetchRow(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
        DBCResultSetMetaData rsMeta = resultSet.getMeta();
        List<? extends DBCAttributeMetaData> attributes = rsMeta.getAttributes();
        if (attributes.size() != this.curAttributes.length) {
            log.debug("Wrong meta attributes count (" + attributes.size() + " <> " + this.curAttributes.length + ") - can't refresh");
            return;
        }
        for (int i = 0; i < this.curAttributes.length; ++i) {
            DBCAttributeMetaData metaAttribute = this.curAttributes[i].getMetaAttribute();
            if (metaAttribute != null && CommonUtils.equalObjects((Object)metaAttribute.getName(), (Object)attributes.get(i).getName())) continue;
            log.debug("Attribute '" + String.valueOf(metaAttribute) + "' doesn't match '" + attributes.get(i).getName() + "'");
            return;
        }
        this.fetchRowValues(session, resultSet);
    }

    protected void fetchRowValues(DBCSession session, DBCResultSet resultSet) throws DBCException {
        this.rowValues = new Object[this.curAttributes.length];
        for (int i = 0; i < this.curAttributes.length; ++i) {
            Object attrValue;
            DBDAttributeBinding attr = this.curAttributes[i];
            DBDValueHandler valueHandler = attr.getValueHandler();
            this.rowValues[i] = attrValue = valueHandler.fetchValueObject(session, resultSet, attr, i);
        }
    }

    @Override
    public void fetchEnd(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) {
    }

    @Override
    public void close() {
    }

    public Object[] getRowValues() {
        return this.rowValues;
    }
}

