/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.functions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.registry.functions.AggregateFunctionDescriptor;

public class FunctionsRegistry {
    static final String TAG_FUNCTION = "function";
    private static FunctionsRegistry instance = null;
    private final List<AggregateFunctionDescriptor> aggregateFunctions = new ArrayList<AggregateFunctionDescriptor>();

    public static synchronized FunctionsRegistry getInstance() {
        if (instance == null) {
            instance = new FunctionsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private FunctionsRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        for (IConfigurationElement ext : extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.aggregateFunction")) {
            if (!TAG_FUNCTION.equals(ext.getName())) continue;
            this.aggregateFunctions.add(new AggregateFunctionDescriptor(ext));
        }
    }

    public void dispose() {
        this.aggregateFunctions.clear();
    }

    public List<AggregateFunctionDescriptor> getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    public AggregateFunctionDescriptor getFunction(String id) {
        for (AggregateFunctionDescriptor func : this.aggregateFunctions) {
            if (!func.getId().equals(id)) continue;
            return func;
        }
        return null;
    }
}

