/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferAttributeTransformerDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferEventProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.utils.CommonUtils;

public class DataTransferRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataTransfer";
    private static DataTransferRegistry instance = null;
    private static final Log log = Log.getLog(DataTransferRegistry.class);
    private final List<DataTransferNodeDescriptor> nodes = new ArrayList<DataTransferNodeDescriptor>();
    private final Map<String, DataTransferAttributeTransformerDescriptor> transformers = new LinkedHashMap<String, DataTransferAttributeTransformerDescriptor>();
    private final Map<String, DataTransferEventProcessorDescriptor> eventProcessors = new LinkedHashMap<String, DataTransferEventProcessorDescriptor>();

    private DataTransferRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            if ("node".equals(ext.getName())) {
                if (!CommonUtils.isEmpty((String)ext.getAttribute("ref"))) continue;
                DataTransferNodeDescriptor node = new DataTransferNodeDescriptor(ext);
                this.nodes.add(node);
                continue;
            }
            if ("transformer".equals(ext.getName())) {
                DataTransferAttributeTransformerDescriptor at = new DataTransferAttributeTransformerDescriptor(ext);
                this.transformers.put(at.getId(), at);
                continue;
            }
            if (!"eventProcessor".equals(ext.getName())) continue;
            DataTransferEventProcessorDescriptor descriptor = new DataTransferEventProcessorDescriptor(ext);
            this.eventProcessors.put(descriptor.getId(), descriptor);
        }
        for (IConfigurationElement ext : extElements) {
            String nodeReference;
            if (!"node".equals(ext.getName()) || CommonUtils.isEmpty((String)(nodeReference = ext.getAttribute("ref")))) continue;
            DataTransferNodeDescriptor refNode = this.getNodeById(nodeReference);
            if (refNode == null) {
                log.error((Object)("Referenced data transfer node '" + nodeReference + "' not found"));
                continue;
            }
            refNode.loadNodeConfigurations(ext);
        }
        this.nodes.sort(Comparator.comparing(DataTransferNodeDescriptor::getName));
    }

    @NotNull
    public static synchronized DataTransferRegistry getInstance() {
        if (instance == null) {
            instance = new DataTransferRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public List<DataTransferNodeDescriptor> getAvailableProducers(@NotNull Collection<DBSObject> sourceObjects) {
        return this.getAvailableNodes(DataTransferNodeDescriptor.NodeType.PRODUCER, sourceObjects);
    }

    @NotNull
    public List<DataTransferNodeDescriptor> getAvailableConsumers(@NotNull Collection<DBSObject> sourceObjects) {
        return this.getAvailableNodes(DataTransferNodeDescriptor.NodeType.CONSUMER, sourceObjects);
    }

    @NotNull
    List<DataTransferNodeDescriptor> getAvailableNodes(@NotNull DataTransferNodeDescriptor.NodeType nodeType, @NotNull Collection<DBSObject> sourceObjects) {
        ArrayList<DataTransferNodeDescriptor> result = new ArrayList<DataTransferNodeDescriptor>();
        block0: for (DataTransferNodeDescriptor node : this.nodes) {
            if (node.getNodeType() != nodeType) continue;
            for (DBSObject sourceObject : sourceObjects) {
                if (!node.appliesToType(sourceObject.getClass())) continue;
                result.add(node);
                continue block0;
            }
        }
        return result;
    }

    @NotNull
    public List<DataTransferNodeDescriptor> getNodes(@NotNull DataTransferNodeDescriptor.NodeType nodeType) {
        ArrayList<DataTransferNodeDescriptor> result = new ArrayList<DataTransferNodeDescriptor>();
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (node.getNodeType() != nodeType) continue;
            result.add(node);
        }
        return result;
    }

    @Nullable
    public DataTransferNodeDescriptor getNodeByType(@NotNull Class<? extends IDataTransferNode> type) {
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (!type.equals(node.getNodeClass())) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public DataTransferNodeDescriptor getNodeById(@NotNull String id) {
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public DataTransferProcessorDescriptor getProcessor(@NotNull String processorFullId) {
        DataTransferNodeDescriptor node;
        String[] idParts = processorFullId.split(":");
        if (idParts.length == 2 && (node = this.getNodeById(idParts[0])) != null) {
            return node.getProcessor(idParts[1]);
        }
        return null;
    }

    @Nullable
    public List<DataTransferProcessorDescriptor> getAvailableProcessors(@NotNull Class<? extends IDataTransferNode<?>> nodeType, @NotNull Class<?> objectType) {
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (node.getNodeClass() != nodeType || !node.appliesToType(objectType)) continue;
            return node.getAvailableProcessors(objectType);
        }
        return null;
    }

    @NotNull
    public List<DataTransferAttributeTransformerDescriptor> getAttributeTransformers() {
        return new ArrayList<DataTransferAttributeTransformerDescriptor>(this.transformers.values());
    }

    @Nullable
    public DataTransferAttributeTransformerDescriptor getAttributeTransformer(String id) {
        return this.transformers.get(id);
    }

    @Nullable
    public DataTransferAttributeTransformerDescriptor getAttributeTransformerByName(@NotNull String tName) {
        return this.transformers.values().stream().filter(t -> t.getName().equals(tName)).findFirst().orElse(null);
    }

    @NotNull
    public Collection<DataTransferEventProcessorDescriptor> getEventProcessors(@NotNull String nodeId) {
        return this.eventProcessors.values().stream().filter(x -> x.isApplicable(nodeId)).sorted(Comparator.comparingInt(DataTransferEventProcessorDescriptor::getOrder)).collect(Collectors.toList());
    }

    @Nullable
    public DataTransferEventProcessorDescriptor getEventProcessorById(@NotNull String id) {
        return this.eventProcessors.get(id);
    }
}

