/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.confirmation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.registry.confirmation.ConfirmationDescriptor;

public class ConfirmationRegistry {
    private static final String ELEMENT_ID = "confirmation";
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.confirmations";
    private static ConfirmationRegistry instance;
    private final Map<String, ConfirmationDescriptor> confirmations = new HashMap<String, ConfirmationDescriptor>();

    ConfirmationRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEMENT_ID.equals(element.getName())) {
                ConfirmationDescriptor descriptor = new ConfirmationDescriptor(element);
                this.confirmations.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
    }

    @NotNull
    public static synchronized ConfirmationRegistry getInstance() {
        if (instance == null) {
            instance = new ConfirmationRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public Collection<ConfirmationDescriptor> getConfirmations() {
        return this.confirmations.values();
    }

    @NotNull
    public ConfirmationDescriptor getConfirmation(@NotNull String id) {
        ConfirmationDescriptor descriptor = this.confirmations.get(id);
        if (descriptor == null) {
            throw new IllegalArgumentException("Can't find confirmation '" + id + "'");
        }
        return descriptor;
    }
}

