/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.rdb.DBSPartitionContainer;
import org.jkiss.utils.CommonUtils;

public abstract class OracleTablePhysical
extends OracleTableBase
implements DBSObjectLazy<OracleDataSource>,
DBSPartitionContainer {
    private static final Log log = Log.getLog(OracleTablePhysical.class);
    private static final String SUB_PART_KEY_TYPE = "SUBPART";
    private long rowCount;
    private Long realRowCount;
    private Object tablespace;
    private boolean partitioned;
    private String partitionedBy;
    private String subPartitionedBy;
    private PartitionInfo partitionInfo;
    private PartitionCache partitionCache;
    private Set<OracleTableColumn> partitionKeys = new HashSet<OracleTableColumn>();
    private Set<OracleTableColumn> subPartitionKeys = new HashSet<OracleTableColumn>();

    protected OracleTablePhysical(@NotNull OracleSchema schema, @NotNull String name) {
        super(schema, name, false);
        this.partitionInfo = new PartitionInfo();
        this.partitionCache = new PartitionCache();
    }

    protected OracleTablePhysical(@NotNull OracleSchema schema, @NotNull ResultSet dbResult) {
        super(schema, dbResult);
        this.readSpecialProperties(dbResult);
        this.partitioned = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PARTITIONED", (String)"Y");
        this.partitionCache = this.partitioned ? (this.partitionCache == null ? new PartitionCache() : this.partitionCache) : null;
    }

    protected OracleTablePhysical(@NotNull OracleSchema schema, @NotNull ResultSet dbResult, @NotNull String name) {
        super(schema, name);
        this.readSpecialProperties(dbResult);
        this.partitioned = false;
    }

    private void readSpecialProperties(@NotNull ResultSet dbResult) {
        this.rowCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUM_ROWS");
        this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLESPACE_NAME");
    }

    @Property(category="Statistics", viewable=true, order=20)
    public long getRowCount() {
        return this.rowCount;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=21)
    public synchronized Long getRealRowCount(DBRProgressMonitor monitor) {
        if (this.realRowCount != null) {
            return this.realRowCount;
        }
        if (!this.isPersisted()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                this.realRowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't fetch row count", (Throwable)e);
        }
        if (this.realRowCount == null) {
            this.realRowCount = -1L;
        }
        return this.realRowCount;
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        return this.tablespace;
    }

    @Property(viewable=true, order=22, editable=true, updatable=true, listProvider=TablespaceListProvider.class)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, null);
    }

    public Object getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(OracleTablespace tablespace) {
        this.tablespace = tablespace;
    }

    @Association
    public Collection<OracleTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).indexCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    public OracleTableIndex getIndex(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleTableIndex)((OracleSchema)this.getContainer()).indexCache.getObject(monitor, (OracleSchema)this.getContainer(), this, name);
    }

    public PartitionCache getPartitionCache() {
        return this.partitionCache;
    }

    @PropertyGroup
    @LazyProperty(cacheValidator=PartitionInfoValidator.class)
    public PartitionInfo getPartitionInfo(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionInfo == null && this.partitioned && this.isPersisted()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load partitioning info");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM ALL_PART_TABLES WHERE OWNER=? AND TABLE_NAME=?");){
                        dbStat.setString(1, ((OracleSchema)this.getContainer()).getName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                this.partitionInfo = new PartitionInfo(monitor, (OracleDataSource)this.getDataSource(), (ResultSet)dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, this.getDataSource());
            }
        }
        return this.partitionInfo;
    }

    @Nullable
    public PartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    @Property(viewable=true, order=13)
    @Association
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Property(viewable=true, editableExpr="object.getDataSource().supportsPartitionsCreation()", order=16, visibleIf=PartitioningTablePropertyValidator.class)
    @LazyProperty(cacheValidator=PartitionedValueLoadValidator.class)
    public String getPartitionedBy(DBRProgressMonitor monitor) {
        if (this.isPersisted() && this.partitionedBy == null && this.isPartitioned()) {
            this.loadPartitionKeys(monitor);
            if (!CommonUtils.isEmpty(this.partitionKeys)) {
                this.partitionedBy = this.partitionKeys.stream().map(JDBCTableColumn::getName).collect(Collectors.joining(","));
            }
        }
        return this.partitionedBy;
    }

    public void setPartitionedBy(String partitionedBy) {
        if (CommonUtils.isNotEmpty((String)partitionedBy) && this.partitionInfo == null) {
            this.partitionInfo = new PartitionInfo();
        }
        if (this.partitionCache == null) {
            this.partitionCache = new PartitionCache();
        }
        this.partitionedBy = partitionedBy;
    }

    public Set<OracleTableColumn> getPartitionKeys() {
        return this.partitionKeys;
    }

    @Property(viewable=true, editableExpr="object.getDataSource().supportsPartitionsCreation()", order=17, visibleIf=PartitioningTablePropertyValidator.class)
    public String getSubPartitionedBy() {
        if (CommonUtils.isEmpty((String)this.subPartitionedBy) && !CommonUtils.isEmpty(this.subPartitionKeys)) {
            this.subPartitionedBy = this.subPartitionKeys.stream().map(JDBCTableColumn::getName).collect(Collectors.joining(","));
        }
        return this.subPartitionedBy;
    }

    public void setSubPartitionedBy(String subPartitionedBy) {
        this.subPartitionedBy = subPartitionedBy;
    }

    public Set<OracleTableColumn> getSubPartitionKeys() {
        return this.subPartitionKeys;
    }

    private void loadPartitionKeys(@NotNull DBRProgressMonitor monitor) {
        String tableName = this.getName();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load partition key info for table");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement stat = session.prepareStatement("SELECT COLUMN_NAME, 'PART' AS TYPE\nFROM SYS.ALL_PART_KEY_COLUMNS\nWHERE OBJECT_TYPE = 'TABLE'\n  AND OWNER = ?\n  AND NAME = ?\n  UNION ALL\nSELECT COLUMN_NAME, 'SUBPART' AS TYPE\nFROM SYS.ALL_SUBPART_KEY_COLUMNS\nWHERE OBJECT_TYPE = 'TABLE'\n  AND OWNER = ?\n  AND NAME = ?");){
                    String schemaName = this.getSchema().getName();
                    stat.setString(1, schemaName);
                    stat.setString(2, tableName);
                    stat.setString(3, schemaName);
                    stat.setString(4, tableName);
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet resultSet = stat.executeQuery();){
                        while (resultSet.next()) {
                            String colName = resultSet.getString(1);
                            String keyType = resultSet.getString(2);
                            OracleTableColumn col = this.getAttribute(monitor, colName);
                            if (col == null) {
                                log.warn((Object)("Column '" + colName + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
                                continue;
                            }
                            if (SUB_PART_KEY_TYPE.equals(keyType)) {
                                this.subPartitionKeys.add(col);
                                continue;
                            }
                            this.partitionKeys.add(col);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error fetching table '" + tableName + "' partition keys info."), (Throwable)e);
        }
    }

    @NotNull
    @Association
    public Collection<OracleTablePartition> getPartitions(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionCache == null) {
            return Collections.emptyList();
        }
        if (!this.isPersisted()) {
            return this.getCachedPartitions();
        }
        return this.partitionCache.getAllObjects(monitor, this);
    }

    @NotNull
    public Collection<OracleTablePartition> getCachedPartitions() {
        if (this.partitionCache == null) {
            return Collections.emptyList();
        }
        return this.partitionCache.getCachedObjects();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).indexCache.clearObjectCache(this);
        if (this.partitionCache != null) {
            this.partitionCache.clearCache();
        }
        this.partitionInfo = null;
        this.partitionKeys.clear();
        this.subPartitionKeys.clear();
        return super.refreshObject(monitor);
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.TABLE);
    }

    private static class PartitionCache
    extends JDBCObjectLookupCache<OracleTablePhysical, OracleTablePartition> {
        private PartitionCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull OracleTablePhysical table, @Nullable OracleTablePartition partition, @Nullable String partitionName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysSchemaPrefix((OracleDataSource)table.getDataSource()) + "ALL_TAB_PARTITIONS \nWHERE TABLE_OWNER=? AND TABLE_NAME=? " + (partition != null || CommonUtils.isNotEmpty((String)partitionName) ? " AND PARTITION_NAME=?" : "") + "\nORDER BY PARTITION_POSITION");
            dbStat.setString(1, ((OracleSchema)table.getContainer()).getName());
            dbStat.setString(2, table.getName());
            if (partition != null || CommonUtils.isNotEmpty((String)partitionName)) {
                dbStat.setString(3, partition != null ? partition.getName() : partitionName);
            }
            return dbStat;
        }

        protected OracleTablePartition fetchObject(@NotNull JDBCSession session, @NotNull OracleTablePhysical table, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String partitionName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PARTITION_NAME");
            if (CommonUtils.isEmpty((String)partitionName)) {
                return null;
            }
            return new OracleTablePartition(table, partitionName, (ResultSet)resultSet, null);
        }
    }

    public static class PartitionInfo
    extends OracleTablePartition.PartitionInfoBase {
        public PartitionInfo(DBRProgressMonitor monitor, OracleDataSource dataSource, ResultSet dbResult) {
            super(monitor, dataSource, dbResult);
        }

        PartitionInfo() {
        }
    }

    public static class PartitionInfoValidator
    implements IPropertyCacheValidator<OracleTablePhysical> {
        public boolean isPropertyCached(@NotNull OracleTablePhysical object, @NotNull Object propertyId) {
            return object.partitioned && object.partitionInfo != null;
        }
    }

    public static class PartitionedValueLoadValidator
    implements IPropertyCacheValidator<OracleTablePhysical> {
        public boolean isPropertyCached(@NotNull OracleTablePhysical object, @NotNull Object propertyId) {
            return object.partitionedBy != null;
        }
    }

    public static class PartitioningTablePropertyValidator
    implements IPropertyValueValidator<OracleTablePhysical, Object> {
        public boolean isValidValue(@NotNull OracleTablePhysical object, @Nullable Object value) throws IllegalArgumentException {
            return !(object instanceof OracleTablePartition) && (!object.isPersisted() || object.isPartitioned());
        }
    }

    public static class TablespaceListProvider
    implements IPropertyValueListProvider<OracleTablePhysical> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(OracleTablePhysical object) {
            ArrayList<OracleTablespace> tablespaces = new ArrayList<OracleTablespace>();
            try {
                tablespaces.addAll(((OracleDataSource)object.getDataSource()).getTablespaces((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.error((Object)e);
            }
            tablespaces.sort(DBUtils.nameComparator());
            return tablespaces.toArray(new OracleTablespace[0]);
        }
    }
}

