/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.CaughtClassMarker;

public class CaughtClassFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public CaughtClassFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (CaughtClassMarker.isCaught(programClass)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (CaughtClassMarker.isCaught(libraryClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }
}

