# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: disable=too-many-lines
# pylint: disable=too-many-statements

from azure.cli.core.commands.parameters import (
    tags_type,
    resource_group_name_type,
    get_location_type,
    get_enum_type
)
from azure.cli.core.commands.validators import get_default_location_from_resource_group


def load_arguments(self, _):

    with self.argument_context('sshkey list') as c:
        c.argument('resource_group_name', resource_group_name_type)

    with self.argument_context('sshkey show') as c:
        c.argument('resource_group_name', resource_group_name_type)
        c.argument('ssh_public_key_name', options_list=['--name', '-n', '--ssh-public-key-name'], type=str, help='The '
                   'name of the SSH public key.', id_part='name')

    with self.argument_context('sshkey create') as c:
        c.argument('resource_group_name', resource_group_name_type)
        c.argument('ssh_public_key_name', options_list=['--name', '-n', '--ssh-public-key-name'], type=str, help='The '
                   'name of the SSH public key.')
        c.argument('location', arg_type=get_location_type(self.cli_ctx), required=False,
                   validator=get_default_location_from_resource_group)
        c.argument('tags', tags_type)
        c.argument('public_key', type=str, help='SSH public key used to authenticate to a virtual machine through ssh. '
                   'If this property is not initially provided when the resource is created, the publicKey property '
                   'will be populated when generateKeyPair is called. If the public key is provided upon resource '
                   'creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.')
        c.argument('encryption_type', arg_type=get_enum_type(['RSA', 'Ed25519']), default='RSA', min_api='2023-09-01',
                   help='The encryption type of the SSH keys to be generated. ')

    with self.argument_context('sshkey update') as c:
        c.argument('resource_group_name', resource_group_name_type)
        c.argument('ssh_public_key_name', options_list=['--name', '-n', '--ssh-public-key-name'], type=str, help='The '
                   'name of the SSH public key.', id_part='name')
        c.argument('tags', tags_type)
        c.argument('public_key', type=str, help='SSH public key used to authenticate to a virtual machine through ssh. '
                   'If this property is not initially provided when the resource is created, the publicKey property '
                   'will be populated when generateKeyPair is called. If the public key is provided upon resource '
                   'creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.')

    with self.argument_context('sshkey delete') as c:
        c.argument('resource_group_name', resource_group_name_type)
        c.argument('ssh_public_key_name', options_list=['--name', '-n', '--ssh-public-key-name'], type=str, help='The '
                   'name of the SSH public key.', id_part='name')
