/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ResourceQuotaStatusApplyConfiguration represents a declarative configuration of the ResourceQuotaStatus type for use
// with apply.
//
// ResourceQuotaStatus defines the enforced hard limits and observed use.
type ResourceQuotaStatusApplyConfiguration struct {
	// Hard is the set of enforced hard limits for each named resource.
	// More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
	Hard *corev1.ResourceList `json:"hard,omitempty"`
	// Used is the current observed total usage of the resource in the namespace.
	Used *corev1.ResourceList `json:"used,omitempty"`
}

// ResourceQuotaStatusApplyConfiguration constructs a declarative configuration of the ResourceQuotaStatus type for use with
// apply.
func ResourceQuotaStatus() *ResourceQuotaStatusApplyConfiguration {
	return &ResourceQuotaStatusApplyConfiguration{}
}

// WithHard sets the Hard field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hard field is set to the value of the last call.
func (b *ResourceQuotaStatusApplyConfiguration) WithHard(value corev1.ResourceList) *ResourceQuotaStatusApplyConfiguration {
	b.Hard = &value
	return b
}

// WithUsed sets the Used field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Used field is set to the value of the last call.
func (b *ResourceQuotaStatusApplyConfiguration) WithUsed(value corev1.ResourceList) *ResourceQuotaStatusApplyConfiguration {
	b.Used = &value
	return b
}
