/* osdkeys.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from osdkeys.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gvc-mixer-stream.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SHOW_OSD (budgie_show_osd_get_type ())
#define BUDGIE_SHOW_OSD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SHOW_OSD, BudgieShowOSD))
#define BUDGIE_IS_SHOW_OSD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SHOW_OSD))
#define BUDGIE_SHOW_OSD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_SHOW_OSD, BudgieShowOSDIface))

typedef struct _BudgieShowOSD BudgieShowOSD;
typedef struct _BudgieShowOSDIface BudgieShowOSDIface;

#define BUDGIE_TYPE_SHOW_OSD_PROXY (budgie_show_osd_proxy_get_type ())
typedef GDBusProxy BudgieShowOSDProxy;
typedef GDBusProxyClass BudgieShowOSDProxyClass;
typedef struct _budgie_show_osd_ShowReadyData budgie_show_osd_ShowReadyData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_OSD_KEYS (budgie_osd_keys_get_type ())
#define BUDGIE_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeys))
#define BUDGIE_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))
#define BUDGIE_IS_OSD_KEYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_IS_OSD_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_KEYS))
#define BUDGIE_OSD_KEYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeysClass))

typedef struct _BudgieOSDKeys BudgieOSDKeys;
typedef struct _BudgieOSDKeysClass BudgieOSDKeysClass;
typedef struct _BudgieOSDKeysPrivate BudgieOSDKeysPrivate;
enum  {
	BUDGIE_OSD_KEYS_0_PROPERTY,
	BUDGIE_OSD_KEYS_NUM_PROPERTIES
};
static GParamSpec* budgie_osd_keys_properties[BUDGIE_OSD_KEYS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

struct _BudgieShowOSDIface {
	GTypeInterface parent_iface;
	void (*Show) (BudgieShowOSD* self, GHashTable* params, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Show_finish) (BudgieShowOSD* self, GAsyncResult* _res_, GError** error);
};

struct _budgie_show_osd_ShowReadyData {
	GDBusMethodInvocation* _invocation_;
	GHashTable* params;
};

struct _BudgieOSDKeys {
	GObject parent_instance;
	BudgieOSDKeysPrivate * priv;
};

struct _BudgieOSDKeysClass {
	GObjectClass parent_class;
};

struct _BudgieOSDKeysPrivate {
	GDBusConnection* conn;
	guint signal_id;
	BudgieShowOSD* osd;
	gdouble current_brightness_level;
	GdkKeymap* map;
	gboolean capslock;
	gboolean numlock;
	gboolean firstrun;
	GvcMixerControl* mixer;
	GvcMixerStream* stream;
	gulong notify_id;
	GSettings* wm_settings;
	gboolean caffeine_was_enabled;
	gboolean initialising;
};

static gint BudgieOSDKeys_private_offset;
static gpointer budgie_osd_keys_parent_class = NULL;

VALA_EXTERN GType budgie_show_osd_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_show_osd_register_object (void* object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error);
VALA_EXTERN GType budgie_show_osd_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieShowOSD, g_object_unref)
VALA_EXTERN void budgie_show_osd_Show (BudgieShowOSD* self,
                           GHashTable* params,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN void budgie_show_osd_Show_finish (BudgieShowOSD* self,
                                  GAsyncResult* _res_,
                                  GError** error);
static GType budgie_show_osd_get_type_once (void);
static void budgie_show_osd_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void budgie_show_osd_proxy_Show_async (BudgieShowOSD* self,
                                       GHashTable* params,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void budgie_show_osd_proxy_Show_finish (BudgieShowOSD* self,
                                        GAsyncResult* _res_,
                                        GError** error);
static void budgie_show_osd_proxy_budgie_show_osd_interface_init (BudgieShowOSDIface* iface);
static void _dbus_budgie_show_osd_Show (BudgieShowOSD* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_show_osd_Show_ready (GObject * source_object,
                                       GAsyncResult * _res_,
                                       gpointer _user_data_);
static void budgie_show_osd_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* budgie_show_osd_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean budgie_show_osd_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _budgie_show_osd_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_osd_keys_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieOSDKeys, g_object_unref)
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_new (void);
VALA_EXTERN BudgieOSDKeys* budgie_osd_keys_construct (GType object_type);
static void budgie_osd_keys_signal_powerchanges (BudgieOSDKeys* self,
                                          GDBusConnection* connection,
                                          const gchar* sender_name,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static void _budgie_osd_keys_signal_powerchanges_gd_bus_signal_callback (GDBusConnection* connection,
                                                                  const gchar* sender_name,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* signal_name,
                                                                  GVariant* parameters,
                                                                  gpointer self);
static void budgie_osd_keys_on_mixer_state_change (BudgieOSDKeys* self,
                                            guint new_state);
static void _budgie_osd_keys_on_mixer_state_change_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                             guint new_state,
                                                                             gpointer self);
static void budgie_osd_keys_on_mixer_sink_changed (BudgieOSDKeys* self,
                                            guint id);
static void _budgie_osd_keys_on_mixer_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                                    guint id,
                                                                                    gpointer self);
static gboolean __lambda44_ (BudgieOSDKeys* self);
static void budgie_osd_keys_on_keymap_state_changed (BudgieOSDKeys* self);
static void _budgie_osd_keys_on_keymap_state_changed_gdk_keymap_state_changed (GdkKeymap* _sender,
                                                                        gpointer self);
static gboolean ___lambda44__gsource_func (gpointer self);
static void budgie_osd_keys_on_caffeine_mode (BudgieOSDKeys* self);
static void _budgie_osd_keys_on_caffeine_mode_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self);
static gboolean __lambda45_ (BudgieOSDKeys* self);
static gboolean ___lambda45__gsource_func (gpointer self);
static void budgie_osd_keys_set_default_mixer (BudgieOSDKeys* self);
static void budgie_osd_keys_on_stream_notify (BudgieOSDKeys* self,
                                       GObject* o,
                                       GParamSpec* p);
static void _budgie_osd_keys_on_stream_notify_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void budgie_osd_keys_update_volume (BudgieOSDKeys* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN gboolean budgie_screenlock_get_is_dimming (void);
static void budgie_osd_keys_finalize (GObject * obj);
static GType budgie_osd_keys_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _budgie_show_osd_dbus_arg_info_Show_params = {-1, "params", "a{sv}", NULL};
static const GDBusArgInfo * const _budgie_show_osd_dbus_arg_info_Show_in[] = {&_budgie_show_osd_dbus_arg_info_Show_params, NULL};
static const GDBusArgInfo * const _budgie_show_osd_dbus_arg_info_Show_out[] = {NULL};
static const GDBusMethodInfo _budgie_show_osd_dbus_method_info_Show = {-1, "Show", (GDBusArgInfo **) (&_budgie_show_osd_dbus_arg_info_Show_in), (GDBusArgInfo **) (&_budgie_show_osd_dbus_arg_info_Show_out), NULL};
static const GDBusMethodInfo * const _budgie_show_osd_dbus_method_info[] = {&_budgie_show_osd_dbus_method_info_Show, NULL};
static const GDBusSignalInfo * const _budgie_show_osd_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_show_osd_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_show_osd_dbus_interface_info = {-1, "org.budgie_desktop.BudgieOSD", (GDBusMethodInfo **) (&_budgie_show_osd_dbus_method_info), (GDBusSignalInfo **) (&_budgie_show_osd_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_show_osd_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_show_osd_dbus_interface_vtable = {budgie_show_osd_dbus_interface_method_call, budgie_show_osd_dbus_interface_get_property, budgie_show_osd_dbus_interface_set_property};

void
budgie_show_osd_Show (BudgieShowOSD* self,
                      GHashTable* params,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	BudgieShowOSDIface* _iface_;
	_iface_ = BUDGIE_SHOW_OSD_GET_INTERFACE (self);
	if (_iface_->Show) {
		_iface_->Show (self, params, _callback_, _user_data_);
	}
}

void
budgie_show_osd_Show_finish (BudgieShowOSD* self,
                             GAsyncResult* _res_,
                             GError** error)
{
	BudgieShowOSDIface* _iface_;
	_iface_ = BUDGIE_SHOW_OSD_GET_INTERFACE (self);
	if (_iface_->Show_finish) {
		_iface_->Show_finish (self, _res_, error);
	}
}

static void
budgie_show_osd_default_init (BudgieShowOSDIface * iface,
                              gpointer iface_data)
{
}

static GType
budgie_show_osd_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieShowOSDIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_show_osd_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_show_osd_type_id;
	budgie_show_osd_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieShowOSD", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_show_osd_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_show_osd_proxy_get_type);
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.BudgieOSD");
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_show_osd_dbus_interface_info));
	g_type_set_qdata (budgie_show_osd_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_show_osd_register_object);
	return budgie_show_osd_type_id;
}

GType
budgie_show_osd_get_type (void)
{
	static volatile gsize budgie_show_osd_type_id__once = 0;
	if (g_once_init_enter (&budgie_show_osd_type_id__once)) {
		GType budgie_show_osd_type_id;
		budgie_show_osd_type_id = budgie_show_osd_get_type_once ();
		g_once_init_leave (&budgie_show_osd_type_id__once, budgie_show_osd_type_id);
	}
	return budgie_show_osd_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieShowOSDProxy, budgie_show_osd_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SHOW_OSD, budgie_show_osd_proxy_budgie_show_osd_interface_init) )
static void
budgie_show_osd_proxy_class_init (BudgieShowOSDProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_show_osd_proxy_g_signal;
}

static void
budgie_show_osd_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters)
{
}

static void
budgie_show_osd_proxy_init (BudgieShowOSDProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_show_osd_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
budgie_show_osd_proxy_Show_async (BudgieShowOSD* self,
                                  GHashTable* params,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp76_;
	GHashTableIter _tmp77_;
	gpointer _tmp78_;
	gpointer _tmp79_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.BudgieOSD", "Show");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp77_, params);
	g_variant_builder_init (&_tmp76_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp77_, &_tmp78_, &_tmp79_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp78_;
		_value = (GVariant*) _tmp79_;
		g_variant_builder_add (&_tmp76_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp76_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_show_osd_proxy_Show_finish (BudgieShowOSD* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_show_osd_proxy_budgie_show_osd_interface_init (BudgieShowOSDIface* iface)
{
	iface->Show = budgie_show_osd_proxy_Show_async;
	iface->Show_finish = budgie_show_osd_proxy_Show_finish;
}

static void
_dbus_budgie_show_osd_Show (BudgieShowOSD* self,
                            GVariant* _parameters_,
                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_show_osd_ShowReadyData* _ready_data;
	GVariant* _tmp80_;
	GHashTable* _tmp81_;
	GVariantIter _tmp82_;
	GVariant* _tmp83_;
	GVariant* _tmp84_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_show_osd_ShowReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp80_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp81_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp82_, _tmp80_);
	while (g_variant_iter_loop (&_tmp82_, "{?*}", &_tmp83_, &_tmp84_)) {
		g_hash_table_insert (_tmp81_, g_variant_dup_string (_tmp83_, NULL), g_variant_get_variant (_tmp84_));
	}
	_ready_data->params = _tmp81_;
	g_variant_unref (_tmp80_);
	budgie_show_osd_Show (self, _ready_data->params, (GAsyncReadyCallback) _dbus_budgie_show_osd_Show_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_show_osd_Show_ready (GObject * source_object,
                                  GAsyncResult * _res_,
                                  gpointer _user_data_)
{
	budgie_show_osd_ShowReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_show_osd_Show_finish ((BudgieShowOSD*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (_ready_data->params);
	g_slice_free (budgie_show_osd_ShowReadyData, _ready_data);
}

static void
budgie_show_osd_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Show") == 0) {
		_dbus_budgie_show_osd_Show (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_show_osd_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_show_osd_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_show_osd_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_show_osd_dbus_interface_info), &_budgie_show_osd_dbus_interface_vtable, data, _budgie_show_osd_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_show_osd_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_osd_keys_get_instance_private (BudgieOSDKeys* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieOSDKeys_private_offset);
}

static void
_budgie_osd_keys_signal_powerchanges_gd_bus_signal_callback (GDBusConnection* connection,
                                                             const gchar* sender_name,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* signal_name,
                                                             GVariant* parameters,
                                                             gpointer self)
{
	budgie_osd_keys_signal_powerchanges ((BudgieOSDKeys*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static void
_budgie_osd_keys_on_mixer_state_change_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                        guint new_state,
                                                                        gpointer self)
{
	budgie_osd_keys_on_mixer_state_change ((BudgieOSDKeys*) self, new_state);
}

static void
_budgie_osd_keys_on_mixer_sink_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                               guint id,
                                                                               gpointer self)
{
	budgie_osd_keys_on_mixer_sink_changed ((BudgieOSDKeys*) self, id);
}

static void
_budgie_osd_keys_on_keymap_state_changed_gdk_keymap_state_changed (GdkKeymap* _sender,
                                                                   gpointer self)
{
	budgie_osd_keys_on_keymap_state_changed ((BudgieOSDKeys*) self);
}

static gboolean
__lambda44_ (BudgieOSDKeys* self)
{
	GdkDisplay* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	gboolean result;
	self->priv->initialising = FALSE;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_keymap_get_for_display (_tmp0_);
	self->priv->map = _tmp1_;
	_tmp2_ = self->priv->map;
	g_signal_connect_object (_tmp2_, "state-changed", (GCallback) _budgie_osd_keys_on_keymap_state_changed_gdk_keymap_state_changed, self, 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda44__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda44_ ((BudgieOSDKeys*) self);
	return result;
}

static void
_budgie_osd_keys_on_caffeine_mode_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self)
{
	budgie_osd_keys_on_caffeine_mode ((BudgieOSDKeys*) self);
}

BudgieOSDKeys*
budgie_osd_keys_construct (GType object_type)
{
	BudgieOSDKeys * self = NULL;
	GDBusConnection* _tmp10_;
	GvcMixerControl* _tmp11_;
	GvcMixerControl* _tmp12_;
	GvcMixerControl* _tmp13_;
	GvcMixerControl* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	GError* _inner_error0_ = NULL;
	self = (BudgieOSDKeys*) g_object_new (object_type, NULL);
	self->priv->initialising = TRUE;
	{
		BudgieShowOSD* _tmp0_ = NULL;
		BudgieShowOSD* _tmp1_;
		BudgieShowOSD* _tmp2_;
		_tmp1_ = (BudgieShowOSD*) g_initable_new (BUDGIE_TYPE_SHOW_OSD_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.budgie_desktop.BudgieOSD", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/budgie_desktop/BudgieOSD", "g-interface-name", "org.budgie_desktop.BudgieOSD", NULL);
		_tmp0_ = (BudgieShowOSD*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->osd);
		self->priv->osd = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("osdkeys.vala:60: %s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GDBusConnection* _tmp5_ = NULL;
		GDBusConnection* _tmp6_;
		GDBusConnection* _tmp7_;
		_tmp6_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (self->priv->conn);
		self->priv->conn = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_info ("osdkeys.vala:67: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = self->priv->conn;
	self->priv->signal_id = g_dbus_connection_signal_subscribe (_tmp10_, "org.gnome.SettingsDaemon.Power", "org.freedesktop.DBus.Properties", "PropertiesChanged", NULL, NULL, G_DBUS_SIGNAL_FLAGS_NONE, _budgie_osd_keys_signal_powerchanges_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
	_tmp11_ = gvc_mixer_control_new ("BD Volume Mixer");
	_g_object_unref0 (self->priv->mixer);
	self->priv->mixer = _tmp11_;
	_tmp12_ = self->priv->mixer;
	g_signal_connect_object (_tmp12_, "state-changed", (GCallback) _budgie_osd_keys_on_mixer_state_change_gvc_mixer_control_state_changed, self, 0);
	_tmp13_ = self->priv->mixer;
	g_signal_connect_object (_tmp13_, "default-sink-changed", (GCallback) _budgie_osd_keys_on_mixer_sink_changed_gvc_mixer_control_default_sink_changed, self, 0);
	_tmp14_ = self->priv->mixer;
	gvc_mixer_control_open (_tmp14_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda44__gsource_func, g_object_ref (self), g_object_unref);
	_tmp15_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->wm_settings);
	self->priv->wm_settings = _tmp15_;
	_tmp16_ = self->priv->wm_settings;
	g_signal_connect_object (_tmp16_, "changed::caffeine-mode", (GCallback) _budgie_osd_keys_on_caffeine_mode_g_settings_changed, self, 0);
	return self;
}

BudgieOSDKeys*
budgie_osd_keys_new (void)
{
	return budgie_osd_keys_construct (BUDGIE_TYPE_OSD_KEYS);
}

static gboolean
__lambda45_ (BudgieOSDKeys* self)
{
	gboolean result;
	self->priv->caffeine_was_enabled = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda45__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda45_ ((BudgieOSDKeys*) self);
	return result;
}

static void
budgie_osd_keys_on_caffeine_mode (BudgieOSDKeys* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_settings;
	if (g_settings_get_boolean (_tmp0_, "caffeine-mode")) {
		self->priv->caffeine_was_enabled = TRUE;
		return;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ___lambda45__gsource_func, g_object_ref (self), g_object_unref);
}

static void
budgie_osd_keys_on_mixer_sink_changed (BudgieOSDKeys* self,
                                       guint id)
{
	g_return_if_fail (self != NULL);
	budgie_osd_keys_set_default_mixer (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_budgie_osd_keys_on_stream_notify_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	budgie_osd_keys_on_stream_notify ((BudgieOSDKeys*) self, _sender, pspec);
}

static void
budgie_osd_keys_set_default_mixer (BudgieOSDKeys* self)
{
	GvcMixerStream* _tmp0_;
	GvcMixerControl* _tmp2_;
	GvcMixerStream* _tmp3_;
	GvcMixerStream* _tmp4_;
	GvcMixerStream* _tmp5_;
	gulong _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stream;
	if (_tmp0_ != NULL) {
		GvcMixerStream* _tmp1_;
		_tmp1_ = self->priv->stream;
		g_signal_handler_disconnect (_tmp1_, self->priv->notify_id);
	}
	_tmp2_ = self->priv->mixer;
	_tmp3_ = gvc_mixer_control_get_default_sink (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp4_;
	_tmp5_ = self->priv->stream;
	_tmp6_ = g_signal_connect_object ((GObject*) _tmp5_, "notify", (GCallback) _budgie_osd_keys_on_stream_notify_g_object_notify, self, 0);
	self->priv->notify_id = _tmp6_;
	budgie_osd_keys_update_volume (self);
}

static void
budgie_osd_keys_on_stream_notify (BudgieOSDKeys* self,
                                  GObject* o,
                                  GParamSpec* p)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = p->name;
	if (g_strcmp0 (_tmp1_, "volume") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = p->name;
		_tmp0_ = g_strcmp0 (_tmp2_, "is-muted") == 0;
	}
	if (_tmp0_) {
		budgie_osd_keys_update_volume (self);
	}
}

/**
 * Called when something changes on the mixer, i.e. we connected
 * This is where we hook into the stream for changes
 */
static void
budgie_osd_keys_on_mixer_state_change (BudgieOSDKeys* self,
                                       guint new_state)
{
	g_return_if_fail (self != NULL);
	if (new_state == ((guint) GVC_STATE_READY)) {
		budgie_osd_keys_set_default_mixer (self);
	}
}

/**
* Update the OSD when something changes (volume/mute)
*/
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
budgie_osd_keys_update_volume (BudgieOSDKeys* self)
{
	gdouble vol_norm = 0.0;
	GvcMixerControl* _tmp0_;
	guint32 vol = 0U;
	GvcMixerStream* _tmp1_;
	gint n = 0;
	gchar* image_name = NULL;
	gboolean _tmp2_ = FALSE;
	GvcMixerStream* _tmp3_;
	gfloat pct = 0.0F;
	gboolean _tmp8_ = FALSE;
	GHashTable* params = NULL;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	GVariant* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GVariant* _tmp18_;
	BudgieShowOSD* _tmp19_;
	GHashTable* _tmp20_;
	g_return_if_fail (self != NULL);
	if (self->priv->initialising) {
		return;
	}
	_tmp0_ = self->priv->mixer;
	vol_norm = gvc_mixer_control_get_vol_max_norm (_tmp0_);
	_tmp1_ = self->priv->stream;
	vol = gvc_mixer_stream_get_volume (_tmp1_);
	n = ((gint) floor ((3 * vol) / vol_norm)) + 1;
	_tmp3_ = self->priv->stream;
	if (gvc_mixer_stream_get_is_muted (_tmp3_)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = vol <= ((guint32) 0);
	}
	if (_tmp2_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("audio-volume-muted-symbolic");
		_g_free0 (image_name);
		image_name = _tmp4_;
	} else {
		switch (n) {
			case 1:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("audio-volume-low-symbolic");
				_g_free0 (image_name);
				image_name = _tmp5_;
				break;
			}
			case 2:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("audio-volume-medium-symbolic");
				_g_free0 (image_name);
				image_name = _tmp6_;
				break;
			}
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("audio-volume-high-symbolic");
				_g_free0 (image_name);
				image_name = _tmp7_;
				break;
			}
		}
	}
	pct = ((gfloat) vol) / ((gfloat) vol_norm);
	if (((gdouble) pct) > 1.0) {
		GvcMixerStream* _tmp9_;
		_tmp9_ = self->priv->stream;
		_tmp8_ = !gvc_mixer_stream_get_is_muted (_tmp9_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("audio-volume-overamplified-symbolic");
		_g_free0 (image_name);
		image_name = _tmp10_;
	}
	_tmp11_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (params);
	params = _tmp11_;
	_tmp12_ = params;
	_tmp13_ = g_strdup ("level");
	_tmp14_ = g_variant_new_double ((gdouble) pct);
	g_variant_ref_sink (_tmp14_);
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = params;
	_tmp16_ = g_strdup ("icon");
	_tmp17_ = image_name;
	_tmp18_ = g_variant_new_string (_tmp17_);
	g_variant_ref_sink (_tmp18_);
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp18_);
	_tmp19_ = self->priv->osd;
	_tmp20_ = params;
	budgie_show_osd_Show (_tmp19_, _tmp20_, NULL, NULL);
	_g_hash_table_unref0 (params);
	_g_free0 (image_name);
}

static void
budgie_osd_keys_on_keymap_state_changed (BudgieOSDKeys* self)
{
	GHashTable* params = NULL;
	GHashTable* _tmp2_;
	gchar* caption = NULL;
	gchar* _tmp3_;
	gboolean skip = FALSE;
	GdkKeymap* _tmp4_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	if (!self->priv->firstrun) {
		GdkKeymap* _tmp0_;
		GdkKeymap* _tmp1_;
		_tmp0_ = self->priv->map;
		self->priv->capslock = gdk_keymap_get_caps_lock_state (_tmp0_);
		_tmp1_ = self->priv->map;
		self->priv->numlock = gdk_keymap_get_num_lock_state (_tmp1_);
		self->priv->firstrun = TRUE;
	}
	_tmp2_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	params = _tmp2_;
	_tmp3_ = g_strdup ("");
	caption = _tmp3_;
	skip = FALSE;
	_tmp4_ = self->priv->map;
	if (gdk_keymap_get_caps_lock_state (_tmp4_)) {
		if (!self->priv->capslock) {
			GHashTable* _tmp5_;
			gchar* _tmp6_;
			GVariant* _tmp7_;
			gchar* _tmp8_;
			GHashTable* _tmp9_;
			gchar* _tmp10_;
			GVariant* _tmp11_;
			_tmp5_ = params;
			_tmp6_ = g_strdup ("icon");
			_tmp7_ = g_variant_new_string ("caps-lock-symbolic");
			g_variant_ref_sink (_tmp7_);
			g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
			_tmp8_ = g_strdup (_ ("Caps Lock is on"));
			_g_free0 (caption);
			caption = _tmp8_;
			_tmp9_ = params;
			_tmp10_ = g_strdup ("icon");
			_tmp11_ = g_variant_new_string ("caps-lock-on-symbolic");
			g_variant_ref_sink (_tmp11_);
			g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
		}
		self->priv->capslock = TRUE;
		skip = TRUE;
	} else {
		if (self->priv->capslock) {
			gchar* _tmp12_;
			GHashTable* _tmp13_;
			gchar* _tmp14_;
			GVariant* _tmp15_;
			_tmp12_ = g_strdup (_ ("Caps Lock is off"));
			_g_free0 (caption);
			caption = _tmp12_;
			_tmp13_ = params;
			_tmp14_ = g_strdup ("icon");
			_tmp15_ = g_variant_new_string ("caps-lock-off-symbolic");
			g_variant_ref_sink (_tmp15_);
			g_hash_table_insert (_tmp13_, _tmp14_, _tmp15_);
		}
		self->priv->capslock = FALSE;
		skip = TRUE;
	}
	if (!skip) {
		GdkKeymap* _tmp16_;
		_tmp16_ = self->priv->map;
		if (gdk_keymap_get_num_lock_state (_tmp16_)) {
			if (!self->priv->numlock) {
				gchar* _tmp17_;
				GHashTable* _tmp18_;
				gchar* _tmp19_;
				GVariant* _tmp20_;
				_tmp17_ = g_strdup (_ ("Num Lock is on"));
				_g_free0 (caption);
				caption = _tmp17_;
				_tmp18_ = params;
				_tmp19_ = g_strdup ("icon");
				_tmp20_ = g_variant_new_string ("num-lock-on-symbolic");
				g_variant_ref_sink (_tmp20_);
				g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
			}
			self->priv->numlock = TRUE;
		} else {
			if (self->priv->numlock) {
				gchar* _tmp21_;
				GHashTable* _tmp22_;
				gchar* _tmp23_;
				GVariant* _tmp24_;
				_tmp21_ = g_strdup (_ ("Num Lock is off"));
				_g_free0 (caption);
				caption = _tmp21_;
				_tmp22_ = params;
				_tmp23_ = g_strdup ("icon");
				_tmp24_ = g_variant_new_string ("num-lock-off-symbolic");
				g_variant_ref_sink (_tmp24_);
				g_hash_table_insert (_tmp22_, _tmp23_, _tmp24_);
			}
			self->priv->numlock = FALSE;
		}
	}
	_tmp25_ = caption;
	if (g_strcmp0 (_tmp25_, "") != 0) {
		GHashTable* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		GVariant* _tmp29_;
		BudgieShowOSD* _tmp30_;
		GHashTable* _tmp31_;
		_tmp26_ = params;
		_tmp27_ = g_strdup ("label");
		_tmp28_ = caption;
		_tmp29_ = g_variant_new_string (_tmp28_);
		g_variant_ref_sink (_tmp29_);
		g_hash_table_insert (_tmp26_, _tmp27_, _tmp29_);
		_tmp30_ = self->priv->osd;
		_tmp31_ = params;
		budgie_show_osd_Show (_tmp30_, _tmp31_, NULL, NULL);
	}
	_g_free0 (caption);
	_g_hash_table_unref0 (params);
}

static void
budgie_osd_keys_signal_powerchanges (BudgieOSDKeys* self,
                                     GDBusConnection* connection,
                                     const gchar* sender_name,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
	GVariantDict* dict = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariantDict* _tmp2_;
	GVariantDict* _tmp3_;
	GVariant* brightness = NULL;
	GVariantDict* _tmp4_;
	const GVariantType* _tmp5_;
	GVariant* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GVariant* _tmp9_;
	gdouble level = 0.0;
	GVariant* _tmp12_;
	gchar* icon = NULL;
	gchar* _tmp13_;
	GHashTable* params = NULL;
	GHashTable* _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	GVariant* _tmp19_;
	GHashTable* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	GVariant* _tmp23_;
	BudgieShowOSD* _tmp24_;
	GHashTable* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	if (self->priv->initialising) {
		return;
	}
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_dict_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_unref0 (_tmp1_);
	dict = _tmp3_;
	_tmp4_ = dict;
	_tmp5_ = G_VARIANT_TYPE_INT32;
	_tmp6_ = g_variant_dict_lookup_value (_tmp4_, "Brightness", _tmp5_);
	brightness = _tmp6_;
	_tmp9_ = brightness;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = budgie_screenlock_get_is_dimming ();
		_tmp11_ = _tmp10_;
		_tmp8_ = _tmp11_;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = self->priv->caffeine_was_enabled;
	}
	if (_tmp7_) {
		_g_variant_unref0 (brightness);
		_g_variant_dict_unref0 (dict);
		return;
	}
	_tmp12_ = brightness;
	level = ((gdouble) g_variant_get_int32 (_tmp12_)) / 100;
	if (self->priv->current_brightness_level == level) {
		_g_variant_unref0 (brightness);
		_g_variant_dict_unref0 (dict);
		return;
	}
	self->priv->current_brightness_level = level;
	_tmp13_ = g_strdup ("display-brightness-symbolic");
	icon = _tmp13_;
	if (level == 1.0) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("display-brightness-high-symbolic");
		_g_free0 (icon);
		icon = _tmp14_;
	} else {
		if (level == 0.0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("display-brightness-low-symbolic");
			_g_free0 (icon);
			icon = _tmp15_;
		}
	}
	_tmp16_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (params);
	params = _tmp16_;
	_tmp17_ = params;
	_tmp18_ = g_strdup ("level");
	_tmp19_ = g_variant_new_double (level);
	g_variant_ref_sink (_tmp19_);
	g_hash_table_insert (_tmp17_, _tmp18_, _tmp19_);
	_tmp20_ = params;
	_tmp21_ = g_strdup ("icon");
	_tmp22_ = icon;
	_tmp23_ = g_variant_new_string (_tmp22_);
	g_variant_ref_sink (_tmp23_);
	g_hash_table_insert (_tmp20_, _tmp21_, _tmp23_);
	_tmp24_ = self->priv->osd;
	_tmp25_ = params;
	budgie_show_osd_Show (_tmp24_, _tmp25_, NULL, NULL);
	_g_hash_table_unref0 (params);
	_g_free0 (icon);
	_g_variant_unref0 (brightness);
	_g_variant_dict_unref0 (dict);
}

static void
budgie_osd_keys_class_init (BudgieOSDKeysClass * klass,
                            gpointer klass_data)
{
	budgie_osd_keys_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieOSDKeys_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_osd_keys_finalize;
}

static void
budgie_osd_keys_instance_init (BudgieOSDKeys * self,
                               gpointer klass)
{
	self->priv = budgie_osd_keys_get_instance_private (self);
	self->priv->conn = NULL;
	self->priv->osd = NULL;
	self->priv->current_brightness_level = 0.0;
	self->priv->firstrun = FALSE;
	self->priv->wm_settings = NULL;
	self->priv->caffeine_was_enabled = FALSE;
}

static void
budgie_osd_keys_finalize (GObject * obj)
{
	BudgieOSDKeys * self;
	gboolean _tmp0_ = FALSE;
	GDBusConnection* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_OSD_KEYS, BudgieOSDKeys);
	_tmp1_ = self->priv->conn;
	if (_tmp1_ != NULL) {
		_tmp0_ = self->priv->signal_id != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GDBusConnection* _tmp2_;
		_tmp2_ = self->priv->conn;
		g_dbus_connection_signal_unsubscribe (_tmp2_, self->priv->signal_id);
	}
	_g_object_unref0 (self->priv->conn);
	_g_object_unref0 (self->priv->osd);
	_g_object_unref0 (self->priv->mixer);
	_g_object_unref0 (self->priv->stream);
	_g_object_unref0 (self->priv->wm_settings);
	G_OBJECT_CLASS (budgie_osd_keys_parent_class)->finalize (obj);
}

static GType
budgie_osd_keys_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieOSDKeysClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_osd_keys_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieOSDKeys), 0, (GInstanceInitFunc) budgie_osd_keys_instance_init, NULL };
	GType budgie_osd_keys_type_id;
	budgie_osd_keys_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieOSDKeys", &g_define_type_info, 0);
	BudgieOSDKeys_private_offset = g_type_add_instance_private (budgie_osd_keys_type_id, sizeof (BudgieOSDKeysPrivate));
	return budgie_osd_keys_type_id;
}

GType
budgie_osd_keys_get_type (void)
{
	static volatile gsize budgie_osd_keys_type_id__once = 0;
	if (g_once_init_enter (&budgie_osd_keys_type_id__once)) {
		GType budgie_osd_keys_type_id;
		budgie_osd_keys_type_id = budgie_osd_keys_get_type_once ();
		g_once_init_leave (&budgie_osd_keys_type_id__once, budgie_osd_keys_type_id);
	}
	return budgie_osd_keys_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

