/* src/bazaar.p/bz-hook-dialog-option.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-hook-dialog-option.h"



struct _BzHookDialogOption
{
  GObject parent_instance;

  char *id;
  char *string;
  char *style;
};

G_DEFINE_FINAL_TYPE (BzHookDialogOption, bz_hook_dialog_option, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_ID,
  PROP_STRING,
  PROP_STYLE,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_hook_dialog_option_dispose (GObject *object)
{
  BzHookDialogOption *self = BZ_HOOK_DIALOG_OPTION (object);

  g_clear_pointer (&self->id, g_free);
  g_clear_pointer (&self->string, g_free);
  g_clear_pointer (&self->style, g_free);

  G_OBJECT_CLASS (bz_hook_dialog_option_parent_class)->dispose (object);
}

static void
bz_hook_dialog_option_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzHookDialogOption *self = BZ_HOOK_DIALOG_OPTION (object);

  switch (prop_id)
    {
    case PROP_ID:
      g_value_set_string (value, bz_hook_dialog_option_get_id (self));
      break;
    case PROP_STRING:
      g_value_set_string (value, bz_hook_dialog_option_get_string (self));
      break;
    case PROP_STYLE:
      g_value_set_string (value, bz_hook_dialog_option_get_style (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_hook_dialog_option_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzHookDialogOption *self = BZ_HOOK_DIALOG_OPTION (object);

  switch (prop_id)
    {
    case PROP_ID:
      bz_hook_dialog_option_set_id (self, g_value_get_string (value));
      break;
    case PROP_STRING:
      bz_hook_dialog_option_set_string (self, g_value_get_string (value));
      break;
    case PROP_STYLE:
      bz_hook_dialog_option_set_style (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_hook_dialog_option_class_init (BzHookDialogOptionClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_hook_dialog_option_set_property;
  object_class->get_property = bz_hook_dialog_option_get_property;
  object_class->dispose      = bz_hook_dialog_option_dispose;

  props[PROP_ID] =
      g_param_spec_string (
          "id",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_STRING] =
      g_param_spec_string (
          "string",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_STYLE] =
      g_param_spec_string (
          "style",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_hook_dialog_option_init (BzHookDialogOption *self)
{
}

BzHookDialogOption *
bz_hook_dialog_option_new (void){
  return g_object_new (BZ_TYPE_HOOK_DIALOG_OPTION, NULL);
}

const char *
bz_hook_dialog_option_get_id (BzHookDialogOption *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG_OPTION (self), NULL);
  return self->id;
}

const char *
bz_hook_dialog_option_get_string (BzHookDialogOption *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG_OPTION (self), NULL);
  return self->string;
}

const char *
bz_hook_dialog_option_get_style (BzHookDialogOption *self){
  g_return_val_if_fail (BZ_IS_HOOK_DIALOG_OPTION (self), NULL);
  return self->style;
}

void
bz_hook_dialog_option_set_id (BzHookDialogOption *self,
    const char *id){
  g_return_if_fail (BZ_IS_HOOK_DIALOG_OPTION (self));

  if (id == self->id || (id != NULL && self->id != NULL && g_strcmp0(id, self->id) == 0))
    return;

  g_clear_pointer (&self->id, g_free);
  if (id != NULL)
    self->id = g_strdup (id);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ID]);
}

void
bz_hook_dialog_option_set_string (BzHookDialogOption *self,
    const char *string){
  g_return_if_fail (BZ_IS_HOOK_DIALOG_OPTION (self));

  if (string == self->string || (string != NULL && self->string != NULL && g_strcmp0(string, self->string) == 0))
    return;

  g_clear_pointer (&self->string, g_free);
  if (string != NULL)
    self->string = g_strdup (string);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_STRING]);
}

void
bz_hook_dialog_option_set_style (BzHookDialogOption *self,
    const char *style){
  g_return_if_fail (BZ_IS_HOOK_DIALOG_OPTION (self));

  if (style == self->style || (style != NULL && self->style != NULL && g_strcmp0(style, self->style) == 0))
    return;

  g_clear_pointer (&self->style, g_free);
  if (style != NULL)
    self->style = g_strdup (style);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_STYLE]);
}

/* End of src/bazaar.p/bz-hook-dialog-option.c */
