#ifndef SBK_KACTIONCOLLECTIONWRAPPER_H
#define SBK_KACTIONCOLLECTIONWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kactioncollection.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KActionCollectionWrapper : public KActionCollection
{
public:
    KActionCollectionWrapper(::QObject * parent, const ::QString & cName = QString());
    KActionCollectionWrapper(const KActionCollectionWrapper &) = delete;
    KActionCollectionWrapper& operator=(const KActionCollectionWrapper &) = delete;
    KActionCollectionWrapper(KActionCollectionWrapper &&) = delete;
    KActionCollectionWrapper& operator=(KActionCollectionWrapper &&) = delete;
    ~KActionCollectionWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void slotActionTriggered() override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 8> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KACTIONCOLLECTIONWRAPPER_H
