/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSecurityPolicyViolationEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSecurityPolicyViolationEventDisposition.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<SecurityPolicyViolationEvent::Init>> convertDictionary<SecurityPolicyViolationEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    SecurityPolicyViolationEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue blockedURIValue;
    if (isNullOrUndefined)
        blockedURIValue = jsUndefined();
    else {
        blockedURIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "blockedURI"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto blockedURIConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, blockedURIValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (blockedURIConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.blockedURI = blockedURIConversionResult.releaseReturnValue();
    JSValue columnNumberValue;
    if (isNullOrUndefined)
        columnNumberValue = jsUndefined();
    else {
        columnNumberValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "columnNumber"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto columnNumberConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, columnNumberValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (columnNumberConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.columnNumber = columnNumberConversionResult.releaseReturnValue();
    JSValue dispositionValue;
    if (isNullOrUndefined)
        dispositionValue = jsUndefined();
    else {
        dispositionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "disposition"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto dispositionConversionResult = convertOptionalWithDefault<IDLEnumeration<SecurityPolicyViolationEventDisposition>>(lexicalGlobalObject, dispositionValue, [&]() -> ConversionResult<IDLEnumeration<SecurityPolicyViolationEventDisposition>> { return Converter<IDLEnumeration<SecurityPolicyViolationEventDisposition>>::ReturnType { SecurityPolicyViolationEventDisposition::Enforce }; });
    if (dispositionConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.disposition = dispositionConversionResult.releaseReturnValue();
    JSValue documentURIValue;
    if (isNullOrUndefined)
        documentURIValue = jsUndefined();
    else {
        documentURIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "documentURI"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto documentURIConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, documentURIValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (documentURIConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.documentURI = documentURIConversionResult.releaseReturnValue();
    JSValue effectiveDirectiveValue;
    if (isNullOrUndefined)
        effectiveDirectiveValue = jsUndefined();
    else {
        effectiveDirectiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "effectiveDirective"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto effectiveDirectiveConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, effectiveDirectiveValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (effectiveDirectiveConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.effectiveDirective = effectiveDirectiveConversionResult.releaseReturnValue();
    JSValue lineNumberValue;
    if (isNullOrUndefined)
        lineNumberValue = jsUndefined();
    else {
        lineNumberValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lineNumber"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto lineNumberConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, lineNumberValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (lineNumberConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.lineNumber = lineNumberConversionResult.releaseReturnValue();
    JSValue originalPolicyValue;
    if (isNullOrUndefined)
        originalPolicyValue = jsUndefined();
    else {
        originalPolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "originalPolicy"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto originalPolicyConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, originalPolicyValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (originalPolicyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.originalPolicy = originalPolicyConversionResult.releaseReturnValue();
    JSValue referrerValue;
    if (isNullOrUndefined)
        referrerValue = jsUndefined();
    else {
        referrerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referrer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto referrerConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, referrerValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (referrerConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.referrer = referrerConversionResult.releaseReturnValue();
    JSValue sampleValue;
    if (isNullOrUndefined)
        sampleValue = jsUndefined();
    else {
        sampleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sample"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sampleConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, sampleValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (sampleConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.sample = sampleConversionResult.releaseReturnValue();
    JSValue sourceFileValue;
    if (isNullOrUndefined)
        sourceFileValue = jsUndefined();
    else {
        sourceFileValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sourceFile"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sourceFileConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, sourceFileValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (sourceFileConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.sourceFile = sourceFileConversionResult.releaseReturnValue();
    JSValue statusCodeValue;
    if (isNullOrUndefined)
        statusCodeValue = jsUndefined();
    else {
        statusCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "statusCode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto statusCodeConversionResult = convertOptionalWithDefault<IDLUnsignedShort>(lexicalGlobalObject, statusCodeValue, [&]() -> ConversionResult<IDLUnsignedShort> { return Converter<IDLUnsignedShort>::ReturnType { 0 }; });
    if (statusCodeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.statusCode = statusCodeConversionResult.releaseReturnValue();
    JSValue violatedDirectiveValue;
    if (isNullOrUndefined)
        violatedDirectiveValue = jsUndefined();
    else {
        violatedDirectiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "violatedDirective"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto violatedDirectiveConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, violatedDirectiveValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (violatedDirectiveConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.violatedDirective = violatedDirectiveConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_documentURI);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_referrer);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_blockedURI);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_effectiveDirective);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_violatedDirective);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_originalPolicy);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sourceFile);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sample);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_disposition);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_statusCode);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineno);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineNumber);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_colno);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_columnNumber);

class JSSecurityPolicyViolationEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSecurityPolicyViolationEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSecurityPolicyViolationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSSecurityPolicyViolationEventPrototype>(vm)) JSSecurityPolicyViolationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSecurityPolicyViolationEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSecurityPolicyViolationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSecurityPolicyViolationEventPrototype, JSSecurityPolicyViolationEventPrototype::Base);

using JSSecurityPolicyViolationEventDOMConstructor = JSDOMConstructor<JSSecurityPolicyViolationEvent>;

static inline EncodedJSValue constructJSSecurityPolicyViolationEvent1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSSecurityPolicyViolationEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = SecurityPolicyViolationEvent::create(typeConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<SecurityPolicyViolationEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<SecurityPolicyViolationEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSSecurityPolicyViolationEvent2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSSecurityPolicyViolationEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<SecurityPolicyViolationEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = SecurityPolicyViolationEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<SecurityPolicyViolationEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<SecurityPolicyViolationEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSSecurityPolicyViolationEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (constructJSSecurityPolicyViolationEvent1(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (constructJSSecurityPolicyViolationEvent2(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSSecurityPolicyViolationEventConstructorConstruct, JSSecurityPolicyViolationEventDOMConstructor::construct);

template<> const ClassInfo JSSecurityPolicyViolationEventDOMConstructor::s_info = { "SecurityPolicyViolationEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventDOMConstructor) };

template<> JSValue JSSecurityPolicyViolationEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSSecurityPolicyViolationEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SecurityPolicyViolationEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSecurityPolicyViolationEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 15> JSSecurityPolicyViolationEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEventConstructor, 0 } },
    HashTableValue { "documentURI"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_documentURI, 0 } },
    HashTableValue { "referrer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_referrer, 0 } },
    HashTableValue { "blockedURI"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_blockedURI, 0 } },
    HashTableValue { "effectiveDirective"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_effectiveDirective, 0 } },
    HashTableValue { "violatedDirective"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_violatedDirective, 0 } },
    HashTableValue { "originalPolicy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_originalPolicy, 0 } },
    HashTableValue { "sourceFile"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_sourceFile, 0 } },
    HashTableValue { "sample"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_sample, 0 } },
    HashTableValue { "disposition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_disposition, 0 } },
    HashTableValue { "statusCode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_statusCode, 0 } },
    HashTableValue { "lineno"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_lineno, 0 } },
    HashTableValue { "lineNumber"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_lineNumber, 0 } },
    HashTableValue { "colno"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_colno, 0 } },
    HashTableValue { "columnNumber"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_columnNumber, 0 } },
};

const ClassInfo JSSecurityPolicyViolationEventPrototype::s_info = { "SecurityPolicyViolationEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventPrototype) };

void JSSecurityPolicyViolationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSecurityPolicyViolationEvent::info(), JSSecurityPolicyViolationEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSecurityPolicyViolationEvent::s_info = { "SecurityPolicyViolationEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEvent) };

JSSecurityPolicyViolationEvent::JSSecurityPolicyViolationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SecurityPolicyViolationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<SecurityPolicyViolationEvent> JSSecurityPolicyViolationEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SecurityPolicyViolationEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSecurityPolicyViolationEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSecurityPolicyViolationEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSecurityPolicyViolationEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSecurityPolicyViolationEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSecurityPolicyViolationEvent>(vm, globalObject);
}

JSValue JSSecurityPolicyViolationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSecurityPolicyViolationEventDOMConstructor, DOMConstructorID::SecurityPolicyViolationEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSecurityPolicyViolationEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSecurityPolicyViolationEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSecurityPolicyViolationEvent_documentURIGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.documentURI())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_documentURI, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_documentURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_referrerGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.referrer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_referrer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_referrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_blockedURIGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockedURI())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_blockedURI, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_blockedURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_effectiveDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.effectiveDirective())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_effectiveDirective, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_effectiveDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_violatedDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.violatedDirective())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_violatedDirective, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_violatedDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_originalPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.originalPolicy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_originalPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_originalPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_sourceFileGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.sourceFile())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sourceFile, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_sourceFileGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_sampleGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.sample())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sample, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_sampleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_dispositionGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<SecurityPolicyViolationEventDisposition>>(lexicalGlobalObject, throwScope, impl.disposition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_disposition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_dispositionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_statusCodeGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.statusCode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_statusCode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_statusCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_linenoGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.lineNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineno, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_linenoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_lineNumberGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.lineNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineNumber, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_lineNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_colnoGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.columnNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_colno, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_colnoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_columnNumberGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.columnNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_columnNumber, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_columnNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSecurityPolicyViolationEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSecurityPolicyViolationEvent, UseCustomHeapCellType::No>(vm, "JSSecurityPolicyViolationEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSecurityPolicyViolationEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSecurityPolicyViolationEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSecurityPolicyViolationEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSecurityPolicyViolationEvent = std::forward<decltype(space)>(space); }
    );
}

void JSSecurityPolicyViolationEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSecurityPolicyViolationEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SecurityPolicyViolationEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore28SecurityPolicyViolationEventE[]; }
#endif
template<std::same_as<SecurityPolicyViolationEvent> T>
static inline void verifyVTable(SecurityPolicyViolationEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SecurityPolicyViolationEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore28SecurityPolicyViolationEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SecurityPolicyViolationEvent has subclasses. If SecurityPolicyViolationEvent has subclasses that get passed
        // to toJS() we currently require SecurityPolicyViolationEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SecurityPolicyViolationEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SecurityPolicyViolationEvent>(impl.ptr());
#endif
    return createWrapper<SecurityPolicyViolationEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SecurityPolicyViolationEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
