/** @file
 * VirtualBox API class wrapper code for IParallelPort.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PARALLELPORT

#include "ParallelPortWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ParallelPortWrap)

//
// IParallelPort properties
//

STDMETHODIMP ParallelPortWrap::COMGETTER(Slot)(ULONG *aSlot)
{
    LogRelFlow(("{%p} %s: enter aSlot=%p\n", this, "ParallelPort::getSlot", aSlot));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSlot);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_SLOT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSlot(aSlot);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_SLOT_RETURN(this, hrc, 0 /*normal*/,*aSlot);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_SLOT_RETURN(this, hrc, 1 /*hrc exception*/,*aSlot);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_SLOT_RETURN(this, hrc, 9 /*unhandled exception*/,*aSlot);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSlot=%RU32 hrc=%Rhrc\n", this, "ParallelPort::getSlot", *aSlot, hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "ParallelPort::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "ParallelPort::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "ParallelPort::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "ParallelPort::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(IOBase)(ULONG *aIOBase)
{
    LogRelFlow(("{%p} %s: enter aIOBase=%p\n", this, "ParallelPort::getIOBase", aIOBase));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIOBase);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IOBASE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIOBase(aIOBase);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IOBASE_RETURN(this, hrc, 0 /*normal*/,*aIOBase);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IOBASE_RETURN(this, hrc, 1 /*hrc exception*/,*aIOBase);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IOBASE_RETURN(this, hrc, 9 /*unhandled exception*/,*aIOBase);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIOBase=%RU32 hrc=%Rhrc\n", this, "ParallelPort::getIOBase", *aIOBase, hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMSETTER(IOBase)(ULONG aIOBase)
{
    LogRelFlow(("{%p} %s: enter aIOBase=%RU32\n", this, "ParallelPort::setIOBase", aIOBase));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IOBASE_ENTER(this, aIOBase);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIOBase(aIOBase);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IOBASE_RETURN(this, hrc, 0 /*normal*/,aIOBase);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IOBASE_RETURN(this, hrc, 1 /*hrc exception*/,aIOBase);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IOBASE_RETURN(this, hrc, 9 /*unhandled exception*/,aIOBase);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "ParallelPort::setIOBase", hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(IRQ)(ULONG *aIRQ)
{
    LogRelFlow(("{%p} %s: enter aIRQ=%p\n", this, "ParallelPort::getIRQ", aIRQ));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIRQ);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IRQ_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIRQ(aIRQ);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IRQ_RETURN(this, hrc, 0 /*normal*/,*aIRQ);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IRQ_RETURN(this, hrc, 1 /*hrc exception*/,*aIRQ);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_IRQ_RETURN(this, hrc, 9 /*unhandled exception*/,*aIRQ);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIRQ=%RU32 hrc=%Rhrc\n", this, "ParallelPort::getIRQ", *aIRQ, hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMSETTER(IRQ)(ULONG aIRQ)
{
    LogRelFlow(("{%p} %s: enter aIRQ=%RU32\n", this, "ParallelPort::setIRQ", aIRQ));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IRQ_ENTER(this, aIRQ);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIRQ(aIRQ);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IRQ_RETURN(this, hrc, 0 /*normal*/,aIRQ);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IRQ_RETURN(this, hrc, 1 /*hrc exception*/,aIRQ);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_IRQ_RETURN(this, hrc, 9 /*unhandled exception*/,aIRQ);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "ParallelPort::setIRQ", hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(Path)(BSTR *aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%p\n", this, "ParallelPort::getPath", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPath);
        BSTROutConverter TmpPath(aPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_PATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPath(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_PATH_RETURN(this, hrc, 0 /*normal*/,TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_PATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_GET_PATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPath=%ls hrc=%Rhrc\n", this, "ParallelPort::getPath", *aPath, hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMSETTER(Path)(IN_BSTR aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls\n", this, "ParallelPort::setPath", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpPath(aPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_PATH_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPath(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_PATH_RETURN(this, hrc, 0 /*normal*/,TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_PATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PARALLELPORT_SET_PATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "ParallelPort::setPath", hrc));
    return hrc;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(InternalAndReservedAttribute1IParallelPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(InternalAndReservedAttribute2IParallelPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(InternalAndReservedAttribute3IParallelPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ParallelPortWrap::COMGETTER(InternalAndReservedAttribute4IParallelPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IParallelPort methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ParallelPortWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ParallelPortWrap, IParallelPort)
#endif // VBOX_WITH_XPCOM
