/** @file
 * VirtualBox API class wrapper code for IAdditionsFacility.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_ADDITIONSFACILITY

#include "AdditionsFacilityWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(AdditionsFacilityWrap)

//
// IAdditionsFacility properties
//

STDMETHODIMP AdditionsFacilityWrap::COMGETTER(ClassType)(AdditionsFacilityClass_T *aClassType)
{
    LogRelFlow(("{%p} %s: enter aClassType=%p\n", this, "AdditionsFacility::getClassType", aClassType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aClassType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_CLASSTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getClassType(aClassType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_CLASSTYPE_RETURN(this, hrc, 0 /*normal*/,*aClassType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_CLASSTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aClassType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_CLASSTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aClassType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aClassType=%RU32 hrc=%Rhrc\n", this, "AdditionsFacility::getClassType", *aClassType, hrc));
    return hrc;
}

STDMETHODIMP AdditionsFacilityWrap::COMGETTER(LastUpdated)(LONG64 *aLastUpdated)
{
    LogRelFlow(("{%p} %s: enter aLastUpdated=%p\n", this, "AdditionsFacility::getLastUpdated", aLastUpdated));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLastUpdated);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_LASTUPDATED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLastUpdated(aLastUpdated);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_LASTUPDATED_RETURN(this, hrc, 0 /*normal*/,*aLastUpdated);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_LASTUPDATED_RETURN(this, hrc, 1 /*hrc exception*/,*aLastUpdated);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_LASTUPDATED_RETURN(this, hrc, 9 /*unhandled exception*/,*aLastUpdated);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLastUpdated=%RI64 hrc=%Rhrc\n", this, "AdditionsFacility::getLastUpdated", *aLastUpdated, hrc));
    return hrc;
}

STDMETHODIMP AdditionsFacilityWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "AdditionsFacility::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "AdditionsFacility::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP AdditionsFacilityWrap::COMGETTER(Status)(AdditionsFacilityStatus_T *aStatus)
{
    LogRelFlow(("{%p} %s: enter aStatus=%p\n", this, "AdditionsFacility::getStatus", aStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStatus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_STATUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStatus(aStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_STATUS_RETURN(this, hrc, 0 /*normal*/,*aStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_STATUS_RETURN(this, hrc, 1 /*hrc exception*/,*aStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_STATUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStatus=%RU32 hrc=%Rhrc\n", this, "AdditionsFacility::getStatus", *aStatus, hrc));
    return hrc;
}

STDMETHODIMP AdditionsFacilityWrap::COMGETTER(Type)(AdditionsFacilityType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "AdditionsFacility::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_ADDITIONSFACILITY_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "AdditionsFacility::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP AdditionsFacilityWrap::COMGETTER(InternalAndReservedAttribute1IAdditionsFacility)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AdditionsFacilityWrap::COMGETTER(InternalAndReservedAttribute2IAdditionsFacility)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IAdditionsFacility methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(AdditionsFacilityWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(AdditionsFacilityWrap, IAdditionsFacility)
#endif // VBOX_WITH_XPCOM
