//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/splitDiopterSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"
#include "pxr/imaging/hd/cameraSchema.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdSplitDiopterSchemaTokens,
    HD_SPLIT_DIOPTER_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdIntDataSourceHandle
HdSplitDiopterSchema::GetCount() const
{
    return _GetTypedDataSource<HdIntDataSource>(
        HdSplitDiopterSchemaTokens->count);
}

HdFloatDataSourceHandle
HdSplitDiopterSchema::GetAngle() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdSplitDiopterSchemaTokens->angle);
}

HdFloatDataSourceHandle
HdSplitDiopterSchema::GetOffset1() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdSplitDiopterSchemaTokens->offset1);
}

HdFloatDataSourceHandle
HdSplitDiopterSchema::GetWidth1() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdSplitDiopterSchemaTokens->width1);
}

HdFloatDataSourceHandle
HdSplitDiopterSchema::GetFocusDistance1() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdSplitDiopterSchemaTokens->focusDistance1);
}

HdFloatDataSourceHandle
HdSplitDiopterSchema::GetOffset2() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdSplitDiopterSchemaTokens->offset2);
}

HdFloatDataSourceHandle
HdSplitDiopterSchema::GetWidth2() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdSplitDiopterSchemaTokens->width2);
}

HdFloatDataSourceHandle
HdSplitDiopterSchema::GetFocusDistance2() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        HdSplitDiopterSchemaTokens->focusDistance2);
}

/*static*/
HdContainerDataSourceHandle
HdSplitDiopterSchema::BuildRetained(
        const HdIntDataSourceHandle &count,
        const HdFloatDataSourceHandle &angle,
        const HdFloatDataSourceHandle &offset1,
        const HdFloatDataSourceHandle &width1,
        const HdFloatDataSourceHandle &focusDistance1,
        const HdFloatDataSourceHandle &offset2,
        const HdFloatDataSourceHandle &width2,
        const HdFloatDataSourceHandle &focusDistance2
)
{
    TfToken _names[8];
    HdDataSourceBaseHandle _values[8];

    size_t _count = 0;

    if (count) {
        _names[_count] = HdSplitDiopterSchemaTokens->count;
        _values[_count++] = count;
    }

    if (angle) {
        _names[_count] = HdSplitDiopterSchemaTokens->angle;
        _values[_count++] = angle;
    }

    if (offset1) {
        _names[_count] = HdSplitDiopterSchemaTokens->offset1;
        _values[_count++] = offset1;
    }

    if (width1) {
        _names[_count] = HdSplitDiopterSchemaTokens->width1;
        _values[_count++] = width1;
    }

    if (focusDistance1) {
        _names[_count] = HdSplitDiopterSchemaTokens->focusDistance1;
        _values[_count++] = focusDistance1;
    }

    if (offset2) {
        _names[_count] = HdSplitDiopterSchemaTokens->offset2;
        _values[_count++] = offset2;
    }

    if (width2) {
        _names[_count] = HdSplitDiopterSchemaTokens->width2;
        _values[_count++] = width2;
    }

    if (focusDistance2) {
        _names[_count] = HdSplitDiopterSchemaTokens->focusDistance2;
        _values[_count++] = focusDistance2;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetCount(
    const HdIntDataSourceHandle &count)
{
    _count = count;
    return *this;
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetAngle(
    const HdFloatDataSourceHandle &angle)
{
    _angle = angle;
    return *this;
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetOffset1(
    const HdFloatDataSourceHandle &offset1)
{
    _offset1 = offset1;
    return *this;
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetWidth1(
    const HdFloatDataSourceHandle &width1)
{
    _width1 = width1;
    return *this;
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetFocusDistance1(
    const HdFloatDataSourceHandle &focusDistance1)
{
    _focusDistance1 = focusDistance1;
    return *this;
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetOffset2(
    const HdFloatDataSourceHandle &offset2)
{
    _offset2 = offset2;
    return *this;
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetWidth2(
    const HdFloatDataSourceHandle &width2)
{
    _width2 = width2;
    return *this;
}

HdSplitDiopterSchema::Builder &
HdSplitDiopterSchema::Builder::SetFocusDistance2(
    const HdFloatDataSourceHandle &focusDistance2)
{
    _focusDistance2 = focusDistance2;
    return *this;
}

HdContainerDataSourceHandle
HdSplitDiopterSchema::Builder::Build()
{
    return HdSplitDiopterSchema::BuildRetained(
        _count,
        _angle,
        _offset1,
        _width1,
        _focusDistance1,
        _offset2,
        _width2,
        _focusDistance2
    );
}

/*static*/
HdSplitDiopterSchema
HdSplitDiopterSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdSplitDiopterSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdSplitDiopterSchemaTokens->splitDiopter))
        : nullptr);
}

/*static*/
const TfToken &
HdSplitDiopterSchema::GetSchemaToken()
{
    return HdSplitDiopterSchemaTokens->splitDiopter;
}

/*static*/
const HdDataSourceLocator &
HdSplitDiopterSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator =
        HdCameraSchema::GetDefaultLocator().Append(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE