//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/sceneGlobalsSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/imaging/hd/sceneIndex.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdSceneGlobalsSchemaTokens,
    HD_SCENE_GLOBALS_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

/* static */
HdSceneGlobalsSchema
HdSceneGlobalsSchema::GetFromSceneIndex(
    const HdSceneIndexBaseRefPtr &si)
{
    if (!si) {
        TF_CODING_ERROR("Invalid input scene index provided.");
        return HdSceneGlobalsSchema(nullptr);
    }

    return GetFromParent(si->GetPrim(GetDefaultPrimPath()).dataSource);
}

// --(END CUSTOM CODE: Schema Methods)--

HdPathDataSourceHandle
HdSceneGlobalsSchema::GetPrimaryCameraPrim() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        HdSceneGlobalsSchemaTokens->primaryCameraPrim);
}

HdPathDataSourceHandle
HdSceneGlobalsSchema::GetActiveRenderPassPrim() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        HdSceneGlobalsSchemaTokens->activeRenderPassPrim);
}

HdPathDataSourceHandle
HdSceneGlobalsSchema::GetActiveRenderSettingsPrim() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        HdSceneGlobalsSchemaTokens->activeRenderSettingsPrim);
}

HdDoubleDataSourceHandle
HdSceneGlobalsSchema::GetStartTimeCode() const
{
    return _GetTypedDataSource<HdDoubleDataSource>(
        HdSceneGlobalsSchemaTokens->startTimeCode);
}

HdDoubleDataSourceHandle
HdSceneGlobalsSchema::GetEndTimeCode() const
{
    return _GetTypedDataSource<HdDoubleDataSource>(
        HdSceneGlobalsSchemaTokens->endTimeCode);
}

HdDoubleDataSourceHandle
HdSceneGlobalsSchema::GetTimeCodesPerSecond() const
{
    return _GetTypedDataSource<HdDoubleDataSource>(
        HdSceneGlobalsSchemaTokens->timeCodesPerSecond);
}

HdDoubleDataSourceHandle
HdSceneGlobalsSchema::GetCurrentFrame() const
{
    return _GetTypedDataSource<HdDoubleDataSource>(
        HdSceneGlobalsSchemaTokens->currentFrame);
}

HdIntDataSourceHandle
HdSceneGlobalsSchema::GetSceneStateId() const
{
    return _GetTypedDataSource<HdIntDataSource>(
        HdSceneGlobalsSchemaTokens->sceneStateId);
}

/*static*/
HdContainerDataSourceHandle
HdSceneGlobalsSchema::BuildRetained(
        const HdPathDataSourceHandle &primaryCameraPrim,
        const HdPathDataSourceHandle &activeRenderPassPrim,
        const HdPathDataSourceHandle &activeRenderSettingsPrim,
        const HdDoubleDataSourceHandle &startTimeCode,
        const HdDoubleDataSourceHandle &endTimeCode,
        const HdDoubleDataSourceHandle &timeCodesPerSecond,
        const HdDoubleDataSourceHandle &currentFrame,
        const HdIntDataSourceHandle &sceneStateId
)
{
    TfToken _names[8];
    HdDataSourceBaseHandle _values[8];

    size_t _count = 0;

    if (primaryCameraPrim) {
        _names[_count] = HdSceneGlobalsSchemaTokens->primaryCameraPrim;
        _values[_count++] = primaryCameraPrim;
    }

    if (activeRenderPassPrim) {
        _names[_count] = HdSceneGlobalsSchemaTokens->activeRenderPassPrim;
        _values[_count++] = activeRenderPassPrim;
    }

    if (activeRenderSettingsPrim) {
        _names[_count] = HdSceneGlobalsSchemaTokens->activeRenderSettingsPrim;
        _values[_count++] = activeRenderSettingsPrim;
    }

    if (startTimeCode) {
        _names[_count] = HdSceneGlobalsSchemaTokens->startTimeCode;
        _values[_count++] = startTimeCode;
    }

    if (endTimeCode) {
        _names[_count] = HdSceneGlobalsSchemaTokens->endTimeCode;
        _values[_count++] = endTimeCode;
    }

    if (timeCodesPerSecond) {
        _names[_count] = HdSceneGlobalsSchemaTokens->timeCodesPerSecond;
        _values[_count++] = timeCodesPerSecond;
    }

    if (currentFrame) {
        _names[_count] = HdSceneGlobalsSchemaTokens->currentFrame;
        _values[_count++] = currentFrame;
    }

    if (sceneStateId) {
        _names[_count] = HdSceneGlobalsSchemaTokens->sceneStateId;
        _values[_count++] = sceneStateId;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetPrimaryCameraPrim(
    const HdPathDataSourceHandle &primaryCameraPrim)
{
    _primaryCameraPrim = primaryCameraPrim;
    return *this;
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetActiveRenderPassPrim(
    const HdPathDataSourceHandle &activeRenderPassPrim)
{
    _activeRenderPassPrim = activeRenderPassPrim;
    return *this;
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetActiveRenderSettingsPrim(
    const HdPathDataSourceHandle &activeRenderSettingsPrim)
{
    _activeRenderSettingsPrim = activeRenderSettingsPrim;
    return *this;
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetStartTimeCode(
    const HdDoubleDataSourceHandle &startTimeCode)
{
    _startTimeCode = startTimeCode;
    return *this;
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetEndTimeCode(
    const HdDoubleDataSourceHandle &endTimeCode)
{
    _endTimeCode = endTimeCode;
    return *this;
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetTimeCodesPerSecond(
    const HdDoubleDataSourceHandle &timeCodesPerSecond)
{
    _timeCodesPerSecond = timeCodesPerSecond;
    return *this;
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetCurrentFrame(
    const HdDoubleDataSourceHandle &currentFrame)
{
    _currentFrame = currentFrame;
    return *this;
}

HdSceneGlobalsSchema::Builder &
HdSceneGlobalsSchema::Builder::SetSceneStateId(
    const HdIntDataSourceHandle &sceneStateId)
{
    _sceneStateId = sceneStateId;
    return *this;
}

HdContainerDataSourceHandle
HdSceneGlobalsSchema::Builder::Build()
{
    return HdSceneGlobalsSchema::BuildRetained(
        _primaryCameraPrim,
        _activeRenderPassPrim,
        _activeRenderSettingsPrim,
        _startTimeCode,
        _endTimeCode,
        _timeCodesPerSecond,
        _currentFrame,
        _sceneStateId
    );
}

/*static*/
HdSceneGlobalsSchema
HdSceneGlobalsSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdSceneGlobalsSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdSceneGlobalsSchemaTokens->sceneGlobals))
        : nullptr);
}

/*static*/
const TfToken &
HdSceneGlobalsSchema::GetSchemaToken()
{
    return HdSceneGlobalsSchemaTokens->sceneGlobals;
}

/*static*/
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetPrimaryCameraPrimLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->primaryCameraPrim);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetActiveRenderPassPrimLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->activeRenderPassPrim);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetActiveRenderSettingsPrimLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->activeRenderSettingsPrim);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetStartTimeCodeLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->startTimeCode);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetEndTimeCodeLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->endTimeCode);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetTimeCodesPerSecondLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->timeCodesPerSecond);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetCurrentFrameLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->currentFrame);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSceneGlobalsSchema::GetSceneStateIdLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSceneGlobalsSchemaTokens->sceneStateId);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE