//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/extComputationPrimvarsSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdExtComputationPrimvarsSchemaTokens,
    HD_EXT_COMPUTATION_PRIMVARS_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

TfTokenVector
HdExtComputationPrimvarsSchema::GetExtComputationPrimvarNames() const
{
    if (_container) {
        return _container->GetNames();
    } else {
        return {};
    }
}

HdExtComputationPrimvarSchema
HdExtComputationPrimvarsSchema::GetExtComputationPrimvar(const TfToken &name) const
{
    return HdExtComputationPrimvarSchema(
        _GetTypedDataSource<HdContainerDataSource>(name));
}

/*static*/
HdContainerDataSourceHandle
HdExtComputationPrimvarsSchema::BuildRetained(
    const size_t count,
    const TfToken * const names,
    const HdDataSourceBaseHandle * const values)
{
    return HdRetainedContainerDataSource::New(count, names, values);
}

/*static*/
HdExtComputationPrimvarsSchema
HdExtComputationPrimvarsSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdExtComputationPrimvarsSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdExtComputationPrimvarsSchemaTokens->extComputationPrimvars))
        : nullptr);
}

/*static*/
const TfToken &
HdExtComputationPrimvarsSchema::GetSchemaToken()
{
    return HdExtComputationPrimvarsSchemaTokens->extComputationPrimvars;
}

/*static*/
const HdDataSourceLocator &
HdExtComputationPrimvarsSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE