/* arm.v5a-linux.elf-so_entry.h
   created from arm.v5a-linux.elf-so_entry.bin, 13107 (0x3333) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V5A_LINUX_ELF_SO_ENTRY_SIZE    13107
#define STUB_ARM_V5A_LINUX_ELF_SO_ENTRY_ADLER32 0x47959260
#define STUB_ARM_V5A_LINUX_ELF_SO_ENTRY_CRC32   0x311459ac

unsigned char stub_arm_v5a_linux_elf_so_entry[13107] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 108, 11,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  16,  0, 13,  0,  0,  0,160,227, 30,255, 47,225,  0,  0, 82,227,
/* 0x0040 */   7,  0,  0, 10,  0,192,160,225,  1, 48,209,228,  1, 32, 82,226,
/* 0x0050 */   1, 48,192,228,  3,  0,  0, 26, 12,  0,160,225, 30,255, 47,225,
/* 0x0060 */   0,  0, 82,227, 15,  0,  0, 10,  0,192,160,225,  1, 16,192,228,
/* 0x0070 */   1, 32, 82,226, 12,  0,  0, 26, 12,  0,160,225, 30,255, 47,225,
/* 0x0080 */   0,  0, 82,227, 23,  0,  0, 10,  1, 48,209,228,  1, 32, 82,226,
/* 0x0090 */   1, 48,192,228, 19,  0,  0, 26, 30,255, 47,225,  7,192,160,225,
/* 0x00a0 */ 129,112,160,227,  1,124,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x00b0 */  30,255, 47,225,  7,192,160,225,  6,112,160,227,  0,  0,  0,239,
/* 0x00c0 */  12,112,160,225, 30,255, 47,225,  7,192,160,225,  1,112,160,227,
/* 0x00d0 */   0,  0,  0,239, 12,112,160,225, 30,255, 47,225,  7,192,160,225,
/* 0x00e0 */ 148,112,160,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x00f0 */   7,192,160,225,118,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0100 */  30,255, 47,225,  7,192,160,225, 93,112,160,227,  0,  0,  0,239,
/* 0x0110 */  12,112,160,225, 30,255, 47,225,  7,192,160,225, 20,112,160,227,
/* 0x0120 */   0,  0,  0,239, 12,112,160,225, 30,255, 47,225,  7,192,160,225,
/* 0x0130 */  19,112,160,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x0140 */   7,192,160,225, 39,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0150 */  30,255, 47,225,  7,192,160,225,  5,112,160,227,  0,  0,  0,239,
/* 0x0160 */  12,112,160,225, 30,255, 47,225,  7,192,160,225, 66,112,160,227,
/* 0x0170 */   1,124,135,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x0180 */   7,192,160,225,  3,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0190 */  30,255, 47,225,  7,192,160,225,106,112,160,227,  0,  0,  0,239,
/* 0x01a0 */  12,112,160,225, 30,255, 47,225,  7,192,160,225,122,112,160,227,
/* 0x01b0 */   0,  0,  0,239, 12,112,160,225, 30,255, 47,225,  7,192,160,225,
/* 0x01c0 */  10,112,160,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x01d0 */   7,192,160,225,  4,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x01e0 */  30,255, 47,225,240,  1,240,231, 30,255, 47,225, 48, 64, 45,233,
/* 0x01f0 */  16, 80,157,229, 12, 64,157,229, 37, 86,160,225,  6,192,192,225,
/* 0x0200 */  12,  0, 64,224, 12, 16,129,224,  7,192,160,225,192,112,160,227,
/* 0x0210 */   0,  0,  0,239, 12,112,160,225, 48,128,189,232, 47,112,114,111,
/* 0x0220 */  99, 47,115,101,108,102, 47, 97,117,120,118,  0,  2,220, 77,226,
/* 0x0230 */  14, 64,160,225,  0, 96,224,227,  6,102,160,225, 99,  0,224,227,
/* 0x0240 */  44, 16, 79,226,  0, 32,160,227,254,255,255,235,  0, 80,160,225,
/* 0x0250 */   0,  0, 16,225,152,  0,  0, 74,  2, 44,160,227, 13, 16,160,225,
/* 0x0260 */   5,  0,160,225,254,255,255,235,  0,  0, 16,225,150,  0,  0, 74,
/* 0x0270 */  13, 16,160,225,  8, 32,145,228,  6, 32, 82,226,148,  0,  0, 10,
/* 0x0280 */   8,  0, 80,226,150,  0,  0, 10,142,  0,  0,234,  4, 96, 17,229,
/* 0x0290 */   6, 96, 66,224,  5,  0,160,225,254,255,255,235,  2,220,141,226,
/* 0x02a0 */   8, 96,141,229,  2,  0,  0,235,254,255,255,234,254,255,255,234,
/* 0x02b0 */  63, 32,  0,226, 31, 48,  0,226, 26,  0, 83,227,  5,  0,  0,154,
/* 0x02c0 */  32,  0, 16,227, 70, 32, 66, 18, 43, 32, 66,  2, 64,  0,130,226,
/* 0x02d0 */  30,255, 47,225,  2,192,160,225, 17,  0,  0,234,  0, 32,208,229,
/* 0x02e0 */  32, 32,130,227,  0, 48,209,229, 32, 48,131,227,  3, 32, 82,224,
/* 0x02f0 */  21,  0,  0, 26,  1,  0,128,226,  1, 16,129,226,  1,192, 76,226,
/* 0x0300 */   1,  0,124,227,  9,  0,  0, 26,  0, 32,160,227,  2,  0,160,225,
/* 0x0310 */  30,255, 47,225,112, 64, 45,233, 64,208, 77,226,  0, 80,160,225,
/* 0x0320 */   1, 96,160,225, 13,  0,160,225,255, 16,160,227, 64, 32,160,227,
/* 0x0330 */ 254,255,255,235,  5,  0,160,225, 13, 16,160,225,254,255,255,235,
/* 0x0340 */   0, 64, 80,226, 41,  0,  0,186,184, 48,221,225, 15, 58,  3,226,
/* 0x0350 */   1,  9, 83,227,  0, 64,160,  3, 54,  0,  0,234,  2,  0,116,227,
/* 0x0360 */  47,  0,  0, 26,  5,  0,160,225,  7, 29,160,227,254,255,255,235,
/* 0x0370 */   0, 64,160,225,  0, 48, 86,226,  1, 48,160, 19,164, 63, 19,224,
/* 0x0380 */  54,  0,  0, 10,  5,  0,160,225,  4, 16,160,225,254,255,255,235,
/* 0x0390 */   4,  0,160,225, 64,208,141,226,112,128,189,232,240, 65, 45,233,
/* 0x03a0 */   0,128,160,225,  1, 96,160,225, 64,  0,  0,235, 47,100, 97,116,
/* 0x03b0 */  97, 47,100, 97,116, 97, 47,  0, 14, 16,160,225, 11, 32,160,227,
/* 0x03c0 */ 254,255,255,235,  0, 64,160,227,  0, 64,192,229,  8,  0,160,225,
/* 0x03d0 */   1, 16,160,227, 23,  0,  0,235, 78,  0,  0,235, 47,112,114,111,
/* 0x03e0 */  99, 47,115,101,108,102, 47, 99,109,100,108,105,110,101,  0,  0,
/* 0x03f0 */  14,112,160,225,  7,  0,160,225,  4, 16,160,225,  4, 32,160,225,
/* 0x0400 */ 254,255,255,235,  0, 64,160,225,  6, 16,160,225,100, 33,159,229,
/* 0x0410 */ 254,255,255,235,  0, 80,160,225,  4,  0,160,225,254,255,255,235,
/* 0x0420 */   0,  0, 85,227, 94,  0,  0,170,  7,  0,160,225,254,255,255,235,
/* 0x0430 */   0, 48,160,227,  5, 48,198,231,  0, 48,214,229,  0,  0, 83,227,
/* 0x0440 */   6, 16,160,  1,140,  0,  0, 10,  6, 16,160,225,  1, 48,241,229,
/* 0x0450 */   0,  0, 83,227,101,  0,  0, 26,140,  0,  0,234,  1, 48,116,229,
/* 0x0460 */  47,  0, 83,227,105,  0,  0, 26,  1,112,100,224, 10,  0,136,226,
/* 0x0470 */   4, 16,160,225,  7, 32,160,225,254,255,255,235,  0, 80,160,225,
/* 0x0480 */   0, 96,160,227,  0, 96,192,229,  8,  0,160,225,  6, 16,160,225,
/* 0x0490 */  23,  0,  0,235, 13,  0,112,227,142,  0,  0, 26,127,  0,  0,235,
/* 0x04a0 */  99,111,109, 46,116,101,114,109,117,120, 47,102,105,108,101,115,
/* 0x04b0 */   0,  0,  0,  0, 14, 16,160,225, 11,  0,136,226, 16, 32,160,227,
/* 0x04c0 */ 254,255,255,235,  4, 16,160,225,  7, 32,160,225,254,255,255,235,
/* 0x04d0 */   0, 80,160,225,  0, 96,192,229,  8,  0,160,225,  1, 16,160,227,
/* 0x04e0 */  23,  0,  0,235,142,  0,  0,234,  1, 64,160,225,105,  0,  0,234,
/* 0x04f0 */ 145,  0,  0,235, 47, 99, 97, 99,104,101,  0,  0, 14, 16,160,225,
/* 0x0500 */   5,  0,160,225,  6, 32,160,227,254,255,255,235,  0, 64,160,225,
/* 0x0510 */   0, 96,160,227,  0, 96,192,229,  8,  0,160,225,  1, 16,160,227,
/* 0x0520 */  23,  0,  0,235,158,  0,  0,235, 47,117,112,120,  0,  0,  0,  0,
/* 0x0530 */  14, 16,160,225,  4,  0,160,225,  4, 32,160,227,254,255,255,235,
/* 0x0540 */   0, 64,160,225,254,255,255,235,  0, 80,160,225,254,255,255,235,
/* 0x0550 */   0,  0,196,229, 37,  3,160,225,254,255,255,235,  1,  0,196,229,
/* 0x0560 */  37,  6,160,225,254,255,255,235,  2,  0,196,229,  3, 96,196,229,
/* 0x0570 */   6,  0,160,225,240,129,189,232,255, 15,  0,  0,240, 65, 45,233,
/* 0x0580 */   1,218, 77,226, 12,208, 77,226,  0,112,160,225,  1,128,160,225,
/* 0x0590 */   2, 96,160,225,185,  0,  0,235,117,112,120,  0, 14, 64,160,225,
/* 0x05a0 */   4,  0,160,225, 16, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x05b0 */  22,  0,112,227,196,  0,  0, 26,  4,  0,160,225,  0, 16,160,227,
/* 0x05c0 */ 254,255,255,235,  0, 80,160,225,  0,  0, 85,227,215,  0,  0,170,
/* 0x05d0 */ 202,  0,  0,235, 47,100,101,118, 47,115,104,109,  0,  0,  0,  0,
/* 0x05e0 */  14,  0,160,225,  8, 18,159,229,  7, 45,160,227,254,255,255,235,
/* 0x05f0 */   0, 80, 80,226,215,  0,  0,170,213,  0,  0,235,109,101,109,102,
/* 0x0600 */ 100, 95, 99,114,101, 97,116,101,  0,  0,  0,  0, 14,  0,160,225,
/* 0x0610 */ 254,255,255,235, 12, 64,141,226,  4,  0,160,225,254,255,255,235,
/* 0x0620 */ 220,  0,  0,235, 97,110,100,  0, 14,  0,160,225,  4, 16,160,225,
/* 0x0630 */   3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,238,  0,  0, 10,
/* 0x0640 */ 228,  0,  0,235, 76,105,110,  0, 14,  0,160,225,  4, 16,160,225,
/* 0x0650 */   3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,238,  0,  0, 26,
/* 0x0660 */ 130, 48,212,229, 52,  0, 83,227,  1, 64,160,131, 16,  1,  0,138,
/* 0x0670 */   0,  0, 86,227,247,  0,  0, 26,254,255,255,235,  0, 96, 80,226,
/* 0x0680 */ 112, 49,159,  5,  1, 42,141,  2, 12, 32,130,  2,  3, 96,194,  7,
/* 0x0690 */  12, 96,141,  2, 38,  0,117,227, 15,  1,  0, 26,  0,  0, 86,227,
/* 0x06a0 */  15,  1,  0, 10,  0, 48,214,229,  0,  0, 83,227,  4,  1,  0, 26,
/* 0x06b0 */   6,  0,160,225,  2, 27,141,226, 12, 16,129,226, 57,  0,  0,235,
/* 0x06c0 */   0,  0, 80,227, 76,  1,  0,186,  6,  0,160,225,194, 16,160,227,
/* 0x06d0 */   7, 45,160,227,254,255,255,235,  0, 80, 80,226,  5,  0,160,177,
/* 0x06e0 */  76,  1,  0,186,  6,  0,160,225,254,255,255,235,  0, 64,160,227,
/* 0x06f0 */  16,  1,  0,234,  0, 64,160,227,  0,  0, 87,227, 23,  1,  0, 10,
/* 0x0700 */ 254,255,255,235,  0,  0,224,225,  7,  0,  0,224,  7,112, 96,224,
/* 0x0710 */   0,128,136,224,  0,  0, 88,227, 50,  1,  0, 10,  0,  0, 84,227,
/* 0x0720 */  33,  1,  0, 10,  5,  0,160,225,  8, 16,160,225,254,255,255,235,
/* 0x0730 */   0,  0, 80,227, 50,  1,  0,170, 76,  1,  0,234,  5,  0,160,225,
/* 0x0740 */   1, 16, 72,226,  0, 32,160,227,254,255,255,235,  1, 26,224,227,
/* 0x0750 */   0, 64,160,227,  1, 58,141,226, 12, 48,131,226,  1, 64,195,231,
/* 0x0760 */   5,  0,160,225,  1, 16,131,224,  1, 32,160,227,254,255,255,235,
/* 0x0770 */   5,  0,160,225,  4, 16,160,225,  4, 32,160,225,254,255,255,235,
/* 0x0780 */   0,  0, 87,227,  1,192,160,  3, 62,  1,  0, 10,254,255,255,235,
/* 0x0790 */   0, 32,160,225,  0, 48,215,225, 74,  1,  0, 10,  5,  0,160,225,
/* 0x07a0 */   7, 16,160,225,  0, 32, 98,226,254,255,255,235, 74,  1,  0,234,
/* 0x07b0 */   0, 80,141,229,  0, 48,160,227,  4, 48,141,229,  7,  0,160,225,
/* 0x07c0 */   8, 16,160,225,  3, 32,160,227, 12, 48,160,225,254,255,255,235,
/* 0x07d0 */   1, 10,112,227,  1, 48,133,146,  3,  0,128,145, 76,  1,  0,234,
/* 0x07e0 */  17,192,160,227, 62,  1,  0,234, 12,208,141,226,  1,218,141,226,
/* 0x07f0 */ 240,129,189,232,  2, 64, 64,  0,  0,240,255,255,240, 64, 45,233,
/* 0x0800 */   8,208, 77,226,  0,112,160,225,  1, 96,160,225,  4,  0,  0,235,
/* 0x0810 */ 117,112,120,  0, 14, 64,160,225,  4,  0,160,225, 16, 16,160,227,
/* 0x0820 */ 254,255,255,235,  0, 80,160,225, 22,  0,112,227, 15,  0,  0, 26,
/* 0x0830 */   4,  0,160,225,  0, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x0840 */   0,  0, 85,227, 53,  0,  0,170, 21,  0,  0,235, 47,100,101,118,
/* 0x0850 */  47,115,104,109,  0,  0,  0,  0, 14,  0,160,225,212, 16,159,229,
/* 0x0860 */   7, 45,160,227,254,255,255,235,  0, 80, 80,226, 53,  0,  0,170,
/* 0x0870 */  21,  0,117,227,  5, 64,160, 17, 74,  0,  0, 26, 47,  0,  0,235,
/* 0x0880 */  85, 80, 88, 45, 53, 46, 48, 32,119, 97,110,116,115, 32,109,101,
/* 0x0890 */ 109,102,100, 95, 99,114,101, 97,116,101, 40, 41, 44, 32,111,114,
/* 0x08a0 */  32,110,101,101,100,115, 32, 47,100,101,118, 47,115,104,109, 40,
/* 0x08b0 */  44, 79, 95, 84, 77, 80, 70, 73, 76, 69, 44, 41, 10,  0,  0,  0,
/* 0x08c0 */  14, 16,160,225,  2,  0,160,227, 61, 32,160,227,254,255,255,235,
/* 0x08d0 */ 127,  0,160,227,254,255,255,235,  5,  0,160,225,  6, 16,160,225,
/* 0x08e0 */ 254,255,255,235,  0,  0, 80,227,  0, 64,160,177, 74,  0,  0,186,
/* 0x08f0 */   0, 80,141,229,  0, 48,160,227,  4, 48,141,229,  7,  0,160,225,
/* 0x0900 */   6, 16,160,225,  3, 32,160,227,  3,  0, 87,225,  1, 48,160,  3,
/* 0x0910 */  17, 48,160, 19,254,255,255,235,  0, 64,160,225,254,255,255,235,
/* 0x0920 */   4,  0, 80,225,  1, 48,132,130,  3, 64,133,128,  4,  0,160,225,
/* 0x0930 */   8,208,141,226,240,128,189,232,  2, 64, 64,  0,  0,  0,160,225,
/* 0x0940 */ 255, 64, 45,233, 12,208, 77,226,124,  0,  0,235,  0,  0,158,229,
/* 0x0950 */   4,  0,141,229,  4,112,158,229, 12, 64,142,226,  0, 32,160,227,
/* 0x0960 */   0, 16,160,225,  0,  0,160,227,254,255,255,235,  4, 48,141,226,
/* 0x0970 */  32, 38,160,225,  2, 38,160,225,  0, 32,141,229,  7, 16,160,225,
/* 0x0980 */   2,112, 64,224,  1,112, 71,226,  4,  0,160,225, 50,  0,  0,235,
/* 0x0990 */   0,  0, 80,227, 22,  0,  0, 10,240,  1,240,231,  4, 32,157,229,
/* 0x09a0 */   0, 16,157,229,  7,  0,160,225,  0, 96,129,229,254,255,255,235,
/* 0x09b0 */   2,  0, 80,225, 30,  0,  0, 10,240,  1,240,231,  0, 80,160,227,
/* 0x09c0 */   7, 64,160,225, 18, 48,160,227,  5, 32,160,227,  4, 16,157,229,
/* 0x09d0 */   0,  0,157,229,  7,192,160,225,192,112,160,227,  0,  0,  0,239,
/* 0x09e0 */  12,112,160,225,  0, 32,157,229,  2,  0, 80,225, 44,  0,  0, 10,
/* 0x09f0 */ 240,  1,240,231,  7,  0,160,225,254,255,255,235, 12, 16,141,226,
/* 0x0a00 */ 220,  0, 79,226,  0, 32,157,229, 12,240,130,226,  0, 16,129,224,
/* 0x0a10 */  62, 64, 45,233,  0, 80,224,227,  2, 65,160,227, 75,  0,  0,234,
/* 0x0a20 */  26,  0,189,232,  1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,
/* 0x0a30 */  48,128,189,232,  4, 64,148,224, 14,240,160, 17,  1, 64,208,228,
/* 0x0a40 */   4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 16,160,227,
/* 0x0a50 */  14,192,160,225, 60,  0,  0,235,  1, 16,177,224, 60,  0,  0,235,
/* 0x0a60 */  68,  0,  0, 58, 12,240,160,225,  1, 48,208,228,  1, 48,194,228,
/* 0x0a70 */  60,  0,  0,235, 73,  0,  0, 42, 66,  0,  0,235,  3, 48, 81,226,
/* 0x0a80 */   0, 16,160,227, 85,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,
/* 0x0a90 */   5, 80,240,225, 55,  0,  0, 10, 60,  0,  0,235,  1, 16,177,224,
/* 0x0aa0 */  60,  0,  0,235,  1, 16,177,224, 92,  0,  0, 26, 66,  0,  0,235,
/* 0x0ab0 */   2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,  5, 48,210,231,
/* 0x0ac0 */   1, 16, 81,226,  1, 48,194,228, 94,  0,  0, 42, 75,  0,  0,234,
/* 0x0ad0 */   8,  0,189,232,  0,  0,160,225,  3,  0, 64,224,  8,  0,189,232,
/* 0x0ae0 */   2,  0,189,232,  3, 32, 66,224,  8,  0,189,232,  0, 32,131,229,
/* 0x0af0 */  30,255, 47,225,  0,  0,224,227,  0,  6,160,225, 30,255, 47,225,
/* 0x0b00 */   0, 46,115,121,109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,
/* 0x0b10 */   0, 46,115,104,115,116,114,116, 97, 98,  0, 46,114,101,108, 69,
/* 0x0b20 */  76, 70, 77, 65, 73, 78, 90,  0, 46,114,101,108, 72, 85, 77, 70,
/* 0x0b30 */  95, 65,  0, 46,114,101,108, 72, 85, 77, 70, 95, 76,  0, 46,114,
/* 0x0b40 */ 101,108, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,114,
/* 0x0b50 */ 101,108, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108,
/* 0x0b60 */  69, 76, 70, 77, 65, 73, 78, 88,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b90 */   0,  0,  0,  0, 31,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0ba0 */   0,  0,  0,  0, 52,  0,  0,  0,116,  2,  0,  0,  0,  0,  0,  0,
/* 0x0bb0 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,
/* 0x0bc0 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 40, 17,  0,  0,
/* 0x0bd0 */ 120,  0,  0,  0, 14,  0,  0,  0,  1,  0,  0,  0,  4,  0,  0,  0,
/* 0x0be0 */   8,  0,  0,  0, 44,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0bf0 */   0,  0,  0,  0,168,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c00 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,
/* 0x0c10 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,160, 17,  0,  0,
/* 0x0c20 */   8,  0,  0,  0, 14,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
/* 0x0c30 */   8,  0,  0,  0, 55,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0c40 */   0,  0,  0,  0,172,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c50 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 51,  0,  0,  0,
/* 0x0c60 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,168, 17,  0,  0,
/* 0x0c70 */   8,  0,  0,  0, 14,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,
/* 0x0c80 */   8,  0,  0,  0, 66,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0c90 */   0,  0,  0,  0,176,  2,  0,  0, 76,  5,  0,  0,  0,  0,  0,  0,
/* 0x0ca0 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 62,  0,  0,  0,
/* 0x0cb0 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,176, 17,  0,  0,
/* 0x0cc0 */ 208,  2,  0,  0, 14,  0,  0,  0,  7,  0,  0,  0,  4,  0,  0,  0,
/* 0x0cd0 */   8,  0,  0,  0, 82,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0ce0 */   0,  0,  0,  0,252,  7,  0,  0, 64,  1,  0,  0,  0,  0,  0,  0,
/* 0x0cf0 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 78,  0,  0,  0,
/* 0x0d00 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128, 20,  0,  0,
/* 0x0d10 */ 128,  0,  0,  0, 14,  0,  0,  0,  9,  0,  0,  0,  4,  0,  0,  0,
/* 0x0d20 */   8,  0,  0,  0, 96,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0d30 */   0,  0,  0,  0, 60,  9,  0,  0,196,  1,  0,  0,  0,  0,  0,  0,
/* 0x0d40 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 92,  0,  0,  0,
/* 0x0d50 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,
/* 0x0d60 */ 184,  0,  0,  0, 14,  0,  0,  0, 11,  0,  0,  0,  4,  0,  0,  0,
/* 0x0d70 */   8,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d80 */   0,  0,  0,  0,  0, 11,  0,  0,105,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d90 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x0da0 */   2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,236, 13,  0,  0,
/* 0x0db0 */  48,  2,  0,  0, 15,  0,  0,  0,  7,  0,  0,  0,  4,  0,  0,  0,
/* 0x0dc0 */  16,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
/* 0x0dd0 */   0,  0,  0,  0, 28, 16,  0,  0, 11,  1,  0,  0,  0,  0,  0,  0,
/* 0x0de0 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0df0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e00 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,
/* 0x0e10 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  7,  0,  0,  0,  0,  0,
/* 0x0e20 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  9,  0,  0,  0,  0,  0,
/* 0x0e30 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 11,  0,  0,  0,  0,  0,
/* 0x0e40 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,
/* 0x0e50 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,  1,  0,  0,  0,
/* 0x0e60 */ 184,  1,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0, 15,  0,  0,  0,
/* 0x0e70 */ 228,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 22,  0,  0,  0,
/* 0x0e80 */ 196,  1,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0, 38,  0,  0,  0,
/* 0x0e90 */   8,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 45,  0,  0,  0,
/* 0x0ea0 */  76,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 53,  0,  0,  0,
/* 0x0eb0 */ 208,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 63,  0,  0,  0,
/* 0x0ec0 */ 248,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 69,  0,  0,  0,
/* 0x0ed0 */ 204,  2,  0,  0,128,  2,  0,  0, 18,  0,  7,  0, 93,  0,  0,  0,
/* 0x0ee0 */ 184,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 98,  0,  0,  0,
/* 0x0ef0 */   0,  0,  0,  0, 64,  1,  0,  0, 18,  0,  9,  0,120,  0,  0,  0,
/* 0x0f00 */ 116,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,126,  0,  0,  0,
/* 0x0f10 */ 156,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,132,  0,  0,  0,
/* 0x0f20 */ 168,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,142,  0,  0,  0,
/* 0x0f30 */   0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,157,  0,  0,  0,
/* 0x0f40 */ 104,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,170,  0,  0,  0,
/* 0x0f50 */   0,  0,  0,  0,  0,  0,  0,  0, 18,  0, 11,  0,177,  0,  0,  0,
/* 0x0f60 */  76,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,182,  0,  0,  0,
/* 0x0f70 */ 136,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,189,  0,  0,  0,
/* 0x0f80 */  44,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,196,  0,  0,  0,
/* 0x0f90 */ 208,  0,  0,  0,196,  0,  0,  0, 18,  0, 11,  0,219,  0,  0,  0,
/* 0x0fa0 */ 176,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,227,  0,  0,  0,
/* 0x0fb0 */ 188,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,233,  0,  0,  0,
/* 0x0fc0 */  96,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,238,  0,  0,  0,
/* 0x0fd0 */ 148,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,243,  0,  0,  0,
/* 0x0fe0 */  52,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,250,  0,  0,  0,
/* 0x0ff0 */  32,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,255,  0,  0,  0,
/* 0x1000 */  12,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,  5,  1,  0,  0,
/* 0x1010 */ 128,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,  0,103,101,116,
/* 0x1020 */  95,112, 97,103,101, 95,109, 97,115,107,  0,103,101,116,112,105,
/* 0x1030 */ 100,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,
/* 0x1040 */ 100,  0,109,101,109, 99,112,121,  0,109,101,109,112, 99,112,121,
/* 0x1050 */   0,102,116,114,117,110, 99, 97,116,101,  0,108,115,101,101,107,
/* 0x1060 */   0,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x1070 */  95, 97,110,100,114,111,105,100,  0,109,109, 97,112,  0,117,112,
/* 0x1080 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,
/* 0x1090 */ 110,117,120,  0,117,110, 97,109,101,  0,119,114,105,116,101,  0,
/* 0x10a0 */ 102,100, 97,116, 97,115,121,110, 99,  0,103,101,116, 95,117,112,
/* 0x10b0 */ 120,102,110, 95,112, 97,116,104,  0,109,101,109,102,100, 95, 99,
/* 0x10c0 */ 114,101, 97,116,101,  0, 95,115,116, 97,114,116,  0,114,101, 97,
/* 0x10d0 */ 100,  0,117,110,108,105,110,107,  0,109,101,109,115,101,116,  0,
/* 0x10e0 */ 117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,
/* 0x10f0 */ 114,101,115,115, 95, 56,  0,109,121, 95, 98,107,112,116,  0,102,
/* 0x1100 */ 115,121,110, 99,  0,115,116, 97,116,  0,101,120,105,116,  0,111,
/* 0x1110 */ 112,101,110, 97,116,  0,111,112,101,110,  0,109,107,100,105,114,
/* 0x1120 */   0, 99,108,111,115,101,  0,  0, 12,  0,  0,  0,  1,  1,  0,  0,
/* 0x1130 */  32,  0,  0,  0,  1,  1,  0,  0, 48,  0,  0,  0,  1,  1,  0,  0,
/* 0x1140 */  64,  0,  0,  0,  1,  1,  0,  0, 80,  0,  0,  0,  1,  1,  0,  0,
/* 0x1150 */  96,  0,  0,  0,  1,  1,  0,  0, 20,  2,  0,  0,  1, 31,  0,  0,
/* 0x1160 */  32,  2,  0,  0,  1,  1,  0,  0, 48,  2,  0,  0,  1, 23,  0,  0,
/* 0x1170 */  56,  2,  0,  0,  1,  1,  0,  0, 72,  2,  0,  0,  1,  1,  0,  0,
/* 0x1180 */  80,  2,  0,  0,  1,  1,  0,  0, 84,  2,  0,  0,  1,  1,  0,  0,
/* 0x1190 */ 100,  2,  0,  0,  1, 34,  0,  0,112,  2,  0,  0,  1,  4,  0,  0,
/* 0x11a0 */   0,  0,  0,  0,  1, 14,  0,  0,  0,  0,  0,  0,  1, 16,  0,  0,
/* 0x11b0 */  12,  0,  0,  0,  1,  2,  0,  0, 40,  0,  0,  0,  1,  2,  0,  0,
/* 0x11c0 */  64,  0,  0,  0,  1,  2,  0,  0, 84,  0,  0,  0,  1,  2,  0,  0,
/* 0x11d0 */ 128,  0,  0,  0,  1, 25,  0,  0,140,  0,  0,  0,  1, 29,  0,  0,
/* 0x11e0 */ 148,  0,  0,  0,  1,  2,  0,  0,168,  0,  0,  0,  1,  2,  0,  0,
/* 0x11f0 */ 176,  0,  0,  0,  1,  2,  0,  0,188,  0,  0,  0,  1, 33,  0,  0,
/* 0x1200 */ 208,  0,  0,  0,  1,  2,  0,  0,220,  0,  0,  0,  1, 27,  0,  0,
/* 0x1210 */ 248,  0,  0,  0,  1,  2,  0,  0, 16,  1,  0,  0,  1, 11,  0,  0,
/* 0x1220 */  36,  1,  0,  0,  1,  2,  0,  0, 40,  1,  0,  0,  1,  2,  0,  0,
/* 0x1230 */  80,  1,  0,  0,  1, 32,  0,  0, 96,  1,  0,  0,  1, 23,  0,  0,
/* 0x1240 */ 108,  1,  0,  0,  1, 34,  0,  0,116,  1,  0,  0,  1,  2,  0,  0,
/* 0x1250 */ 124,  1,  0,  0,  1, 27,  0,  0,148,  1,  0,  0,  1,  2,  0,  0,
/* 0x1260 */ 164,  1,  0,  0,  1,  2,  0,  0,168,  1,  0,  0,  1,  2,  0,  0,
/* 0x1270 */ 180,  1,  0,  0,  1,  2,  0,  0,200,  1,  0,  0,  1, 11,  0,  0,
/* 0x1280 */ 224,  1,  0,  0,  1,  2,  0,  0,232,  1,  0,  0,  1,  2,  0,  0,
/* 0x1290 */ 236,  1,  0,  0,  1,  2,  0,  0, 16,  2,  0,  0,  1, 11,  0,  0,
/* 0x12a0 */  28,  2,  0,  0,  1, 11,  0,  0, 48,  2,  0,  0,  1,  2,  0,  0,
/* 0x12b0 */  52,  2,  0,  0,  1,  2,  0,  0, 60,  2,  0,  0,  1,  2,  0,  0,
/* 0x12c0 */  64,  2,  0,  0,  1,  2,  0,  0, 88,  2,  0,  0,  1, 11,  0,  0,
/* 0x12d0 */ 112,  2,  0,  0,  1,  2,  0,  0,116,  2,  0,  0,  1,  2,  0,  0,
/* 0x12e0 */ 140,  2,  0,  0,  1, 11,  0,  0,148,  2,  0,  0,  1,  8,  0,  0,
/* 0x12f0 */ 156,  2,  0,  0,  1,  2,  0,  0,168,  2,  0,  0,  1,  2,  0,  0,
/* 0x1300 */ 180,  2,  0,  0,  1,  2,  0,  0,228,  2,  0,  0,  1,  2,  0,  0,
/* 0x1310 */ 248,  2,  0,  0,  1, 21,  0,  0,  4,  3,  0,  0,  1,  2,  0,  0,
/* 0x1320 */  16,  3,  0,  0,  1, 21,  0,  0, 28,  3,  0,  0,  1,  2,  0,  0,
/* 0x1330 */  32,  3,  0,  0,  1,  2,  0,  0, 60,  3,  0,  0,  1, 32,  0,  0,
/* 0x1340 */  68,  3,  0,  0,  1,  2,  0,  0, 72,  3,  0,  0,  1,  2,  0,  0,
/* 0x1350 */  96,  3,  0,  0,  1, 27,  0,  0,108,  3,  0,  0,  1, 17,  0,  0,
/* 0x1360 */ 112,  3,  0,  0,  1,  2,  0,  0,132,  3,  0,  0,  1,  2,  0,  0,
/* 0x1370 */ 140,  3,  0,  0,  1,  2,  0,  0,144,  3,  0,  0,  1,  2,  0,  0,
/* 0x1380 */ 164,  3,  0,  0,  1,  2,  0,  0,172,  3,  0,  0,  1,  2,  0,  0,
/* 0x1390 */ 188,  3,  0,  0,  1,  2,  0,  0,196,  3,  0,  0,  1,  2,  0,  0,
/* 0x13a0 */ 200,  3,  0,  0,  1, 20,  0,  0,232,  3,  0,  0,  1,  2,  0,  0,
/* 0x13b0 */ 240,  3,  0,  0,  1,  2,  0,  0,252,  3,  0,  0,  1,  2,  0,  0,
/* 0x13c0 */  12,  4,  0,  0,  1,  2,  0,  0, 20,  4,  0,  0,  1,  2,  0,  0,
/* 0x13d0 */  36,  4,  0,  0,  1, 32,  0,  0, 48,  4,  0,  0,  1,  2,  0,  0,
/* 0x13e0 */  56,  4,  0,  0,  1, 24,  0,  0, 64,  4,  0,  0,  1,  2,  0,  0,
/* 0x13f0 */  76,  4,  0,  0,  1,  2,  0,  0, 80,  4,  0,  0,  1,  7,  0,  0,
/* 0x1400 */ 104,  4,  0,  0,  1,  2,  0,  0,112,  4,  0,  0,  1,  2,  0,  0,
/* 0x1410 */ 124,  4,  0,  0,  1, 12,  0,  0,132,  4,  0,  0,  1,  2,  0,  0,
/* 0x1420 */ 136,  4,  0,  0,  1,  2,  0,  0,152,  4,  0,  0,  1, 13,  0,  0,
/* 0x1430 */ 188,  4,  0,  0,  1, 18,  0,  0,204,  4,  0,  0,  1, 13,  0,  0,
/* 0x1440 */ 216,  4,  0,  0,  1,  2,  0,  0,220,  4,  0,  0,  1,  7,  0,  0,
/* 0x1450 */ 232,  4,  0,  0,  1,  2,  0,  0,248,  4,  0,  0,  1, 18,  0,  0,
/* 0x1460 */ 252,  4,  0,  0,  1,  2,  0,  0, 28,  5,  0,  0,  1, 15,  0,  0,
/* 0x1470 */  44,  5,  0,  0,  1,  2,  0,  0, 52,  5,  0,  0,  1,  2,  0,  0,
/* 0x1480 */  16,  0,  0,  0,  1,  3,  0,  0, 36,  0,  0,  0,  1, 21,  0,  0,
/* 0x1490 */  48,  0,  0,  0,  1,  3,  0,  0, 60,  0,  0,  0,  1, 21,  0,  0,
/* 0x14a0 */  72,  0,  0,  0,  1,  3,  0,  0, 76,  0,  0,  0,  1,  3,  0,  0,
/* 0x14b0 */ 104,  0,  0,  0,  1, 32,  0,  0,112,  0,  0,  0,  1,  3,  0,  0,
/* 0x14c0 */ 124,  0,  0,  0,  1,  3,  0,  0,128,  0,  0,  0,  1,  3,  0,  0,
/* 0x14d0 */ 208,  0,  0,  0,  1, 18,  0,  0,216,  0,  0,  0,  1, 30,  0,  0,
/* 0x14e0 */ 228,  0,  0,  0,  1, 12,  0,  0,240,  0,  0,  0,  1,  3,  0,  0,
/* 0x14f0 */  24,  1,  0,  0,  1, 15,  0,  0, 32,  1,  0,  0,  1,  7,  0,  0,
/* 0x1500 */  12,  0,  0,  0,  1,  1,  0,  0, 44,  0,  0,  0,  1,  9,  0,  0,
/* 0x1510 */  80,  0,  0,  0,  1,  4,  0,  0, 88,  0,  0,  0,  1,  4,  0,  0,
/* 0x1520 */ 112,  0,  0,  0,  1, 18,  0,  0,120,  0,  0,  0,  1,  4,  0,  0,
/* 0x1530 */ 176,  0,  0,  0,  1,  4,  0,  0,188,  0,  0,  0,  1, 34,  0,  0,
/* 0x1540 */ 224,  0,  0,  0,  1,  4,  0,  0, 24,  1,  0,  0,  1,  4,  0,  0,
/* 0x1550 */  32,  1,  0,  0,  1,  4,  0,  0, 36,  1,  0,  0,  1,  4,  0,  0,
/* 0x1560 */  52,  1,  0,  0,  1,  4,  0,  0, 56,  1,  0,  0,  1,  4,  0,  0,
/* 0x1570 */  60,  1,  0,  0,  1,  4,  0,  0, 72,  1,  0,  0,  1,  4,  0,  0,
/* 0x1580 */  88,  1,  0,  0,  1,  4,  0,  0, 92,  1,  0,  0,  1,  4,  0,  0,
/* 0x1590 */ 100,  1,  0,  0,  1,  4,  0,  0,108,  1,  0,  0,  1,  4,  0,  0,
/* 0x15a0 */ 112,  1,  0,  0,  1,  4,  0,  0,140,  1,  0,  0,  1,  4,  0,  0,
/* 0x15b0 */ 144,  1,  0,  0,  1,  4,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x15c0 */ 109, 97,116, 32,101,108,102, 51, 50, 45,108,105,116,116,108,101,
/* 0x15d0 */  97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x15e0 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x15f0 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x1600 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x1610 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x1620 */ 108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1630 */  90, 32, 32, 32, 32, 32, 32, 48, 50, 55, 52, 32, 32, 48, 32, 32,
/* 0x1640 */  48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79,
/* 0x1650 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 72, 85, 77, 70, 95,
/* 0x1660 */  65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32,
/* 0x1670 */  48, 32, 32, 48, 50, 97, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1680 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 72, 85, 77, 70,
/* 0x1690 */  95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32,
/* 0x16a0 */  32, 48, 32, 32, 48, 50, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x16b0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 85, 77, 70,
/* 0x16c0 */  95, 65, 78, 68, 82, 79, 73, 68, 32, 32, 32, 48, 53, 52, 99, 32,
/* 0x16d0 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 98, 48, 32, 32, 50, 42, 42,
/* 0x16e0 */  50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x16f0 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48, 49,
/* 0x1700 */  52, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55,102, 99, 32, 32,
/* 0x1710 */  50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1720 */  32, 53, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32,
/* 0x1730 */  32, 48, 49, 99, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 51,
/* 0x1740 */  99, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1750 */  83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10,
/* 0x1760 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1770 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70, 77,
/* 0x1780 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1790 */  32, 32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x17a0 */  68, 32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x17b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x17c0 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 32, 85, 77, 70,
/* 0x17d0 */  95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x17e0 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x17f0 */  32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x1800 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77,
/* 0x1810 */  70, 95, 65, 32, 48, 32, 72, 85, 77, 70, 95, 65, 10, 48, 48, 48,
/* 0x1820 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85,
/* 0x1830 */  77, 70, 95, 76, 32, 48, 32, 72, 85, 77, 70, 95, 76, 10, 48, 48,
/* 0x1840 */  48, 48, 48, 49, 98, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1850 */  76, 70, 77, 65, 73, 78, 88, 32, 48, 32,103,101,116, 95,112, 97,
/* 0x1860 */ 103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48,101, 52,
/* 0x1870 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1880 */  90, 32, 48, 32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48,
/* 0x1890 */  49, 99, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x18a0 */  65, 73, 78, 88, 32, 48, 32,117,112,120, 95,109,109, 97,112, 95,
/* 0x18b0 */  97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x18c0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x18d0 */  32, 48, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48,
/* 0x18e0 */  52, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x18f0 */  73, 78, 90, 32, 48, 32,109,101,109,112, 99,112,121, 10, 48, 48,
/* 0x1900 */  48, 48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1910 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,116,114,117,110, 99,
/* 0x1920 */  97,116,101, 10, 48, 48, 48, 48, 48, 48,102, 56, 32,103, 32, 32,
/* 0x1930 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1940 */ 108,115,101,101,107, 10, 48, 48, 48, 48, 48, 50, 99, 99, 32,103,
/* 0x1950 */  32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x1960 */  73, 68, 32, 48, 50, 56, 48, 32,117,112,120, 95,109,109, 97,112,
/* 0x1970 */  95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100, 10,
/* 0x1980 */  48, 48, 48, 48, 48, 49, 98, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1990 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,109, 97,112,
/* 0x19a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x19b0 */  70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 49, 52, 48,
/* 0x19c0 */  32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x19d0 */  95,108,105,110,117,120, 10, 48, 48, 48, 48, 48, 49, 55, 52, 32,
/* 0x19e0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x19f0 */  32, 48, 32,117,110, 97,109,101, 10, 48, 48, 48, 48, 48, 49, 57,
/* 0x1a00 */  99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1a10 */  78, 90, 32, 48, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48,
/* 0x1a20 */  48, 97, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1a30 */  65, 73, 78, 90, 32, 48, 32,102,100, 97,116, 97,115,121,110, 99,
/* 0x1a40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1a50 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,103,101,116,
/* 0x1a60 */  95,117,112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48,
/* 0x1a70 */  48, 48, 54, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1a80 */  77, 65, 73, 78, 90, 32, 48, 32,109,101,109,102,100, 95, 99,114,
/* 0x1a90 */ 101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32,
/* 0x1aa0 */  32, 32, 32, 32, 70, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48,
/* 0x1ab0 */  32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 49, 52, 99,
/* 0x1ac0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1ad0 */  90, 32, 48, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 49, 56,
/* 0x1ae0 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1af0 */  78, 90, 32, 48, 32,117,110,108,105,110,107, 10, 48, 48, 48, 48,
/* 0x1b00 */  48, 48, 50, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1b10 */  77, 65, 73, 78, 90, 32, 48, 32,109,101,109,115,101,116, 10, 48,
/* 0x1b20 */  48, 48, 48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x1b30 */  69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 99, 52, 32,117, 99,108,
/* 0x1b40 */  95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,
/* 0x1b50 */ 115, 95, 56, 10, 48, 48, 48, 48, 48, 49, 98, 48, 32,103, 32, 32,
/* 0x1b60 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1b70 */ 109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48, 98, 99,
/* 0x1b80 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1b90 */  90, 32, 48, 32,102,115,121,110, 99, 10, 48, 48, 48, 48, 48, 49,
/* 0x1ba0 */  54, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x1bb0 */  73, 78, 90, 32, 48, 32,115,116, 97,116, 10, 48, 48, 48, 48, 48,
/* 0x1bc0 */  48, 57, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1bd0 */  65, 73, 78, 90, 32, 48, 32,101,120,105,116, 10, 48, 48, 48, 48,
/* 0x1be0 */  48, 49, 51, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1bf0 */  77, 65, 73, 78, 90, 32, 48, 32,111,112,101,110, 97,116, 10, 48,
/* 0x1c00 */  48, 48, 48, 48, 49, 50, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c10 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,111,112,101,110, 10,
/* 0x1c20 */  48, 48, 48, 48, 48, 49, 48, 99, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1c30 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,107,100,105,
/* 0x1c40 */ 114, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32,103, 32, 32, 32, 32,
/* 0x1c50 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,108,
/* 0x1c60 */ 111,115,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1c70 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70,
/* 0x1c80 */  77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1c90 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ca0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cb0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1cc0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48,
/* 0x1cd0 */  48, 48, 48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1ce0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1cf0 */  10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1d00 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1d10 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82, 95,
/* 0x1d20 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d30 */  69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 53,
/* 0x1d40 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1d50 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48,
/* 0x1d60 */  48, 48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1d70 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1d80 */  10, 48, 48, 48, 48, 48, 50, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x1d90 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110,
/* 0x1da0 */  97,116, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82,
/* 0x1db0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1dc0 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 51, 48, 32,
/* 0x1dd0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1de0 */  32, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32,
/* 0x1df0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1e00 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x1e10 */  50, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1e20 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x1e30 */  48, 48, 48, 48, 50, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1e40 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1e50 */  78, 90, 10, 48, 48, 48, 48, 48, 50, 53, 52, 32, 82, 95, 65, 82,
/* 0x1e60 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1e70 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 54, 52, 32,
/* 0x1e80 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1e90 */  32, 32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 50, 55, 48,
/* 0x1ea0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1eb0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 10, 82, 69, 76,
/* 0x1ec0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x1ed0 */  70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 65, 93, 58, 10, 79, 70,
/* 0x1ee0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1ef0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x1f00 */  48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1f10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109,
/* 0x1f20 */  97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,
/* 0x1f30 */ 100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x1f40 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95,
/* 0x1f50 */  76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x1f60 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x1f70 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95,
/* 0x1f80 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f90 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,
/* 0x1fa0 */ 108,105,110,117,120, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1fb0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85,
/* 0x1fc0 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 93, 58, 10, 79, 70, 70,
/* 0x1fd0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1ff0 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2000 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2010 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82, 95,
/* 0x2020 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2030 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2040 */  48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2050 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2060 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 53, 52, 32, 82, 95, 65, 82,
/* 0x2070 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2080 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2090 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x20a0 */  32, 32, 32, 32, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48,
/* 0x20b0 */  48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x20c0 */  32, 32, 32, 32, 32, 32, 32,115,116, 97,116, 10, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x20e0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x20f0 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82,
/* 0x2100 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2110 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2120 */  98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2130 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2140 */  10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2150 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,107,100,105,
/* 0x2160 */ 114, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77,
/* 0x2170 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2180 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,100,
/* 0x2190 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x21a0 */  32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48,
/* 0x21b0 */  48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x21c0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x21d0 */  73, 68, 10, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65, 82,
/* 0x21e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x21f0 */ 109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49, 50, 52, 32, 82,
/* 0x2200 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2210 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2220 */  48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2230 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2240 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 53, 48, 32, 82, 95, 65,
/* 0x2250 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,
/* 0x2260 */ 112,101,110, 10, 48, 48, 48, 48, 48, 49, 54, 48, 32, 82, 95, 65,
/* 0x2270 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,114,
/* 0x2280 */ 101, 97,100, 10, 48, 48, 48, 48, 48, 49, 54, 99, 32, 82, 95, 65,
/* 0x2290 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x22a0 */ 108,111,115,101, 10, 48, 48, 48, 48, 48, 49, 55, 52, 32, 82, 95,
/* 0x22b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x22c0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x22d0 */  48, 49, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x22e0 */  32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48,
/* 0x22f0 */  48, 48, 48, 48, 49, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2300 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2310 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97, 52, 32, 82,
/* 0x2320 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2330 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2340 */  48, 48, 49, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2350 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2360 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 98, 52, 32, 82, 95, 65,
/* 0x2370 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2380 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2390 */  49, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x23a0 */  32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48,
/* 0x23b0 */  48, 48, 48, 49,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x23c0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x23d0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 56, 32, 82, 95,
/* 0x23e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x23f0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2400 */  48, 49,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2420 */  73, 68, 10, 48, 48, 48, 48, 48, 50, 49, 48, 32, 82, 95, 65, 82,
/* 0x2430 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x2440 */ 109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 49, 99, 32, 82,
/* 0x2450 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2460 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 51,
/* 0x2470 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2480 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2490 */  48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x24a0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x24b0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 51, 99, 32,
/* 0x24c0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x24d0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x24e0 */  48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x24f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2500 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95,
/* 0x2510 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2520 */ 109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 55, 48,
/* 0x2530 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2540 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2550 */  48, 48, 48, 48, 50, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2560 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2570 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 56, 99, 32, 82,
/* 0x2580 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2590 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 57,
/* 0x25a0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x25b0 */  32, 32, 32, 32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48,
/* 0x25c0 */  50, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x25d0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x25e0 */  68, 10, 48, 48, 48, 48, 48, 50, 97, 56, 32, 82, 95, 65, 82, 77,
/* 0x25f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2600 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 98,
/* 0x2610 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2620 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2630 */  48, 48, 48, 48, 48, 50,101, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2640 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2650 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,102, 56, 32,
/* 0x2660 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2670 */  32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x2680 */  48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2690 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x26a0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 49, 48, 32, 82,
/* 0x26b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x26c0 */  32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48, 48,
/* 0x26d0 */  48, 48, 48, 51, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x26e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x26f0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 50, 48, 32, 82, 95,
/* 0x2700 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2710 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2720 */  48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2730 */  32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48,
/* 0x2740 */  48, 51, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2750 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2760 */  73, 68, 10, 48, 48, 48, 48, 48, 51, 52, 56, 32, 82, 95, 65, 82,
/* 0x2770 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2780 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x2790 */  54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x27a0 */  32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48,
/* 0x27b0 */  48, 48, 51, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x27c0 */  32, 32, 32, 32, 32, 32, 32, 32,117,110, 97,109,101, 10, 48, 48,
/* 0x27d0 */  48, 48, 48, 51, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x27e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x27f0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 52, 32, 82, 95,
/* 0x2800 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2810 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2820 */  48, 51, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2830 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2840 */  73, 68, 10, 48, 48, 48, 48, 48, 51, 57, 48, 32, 82, 95, 65, 82,
/* 0x2850 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2860 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x2870 */  97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2880 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2890 */  10, 48, 48, 48, 48, 48, 51, 97, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x28a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x28b0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 98, 99,
/* 0x28c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x28d0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x28e0 */  48, 48, 48, 48, 51, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x28f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2900 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 99, 56, 32, 82,
/* 0x2910 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2920 */  32,103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104, 10,
/* 0x2930 */  48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2940 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2950 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,102, 48, 32,
/* 0x2960 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2970 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2980 */  48, 48, 48, 51,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2990 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x29a0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 48, 99, 32, 82, 95,
/* 0x29b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x29c0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x29d0 */  48, 52, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x29e0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x29f0 */  73, 68, 10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82,
/* 0x2a00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,
/* 0x2a10 */ 101,110, 10, 48, 48, 48, 48, 48, 52, 51, 48, 32, 82, 95, 65, 82,
/* 0x2a20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2a30 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x2a40 */  51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2a50 */  32, 32, 32, 32, 32,117,110,108,105,110,107, 10, 48, 48, 48, 48,
/* 0x2a60 */  48, 52, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2a70 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2a80 */  73, 68, 10, 48, 48, 48, 48, 48, 52, 52, 99, 32, 82, 95, 65, 82,
/* 0x2a90 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2aa0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x2ab0 */  53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ac0 */  32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x2ad0 */ 115,107, 10, 48, 48, 48, 48, 48, 52, 54, 56, 32, 82, 95, 65, 82,
/* 0x2ae0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2af0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x2b00 */  55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2b10 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2b20 */  10, 48, 48, 48, 48, 48, 52, 55, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2b30 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,102,116,114,117,
/* 0x2b40 */ 110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 52, 56, 52, 32, 82,
/* 0x2b50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b60 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2b70 */  48, 48, 52, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2b80 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2b90 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 57, 56, 32, 82, 95, 65,
/* 0x2ba0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x2bb0 */ 115,101,101,107, 10, 48, 48, 48, 48, 48, 52, 98, 99, 32, 82, 95,
/* 0x2bc0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2bd0 */ 119,114,105,116,101, 10, 48, 48, 48, 48, 48, 52, 99, 99, 32, 82,
/* 0x2be0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2bf0 */  32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 52,100, 56, 32,
/* 0x2c00 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2c10 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2c20 */  48, 48, 48, 52,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2c30 */  52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,
/* 0x2c40 */ 101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 52,101, 56, 32,
/* 0x2c50 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2c60 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2c70 */  48, 48, 48, 52,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2c80 */  52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101, 10, 48,
/* 0x2c90 */  48, 48, 48, 48, 52,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2ca0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2cb0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 49, 99, 32, 82,
/* 0x2cc0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2cd0 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 53, 50, 99, 32, 82,
/* 0x2ce0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2cf0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2d00 */  48, 48, 53, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2d10 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2d20 */  79, 73, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x2d30 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70,
/* 0x2d40 */  95, 76, 73, 78, 85, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x2d50 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2d60 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2d70 */  49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2d80 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48,
/* 0x2d90 */  48, 48, 48, 48, 48, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2da0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,100, 95,
/* 0x2db0 */  99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32,
/* 0x2dc0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2dd0 */  32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48,
/* 0x2de0 */  48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2df0 */  32, 32, 32, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101,
/* 0x2e00 */  97,116,101, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65,
/* 0x2e10 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2e20 */  77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x2e30 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2e40 */  32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48,
/* 0x2e50 */  48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2e60 */  52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48,
/* 0x2e70 */  48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2e80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78,
/* 0x2e90 */  85, 88, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 65, 82,
/* 0x2ea0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2eb0 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 56, 48,
/* 0x2ec0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2ed0 */  32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48,
/* 0x2ee0 */  48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2ef0 */  32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101, 10, 48, 48,
/* 0x2f00 */  48, 48, 48, 48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2f10 */  52, 32, 32, 32, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48,
/* 0x2f20 */  48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2f30 */  52, 32, 32, 32, 32, 32, 32, 32, 32,102,116,114,117,110, 99, 97,
/* 0x2f40 */ 116,101, 10, 48, 48, 48, 48, 48, 48,102, 48, 32, 82, 95, 65, 82,
/* 0x2f50 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2f60 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 49, 49, 56,
/* 0x2f70 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2f80 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 49, 50, 48,
/* 0x2f90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fa0 */  32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,
/* 0x2fb0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x2fc0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73,
/* 0x2fd0 */  78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x2fe0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ff0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,
/* 0x3000 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3010 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x3020 */  50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3030 */  32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x3040 */ 100, 95,102,100, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95,
/* 0x3050 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3060 */  69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 53,
/* 0x3070 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3080 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48,
/* 0x3090 */  48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x30a0 */  32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101, 10, 48, 48,
/* 0x30b0 */  48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x30c0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x30d0 */  88, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77,
/* 0x30e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x30f0 */  77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82,
/* 0x3100 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3110 */  32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 48,101, 48, 32,
/* 0x3120 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3130 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x3140 */  49, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3150 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x3160 */  48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3170 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x3180 */  78, 88, 10, 48, 48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82,
/* 0x3190 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x31a0 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 51, 52, 32,
/* 0x31b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x31c0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x31d0 */  49, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x31e0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x31f0 */  48, 48, 48, 48, 49, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3200 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x3210 */  78, 88, 10, 48, 48, 48, 48, 48, 49, 52, 56, 32, 82, 95, 65, 82,
/* 0x3220 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x3230 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 53, 56, 32,
/* 0x3240 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3250 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x3260 */  49, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3270 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x3280 */  48, 48, 48, 48, 49, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3290 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x32a0 */  78, 88, 10, 48, 48, 48, 48, 48, 49, 54, 99, 32, 82, 95, 65, 82,
/* 0x32b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x32c0 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 55, 48, 32,
/* 0x32d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x32e0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x32f0 */  49, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3300 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x3310 */  48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3320 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x3330 */  78, 88, 10
};
