/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

// LimitedPriorityLevelConfigurationApplyConfiguration represents a declarative configuration of the LimitedPriorityLevelConfiguration type for use
// with apply.
//
// LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits.
// It addresses two issues:
// - How are requests for this priority level limited?
// - What should be done with requests that exceed the limit?
type LimitedPriorityLevelConfigurationApplyConfiguration struct {
	// `assuredConcurrencyShares` (ACS) configures the execution
	// limit, which is a limit on the number of requests of this
	// priority level that may be executing at a given time.  ACS must
	// be a positive number. The server's concurrency limit (SCL) is
	// divided among the concurrency-controlled priority levels in
	// proportion to their assured concurrency shares. This produces
	// the assured concurrency value (ACV) --- the number of requests
	// that may be executing at a time --- for each such priority
	// level:
	//
	// ACV(l) = ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )
	//
	// bigger numbers of ACS mean more reserved concurrent requests (at the
	// expense of every other PL).
	// This field has a default value of 30.
	AssuredConcurrencyShares *int32 `json:"assuredConcurrencyShares,omitempty"`
	// `limitResponse` indicates what to do with requests that can not be executed right now
	LimitResponse *LimitResponseApplyConfiguration `json:"limitResponse,omitempty"`
	// `lendablePercent` prescribes the fraction of the level's NominalCL that
	// can be borrowed by other priority levels. The value of this
	// field must be between 0 and 100, inclusive, and it defaults to 0.
	// The number of seats that other levels can borrow from this level, known
	// as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
	//
	// LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
	LendablePercent *int32 `json:"lendablePercent,omitempty"`
	// `borrowingLimitPercent`, if present, configures a limit on how many
	// seats this priority level can borrow from other priority levels.
	// The limit is known as this level's BorrowingConcurrencyLimit
	// (BorrowingCL) and is a limit on the total number of seats that this
	// level may borrow at any one time.
	// This field holds the ratio of that limit to the level's nominal
	// concurrency limit. When this field is non-nil, it must hold a
	// non-negative integer and the limit is calculated as follows.
	//
	// BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )
	//
	// The value of this field can be more than 100, implying that this
	// priority level can borrow a number of seats that is greater than
	// its own nominal concurrency limit (NominalCL).
	// When this field is left `nil`, the limit is effectively infinite.
	BorrowingLimitPercent *int32 `json:"borrowingLimitPercent,omitempty"`
}

// LimitedPriorityLevelConfigurationApplyConfiguration constructs a declarative configuration of the LimitedPriorityLevelConfiguration type for use with
// apply.
func LimitedPriorityLevelConfiguration() *LimitedPriorityLevelConfigurationApplyConfiguration {
	return &LimitedPriorityLevelConfigurationApplyConfiguration{}
}

// WithAssuredConcurrencyShares sets the AssuredConcurrencyShares field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AssuredConcurrencyShares field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithAssuredConcurrencyShares(value int32) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.AssuredConcurrencyShares = &value
	return b
}

// WithLimitResponse sets the LimitResponse field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LimitResponse field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithLimitResponse(value *LimitResponseApplyConfiguration) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.LimitResponse = value
	return b
}

// WithLendablePercent sets the LendablePercent field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LendablePercent field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithLendablePercent(value int32) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.LendablePercent = &value
	return b
}

// WithBorrowingLimitPercent sets the BorrowingLimitPercent field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BorrowingLimitPercent field is set to the value of the last call.
func (b *LimitedPriorityLevelConfigurationApplyConfiguration) WithBorrowingLimitPercent(value int32) *LimitedPriorityLevelConfigurationApplyConfiguration {
	b.BorrowingLimitPercent = &value
	return b
}
