/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.57 from the
 * contents of JSON-XS.xxs. Do not edit this file, edit JSON-XS.xxs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
/*
   This is a modified copy of XS.xs taken from the CPAN module JSON::XS by Marc A. Lehmann
     as per most recent stable version 3.04 released at Aug 17, 2017.

   See https://metacpan.org/release/MLEHMANN/JSON-XS-3.04

   Following modifications have been applied:

   - Handling boolean values aligned with polymake's way of dealing with booleans,
     in particular booleans are decoded as natural values PL_sv_yes and PL_sv_no,
     and all values satisfying polymake's is_boolean() are encoded as JSON booleans.
     Artificial boolean reference values are still supported.
   - Perl interpreter context explicitly passed into internal functions.
   - Special handling of serialized sparse containers.
   - Function for directly encoding into an IO stream.
   - Saving an restoring comment blocks within objects.
   - Cosmetic changes fixing C++ warnings treated as errors.
*/

#include "polymake/perl/glue.h"

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <float.h>
#include <inttypes.h>

#if defined(__clang__)
#pragma clang diagnostic ignored "-Wdangling-else"
#pragma clang diagnostic ignored "-Wunused-result"
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wunused-label"
#pragma clang diagnostic ignored "-Wshadow"
#pragma clang diagnostic ignored "-Wconversion"
#elif defined(__GNUC__)
#pragma GCC diagnostic ignored "-Wunused-result"
#pragma GCC diagnostic ignored "-Wunused-variable"
#pragma GCC diagnostic ignored "-Wunused-label"
#pragma GCC diagnostic ignored "-Wshadow"
#pragma GCC diagnostic ignored "-Wconversion"
#endif

#if defined(__BORLANDC__) || defined(_MSC_VER)
# define snprintf _snprintf // C compilers have this in stdio.h
#endif

// some old perls do not have this, try to make it work, no
// guarantees, though. if it breaks, you get to keep the pieces.
#ifndef UTF8_MAXBYTES
# define UTF8_MAXBYTES 13
#endif

// compatibility with perl <5.18
#ifndef HvNAMELEN_get
# define HvNAMELEN_get(hv) strlen (HvNAME (hv))
#endif
#ifndef HvNAMELEN
# define HvNAMELEN(hv) HvNAMELEN_get (hv)
#endif
#ifndef HvNAMEUTF8
# define HvNAMEUTF8(hv) 0
#endif

// three extra for rounding, sign, and end of string
#define IVUV_MAXCHARS (sizeof (UV) * CHAR_BIT * 28 / 93 + 3)

#define F_ASCII          0x00000001UL
#define F_LATIN1         0x00000002UL
#define F_UTF8           0x00000004UL
#define F_INDENT         0x00000008UL
#define F_CANONICAL      0x00000010UL
#define F_SPACE_BEFORE   0x00000020UL
#define F_SPACE_AFTER    0x00000040UL
#define F_ALLOW_NONREF   0x00000100UL
#define F_SHRINK         0x00000200UL
#define F_ALLOW_BLESSED  0x00000400UL
#define F_CONV_BLESSED   0x00000800UL
#define F_RELAXED        0x00001000UL
#define F_ALLOW_UNKNOWN  0x00002000UL
#define F_ALLOW_TAGS     0x00004000UL
#define F_WITH_COMMENTS  0x00010000UL
#define F_HOOK           0x00080000UL // some hooks exist, so slow-path processing

#define F_PRETTY    F_INDENT | F_SPACE_BEFORE | F_SPACE_AFTER

#define INIT_SIZE   32 // initial scalar size to be allocated
#define FILE_BUF_SIZE 4096
#define INDENT_STEP 2  // spaces per indentation level

#define SHORT_STRING_LEN 16384 // special-case strings of up to this size

#define DECODE_WANTS_OCTETS(json) ((json)->flags & F_UTF8)

#define SB do {
#define SE } while (0)

#if __GNUC__ >= 3
# define expect(expr,value)         __builtin_expect ((expr), (value))
# define INLINE                     static inline
#else
# define expect(expr,value)         (expr)
# define INLINE                     static
#endif

#define expect_false(expr) expect ((expr) != 0, 0)
#define expect_true(expr)  expect ((expr) != 0, 1)

#define IN_RANGE_INC(type,val,beg,end) \
  ((unsigned type)((unsigned type)(val) - (unsigned type)(beg)) \
  <= (unsigned type)((unsigned type)(end) - (unsigned type)(beg)))

#define ERR_NESTING_EXCEEDED "json text or perl structure exceeds maximum nesting level (max_depth set too low?)"

#if false && defined(USE_ITHREADS)
# define JSON_SLOW 1
# define JSON_STASH (json_stash ? json_stash : gv_stashpv ("JSON::XS", 1))
# define BOOL_STASH (bool_stash ? bool_stash : gv_stashpv ("Types::Serialiser::Boolean", 1))
#else
# define JSON_SLOW 0
# define JSON_STASH json_stash
# define BOOL_STASH bool_stash
#endif

// the amount of HEs to allocate on the stack, when sorting keys
#define STACK_HES 64

static HV *json_stash, *bool_stash; // JSON::XS::, boolean::
static SV *bool_true, *bool_false, *sv_json;

enum {
  INCR_M_WS = 0, // initial whitespace skipping, must be 0
  INCR_M_STR,    // inside string
  INCR_M_BS,     // inside backslash
  INCR_M_C0,     // inside comment in initial whitespace sequence
  INCR_M_C1,     // inside comment in other places
  INCR_M_JSON    // outside anything, count nesting
};

#define INCR_DONE(json) ((json)->incr_nest <= 0 && (json)->incr_mode == INCR_M_JSON)

typedef struct {
  U32 flags;
  I32 max_depth;
  STRLEN max_size;

  SV *cb_object;
  HV *cb_sk_object;

  // for the incremental parser
  SV *incr_text;   // the source text so far
  STRLEN incr_pos; // the current offset into the text
  int incr_nest;   // {[]}-nesting level
  unsigned char incr_mode;
} JSON;

INLINE void
json_init (JSON *json)
{
  Zero (json, 1, JSON);
  json->max_depth = 512;
}

/////////////////////////////////////////////////////////////////////////////
// utility functions
#if JSON_SLOW
INLINE SV *
get_bool (const char *name)
{
  SV *sv = get_sv (name, 1);

  SvREADONLY_on (sv);
  SvREADONLY_on (SvRV (sv));

  return sv;
}
#endif

INLINE void
shrink (pTHX_ SV *sv)
{
  sv_utf8_downgrade (sv, 1);

  if (SvLEN (sv) > SvCUR (sv) + 1)
    {
#ifdef SvPV_shrink_to_cur
      SvPV_shrink_to_cur (sv);
#elif defined (SvPV_renew)
      SvPV_renew (sv, SvCUR (sv) + 1);
#endif
    }
}

/* adds two STRLENs together, slow, and with paranoia */
STRLEN
strlen_sum (STRLEN l1, STRLEN l2)
{
  size_t sum = l1 + l2;

  if (sum < (size_t)l2 || sum != (size_t)(STRLEN)sum)
    croak ("JSON::XS: string size overflow");

  return sum;
}

/* similar to SvGROW, but somewhat safer and guarantees exponential realloc strategy */
static char *
json_sv_grow (pTHX_ SV *sv, size_t len1, size_t len2)
{
  len1 = strlen_sum (len1, len2);
  len1 = strlen_sum (len1, len1 >> 1);

  if (len1 > 4096 - 24)
    len1 = (len1 | 4095) - 24;

  return SvGROW (sv, len1);
}

// decode an utf-8 character and return it, or (UV)-1 in
// case of an error.
// we special-case "safe" characters from U+80 .. U+7FF,
// but use the very good perl function to parse anything else.
// note that we never call this function for a ascii codepoints
INLINE UV
decode_utf8 (pTHX_ unsigned char *s, STRLEN len, STRLEN *clen)
{
  if (expect_true (len >= 2
                   && IN_RANGE_INC (char, s[0], 0xc2, 0xdf)
                   && IN_RANGE_INC (char, s[1], 0x80, 0xbf)))
    {
      *clen = 2;
      return ((s[0] & 0x1f) << 6) | (s[1] & 0x3f);
    }
  else
    return utf8n_to_uvchr (s, len, clen, UTF8_CHECK_ONLY);
}

// likewise for encoding, also never called for ascii codepoints
// this function takes advantage of this fact, although current gccs
// seem to optimise the check for >= 0x80 away anyways
INLINE unsigned char *
encode_utf8 (unsigned char *s, UV ch)
{
  if      (expect_false (ch < 0x000080))
    *s++ = ch;
  else if (expect_true  (ch < 0x000800))
    *s++ = 0xc0 | ( ch >>  6),
    *s++ = 0x80 | ( ch        & 0x3f);
  else if (              ch < 0x010000)
    *s++ = 0xe0 | ( ch >> 12),
    *s++ = 0x80 | ((ch >>  6) & 0x3f),
    *s++ = 0x80 | ( ch        & 0x3f);
  else if (              ch < 0x110000)
    *s++ = 0xf0 | ( ch >> 18),
    *s++ = 0x80 | ((ch >> 12) & 0x3f),
    *s++ = 0x80 | ((ch >>  6) & 0x3f),
    *s++ = 0x80 | ( ch        & 0x3f);

  return s;
}

// convert offset pointer to character index, sv must be string
static STRLEN
ptr_to_index (pTHX_ SV *sv, char *offset)
{
  return SvUTF8 (sv)
    ? utf8_distance ((const U8*)offset, (const U8*)SvPVX (sv))
         : offset - SvPVX (sv);
}

/////////////////////////////////////////////////////////////////////////////
// fp hell

// scan a group of digits, and a trailing exponent
static void
json_atof_scan1 (const char *s, NV *accum, int *expo, int postdp, int maxdepth)
{
  UV  uaccum = 0;
  int eaccum = 0;

  // if we recurse too deep, skip all remaining digits
  // to avoid a stack overflow attack
  if (expect_false (--maxdepth <= 0))
    while (((U8)*s - '0') < 10)
      ++s;

  for (;;)
    {
      U8 dig = (U8)*s - '0';

      if (expect_false (dig >= 10))
        {
          if (dig == (U8)((U8)'.' - (U8)'0'))
            {
              ++s;
              json_atof_scan1 (s, accum, expo, 1, maxdepth);
            }
          else if ((dig | ' ') == 'e' - '0')
            {
              int exp2 = 0;
              int neg  = 0;

              ++s;

              if (*s == '-')
                {
                  ++s;
                  neg = 1;
                }
              else if (*s == '+')
                ++s;

              while ((dig = (U8)*s - '0') < 10)
                exp2 = exp2 * 10 + *s++ - '0';

              *expo += neg ? -exp2 : exp2;
            }

          break;
        }

      ++s;

      uaccum = uaccum * 10 + dig;
      ++eaccum;

      // if we have too many digits, then recurse for more
      // we actually do this for rather few digits
      if (uaccum >= (UV_MAX - 9) / 10)
        {
          if (postdp) *expo -= eaccum;
          json_atof_scan1 (s, accum, expo, postdp, maxdepth);
          if (postdp) *expo += eaccum;

          break;
        }
    }

  // this relies greatly on the quality of the pow ()
  // implementation of the platform, but a good
  // implementation is hard to beat.
  // (IEEE 754 conformant ones are required to be exact)
  if (postdp) *expo -= eaccum;
  *accum += uaccum * Perl_pow (10., *expo);
  *expo += eaccum;
}

static NV
json_atof (const char *s)
{
  NV accum = 0.;
  int expo = 0;
  int neg  = 0;

  if (*s == '-')
    {
      ++s;
      neg = 1;
    }

  // a recursion depth of ten gives us >>500 bits
  json_atof_scan1 (s, &accum, &expo, 0, 10);

  return neg ? -accum : accum;
}

// target of scalar reference is bool?  -1 == nope, 0 == false, 1 == true
static int
ref_bool_type (pTHX_ SV *sv)
{
  svtype svt = SvTYPE (sv);

  if (svt < SVt_PVAV)
    {
      STRLEN len = 0;
      char *pv = svt ? SvPV (sv, len) : 0;

      if (len == 1)
        if (*pv == '1')
          return 1;
        else if (*pv == '0')
          return 0;
    }

  return -1;
}

// returns whether scalar is not a reference in the sense of allow_nonref
static int
json_nonref (pTHX_ SV *scalar)
{
  if (!SvROK (scalar))
    return 1;

  scalar = SvRV (scalar);

  if (SvTYPE (scalar) >= SVt_PVMG)
    {
      if (SvSTASH (scalar) == bool_stash)
        return 1;

      if (!SvOBJECT (scalar) && ref_bool_type (aTHX_ scalar) >= 0)
        return 1;
    }

  return 0;
}

/////////////////////////////////////////////////////////////////////////////
// encoder

// structure used for encoding JSON
typedef struct
{
  char *cur;  // SvPVX (sv) + current output position
  char *end;  // end of string buffer in sv
  SV *sv;     // result scalar
  PerlIO* fp; // direct output stream
  JSON json;
  I32 indent; // indentation level
  UV limit;   // escape character values >= this value when encoding
} enc_t;

static const MGVTBL attached_comments_vtbl = { 0, 0, 0, 0, 0 };
static const MGVTBL format_flags_vtbl = { 0, 0, 0, 0, 0 };

INLINE U32
get_format_flags(pTHX_ enc_t *enc, SV *sv)
{
  U32 flags = enc->json.flags;
  if (flags & (F_INDENT | F_SPACE_AFTER | F_CANONICAL)) {
    if (MAGIC* mg = mg_findext(sv, PERL_MAGIC_ext, &format_flags_vtbl))
      flags &= mg->mg_len;
  }
  return flags;
}

INLINE PerlIO*
check_outfile(pTHX_ SV* file_ref)
{
   IO* io;
   PerlIO* ofp;
   if (SvROK(file_ref)) file_ref = SvRV(file_ref);
   if (SvTYPE(file_ref) != SVt_PVGV || !(io = GvIO(file_ref)))
      croak( "write_json - not a valid stream" );
   if (!(ofp = IoOFP(io)))
      croak( "write_json - stream not opened for writing" );
   if (PerlIO_isutf8(ofp))
      croak( "write_json - stream has utf8 layer, must be raw" );
   return ofp;
}

INLINE void
need (enc_t *enc, STRLEN len)
{
  if (expect_false ((uintptr_t)(enc->end - enc->cur) < len))
    {
      dTHX;
      char* beg = (char *)SvPVX(enc->sv);
      STRLEN cur = enc->cur - beg;
      if (enc->fp) {
         PerlIO_write(enc->fp, beg, cur);
         if (len < SvLEN(enc->sv)) {
            enc->cur = beg;
            return;
         }
         cur = 0;
      }
      char *buf = json_sv_grow (aTHX_ enc->sv, cur, len);
      enc->cur = buf + cur;
      enc->end = buf + SvLEN (enc->sv) - !(enc->fp);  // reserve for trailing 0 if this is going to become the result value
    }
}

INLINE void
encode_ch (enc_t *enc, char ch)
{
  need (enc, 1);
  *enc->cur++ = ch;
}

static void
encode_str (enc_t *enc, const char *str, STRLEN len, int is_utf8)
{
  dTHX;
  const char *end = str + len;

  need (enc, len);

  while (str < end)
    {
      unsigned char ch = *(unsigned char *)str;

      if (expect_true (ch >= 0x20 && ch < 0x80)) // most common case
        {
          if (expect_false (ch == '"')) // but with slow exceptions
            {
              need (enc, len + 1);
              *enc->cur++ = '\\';
              *enc->cur++ = '"';
            }
          else if (expect_false (ch == '\\'))
            {
              need (enc, len + 1);
              *enc->cur++ = '\\';
              *enc->cur++ = '\\';
            }
          else
            *enc->cur++ = ch;

          ++str;
        }
      else
        {
          switch (ch)
            {
              case '\010': need (enc, len + 1); *enc->cur++ = '\\'; *enc->cur++ = 'b'; ++str; break;
              case '\011': need (enc, len + 1); *enc->cur++ = '\\'; *enc->cur++ = 't'; ++str; break;
              case '\012': need (enc, len + 1); *enc->cur++ = '\\'; *enc->cur++ = 'n'; ++str; break;
              case '\014': need (enc, len + 1); *enc->cur++ = '\\'; *enc->cur++ = 'f'; ++str; break;
              case '\015': need (enc, len + 1); *enc->cur++ = '\\'; *enc->cur++ = 'r'; ++str; break;

              default:
                {
                  STRLEN clen;
                  UV uch;

                  if (is_utf8)
                    {
                      uch = decode_utf8 (aTHX_ (U8*)str, end - str, &clen);
                      if (clen == (STRLEN)-1)
                        croak ("malformed or illegal unicode character in string [%.11s], cannot convert to JSON", str);
                    }
                  else
                    {
                      uch = ch;
                      clen = 1;
                    }

                  if (uch < 0x80/*0x20*/ || uch >= enc->limit)
                    {
                      if (uch >= 0x10000UL)
                        {
                          if (uch >= 0x110000UL)
                            croak ("out of range codepoint (0x%lx) encountered, unrepresentable in JSON", (unsigned long)uch);

                          need (enc, len + 11);
                          snprintf (enc->cur, 13, "\\u%04x\\u%04x",
                                    (int)((uch - 0x10000) / 0x400 + 0xD800),
                                    (int)((uch - 0x10000) % 0x400 + 0xDC00));
                          enc->cur += 12;
                        }
                      else
                        {
                          need (enc, len + 5);
                          *enc->cur++ = '\\';
                          *enc->cur++ = 'u';
                          *enc->cur++ = PL_hexdigit [ uch >> 12      ];
                          *enc->cur++ = PL_hexdigit [(uch >>  8) & 15];
                          *enc->cur++ = PL_hexdigit [(uch >>  4) & 15];
                          *enc->cur++ = PL_hexdigit [(uch >>  0) & 15];
                        }

                      str += clen;
                    }
                  else if (enc->json.flags & F_LATIN1)
                    {
                      *enc->cur++ = uch;
                      str += clen;
                    }
                  else if (is_utf8)
                    {
                      need (enc, len + clen);
                      do
                        {
                          *enc->cur++ = *str++;
                        }
                      while (--clen);
                    }
                  else
                    {
                      need (enc, len + UTF8_MAXBYTES - 1); // never more than 11 bytes needed
                      enc->cur = (char*)encode_utf8 ((U8*)enc->cur, uch);
                      ++str;
                    }
                }
            }
        }

      --len;
    }
}

INLINE void
encode_indent (enc_t *enc, const U32 format_flags)
{
  if (format_flags & F_INDENT)
    {
      int spaces = enc->indent * INDENT_STEP;

      need (enc, spaces);
      memset (enc->cur, ' ', spaces);
      enc->cur += spaces;
    }
}

INLINE void
encode_space (enc_t *enc)
{
  need (enc, 1);
  encode_ch (enc, ' ');
}

INLINE void
encode_nl (enc_t *enc, const U32 format_flags)
{
  if (format_flags & F_INDENT)
    {
      need (enc, 1);
      encode_ch (enc, '\n');
    }
}

INLINE void
encode_comma (enc_t *enc, const U32 format_flags)
{
  encode_ch (enc, ',');

  if (format_flags & F_INDENT) {
    need (enc, 1);
    encode_ch (enc, '\n');
  } else if (format_flags & F_SPACE_AFTER) {
    encode_space (enc);
  }
}

static void encode_sv (enc_t *enc, SV *sv);

INLINE void
encode_av_element(pTHX_ enc_t *enc, AV *av, const SSize_t i, const U32 format_flags)
{
  SV **svp = av_fetch (av, i, 0);

  encode_indent(enc, format_flags);

  if (svp)
    encode_sv (enc, *svp);
  else
    encode_str (enc, "null", 4, 0);
}

static void
encode_av (enc_t *enc, AV *av)
{
  dTHX;
  SSize_t i = 0, len = av_len (av);

  if (enc->indent >= enc->json.max_depth)
    croak (ERR_NESTING_EXCEEDED);

  encode_ch (enc, '[');

  if (len >= 0)
    {
      const U32 format_flags = get_format_flags(aTHX_ enc, (SV*)av);

      encode_nl(enc, format_flags);
      ++enc->indent;
      encode_av_element(aTHX_ enc, av, i, format_flags);
      while (++i <= len) {
        encode_comma(enc, format_flags);
        encode_av_element(aTHX_ enc, av, i, format_flags);
      }

      encode_nl(enc, format_flags);
      --enc->indent;
      encode_indent(enc, format_flags);
    }

  encode_ch (enc, ']');
}

INLINE void
encode_colon (enc_t* enc, const U32 format_flags)
{
  if (format_flags & F_SPACE_BEFORE) encode_space (enc);
  encode_ch (enc, ':');
  if (format_flags & F_SPACE_AFTER ) encode_space (enc);
}

static void
encode_hv_element (pTHX_ enc_t *enc, HV* hv, HE *he, const U32 format_flags, U32& between_elems)
{
  SV* val_sv = expect_false(SvMAGICAL (hv)) ? hv_iterval (hv, he) : HeVAL(he);

  if (format_flags & F_WITH_COMMENTS) {
    bool emitted_comments = false;

    if (SvTYPE(val_sv) >= SVt_PVMG) {
      if (MAGIC* mg = mg_findext(val_sv, PERL_MAGIC_ext, &attached_comments_vtbl)) {
        SV* comments_sv = mg->mg_obj;
        AV* comments_av;
        if (comments_sv && SvROK(comments_sv) && SvTYPE(SvRV(comments_sv)) == SVt_PVAV &&
            (comments_av = (AV*)SvRV(comments_sv), AvFILLp(comments_av) >= 0)) {

          if (enc->indent == 1) {
            // separate top-level commented entries with extra empty lines
            if (between_elems)
              encode_nl(enc, F_INDENT);
            between_elems = 1;
            emitted_comments = true;
          }

          for (SV **line_svp = AvARRAY(comments_av), **line_lastp = line_svp + AvFILLp(comments_av);
               line_svp <= line_lastp;  ++line_svp) {
            encode_indent(enc, format_flags);
            SV* line_sv = *line_svp;
            STRLEN comment_len;
            const char* comment = SvPV(line_sv, comment_len);
            if (comment[comment_len - 1] == '\n') --comment_len;
            if (comment[comment_len - 1] == '\r') --comment_len;
            encode_str(enc, comment, comment_len, SvUTF8(line_sv));
            encode_nl(enc, F_INDENT);
          }
        }
      }
    }

    if (!emitted_comments) {
      if (between_elems == 1)
        encode_nl(enc, F_INDENT);
      between_elems = 2;
    }
  }

  encode_indent(enc, format_flags);
  encode_ch (enc, '"');

  if (HeKLEN (he) == HEf_SVKEY)
    {
      SV *sv = HeSVKEY (he);
      STRLEN len;
      char *str;

      SvGETMAGIC (sv);
      str = SvPV (sv, len);

      encode_str (enc, str, len, SvUTF8 (sv));
    }
  else
    encode_str (enc, HeKEY (he), HeKLEN (he), HeKUTF8 (he));

  encode_ch (enc, '"');
  encode_colon(enc, format_flags);
  encode_sv (enc, val_sv);
}

// compare hash entries, used when all keys are bytestrings
static int
he_cmp_fast (const void *a_, const void *b_)
{
  int cmp;

  HE *a = *(HE **)a_;
  HE *b = *(HE **)b_;

  STRLEN la = HeKLEN (a);
  STRLEN lb = HeKLEN (b);

  if (!(cmp = memcmp (HeKEY (b), HeKEY (a), lb < la ? lb : la)))
    cmp = lb - la;

  return cmp;
}

// compare hash entries, used when some keys are sv's or utf-x
#ifdef PERL_IMPLICIT_CONTEXT
# if defined(__APPLE__) || defined(__FreeBSD__)
static int
he_cmp_slow_r (void* pi, const void* a, const void* b)
{
  dTHX;
  return sv_cmp (HeSVKEY_force (*(HE **)b), HeSVKEY_force (*(HE **)a));
}
# else
static int
he_cmp_slow_r (const void* a, const void* b, void* pi)
{
  dTHX;
  return sv_cmp (HeSVKEY_force (*(HE **)b), HeSVKEY_force (*(HE **)a));
}
# endif
#else
static int
he_cmp_slow (const void* a, const void* b)
{
  return sv_cmp (HeSVKEY_force (*(HE **)b), HeSVKEY_force (*(HE **)a));
}
#endif

static void
encode_hv (enc_t *enc, HV *hv)
{
  dTHX;
  HE *he;

  if (enc->indent >= enc->json.max_depth)
    croak (ERR_NESTING_EXCEEDED);

  encode_ch (enc, '{');
  const U32 format_flags = get_format_flags(aTHX_ enc, (SV*)hv);
  U32 between_elems = 0;

  // for canonical output we have to sort by keys first
  // actually, this is mostly due to the stupid so-called
  // security workaround added somewhere in 5.8.x
  // that randomises hash orderings
  if ((format_flags & F_CANONICAL) && (!SvRMAGICAL(hv) || pm::perl::glue::get_monitored_magic((SV*)hv)))
    {
      SSize_t count = hv_iterinit (hv);

      if (SvMAGICAL (hv))
        {
          // need to count by iterating. could improve by dynamically building the vector below
          // but I don't care for the speed of this special case.
          // note also that we will run into undefined behaviour when the two iterations
          // do not result in the same count, something I might care for in some later release.

          count = 0;
          while (hv_iternext (hv))
            ++count;

          hv_iterinit (hv);
        }

      if (count)
        {
          SSize_t i, fast = 1;
          HE *hes_stack [STACK_HES];
          HE **hes = hes_stack;

          // allocate larger arrays on the heap
          if (count > STACK_HES)
            {
              SV *sv = sv_2mortal (NEWSV (0, count * sizeof (*hes)));
              hes = (HE **)SvPVX (sv);
            }

          i = 0;
          while ((he = hv_iternext (hv)))
            {
              hes [i++] = he;
              if (HeKLEN (he) < 0 || HeKUTF8 (he))
                fast = 0;
            }

          assert (i == count);

          if (fast)
            qsort(hes,  count, sizeof (HE *), he_cmp_fast);
          else
            {
              // hack to forcefully disable "use bytes"
              COP cop = *PL_curcop;
              cop.op_private = 0;

              ENTER;
              SAVETMPS;

              SAVEVPTR (PL_curcop);
              PL_curcop = &cop;
#ifdef PERL_IMPLICIT_CONTEXT
# if defined(__APPLE__) || defined(__FreeBSD__)
              qsort_r (hes, count, sizeof (HE *), aTHX_ he_cmp_slow_r);
# else
              qsort_r (hes, count, sizeof (HE *), he_cmp_slow_r, aTHX);
# endif
#else
              qsort (hes, count, sizeof (HE *), he_cmp_slow);
#endif
              FREETMPS;
              LEAVE;
            }

          encode_nl(enc, format_flags);
          ++enc->indent;
          encode_hv_element(aTHX_ enc, hv, hes[--count], format_flags, between_elems);
          while (count) {
            encode_comma(enc, format_flags);
            encode_hv_element(aTHX_ enc, hv, hes[--count], format_flags, between_elems);
          }

          encode_nl(enc, format_flags);
          --enc->indent;
          encode_indent(enc, format_flags);
        }
    }
  else
    {
      if (hv_iterinit (hv) || SvMAGICAL (hv))
        if ((he = hv_iternext (hv)))
          {
            encode_nl(enc, format_flags);
            ++enc->indent;
            encode_hv_element(aTHX_ enc, hv, he, format_flags, between_elems);
            while ((he = hv_iternext (hv))) {
              encode_comma(enc, format_flags);
              encode_hv_element(aTHX_ enc, hv, he, format_flags, between_elems);
            }

            encode_nl(enc, format_flags);
            --enc->indent;
            encode_indent(enc, format_flags);
          }
    }

  encode_ch (enc, '}');
}

// encode objects, arrays and special \0=false and \1=true values.
static void
encode_rv (enc_t *enc, SV *sv)
{
  dTHX;
  svtype svt;
  GV *method;

  SvGETMAGIC (sv);
  svt = SvTYPE (sv);

  if (expect_false (SvOBJECT (sv)))
    {
      HV *stash = SvSTASH (sv);

      if (stash == bool_stash)
        {
          if (SvIV (sv))
            encode_str (enc, "true", 4, 0);
          else
            encode_str (enc, "false", 5, 0);
        }
      else if ((enc->json.flags & F_ALLOW_TAGS) && (method = gv_fetchmethod_autoload (stash, "FREEZE", 0)))
        {
          SSize_t count;
          dSP;

          ENTER; SAVETMPS;
          SAVESTACK_POS ();
          PUSHMARK (SP);
          EXTEND (SP, 2);
          // we re-bless the reference to get overload and other niceties right
          PUSHs (sv_bless (sv_2mortal (newRV_inc (sv)), stash));
          PUSHs (sv_json);

          PUTBACK;
          count = call_sv ((SV *)GvCV (method), G_ARRAY);
          SPAGAIN;

          // catch this surprisingly common error
          if (SvROK (TOPs) && SvRV (TOPs) == sv)
            croak ("%s::FREEZE method returned same object as was passed instead of a new one", HvNAME (SvSTASH (sv)));

          encode_ch (enc, '(');
          encode_ch (enc, '"');
          encode_str (enc, HvNAME (stash), HvNAMELEN (stash), HvNAMEUTF8 (stash));
          encode_ch (enc, '"');
          encode_ch (enc, ')');
          encode_ch (enc, '[');

          while (count)
            {
              encode_sv (enc, SP[1 - count--]);

              if (count)
                encode_ch (enc, ',');
            }

          encode_ch (enc, ']');

          FREETMPS; LEAVE;
        }
      else if ((enc->json.flags & F_CONV_BLESSED) && (method = gv_fetchmethod_autoload (stash, "TO_JSON", 0)))
        {
          dSP;

          ENTER; SAVETMPS;
          PUSHMARK (SP);
          // we re-bless the reference to get overload and other niceties right
          XPUSHs (sv_bless (sv_2mortal (newRV_inc (sv)), stash));

          // calling with G_SCALAR ensures that we always get a 1 return value
          PUTBACK;
          call_sv ((SV *)GvCV (method), G_SCALAR);
          SPAGAIN;

          // catch this surprisingly common error
          if (SvROK (TOPs) && SvRV (TOPs) == sv)
            croak ("%s::TO_JSON method returned same object as was passed instead of a new one", HvNAME (SvSTASH (sv)));

          sv = POPs;
          PUTBACK;

          encode_sv (enc, sv);

          FREETMPS; LEAVE;
        }
      else if (enc->json.flags & F_ALLOW_BLESSED)
        encode_str (enc, "null", 4, 0);
      else
        croak ("encountered object '%s', but neither allow_blessed, convert_blessed nor allow_tags settings are enabled (or TO_JSON/FREEZE method missing)",
               SvPV_nolen (sv_2mortal (newRV_inc (sv))));
    }
  else if (svt == SVt_PVHV)
    encode_hv (enc, (HV *)sv);
  else if (svt == SVt_PVAV)
    encode_av (enc, (AV *)sv);
  else if (svt < SVt_PVAV)
    {
      int bool_type = ref_bool_type (aTHX_ sv);

      if (bool_type == 1)
        encode_str (enc, "true", 4, 0);
      else if (bool_type == 0)
        encode_str (enc, "false", 5, 0);
      else if (enc->json.flags & F_ALLOW_UNKNOWN)
        encode_str (enc, "null", 4, 0);
      else
        croak ("cannot encode reference to scalar '%s' unless the scalar is 0 or 1",
               SvPV_nolen (sv_2mortal (newRV_inc (sv))));
    }
  else if (enc->json.flags & F_ALLOW_UNKNOWN)
    encode_str (enc, "null", 4, 0);
  else
    croak ("encountered %s, but JSON can only represent references to arrays or hashes",
           SvPV_nolen (sv_2mortal (newRV_inc (sv))));
}

static void
encode_sv (enc_t *enc, SV *sv)
{
  dTHX;
  SvGETMAGIC (sv);

  if (SvIOKp (sv))
  {
    if (pm::perl::glue::is_boolean_value(aTHX_ sv))
    {
       if (SvIVX(sv)) encode_str (enc, "true" , 4, 0);
       else           encode_str (enc, "false", 5, 0);
    }
    else
    {
      // we assume we can always read an IV as a UV and vice versa
      // we assume two's complement
      // we assume no aliasing issues in the union
      if (SvIsUV (sv) ? SvUVX (sv) <= 59000
                      : SvIVX (sv) <= 59000 && SvIVX (sv) >= -59000)
        {
          // optimise the "small number case"
          // code will likely be branchless and use only a single multiplication
          // works for numbers up to 59074
          I32 i = SvIVX (sv);
          U32 u;
          char digit, nz = 0;

          need (enc, 6);

          *enc->cur = '-'; enc->cur += i < 0 ? 1 : 0;
          u = i < 0 ? -i : i;

          // convert to 4.28 fixed-point representation
          u = u * ((0xfffffff + 10000) / 10000); // 10**5, 5 fractional digits

          // now output digit by digit, each time masking out the integer part
          // and multiplying by 5 while moving the decimal point one to the right,
          // resulting in a net multiplication by 10.
          // we always write the digit to memory but conditionally increment
          // the pointer, to enable the use of conditional move instructions.
          digit = u >> 28; *enc->cur = digit + '0'; enc->cur += (nz = nz || digit); u = (u & 0xfffffffUL) * 5;
          digit = u >> 27; *enc->cur = digit + '0'; enc->cur += (nz = nz || digit); u = (u & 0x7ffffffUL) * 5;
          digit = u >> 26; *enc->cur = digit + '0'; enc->cur += (nz = nz || digit); u = (u & 0x3ffffffUL) * 5;
          digit = u >> 25; *enc->cur = digit + '0'; enc->cur += (nz = nz || digit); u = (u & 0x1ffffffUL) * 5;
          digit = u >> 24; *enc->cur = digit + '0'; enc->cur += 1; // correctly generate '0'
        }
      else
        {
          // large integer, use the (rather slow) snprintf way.
          need (enc, IVUV_MAXCHARS);
          enc->cur +=
             SvIsUV(sv)
                ? snprintf (enc->cur, IVUV_MAXCHARS, "%" UVuf, (UV)SvUVX (sv))
                : snprintf (enc->cur, IVUV_MAXCHARS, "%" IVdf, (IV)SvIVX (sv));
        }
    }
  }
  else if (SvNOKp (sv))
    {
      // trust that perl will do the right thing w.r.t. JSON syntax.
      need (enc, NV_DIG + 32);
      //Gconvert (SvNVX (sv), NV_DIG, 0, enc->cur);
      snprintf(enc->cur,32,"%.*g",NV_DIG,SvNVX (sv));
      // quote [-]inf
      int s = strlen(enc->cur);
      if (enc->cur[0] == 'i' ||
          enc->cur[0] == '-' && enc->cur[1] == 'i' ||
          enc->cur[0] == 'I' && (enc->cur[0] = 'i', true) ||
          enc->cur[0] == '-' && enc->cur[1] == 'I' && (enc->cur[1] = 'I', true)) {
        Move(enc->cur, enc->cur + 1, s, char);
        enc->cur[0] = '"';
        enc->cur[++s] = '"';
        enc->cur[++s] = 0;
      }
      enc->cur += s;
    }
  else if (SvPOKp (sv))
    {
      STRLEN len;
      char *str = SvPV (sv, len);
      encode_ch (enc, '"');
      encode_str (enc, str, len, SvUTF8 (sv));
      encode_ch (enc, '"');
    }
  else if (SvROK (sv))
    encode_rv (enc, SvRV (sv));
  else if (!SvOK (sv) || enc->json.flags & F_ALLOW_UNKNOWN)
    encode_str (enc, "null", 4, 0);
  else
    croak ("encountered perl type (%s,0x%x) that JSON cannot handle, check your input data",
           SvPV_nolen (sv), (unsigned int)SvFLAGS (sv));
}

static SV *
encode_json (pTHX_ SV *scalar, JSON *json, PerlIO* ofp = nullptr)
{
  enc_t enc;

  if ((json->flags & (F_WITH_COMMENTS | F_INDENT)) == F_WITH_COMMENTS)
    croak("comments can't be printed out when indentation is switched off");

  if (!(json->flags & F_ALLOW_NONREF) && json_nonref (aTHX_ scalar))
    croak ("hash- or arrayref expected (not a simple scalar, use allow_nonref to allow this)");

  enc.json      = *json;
  enc.sv        = sv_2mortal (NEWSV (0, ofp ? FILE_BUF_SIZE : INIT_SIZE));
  enc.cur       = SvPVX (enc.sv);
  enc.end       = enc.cur + SvLEN(enc.sv) - !ofp;
  enc.indent    = 0;
  enc.limit     = enc.json.flags & F_ASCII  ? 0x000080UL
                : enc.json.flags & F_LATIN1 ? 0x000100UL
                                            : 0x110000UL;
  enc.fp = ofp;

  SvPOK_only (enc.sv);
  encode_sv (&enc, scalar);
  encode_nl (&enc, enc.json.flags);

  if (ofp) {
     const STRLEN tail_len = enc.cur - SvPVX(enc.sv);
     if (tail_len != 0)
        PerlIO_write(ofp, SvPVX(enc.sv), tail_len);
     return nullptr;
  }

  SvCUR_set (enc.sv, enc.cur - SvPVX (enc.sv));
  *SvEND (enc.sv) = 0; // many xs functions expect a trailing 0 for text strings

  if (!(enc.json.flags & (F_ASCII | F_LATIN1 | F_UTF8)))
    SvUTF8_on (enc.sv);

  if (enc.json.flags & F_SHRINK)
    shrink (aTHX_ enc.sv);

  return enc.sv;
}

/////////////////////////////////////////////////////////////////////////////
// decoder

// structure used for decoding JSON
typedef struct
{
  char *cur; // current parser pointer
  char *end; // end of input string
  const char *err; // parse error, if != 0
  JSON json;
  I32 depth; // recursion depth
  I32 maxdepth; // recursion depth limit
} dec_t;

static SV *
decode_str (dec_t *dec, const char delim = '"');

INLINE void
decode_comment (dec_t *dec)
{
  // only '#'-style comments allowed a.t.m.

  while (*dec->cur && *dec->cur != 0x0a && *dec->cur != 0x0d)
    ++dec->cur;
}

INLINE
void decode_ws (dec_t *dec)
{
  AV* comments_av = nullptr;
  const char* last_comment_end = nullptr;
  for (;;)
    {
      char ch = *dec->cur;

      if (ch > ' ')
        {
          if (expect_false (ch == '#'))
            {
              if (dec->json.flags & (F_RELAXED | F_WITH_COMMENTS))
                decode_comment (dec);
              else
                break;
            }
          else
            break;
        }
      else if (ch != ' ' && ch != '\n' && ch != '\r' && ch != '\t')
        break; // parse error, but let higher level handle it, gives better error messages

      ++dec->cur;
    }
}

static AV*
decode_ws_with_comments(pTHX_ dec_t *dec)
{
  AV* comments_av = nullptr;
  const char* last_comment_end = nullptr;
  for (;;)
    {
      char ch = *dec->cur;

      if (ch > ' ')
        {
          if (expect_false (ch == '#'))
            {
              if (dec->json.flags & F_WITH_COMMENTS) {
                // only collect full-line comments, not the trailing ones
                // note: we never call this at the beginning of the input stream, only within an object,
                // therefore it's safe to look behind as long as we see white spaces
                const char* eol = dec->cur;
                do
                  --eol;
                while (*eol == ' ' || *eol == '\t');

                // the usual EOL madness
                if (*eol == '\n' || *eol == '\r') {

                  // only collect contiguous comment blocks
                  if (eol != last_comment_end && comments_av) {
                    av_clear(comments_av);
                  }

                  SV* comment_line = decode_str(dec, *eol);
                  last_comment_end = dec->cur - 1;

                  if (comment_line) {
                    sv_catpvn(comment_line, eol, 1);
                    if (!comments_av) comments_av = newAV();
                    av_push(comments_av, comment_line);
                  }
                } else {
                  decode_comment(dec);
                }
              } else {
                decode_comment(dec);
              }
            }
          else
            break;
        }
      else if (ch != ' ' && ch != '\n' && ch != '\r' && ch != '\t')
        break; // parse error, but let higher level handle it, gives better error messages

      ++dec->cur;
    }

  if (comments_av) {
    // only keep non-empty comment blocks
    for (SV **line_svp = AvARRAY(comments_av), **line_lastp = line_svp + AvFILLp(comments_av);
         line_svp <= line_lastp;  ++line_svp) {
      if (strspn(SvPVX(*line_svp), "# \t\n\r") < SvCUR(*line_svp))
        return comments_av;
    }
    SvREFCNT_dec(comments_av);
  }

  return nullptr;
}

static void
attach_comments(pTHX_ SV* val, AV* &comments_av)
{
  SV* comments_ref = newRV_noinc((SV*)comments_av);
  sv_magicext(val, comments_ref, PERL_MAGIC_ext, &attached_comments_vtbl, nullptr, 0);
  SvREFCNT_dec(comments_ref);  // compensate for inc() within sv_magicext
  comments_av = nullptr;
}

#define ERR(reason) SB dec->err = reason; goto fail; SE

#define EXPECT_CH(ch) SB \
  if (*dec->cur != ch)		\
    ERR (# ch " expected");	\
  ++dec->cur;			\
  SE

#define DEC_INC_DEPTH if (++dec->depth > dec->json.max_depth) ERR (ERR_NESTING_EXCEEDED)
#define DEC_DEC_DEPTH --dec->depth

static SV *decode_sv (dec_t *dec);

static signed char decode_hexdigit[256];

static UV
decode_4hex (dec_t *dec)
{
  signed char d1, d2, d3, d4;
  unsigned char *cur = (unsigned char *)dec->cur;

  d1 = decode_hexdigit [cur [0]]; if (expect_false (d1 < 0)) ERR ("exactly four hexadecimal digits expected");
  d2 = decode_hexdigit [cur [1]]; if (expect_false (d2 < 0)) ERR ("exactly four hexadecimal digits expected");
  d3 = decode_hexdigit [cur [2]]; if (expect_false (d3 < 0)) ERR ("exactly four hexadecimal digits expected");
  d4 = decode_hexdigit [cur [3]]; if (expect_false (d4 < 0)) ERR ("exactly four hexadecimal digits expected");

  dec->cur += 4;

  return ((UV)d1) << 12
       | ((UV)d2) <<  8
       | ((UV)d3) <<  4
       | ((UV)d4);

fail:
  return (UV)-1;
}

static SV *
decode_str (dec_t *dec, const char delim)
{
  dTHX;
  SV *sv = 0;
  int utf8 = 0;
  char *dec_cur = dec->cur;

  do
    {
      char buf [SHORT_STRING_LEN + UTF8_MAXBYTES];
      char *cur = buf;

      do
        {
          unsigned char ch = *(unsigned char *)dec_cur++;

          if (expect_false (ch == delim))
            {
              --dec_cur;
              break;
            }
          else if (expect_false (ch == '\\'))
            {
              switch (*dec_cur)
                {
                  case '\\':
                  case '/':
                  case '"': *cur++ = *dec_cur++; break;

                  case 'b': ++dec_cur; *cur++ = '\010'; break;
                  case 't': ++dec_cur; *cur++ = '\011'; break;
                  case 'n': ++dec_cur; *cur++ = '\012'; break;
                  case 'f': ++dec_cur; *cur++ = '\014'; break;
                  case 'r': ++dec_cur; *cur++ = '\015'; break;

                  case 'u':
                    {
                      UV lo, hi;
                      ++dec_cur;

                      dec->cur = dec_cur;
                      hi = decode_4hex (dec);
                      dec_cur = dec->cur;
                      if (hi == (UV)-1)
                        goto fail;

                      // possibly a surrogate pair
                      if (hi >= 0xd800)
                        if (hi < 0xdc00)
                          {
                            if (dec_cur [0] != '\\' || dec_cur [1] != 'u')
                              ERR ("missing low surrogate character in surrogate pair");

                            dec_cur += 2;

                            dec->cur = dec_cur;
                            lo = decode_4hex (dec);
                            dec_cur = dec->cur;
                            if (lo == (UV)-1)
                              goto fail;

                            if (lo < 0xdc00 || lo >= 0xe000)
                              ERR ("surrogate pair expected");

                            hi = (hi - 0xD800) * 0x400 + (lo - 0xDC00) + 0x10000;
                          }
                        else if (hi < 0xe000)
                          ERR ("missing high surrogate character in surrogate pair");

                      if (hi >= 0x80)
                        {
                          utf8 = 1;

                          cur = (char*)encode_utf8 ((U8*)cur, hi);
                        }
                      else
                        *cur++ = hi;
                    }
                    break;

                  default:
                    --dec_cur;
                    ERR ("illegal backslash escape sequence in string");
                }
            }
          else if (expect_true (ch >= 0x20 && ch < 0x80))
            *cur++ = ch;
          else if (ch >= 0x80)
            {
              STRLEN clen;

              --dec_cur;

              decode_utf8 (aTHX_ (U8*)dec_cur, dec->end - dec_cur, &clen);
              if (clen == (STRLEN)-1)
                ERR ("malformed UTF-8 character in JSON string");

              do
                *cur++ = *dec_cur++;
              while (--clen);

              utf8 = 1;
            }
          else if (ch == '\t' && dec->json.flags & F_RELAXED)
            *cur++ = ch;
          else
            {
              --dec_cur;

              if (!ch)
                ERR ("unexpected end of string while parsing JSON string");
              else
                ERR ("invalid character encountered while parsing JSON string");
            }
        }
      while (cur < buf + SHORT_STRING_LEN);

      {
        STRLEN len = cur - buf;

        if (sv)
          {
            STRLEN cur = SvCUR (sv);

            if (SvLEN (sv) - cur <= len)
              json_sv_grow (aTHX_ sv, cur, len);

            memcpy (SvPVX (sv) + SvCUR (sv), buf, len);
            SvCUR_set (sv, SvCUR (sv) + len);
          }
        else
          sv = newSVpvn (buf, len);
      }
    }
  while (*dec_cur != delim);

  ++dec_cur;

  if (sv)
    {
      SvPOK_only (sv);
      *SvEND (sv) = 0;

      if (utf8)
        SvUTF8_on (sv);
    }
  else
    sv = newSVpvn ("", 0);

  dec->cur = dec_cur;
  return sv;

fail:
  dec->cur = dec_cur;
  return 0;
}

static SV *
decode_num (dec_t *dec)
{
  dTHX;
  int is_nv = 0;
  char *start = dec->cur;

  // [minus]
  if (*dec->cur == '-')
    ++dec->cur;

  if (*dec->cur == '0')
    {
      ++dec->cur;
      if (*dec->cur >= '0' && *dec->cur <= '9')
         ERR ("malformed number (leading zero must not be followed by another digit)");
    }
  else if (*dec->cur < '0' || *dec->cur > '9')
    ERR ("malformed number (no digits after initial minus)");
  else
    do
      {
        ++dec->cur;
      }
    while (*dec->cur >= '0' && *dec->cur <= '9');

  // [frac]
  if (*dec->cur == '.')
    {
      ++dec->cur;

      if (*dec->cur < '0' || *dec->cur > '9')
        ERR ("malformed number (no digits after decimal point)");

      do
        {
          ++dec->cur;
        }
      while (*dec->cur >= '0' && *dec->cur <= '9');

      is_nv = 1;
    }

  // [exp]
  if (*dec->cur == 'e' || *dec->cur == 'E')
    {
      ++dec->cur;

      if (*dec->cur == '-' || *dec->cur == '+')
        ++dec->cur;

      if (*dec->cur < '0' || *dec->cur > '9')
        ERR ("malformed number (no digits after exp sign)");

      do
        {
          ++dec->cur;
        }
      while (*dec->cur >= '0' && *dec->cur <= '9');

      is_nv = 1;
    }

  if (!is_nv)
    {
      int len = dec->cur - start;

      // special case the rather common 1..5-digit-int case
      if (*start == '-')
        switch (len)
          {
            case 2: return newSViv (-(IV)(                                                                          start [1] - '0' *     1));
            case 3: return newSViv (-(IV)(                                                         start [1] * 10 + start [2] - '0' *    11));
            case 4: return newSViv (-(IV)(                                       start [1] * 100 + start [2] * 10 + start [3] - '0' *   111));
            case 5: return newSViv (-(IV)(                    start [1] * 1000 + start [2] * 100 + start [3] * 10 + start [4] - '0' *  1111));
            case 6: return newSViv (-(IV)(start [1] * 10000 + start [2] * 1000 + start [3] * 100 + start [4] * 10 + start [5] - '0' * 11111));
          }
      else
        switch (len)
          {
            case 1: return newSViv (                                                                                start [0] - '0' *     1);
            case 2: return newSViv (                                                               start [0] * 10 + start [1] - '0' *    11);
            case 3: return newSViv (                                             start [0] * 100 + start [1] * 10 + start [2] - '0' *   111);
            case 4: return newSViv (                          start [0] * 1000 + start [1] * 100 + start [2] * 10 + start [3] - '0' *  1111);
            case 5: return newSViv (      start [0] * 10000 + start [1] * 1000 + start [2] * 100 + start [3] * 10 + start [4] - '0' * 11111);
          }

      {
        UV uv;
        int numtype = grok_number (start, len, &uv);
        if (numtype & IS_NUMBER_IN_UV)
          if (numtype & IS_NUMBER_NEG)
            {
              if (uv < (UV)IV_MIN)
                return newSViv (-(IV)uv);
            }
          else
            return newSVuv (uv);
      }

      len -= *start == '-' ? 1 : 0;

      // does not fit into IV or UV, try NV
      if (len <= NV_DIG)
        // fits into NV without loss of precision
        return newSVnv (json_atof (start));

      // everything else fails, convert it to a string
      return newSVpvn (start, dec->cur - start);
    }

  // loss of precision here
  return newSVnv (json_atof (start));

fail:
  return 0;
}

static SV *
decode_av (dec_t *dec)
{
  dTHX;
  AV *av = newAV ();

  DEC_INC_DEPTH;
  decode_ws (dec);

  if (*dec->cur == ']')
    ++dec->cur;
  else
    for (;;)
      {
        SV *value;

        value = decode_sv (dec);
        if (!value)
          goto fail;

        av_push (av, value);

        decode_ws (dec);

        if (*dec->cur == ']')
          {
            ++dec->cur;
            break;
          }

        if (*dec->cur != ',')
          ERR (", or ] expected while parsing array");

        ++dec->cur;

        decode_ws (dec);

        if (*dec->cur == ']' && dec->json.flags & F_RELAXED)
          {
            ++dec->cur;
            break;
          }
      }

  DEC_DEC_DEPTH;
  return newRV_noinc ((SV *)av);

fail:
  SvREFCNT_dec (av);
  DEC_DEC_DEPTH;
  return 0;
}

static void add_sparse_item(pTHX_ AV*& sparse_dict, const char* key, STRLEN len, SV* value)
{
  UV index;
  if ((len == SvCUR(pm::perl::glue::Serializer_Sparse_dim_key) &&
       !strncmp(key, SvPVX(pm::perl::glue::Serializer_Sparse_dim_key), len) &&
       SvIOK(value) && SvIVX(value) >= 0
       ? (index = SvIVX(value), value = pm::perl::glue::Serializer_Sparse_dim_key, true)
       : (grok_number(key, len, &index) == IS_NUMBER_IN_UV))
      &&
      (sparse_dict ? ((UV)SvIVX(AvARRAY(sparse_dict)[AvFILLp(sparse_dict) - 1]) < index &&
                      AvARRAY(sparse_dict)[AvFILLp(sparse_dict)] != pm::perl::glue::Serializer_Sparse_dim_key)
       : (sparse_dict = newAV(), true))) {
    av_push(sparse_dict, newSViv(index));
    av_push(sparse_dict, SvREFCNT_inc_simple_NN(value));
  } else if (sparse_dict) {
    SvREFCNT_dec((SV*)sparse_dict);
    sparse_dict = nullptr;
  }
}

namespace pm { namespace perl { namespace glue {

MGVTBL sparse_input_vtbl = { 0, 0, 0, 0, 0 };

} } }

static SV *
decode_hv (dec_t *dec)
{
  dTHX;
  SV *sv;
  HV *hv = newHV ();
  AV* sparse_dict = nullptr;
  AV* comments_av = nullptr;

  DEC_INC_DEPTH;
  comments_av = decode_ws_with_comments(aTHX_ dec);

  if (*dec->cur == '}')
    ++dec->cur;
  else
    for (;;)
      {
        EXPECT_CH ('"');

        // heuristic: assume that
        // a) decode_str + hv_store_ent are abysmally slow.
        // b) most hash keys are short, simple ascii text.
        // => try to "fast-match" such strings to avoid
        // the overhead of decode_str + hv_store_ent.
        {
          SV *value;
          char *p = dec->cur;
          char *e = p + 24; // only try up to 24 bytes

          for (;;)
            {
              // the >= 0x80 is false on most architectures
              if (p == e || ((unsigned char)*p) < 0x20 || ((unsigned char)*p) >= 0x80 || *p == '\\')
                {
                  // slow path, back up and use decode_str
                  SV *key = decode_str (dec);
                  if (!key)
                    goto fail;

                  decode_ws (dec); EXPECT_CH (':');

                  decode_ws (dec);
                  value = decode_sv (dec);
                  if (!value)
                    {
                      SvREFCNT_dec (key);
                      goto fail;
                    }
                  if (sparse_dict) {
                    SvREFCNT_dec((SV*)sparse_dict);
                    sparse_dict = nullptr;
                  }
                  hv_store_ent (hv, key, value, 0);
                  SvREFCNT_dec (key);

                  if (comments_av) attach_comments(aTHX_ value, comments_av);

                  break;
                }
              else if (*p == '"')
                {
                  // fast path, got a simple key
                  char *key = dec->cur;
                  SSize_t len = p - key;
                  dec->cur = p + 1;

                  decode_ws (dec); EXPECT_CH (':');

                  decode_ws (dec);
                  value = decode_sv (dec);
                  if (!value)
                    goto fail;

                  if (!(dec->json.flags & F_HOOK)) {
                    if (HvUSEDKEYS(hv) == 0 || sparse_dict) {
                      add_sparse_item(aTHX_ sparse_dict, key, len, value);
                    }
                  }

                  hv_store (hv, key, len, value, 0);

                  if (comments_av) attach_comments(aTHX_ value, comments_av);

                  break;
                }

              ++p;
            }
        }

        decode_ws (dec);

        if (*dec->cur == '}')
          {
            ++dec->cur;
            break;
          }

        if (*dec->cur != ',')
          ERR (", or } expected while parsing object/hash");

        ++dec->cur;

        comments_av = decode_ws_with_comments(aTHX_ dec);

        if (*dec->cur == '}' && dec->json.flags & F_RELAXED)
          {
            ++dec->cur;
            break;
          }
      }

  DEC_DEC_DEPTH;

  SvREFCNT_dec(comments_av);

  sv = newRV_noinc ((SV *)hv);

  // check filter callbacks
  if (dec->json.flags & F_HOOK)
    {
      if (dec->json.cb_sk_object && HvKEYS (hv) == 1)
        {
          HE *cb, *he;

          hv_iterinit (hv);
          he = hv_iternext (hv);
          hv_iterinit (hv);

          // the next line creates a mortal sv each time it's called.
          // might want to optimise this for common cases.
          cb = hv_fetch_ent (dec->json.cb_sk_object, hv_iterkeysv (he), 0, 0);

          if (cb)
            {
              dSP;
              int count;

              ENTER; SAVETMPS;
              SAVESTACK_POS ();
              PUSHMARK (SP);
              XPUSHs (HeVAL (he));
              sv_2mortal (sv);

              PUTBACK; count = call_sv (HeVAL (cb), G_ARRAY); SPAGAIN;

              if (count == 1)
                {
                  sv = newSVsv (POPs);
                  FREETMPS; LEAVE;
                  return sv;
                }

              SvREFCNT_inc (sv);
              FREETMPS; LEAVE;
            }
        }

      if (dec->json.cb_object)
        {
          dSP;
          int count;

          ENTER; SAVETMPS;
          SAVESTACK_POS ();
          PUSHMARK (SP);
          XPUSHs (sv_2mortal (sv));

          PUTBACK; count = call_sv (dec->json.cb_object, G_ARRAY); SPAGAIN;

          if (count == 1)
            {
              sv = newSVsv (POPs);
              FREETMPS; LEAVE;
              return sv;
            }

          SvREFCNT_inc (sv);
          FREETMPS; LEAVE;
        }
    }
  else if (sparse_dict) {
    sv_magicext((SV*)hv, (SV*)sparse_dict, PERL_MAGIC_ext, &pm::perl::glue::sparse_input_vtbl, nullptr, 0);
    SvREFCNT_dec((SV*)sparse_dict);  // compensate for inc above
  }

  return sv;

fail:
  SvREFCNT_dec (hv);
  SvREFCNT_dec(comments_av);
  DEC_DEC_DEPTH;
  return 0;
}

static SV *
decode_tag (dec_t *dec)
{
  dTHX;
  SV *tag = 0;
  SV *val = 0;

  if (!(dec->json.flags & F_ALLOW_TAGS))
    ERR ("malformed JSON string, neither array, object, number, string or atom");

  ++dec->cur;

  decode_ws (dec);

  tag = decode_sv (dec);
  if (!tag)
    goto fail;

  if (!SvPOK (tag))
    ERR ("malformed JSON string, (tag) must be a string");

  decode_ws (dec);

  if (*dec->cur != ')')
    ERR (") expected after tag");

  ++dec->cur;

  decode_ws (dec);

  val = decode_sv (dec);
  if (!val)
    goto fail;

  if (!SvROK (val) || SvTYPE (SvRV (val)) != SVt_PVAV)
    ERR ("malformed JSON string, tag value must be an array");

  {
    AV *av = (AV *)SvRV (val);
    SSize_t i, len = av_len (av) + 1;
    HV *stash = gv_stashsv (tag, 0);
    SV *sv;

    if (!stash)
      ERR ("cannot decode perl-object (package does not exist)");

    GV *method = gv_fetchmethod_autoload (stash, "THAW", 0);

    if (!method)
      ERR ("cannot decode perl-object (package does not have a THAW method)");

    dSP;

    ENTER; SAVETMPS;
    PUSHMARK (SP);
    EXTEND (SP, len + 2);
    // we re-bless the reference to get overload and other niceties right
    PUSHs (tag);
    PUSHs (sv_json);

    for (i = 0; i < len; ++i)
      PUSHs (*av_fetch (av, i, 1));

    PUTBACK;
    call_sv ((SV *)GvCV (method), G_SCALAR);
    SPAGAIN;

    SvREFCNT_dec (tag);
    SvREFCNT_dec (val);
    sv = SvREFCNT_inc (POPs);

    PUTBACK;

    FREETMPS; LEAVE;

    return sv;
  }

fail:
  SvREFCNT_dec (tag);
  SvREFCNT_dec (val);
  return 0;
}

static SV *
decode_sv (dec_t *dec)
{
  dTHX;
  // the beauty of JSON: you need exactly one character lookahead
  // to parse everything.
  switch (*dec->cur)
    {
      case '"': ++dec->cur; return decode_str (dec);
      case '[': ++dec->cur; return decode_av  (dec);
      case '{': ++dec->cur; return decode_hv  (dec);
      case '(':             return decode_tag (dec);

      case '-':
      case '0': case '1': case '2': case '3': case '4':
      case '5': case '6': case '7': case '8': case '9':
        return decode_num (dec);

      case 't':
        if (dec->end - dec->cur >= 4 && !memcmp (dec->cur, "true", 4))
          {
            dec->cur += 4;
#if JSON_SLOW
            bool_true = get_bool ("Types::Serialiser::true");
#endif
            return newSVsv (bool_true);
          }
        else
          ERR ("'true' expected");

        break;

      case 'f':
        if (dec->end - dec->cur >= 5 && !memcmp (dec->cur, "false", 5))
          {
            dec->cur += 5;
#if JSON_SLOW
            bool_false = get_bool ("Types::Serialiser::false");
#endif
            return newSVsv (bool_false);
          }
        else
          ERR ("'false' expected");

        break;

      case 'n':
        if (dec->end - dec->cur >= 4 && !memcmp (dec->cur, "null", 4))
          {
            dec->cur += 4;
            return newSVsv (&PL_sv_undef);
          }
        else
          ERR ("'null' expected");

        break;

      default:
        ERR ("malformed JSON string, neither tag, array, object, number, string or atom");
        break;
    }

fail:
  return 0;
}

static SV *
decode_json (pTHX_ SV *string, JSON *json, STRLEN *offset_return)
{
  dec_t dec;
  SV *sv;

  /* work around bugs in 5.10 where manipulating magic values
   * makes perl ignore the magic in subsequent accesses.
   * also make a copy of non-PV values, to get them into a clean
   * state (SvPV should do that, but it's buggy, see below).
   *
   * SvIsCOW_shared_hash works around a bug in perl (possibly 5.16),
   * as reported by Reini Urban.
   */
  /*SvGETMAGIC (string);*/
  if (SvMAGICAL (string) || !SvPOK (string) || SvIsCOW_shared_hash (string))
    string = sv_2mortal (newSVsv (string));

  SvUPGRADE (string, SVt_PV);

  /* work around a bug in perl 5.10, which causes SvCUR to fail an
   * assertion with -DDEBUGGING, although SvCUR is documented to
   * return the xpv_cur field which certainly exists after upgrading.
   * according to nicholas clark, calling SvPOK fixes this.
   * But it doesn't fix it, so try another workaround, call SvPV_nolen
   * and hope for the best.
   * Damnit, SvPV_nolen still trips over yet another assertion. This
   * assertion business is seriously broken, try yet another workaround
   * for the broken -DDEBUGGING.
   */
  {
#ifdef DEBUGGING
    STRLEN offset = SvOK (string) ? sv_len (string) : 0;
#else
    STRLEN offset = SvCUR (string);
#endif

    if (offset > json->max_size && json->max_size)
      croak ("attempted decode of JSON text of %lu bytes size, but max_size is set to %lu",
             (unsigned long)SvCUR (string), (unsigned long)json->max_size);
  }

  if (DECODE_WANTS_OCTETS (json))
    sv_utf8_downgrade (string, 0);
  else
    sv_utf8_upgrade (string);

  SvGROW (string, SvCUR (string) + 1); // should basically be a NOP

  dec.json  = *json;
  dec.cur   = SvPVX (string);
  dec.end   = SvEND (string);
  dec.err   = 0;
  dec.depth = 0;

  if (dec.json.cb_object || dec.json.cb_sk_object)
    dec.json.flags |= F_HOOK;

  *dec.end = 0; // this should basically be a nop, too, but make sure it's there

  decode_ws (&dec);
  sv = decode_sv (&dec);

  if (offset_return)
    *offset_return = dec.cur - SvPVX (string);
  else if (sv)
    {
      // check for trailing garbage
      decode_ws (&dec);

      if (*dec.cur)
        {
          dec.err = "garbage after JSON object";
          SvREFCNT_dec (sv);
          sv = 0;
        }
    }

  if (!sv)
    {
      SV *uni = sv_newmortal ();

      // horrible hack to silence warning inside pv_uni_display
      COP cop = *PL_curcop;
      cop.cop_warnings = pWARN_NONE;
      ENTER;
      SAVEVPTR (PL_curcop);
      PL_curcop = &cop;
      pv_uni_display (uni, (const U8*)dec.cur, dec.end - dec.cur, 20, UNI_DISPLAY_QQ);
      LEAVE;

      croak ("%s, at character offset %d (before \"%s\")",
             dec.err,
             (int)ptr_to_index (aTHX_ string, dec.cur),
             dec.cur != dec.end ? SvPV_nolen (uni) : "(end of string)");
    }

  sv = sv_2mortal (sv);

  if (!(dec.json.flags & F_ALLOW_NONREF) && json_nonref (aTHX_ sv))
    croak ("JSON text must be an object or array (but found number, string, true, false or null, use allow_nonref to allow this)");

  return sv;
}

/////////////////////////////////////////////////////////////////////////////
// incremental parser

static void
incr_parse (JSON *self)
{
  const char *p = SvPVX (self->incr_text) + self->incr_pos;

  // the state machine here is a bit convoluted and could be simplified a lot
  // but this would make it slower, so...

  for (;;)
    {
      //printf ("loop pod %d *p<%c><%s>, mode %d nest %d\n", p - SvPVX (self->incr_text), *p, p, self->incr_mode, self->incr_nest);//D
      switch (self->incr_mode)
        {
          // only used for initial whitespace skipping
          case INCR_M_WS:
            for (;;)
              {
                if (*p > 0x20)
                  {
                    if (*p == '#')
                      {
                        self->incr_mode = INCR_M_C0;
                        goto incr_m_c;
                      }
                    else
                      {
                        self->incr_mode = INCR_M_JSON;
                        goto incr_m_json;
                      }
                  }
                else if (!*p)
                  goto interrupt;

                ++p;
              }

          // skip a single char inside a string (for \\-processing)
          case INCR_M_BS:
            if (!*p)
              goto interrupt;

            ++p;
            self->incr_mode = INCR_M_STR;
            goto incr_m_str;

          // inside #-style comments
          case INCR_M_C0:
          case INCR_M_C1:
          incr_m_c:
            for (;;)
              {
                if (*p == '\n')
                  {
                    self->incr_mode = self->incr_mode == INCR_M_C0 ? INCR_M_WS : INCR_M_JSON;
                    break;
                  }
                else if (!*p)
                  goto interrupt;

                ++p;
              }

            break;

          // inside a string
          case INCR_M_STR:
          incr_m_str:
            for (;;)
              {
                if (*p == '"')
                  {
                    ++p;
                    self->incr_mode = INCR_M_JSON;

                    if (!self->incr_nest)
                      goto interrupt;

                    goto incr_m_json;
                  }
                else if (*p == '\\')
                  {
                    ++p; // "virtually" consumes character after '\'

                    if (!*p) // if at end of string we have to switch modes
                      {
                        self->incr_mode = INCR_M_BS;
                        goto interrupt;
                      }
                  }
                else if (!*p)
                  goto interrupt;

                ++p;
              }

          // after initial ws, outside string
          case INCR_M_JSON:
          incr_m_json:
            for (;;)
              {
                switch (*p++)
                  {
                    case 0:
                      --p;
                      goto interrupt;

                    case 0x09:
                    case 0x0a:
                    case 0x0d:
                    case 0x20:
                      if (!self->incr_nest)
                        {
                          --p; // do not eat the whitespace, let the next round do it
                          goto interrupt;
                        }
                      break;

                    case '"':
                      self->incr_mode = INCR_M_STR;
                      goto incr_m_str;

                    case '[':
                    case '{':
                    case '(':
                      if (++self->incr_nest > self->max_depth)
                        croak (ERR_NESTING_EXCEEDED);
                      break;

                    case ']':
                    case '}':
                      if (--self->incr_nest <= 0)
                        goto interrupt;
                      break;

                    case ')':
                      --self->incr_nest;
                      break;

                    case '#':
                      self->incr_mode = INCR_M_C1;
                      goto incr_m_c;
                  }
              }
        }

      modechange:
        ;
    }

interrupt:
  self->incr_pos = p - SvPVX (self->incr_text);
  //printf ("interrupt<%.*s>\n", self->incr_pos, SvPVX(self->incr_text));//D
  //printf ("return pos %d mode %d nest %d\n", self->incr_pos, self->incr_mode, self->incr_nest);//D
}

/////////////////////////////////////////////////////////////////////////////
// XS interface functions

#line 2320 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

/* simple backcompat versions of the TARGx() macros with no optimisation */
#ifndef TARGi
#  define TARGi(iv, do_taint) sv_setiv_mg(TARG, iv)
#  define TARGu(uv, do_taint) sv_setuv_mg(TARG, uv)
#  define TARGn(nv, do_taint) sv_setnv_mg(TARG, nv)
#endif

#line 2471 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"

XS_EUPXS(XS_JSON__XS_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_CLONE)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 2339 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        json_stash = 0;
        bool_stash = 0;
#line 2483 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_JSON__XS_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "klass");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	klass = (char *)SvPV_nolen(ST(0))
;
#line 2344 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
	SV *pv = NEWSV (0, sizeof (JSON));
        SvPOK_only (pv);
        json_init ((JSON *)SvPVX (pv));
        XPUSHs (sv_2mortal (sv_bless (
           newRV_noinc (pv),
           strEQ (klass, "JSON::XS") ? JSON_STASH : gv_stashpv (klass, 1)
        )));
}
#line 2510 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_ascii); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_ascii)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, enable= 1");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	int	enable;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;

	if (items < 2)
	    enable = 1;
	else {
	    enable = (int)SvIV(ST(1))
;
	}
#line 2373 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
        if (enable)
          self->flags |=  ix;
        else
          self->flags &= ~ix;

        XPUSHs (ST (0));
}
#line 2555 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_get_ascii); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_get_ascii)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2400 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        XPUSHs (boolSV (self->flags & ix));
#line 2585 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_max_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_max_depth)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, max_depth= INT_MAX");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	I32	max_depth;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;

	if (items < 2)
	    max_depth = INT_MAX;
	else {
	    max_depth = (I32)SvIV(ST(1))
;
	}
#line 2404 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        self->max_depth = max_depth;
        XPUSHs (ST (0));
#line 2623 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_get_max_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_get_max_depth)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	U32	RETVAL;
	dXSTARG;
	JSON *	self;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2409 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        RETVAL = self->max_depth;
#line 2652 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	TARGu((UV)RETVAL, 1);
	ST(0) = TARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_JSON__XS_max_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_max_size)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, max_size= 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	U32	max_size;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;

	if (items < 2)
	    max_size = 0;
	else {
	    max_size = (unsigned long)SvUV(ST(1))
;
	}
#line 2415 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        self->max_size = max_size;
        XPUSHs (ST (0));
#line 2691 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_get_max_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_get_max_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	JSON *	self;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2420 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        RETVAL = self->max_size;
#line 2720 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	TARGi((IV)RETVAL, 1);
	ST(0) = TARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_JSON__XS_filter_json_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_filter_json_object)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cb= &PL_sv_undef");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	SV *	cb;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;

	if (items < 2)
	    cb = &PL_sv_undef;
	else {
	    cb = ST(1)
;
	}
#line 2426 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
        SvREFCNT_dec (self->cb_object);
        self->cb_object = SvOK (cb) ? newSVsv (cb) : 0;

        XPUSHs (ST (0));
}
#line 2763 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_filter_json_single_key_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_filter_json_single_key_object)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, key, cb= &PL_sv_undef");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	SV *	key = ST(1)
;
	SV *	cb;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;

	if (items < 3)
	    cb = &PL_sv_undef;
	else {
	    cb = ST(2)
;
	}
#line 2435 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
	if (!self->cb_sk_object)
          self->cb_sk_object = newHV ();

        if (SvOK (cb))
          hv_store_ent (self->cb_sk_object, key, newSVsv (cb), 0);
        else
          {
            hv_delete_ent (self->cb_sk_object, key, G_DISCARD, 0);

            if (!HvKEYS (self->cb_sk_object))
              {
                SvREFCNT_dec (self->cb_sk_object);
                self->cb_sk_object = 0;
              }
          }

        XPUSHs (ST (0));
}
#line 2820 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_encode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_encode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, scalar");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	SV *	scalar = ST(1)
;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2457 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        PUTBACK; scalar = encode_json (aTHX_ scalar, self); SPAGAIN;
        XPUSHs (scalar);
#line 2852 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_write)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, scalar, file_ref");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	SV *	scalar = ST(1)
;
	SV *	file_ref = ST(2)
;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2462 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
  PerlIO* ofp = check_outfile(aTHX_ file_ref);
  PUTBACK; scalar = encode_json (aTHX_ scalar, self, ofp); SPAGAIN;
}
#line 2888 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_decode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_decode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, jsonstr");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	SV *	jsonstr = ST(1)
;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2469 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        PUTBACK; jsonstr = decode_json (aTHX_ jsonstr, self, 0); SPAGAIN;
        XPUSHs (jsonstr);
#line 2920 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_decode_prefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_decode_prefix)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, jsonstr");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	SV *	jsonstr = ST(1)
;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2474 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
	SV *sv;
        STRLEN offset;
        PUTBACK; sv = decode_json (aTHX_ jsonstr, self, &offset); SPAGAIN;
        EXTEND (SP, 2);
        PUSHs (sv);
        PUSHs (sv_2mortal (newSVuv (ptr_to_index (aTHX_ jsonstr, SvPV_nolen (jsonstr) + offset))));
}
#line 2958 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_incr_parse); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_incr_parse)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, jsonstr= 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	JSON *	self;
	SV *	jsonstr;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;

	if (items < 2)
	    jsonstr = 0;
	else {
	    jsonstr = ST(1)
;
	}
#line 2485 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
	if (!self->incr_text)
          self->incr_text = newSVpvn ("", 0);

        /* if utf8-ness doesn't match the decoder, need to upgrade/downgrade */
        if (!DECODE_WANTS_OCTETS (self) == !SvUTF8 (self->incr_text))
          if (DECODE_WANTS_OCTETS (self))
            {
              if (self->incr_pos)
                self->incr_pos = utf8_length ((U8 *)SvPVX (self->incr_text),
                                              (U8 *)SvPVX (self->incr_text) + self->incr_pos);

              sv_utf8_downgrade (self->incr_text, 0);
            }
          else
            {
              sv_utf8_upgrade (self->incr_text);

              if (self->incr_pos)
                self->incr_pos = utf8_hop ((U8 *)SvPVX (self->incr_text), self->incr_pos)
                                 - (U8 *)SvPVX (self->incr_text);
            }

        // append data, if any
        if (jsonstr)
          {
            /* make sure both strings have same encoding */
            if (SvUTF8 (jsonstr) != SvUTF8 (self->incr_text))
              if (SvUTF8 (jsonstr))
                sv_utf8_downgrade (jsonstr, 0);
              else
                sv_utf8_upgrade (jsonstr);

            /* and then just blindly append */
            {
              STRLEN len;
              const char *str = SvPV (jsonstr, len);
              STRLEN cur = SvCUR (self->incr_text);

              if (SvLEN (self->incr_text) - cur <= len)
                json_sv_grow (aTHX_ self->incr_text, cur, len);

              Move (str, SvEND (self->incr_text), len, char);
              SvCUR_set (self->incr_text, SvCUR (self->incr_text) + len);
              *SvEND (self->incr_text) = 0; // this should basically be a nop, too, but make sure it's there
            }
          }

        if (GIMME_V != G_VOID)
          do
            {
              SV *sv;
              STRLEN offset;

              if (!INCR_DONE (self))
                {
                  incr_parse (self);

                  if (self->incr_pos > self->max_size && self->max_size)
                    croak ("attempted decode of JSON text of %lu bytes size, but max_size is set to %lu",
                           (unsigned long)self->incr_pos, (unsigned long)self->max_size);

                  if (!INCR_DONE (self))
                    {
                      // as an optimisation, do not accumulate white space in the incr buffer
                      if (self->incr_mode == INCR_M_WS && self->incr_pos)
                        {
                          self->incr_pos = 0;
                          SvCUR_set (self->incr_text, 0);
                        }

                      break;
                    }
                }

              PUTBACK; sv = decode_json (aTHX_ self->incr_text, self, &offset); SPAGAIN;
              XPUSHs (sv);

              self->incr_pos -= offset;
              self->incr_nest = 0;
              self->incr_mode = 0;

              sv_chop (self->incr_text, SvPVX (self->incr_text) + offset);
            }
          while (GIMME_V == G_ARRAY);
}
#line 3080 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_incr_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_incr_text)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	JSON *	self;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2575 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
        if (self->incr_pos)
          croak ("incr_text can not be called when the incremental parser already started parsing");

        RETVAL = self->incr_text ? SvREFCNT_inc (self->incr_text) : &PL_sv_undef;
}
#line 3113 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_JSON__XS_incr_skip); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_incr_skip)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	JSON *	self;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2586 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
        if (self->incr_pos)
          {
            sv_chop (self->incr_text, SvPV_nolen (self->incr_text) + self->incr_pos);
            self->incr_pos  = 0;
            self->incr_nest = 0;
            self->incr_mode = 0;
          }
}
#line 3149 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_JSON__XS_incr_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_incr_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	JSON *	self;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2598 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
	SvREFCNT_dec (self->incr_text);
        self->incr_text = 0;
        self->incr_pos  = 0;
        self->incr_nest = 0;
        self->incr_mode = 0;
}
#line 3181 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_JSON__XS_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	JSON *	self;

	if (!(
           SvROK (ST(0))
           && SvOBJECT (SvRV (ST(0)))
           && (SvSTASH (SvRV (ST(0))) == JSON_STASH || sv_derived_from (ST(0), "JSON::XS"))
        ))
          croak ("object is not of type JSON::XS");
        /**/
        self = (JSON *)SvPVX (SvRV (ST(0)))
;
#line 2608 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
        SvREFCNT_dec (self->cb_sk_object);
        SvREFCNT_dec (self->cb_object);
        SvREFCNT_dec (self->incr_text);
#line 3209 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_JSON__XS_encode_json); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_encode_json)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scalar");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	scalar = ST(0)
;
#line 2616 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
        JSON json;
        json_init (&json);
        json.flags |= F_UTF8;
        PUTBACK; scalar = encode_json (aTHX_ scalar, &json); SPAGAIN;
        XPUSHs (scalar);
}
#line 3234 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_write_json); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_write_json)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "file_ref, scalar");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	file_ref = ST(0)
;
	SV *	scalar = ST(1)
;
#line 2626 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
   PerlIO* ofp = check_outfile(aTHX_ file_ref);
   JSON json;
   json_init (&json);
   json.flags |= F_UTF8;
   PUTBACK; encode_json (aTHX_ scalar, &json, ofp); SPAGAIN;
}
#line 3262 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_decode_json); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_decode_json)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "jsonstr");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	jsonstr = ST(0)
;
#line 2636 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
        JSON json;
        json_init (&json);
        json.flags |= F_UTF8;
        PUTBACK; jsonstr = decode_json (aTHX_ jsonstr, &json, 0); SPAGAIN;
        XPUSHs (jsonstr);
}
#line 3288 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_set_multiline_flag); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_set_multiline_flag)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ref, multiline");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	ref = ST(0)
;
	I32	multiline = (I32)SvIV(ST(1))
;
#line 2646 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
  SV* sv;
  if (SvROK(ref) && (sv = SvRV(ref), SvTYPE(sv) == SVt_PVAV || SvTYPE(sv) == SVt_PVHV)) {
    MAGIC* mg = mg_findext(sv, PERL_MAGIC_ext, &format_flags_vtbl);
    if (!mg)
      mg = sv_magicext(sv, nullptr, PERL_MAGIC_ext, &format_flags_vtbl, nullptr, 0);
    mg->mg_len = multiline ? F_INDENT | F_SPACE_AFTER : F_SPACE_AFTER;

  } else {
    croak_xs_usage(cv, "\\@array || \\%hash, boolean");
  }
}
#line 3321 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_get_attached_comments); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_get_attached_comments)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	val = ST(0)
;
#line 2661 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
  if (SvTYPE(val) >= SVt_PVMG) {
    MAGIC* mg = mg_findext(val, PERL_MAGIC_ext, &attached_comments_vtbl);
    if (mg && mg->mg_obj && SvROK(mg->mg_obj)) {
      SV* ret = sv_mortalcopy(mg->mg_obj);
      PUSHs(ret);
    }
  }
}
#line 3349 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_JSON__XS_attach_comments); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_JSON__XS_attach_comments)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "val, comments_ref");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	val = ST(0)
;
	SV *	comments_ref = ST(1)
;
#line 2673 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
  if (!SvROK(comments_ref) || SvTYPE(SvRV(comments_ref)) != SVt_PVAV)
    croak_xs_usage(cv, "$val, \\@array");
  sv_magicext(val, comments_ref, PERL_MAGIC_ext, &attached_comments_vtbl, nullptr, 0);
}
#line 3375 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_JSON__XS); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_JSON__XS)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("JSON::XS::CLONE", XS_JSON__XS_CLONE);
        newXS_deffile("JSON::XS::new", XS_JSON__XS_new);
        cv = newXS_deffile("JSON::XS::allow_blessed", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_ALLOW_BLESSED;
        cv = newXS_deffile("JSON::XS::allow_nonref", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_ALLOW_NONREF;
        cv = newXS_deffile("JSON::XS::allow_tags", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_ALLOW_TAGS;
        cv = newXS_deffile("JSON::XS::allow_unknown", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_ALLOW_UNKNOWN;
        cv = newXS_deffile("JSON::XS::ascii", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_ASCII;
        cv = newXS_deffile("JSON::XS::canonical", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_CANONICAL;
        cv = newXS_deffile("JSON::XS::convert_blessed", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_CONV_BLESSED;
        cv = newXS_deffile("JSON::XS::indent", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_INDENT;
        cv = newXS_deffile("JSON::XS::latin1", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_LATIN1;
        cv = newXS_deffile("JSON::XS::pretty", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_PRETTY;
        cv = newXS_deffile("JSON::XS::relaxed", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_RELAXED;
        cv = newXS_deffile("JSON::XS::shrink", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_SHRINK;
        cv = newXS_deffile("JSON::XS::space_after", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_SPACE_AFTER;
        cv = newXS_deffile("JSON::XS::space_before", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_SPACE_BEFORE;
        cv = newXS_deffile("JSON::XS::utf8", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_UTF8;
        cv = newXS_deffile("JSON::XS::with_comments", XS_JSON__XS_ascii);
        XSANY.any_i32 = F_WITH_COMMENTS;
        cv = newXS_deffile("JSON::XS::get_allow_blessed", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_ALLOW_BLESSED;
        cv = newXS_deffile("JSON::XS::get_allow_nonref", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_ALLOW_NONREF;
        cv = newXS_deffile("JSON::XS::get_allow_tags", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_ALLOW_TAGS;
        cv = newXS_deffile("JSON::XS::get_allow_unknown", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_ALLOW_UNKNOWN;
        cv = newXS_deffile("JSON::XS::get_ascii", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_ASCII;
        cv = newXS_deffile("JSON::XS::get_canonical", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_CANONICAL;
        cv = newXS_deffile("JSON::XS::get_convert_blessed", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_CONV_BLESSED;
        cv = newXS_deffile("JSON::XS::get_indent", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_INDENT;
        cv = newXS_deffile("JSON::XS::get_latin1", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_LATIN1;
        cv = newXS_deffile("JSON::XS::get_relaxed", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_RELAXED;
        cv = newXS_deffile("JSON::XS::get_shrink", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_SHRINK;
        cv = newXS_deffile("JSON::XS::get_space_after", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_SPACE_AFTER;
        cv = newXS_deffile("JSON::XS::get_space_before", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_SPACE_BEFORE;
        cv = newXS_deffile("JSON::XS::get_utf8", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_UTF8;
        cv = newXS_deffile("JSON::XS::get_with_comments", XS_JSON__XS_get_ascii);
        XSANY.any_i32 = F_WITH_COMMENTS;
        newXS_deffile("JSON::XS::max_depth", XS_JSON__XS_max_depth);
        newXS_deffile("JSON::XS::get_max_depth", XS_JSON__XS_get_max_depth);
        newXS_deffile("JSON::XS::max_size", XS_JSON__XS_max_size);
        newXS_deffile("JSON::XS::get_max_size", XS_JSON__XS_get_max_size);
        newXS_deffile("JSON::XS::filter_json_object", XS_JSON__XS_filter_json_object);
        newXS_deffile("JSON::XS::filter_json_single_key_object", XS_JSON__XS_filter_json_single_key_object);
        newXS_deffile("JSON::XS::encode", XS_JSON__XS_encode);
        newXS_deffile("JSON::XS::write", XS_JSON__XS_write);
        newXS_deffile("JSON::XS::decode", XS_JSON__XS_decode);
        newXS_deffile("JSON::XS::decode_prefix", XS_JSON__XS_decode_prefix);
        newXS_deffile("JSON::XS::incr_parse", XS_JSON__XS_incr_parse);
        cv = newXS_deffile("JSON::XS::incr_text", XS_JSON__XS_incr_text);
        apply_attrs_string("JSON::XS", cv, "lvalue", 0);
        newXS_deffile("JSON::XS::incr_skip", XS_JSON__XS_incr_skip);
        newXS_deffile("JSON::XS::incr_reset", XS_JSON__XS_incr_reset);
        newXS_deffile("JSON::XS::DESTROY", XS_JSON__XS_DESTROY);
        (void)newXSproto_portable("JSON::XS::encode_json", XS_JSON__XS_encode_json, file, "$");
        (void)newXSproto_portable("JSON::XS::write_json", XS_JSON__XS_write_json, file, "$$");
        (void)newXSproto_portable("JSON::XS::decode_json", XS_JSON__XS_decode_json, file, "$");
        (void)newXSproto_portable("JSON::XS::set_multiline_flag", XS_JSON__XS_set_multiline_flag, file, "$$");
        (void)newXSproto_portable("JSON::XS::get_attached_comments", XS_JSON__XS_get_attached_comments, file, "$");
        (void)newXSproto_portable("JSON::XS::attach_comments", XS_JSON__XS_attach_comments, file, "$$");

    /* Initialisation Section */

#line 2313 "/build/polymake/src/polymake-4.15/lib/core/src/perl/JSON-XS.xxs"
{
	int i;

        for (i = 0; i < 256; ++i)
          decode_hexdigit [i] =
            i >= '0' && i <= '9' ? i - '0'
            : i >= 'a' && i <= 'f' ? i - 'a' + 10
            : i >= 'A' && i <= 'F' ? i - 'A' + 10
            : -1;

	json_stash = gv_stashpv("JSON::XS", 1);
	bool_stash = gv_stashpv("boolean", 1);
        bool_true  = &PL_sv_yes;
        bool_false = &PL_sv_no;

        sv_json = newSVpv ("JSON", 0);
        SvREADONLY_on (sv_json);
        if (PL_DBgv) {
          CvNODEBUG_on (get_cv ("JSON::XS::incr_text", 0)); /* the debugger completely breaks lvalue subs */
        }
}

#line 3521 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/JSON-XS.cc"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
