// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkStreamLines_gs.h"

const char *vtkStreamLines_gs =
"// clang-format off\n"
"//VTK::System::Dec\n"
"//VTK::Output::Dec\n"
"// clang-format on\n"
"\n"
"in vec3 vertexColorVSOutput[];\n"
"\n"
"out vec3 vertexColorGSOutput;\n"
"\n"
"uniform vec2 lineWidthNVC;\n"
"\n"
"layout(lines) in;\n"
"layout(triangle_strip, max_vertices = 4) out;\n"
"\n"
"void main()\n"
"{\n"
"  // compute the lines direction\n"
"  vec2 normal = normalize(gl_in[1].gl_Position.xy / gl_in[1].gl_Position.w -\n"
"    gl_in[0].gl_Position.xy / gl_in[0].gl_Position.w);\n"
"\n"
"  // rotate 90 degrees\n"
"  normal = vec2(-1.0 * normal.y, normal.x);\n"
"\n"
"  for (int j = 0; j < 4; j++)\n"
"  {\n"
"    int i = j / 2;\n"
"\n"
"    vertexColorGSOutput = vertexColorVSOutput[i];\n"
"\n"
"    gl_Position = vec4(gl_in[i].gl_Position.xy +\n"
"        (lineWidthNVC * normal) * ((j + 1) % 2 - 0.5) * gl_in[i].gl_Position.w,\n"
"      gl_in[i].gl_Position.z, gl_in[i].gl_Position.w);\n"
"\n"
"    EmitVertex();\n"
"  }\n"
"  EndPrimitive();\n"
"}\n"
"";
