// python wrapper for vtkSpyPlotReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSpyPlotReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSpyPlotReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSpyPlotReader_ClassNew(); }


static PyObject *
PyvtkSpyPlotReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSpyPlotReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSpyPlotReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSpyPlotReader *tempr = vtkSpyPlotReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSpyPlotReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSpyPlotReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSpyPlotReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSpyPlotReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_PrintBlockList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrintBlockList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  vtkNonOverlappingAMR *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkNonOverlappingAMR") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->PrintBlockList(temp0, temp1);
    }
    else
    {
      op->vtkSpyPlotReader::PrintBlockList(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkSpyPlotReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeStep(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetTimeStep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStep() :
      op->vtkSpyPlotReader::GetTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetDistributeFiles(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDistributeFiles");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDistributeFiles(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetDistributeFiles(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetDistributeFiles(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDistributeFiles");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDistributeFiles() :
      op->vtkSpyPlotReader::GetDistributeFiles());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_DistributeFilesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DistributeFilesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DistributeFilesOn();
    }
    else
    {
      op->vtkSpyPlotReader::DistributeFilesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_DistributeFilesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DistributeFilesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DistributeFilesOff();
    }
    else
    {
      op->vtkSpyPlotReader::DistributeFilesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetGenerateLevelArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateLevelArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateLevelArray(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetGenerateLevelArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetGenerateLevelArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateLevelArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateLevelArray() :
      op->vtkSpyPlotReader::GetGenerateLevelArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateLevelArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateLevelArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateLevelArrayOn();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateLevelArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateLevelArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateLevelArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateLevelArrayOff();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateLevelArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetGenerateBlockIdArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateBlockIdArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateBlockIdArray(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetGenerateBlockIdArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetGenerateBlockIdArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateBlockIdArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateBlockIdArray() :
      op->vtkSpyPlotReader::GetGenerateBlockIdArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateBlockIdArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateBlockIdArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateBlockIdArrayOn();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateBlockIdArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateBlockIdArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateBlockIdArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateBlockIdArrayOff();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateBlockIdArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetGenerateActiveBlockArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateActiveBlockArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateActiveBlockArray(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetGenerateActiveBlockArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetGenerateActiveBlockArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateActiveBlockArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateActiveBlockArray() :
      op->vtkSpyPlotReader::GetGenerateActiveBlockArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateActiveBlockArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateActiveBlockArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateActiveBlockArrayOn();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateActiveBlockArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateActiveBlockArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateActiveBlockArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateActiveBlockArrayOff();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateActiveBlockArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetGenerateTracerArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateTracerArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateTracerArray(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetGenerateTracerArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetGenerateTracerArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateTracerArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateTracerArray() :
      op->vtkSpyPlotReader::GetGenerateTracerArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateTracerArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateTracerArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateTracerArrayOn();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateTracerArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateTracerArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateTracerArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateTracerArrayOff();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateTracerArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetGenerateMarkers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateMarkers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateMarkers(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetGenerateMarkers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetGenerateMarkers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateMarkers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateMarkers() :
      op->vtkSpyPlotReader::GetGenerateMarkers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateMarkersOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateMarkersOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateMarkersOn();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateMarkersOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GenerateMarkersOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateMarkersOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateMarkersOff();
    }
    else
    {
      op->vtkSpyPlotReader::GenerateMarkersOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetDownConvertVolumeFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDownConvertVolumeFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDownConvertVolumeFraction(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetDownConvertVolumeFraction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetDownConvertVolumeFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDownConvertVolumeFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDownConvertVolumeFraction() :
      op->vtkSpyPlotReader::GetDownConvertVolumeFraction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_DownConvertVolumeFractionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DownConvertVolumeFractionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DownConvertVolumeFractionOn();
    }
    else
    {
      op->vtkSpyPlotReader::DownConvertVolumeFractionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_DownConvertVolumeFractionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DownConvertVolumeFractionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DownConvertVolumeFractionOff();
    }
    else
    {
      op->vtkSpyPlotReader::DownConvertVolumeFractionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetComputeDerivedVariables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeDerivedVariables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeDerivedVariables(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetComputeDerivedVariables(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetComputeDerivedVariables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeDerivedVariables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetComputeDerivedVariables() :
      op->vtkSpyPlotReader::GetComputeDerivedVariables());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_ComputeDerivedVariablesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeDerivedVariablesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ComputeDerivedVariablesOn();
    }
    else
    {
      op->vtkSpyPlotReader::ComputeDerivedVariablesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_ComputeDerivedVariablesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeDerivedVariablesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ComputeDerivedVariablesOff();
    }
    else
    {
      op->vtkSpyPlotReader::ComputeDerivedVariablesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetMergeXYZComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMergeXYZComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMergeXYZComponents(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetMergeXYZComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetMergeXYZComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMergeXYZComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMergeXYZComponents() :
      op->vtkSpyPlotReader::GetMergeXYZComponents());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_MergeXYZComponentsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MergeXYZComponentsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MergeXYZComponentsOn();
    }
    else
    {
      op->vtkSpyPlotReader::MergeXYZComponentsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_MergeXYZComponentsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MergeXYZComponentsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MergeXYZComponentsOff();
    }
    else
    {
      op->vtkSpyPlotReader::MergeXYZComponentsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetTimeStepRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTimeStepRange() :
      op->vtkSpyPlotReader::GetTimeStepRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetNumberOfCellArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCellArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfCellArrays() :
      op->vtkSpyPlotReader::GetNumberOfCellArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetCellArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCellArrayName(temp0) :
      op->vtkSpyPlotReader::GetCellArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_GetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCellArrayStatus(temp0) :
      op->vtkSpyPlotReader::GetCellArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCellArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkSpyPlotReader::SetCellArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_SetGlobalController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGlobalController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetGlobalController(temp0);
    }
    else
    {
      op->vtkSpyPlotReader::SetGlobalController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotReader_CanReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotReader *op = static_cast<vtkSpyPlotReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->CanReadFile(temp0) :
      op->vtkSpyPlotReader::CanReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSpyPlotReader_Methods[] = {
  {"IsTypeOf", PyvtkSpyPlotReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSpyPlotReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSpyPlotReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSpyPlotReader\nC++: static vtkSpyPlotReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSpyPlotReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSpyPlotReader\nC++: vtkSpyPlotReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSpyPlotReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSpyPlotReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"PrintBlockList", PyvtkSpyPlotReader_PrintBlockList, METH_VARARGS,
   "PrintBlockList(self, hbds:vtkNonOverlappingAMR, myProcId:int)\n    -> None\nC++: void PrintBlockList(vtkNonOverlappingAMR *hbds, int myProcId)\n\n"},
  {"SetFileName", PyvtkSpyPlotReader_SetFileName, METH_VARARGS,
   "SetFileName(self, filename:str) -> None\nC++: virtual void SetFileName(const char *filename)\n\nGet and set the file name. It is either the name of the case file\nor the name of the single binary file.\n"},
  {"GetFileName", PyvtkSpyPlotReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetTimeStep", PyvtkSpyPlotReader_SetTimeStep, METH_VARARGS,
   "SetTimeStep(self, _arg:int) -> None\nC++: virtual void SetTimeStep(int _arg)\n\nSet and get the time step. The time step is an index, NOT a time\ngiven in seconds.\n"},
  {"GetTimeStep", PyvtkSpyPlotReader_GetTimeStep, METH_VARARGS,
   "GetTimeStep(self) -> int\nC++: virtual int GetTimeStep()\n\n"},
  {"SetDistributeFiles", PyvtkSpyPlotReader_SetDistributeFiles, METH_VARARGS,
   "SetDistributeFiles(self, _arg:int) -> None\nC++: virtual void SetDistributeFiles(int _arg)\n\nIf true, the reader distributes files over processors. If false,\nthe reader distributes blocks over processors. Default is false.\nDistributing blocks should provide a better load balancing: if\nthere is only one file and several processors, only the first\nprocessor is used in the case of the file-distributed method.\n"},
  {"GetDistributeFiles", PyvtkSpyPlotReader_GetDistributeFiles, METH_VARARGS,
   "GetDistributeFiles(self) -> int\nC++: virtual int GetDistributeFiles()\n\n"},
  {"DistributeFilesOn", PyvtkSpyPlotReader_DistributeFilesOn, METH_VARARGS,
   "DistributeFilesOn(self) -> None\nC++: virtual void DistributeFilesOn()\n\n"},
  {"DistributeFilesOff", PyvtkSpyPlotReader_DistributeFilesOff, METH_VARARGS,
   "DistributeFilesOff(self) -> None\nC++: virtual void DistributeFilesOff()\n\n"},
  {"SetGenerateLevelArray", PyvtkSpyPlotReader_SetGenerateLevelArray, METH_VARARGS,
   "SetGenerateLevelArray(self, _arg:int) -> None\nC++: virtual void SetGenerateLevelArray(int _arg)\n\nIf true, the reader generate a cell array in each block that\nstores the level in the hierarchy, starting from 0. False by\ndefault.\n"},
  {"GetGenerateLevelArray", PyvtkSpyPlotReader_GetGenerateLevelArray, METH_VARARGS,
   "GetGenerateLevelArray(self) -> int\nC++: virtual int GetGenerateLevelArray()\n\n"},
  {"GenerateLevelArrayOn", PyvtkSpyPlotReader_GenerateLevelArrayOn, METH_VARARGS,
   "GenerateLevelArrayOn(self) -> None\nC++: virtual void GenerateLevelArrayOn()\n\n"},
  {"GenerateLevelArrayOff", PyvtkSpyPlotReader_GenerateLevelArrayOff, METH_VARARGS,
   "GenerateLevelArrayOff(self) -> None\nC++: virtual void GenerateLevelArrayOff()\n\n"},
  {"SetGenerateBlockIdArray", PyvtkSpyPlotReader_SetGenerateBlockIdArray, METH_VARARGS,
   "SetGenerateBlockIdArray(self, _arg:int) -> None\nC++: virtual void SetGenerateBlockIdArray(int _arg)\n\nIf true, the reader generate a cell array in each block that\nstores a unique but not necessarily contiguous id. False by\ndefault.\n"},
  {"GetGenerateBlockIdArray", PyvtkSpyPlotReader_GetGenerateBlockIdArray, METH_VARARGS,
   "GetGenerateBlockIdArray(self) -> int\nC++: virtual int GetGenerateBlockIdArray()\n\n"},
  {"GenerateBlockIdArrayOn", PyvtkSpyPlotReader_GenerateBlockIdArrayOn, METH_VARARGS,
   "GenerateBlockIdArrayOn(self) -> None\nC++: virtual void GenerateBlockIdArrayOn()\n\n"},
  {"GenerateBlockIdArrayOff", PyvtkSpyPlotReader_GenerateBlockIdArrayOff, METH_VARARGS,
   "GenerateBlockIdArrayOff(self) -> None\nC++: virtual void GenerateBlockIdArrayOff()\n\n"},
  {"SetGenerateActiveBlockArray", PyvtkSpyPlotReader_SetGenerateActiveBlockArray, METH_VARARGS,
   "SetGenerateActiveBlockArray(self, _arg:int) -> None\nC++: virtual void SetGenerateActiveBlockArray(int _arg)\n\nIf true, the reader generate a cell array in each block that\ncorresponds to the Active field in the file. False by default.\n"},
  {"GetGenerateActiveBlockArray", PyvtkSpyPlotReader_GetGenerateActiveBlockArray, METH_VARARGS,
   "GetGenerateActiveBlockArray(self) -> int\nC++: virtual int GetGenerateActiveBlockArray()\n\n"},
  {"GenerateActiveBlockArrayOn", PyvtkSpyPlotReader_GenerateActiveBlockArrayOn, METH_VARARGS,
   "GenerateActiveBlockArrayOn(self) -> None\nC++: virtual void GenerateActiveBlockArrayOn()\n\n"},
  {"GenerateActiveBlockArrayOff", PyvtkSpyPlotReader_GenerateActiveBlockArrayOff, METH_VARARGS,
   "GenerateActiveBlockArrayOff(self) -> None\nC++: virtual void GenerateActiveBlockArrayOff()\n\n"},
  {"SetGenerateTracerArray", PyvtkSpyPlotReader_SetGenerateTracerArray, METH_VARARGS,
   "SetGenerateTracerArray(self, _arg:int) -> None\nC++: virtual void SetGenerateTracerArray(int _arg)\n\nIf true, the reader will extract tracer data at each time step\nand include a field data array for the tracers at that time.\n"},
  {"GetGenerateTracerArray", PyvtkSpyPlotReader_GetGenerateTracerArray, METH_VARARGS,
   "GetGenerateTracerArray(self) -> int\nC++: virtual int GetGenerateTracerArray()\n\n"},
  {"GenerateTracerArrayOn", PyvtkSpyPlotReader_GenerateTracerArrayOn, METH_VARARGS,
   "GenerateTracerArrayOn(self) -> None\nC++: virtual void GenerateTracerArrayOn()\n\n"},
  {"GenerateTracerArrayOff", PyvtkSpyPlotReader_GenerateTracerArrayOff, METH_VARARGS,
   "GenerateTracerArrayOff(self) -> None\nC++: virtual void GenerateTracerArrayOff()\n\n"},
  {"SetGenerateMarkers", PyvtkSpyPlotReader_SetGenerateMarkers, METH_VARARGS,
   "SetGenerateMarkers(self, gm:int) -> None\nC++: void SetGenerateMarkers(int gm)\n\nif true, the reader will extract the marker data at each time\nstep and create a set of vtkPoints in the second output port.\n"},
  {"GetGenerateMarkers", PyvtkSpyPlotReader_GetGenerateMarkers, METH_VARARGS,
   "GetGenerateMarkers(self) -> int\nC++: virtual int GetGenerateMarkers()\n\n"},
  {"GenerateMarkersOn", PyvtkSpyPlotReader_GenerateMarkersOn, METH_VARARGS,
   "GenerateMarkersOn(self) -> None\nC++: virtual void GenerateMarkersOn()\n\n"},
  {"GenerateMarkersOff", PyvtkSpyPlotReader_GenerateMarkersOff, METH_VARARGS,
   "GenerateMarkersOff(self) -> None\nC++: virtual void GenerateMarkersOff()\n\n"},
  {"SetDownConvertVolumeFraction", PyvtkSpyPlotReader_SetDownConvertVolumeFraction, METH_VARARGS,
   "SetDownConvertVolumeFraction(self, vf:int) -> None\nC++: void SetDownConvertVolumeFraction(int vf)\n\nIf true, the reader will convert volume fraction arrays to\nunsigned char. True by default.\n"},
  {"GetDownConvertVolumeFraction", PyvtkSpyPlotReader_GetDownConvertVolumeFraction, METH_VARARGS,
   "GetDownConvertVolumeFraction(self) -> int\nC++: virtual int GetDownConvertVolumeFraction()\n\n"},
  {"DownConvertVolumeFractionOn", PyvtkSpyPlotReader_DownConvertVolumeFractionOn, METH_VARARGS,
   "DownConvertVolumeFractionOn(self) -> None\nC++: virtual void DownConvertVolumeFractionOn()\n\n"},
  {"DownConvertVolumeFractionOff", PyvtkSpyPlotReader_DownConvertVolumeFractionOff, METH_VARARGS,
   "DownConvertVolumeFractionOff(self) -> None\nC++: virtual void DownConvertVolumeFractionOff()\n\n"},
  {"SetComputeDerivedVariables", PyvtkSpyPlotReader_SetComputeDerivedVariables, METH_VARARGS,
   "SetComputeDerivedVariables(self, _arg:int) -> None\nC++: virtual void SetComputeDerivedVariables(int _arg)\n\nIf true, the reader will calculate all derived variables it can\ngiven which properties the user has selected True by default.\n"},
  {"GetComputeDerivedVariables", PyvtkSpyPlotReader_GetComputeDerivedVariables, METH_VARARGS,
   "GetComputeDerivedVariables(self) -> int\nC++: virtual int GetComputeDerivedVariables()\n\n"},
  {"ComputeDerivedVariablesOn", PyvtkSpyPlotReader_ComputeDerivedVariablesOn, METH_VARARGS,
   "ComputeDerivedVariablesOn(self) -> None\nC++: virtual void ComputeDerivedVariablesOn()\n\n"},
  {"ComputeDerivedVariablesOff", PyvtkSpyPlotReader_ComputeDerivedVariablesOff, METH_VARARGS,
   "ComputeDerivedVariablesOff(self) -> None\nC++: virtual void ComputeDerivedVariablesOff()\n\n"},
  {"SetMergeXYZComponents", PyvtkSpyPlotReader_SetMergeXYZComponents, METH_VARARGS,
   "SetMergeXYZComponents(self, merge:int) -> None\nC++: void SetMergeXYZComponents(int merge)\n\nIf true, the reader will merge scalar arrays named, for example, \"X\nvelocity\" \"Y velocity\" and \"Z velocity\" into a vector array named\n\"velocity\" with scalar components X, Y and Z. It will also merge\nX and Y scalar arrays (with no Z component) into a vector with\nscalar components X, Y and 0. True by default.\n"},
  {"GetMergeXYZComponents", PyvtkSpyPlotReader_GetMergeXYZComponents, METH_VARARGS,
   "GetMergeXYZComponents(self) -> int\nC++: virtual int GetMergeXYZComponents()\n\n"},
  {"MergeXYZComponentsOn", PyvtkSpyPlotReader_MergeXYZComponentsOn, METH_VARARGS,
   "MergeXYZComponentsOn(self) -> None\nC++: virtual void MergeXYZComponentsOn()\n\n"},
  {"MergeXYZComponentsOff", PyvtkSpyPlotReader_MergeXYZComponentsOff, METH_VARARGS,
   "MergeXYZComponentsOff(self) -> None\nC++: virtual void MergeXYZComponentsOff()\n\n"},
  {"GetTimeStepRange", PyvtkSpyPlotReader_GetTimeStepRange, METH_VARARGS,
   "GetTimeStepRange(self) -> (int, int)\nC++: virtual int *GetTimeStepRange()\n\nGet the time step range.\n"},
  {"GetNumberOfCellArrays", PyvtkSpyPlotReader_GetNumberOfCellArrays, METH_VARARGS,
   "GetNumberOfCellArrays(self) -> int\nC++: int GetNumberOfCellArrays()\n\nCell array selection\n"},
  {"GetCellArrayName", PyvtkSpyPlotReader_GetCellArrayName, METH_VARARGS,
   "GetCellArrayName(self, idx:int) -> str\nC++: const char *GetCellArrayName(int idx)\n\n"},
  {"GetCellArrayStatus", PyvtkSpyPlotReader_GetCellArrayStatus, METH_VARARGS,
   "GetCellArrayStatus(self, name:str) -> int\nC++: int GetCellArrayStatus(const char *name)\n\n"},
  {"SetCellArrayStatus", PyvtkSpyPlotReader_SetCellArrayStatus, METH_VARARGS,
   "SetCellArrayStatus(self, name:str, status:int) -> None\nC++: void SetCellArrayStatus(const char *name, int status)\n\n"},
  {"SetGlobalController", PyvtkSpyPlotReader_SetGlobalController, METH_VARARGS,
   "SetGlobalController(self, controller:vtkMultiProcessController)\n    -> None\nC++: void SetGlobalController(\n    vtkMultiProcessController *controller)\n\nSet the controller used to coordinate parallel reading. The \"global\ncontroller\" has all processes while the \"controller\" has only\nthose who have blocks.\n"},
  {"CanReadFile", PyvtkSpyPlotReader_CanReadFile, METH_VARARGS,
   "CanReadFile(self, fname:str) -> int\nC++: virtual int CanReadFile(const char *fname)\n\nDetermine if the file can be read with this reader.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSpyPlotReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetTimeStep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetTimeStep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeStep/SetTimeStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("distribute_files"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetDistributeFiles(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetDistributeFiles(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetDistributeFiles(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDistributeFiles/SetDistributeFiles\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_level_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetGenerateLevelArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetGenerateLevelArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetGenerateLevelArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateLevelArray/SetGenerateLevelArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_block_id_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetGenerateBlockIdArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetGenerateBlockIdArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetGenerateBlockIdArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateBlockIdArray/SetGenerateBlockIdArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_active_block_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetGenerateActiveBlockArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetGenerateActiveBlockArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetGenerateActiveBlockArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateActiveBlockArray/SetGenerateActiveBlockArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_tracer_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetGenerateTracerArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetGenerateTracerArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetGenerateTracerArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateTracerArray/SetGenerateTracerArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_markers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetGenerateMarkers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetGenerateMarkers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetGenerateMarkers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateMarkers/SetGenerateMarkers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("down_convert_volume_fraction"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetDownConvertVolumeFraction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetDownConvertVolumeFraction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetDownConvertVolumeFraction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDownConvertVolumeFraction/SetDownConvertVolumeFraction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_derived_variables"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetComputeDerivedVariables(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetComputeDerivedVariables(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetComputeDerivedVariables(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeDerivedVariables/SetComputeDerivedVariables\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("merge_xyz_components"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetMergeXYZComponents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetMergeXYZComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetMergeXYZComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMergeXYZComponents/SetMergeXYZComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_controller"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotReader_SetGlobalController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotReader_SetGlobalController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGlobalController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetTimeStepRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeStepRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cell_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotReader_GetNumberOfCellArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCellArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSpyPlotReader_Doc =
  "vtkSpyPlotReader - Read SPCTH Spy Plot file format\n\n"
  "Superclass: vtkCompositeDataSetAlgorithm\n\n"
  "vtkSpyPlotReader is a reader that reads SPCTH Spy Plot file format\n"
  "through an ascii meta file called the \"case\" file (extension .spcth).\n"
  "This case file lists all the actual binary files that describe a\n"
  "dataset. Each binary file describes a part of the dataset. However,\n"
  "if only a single binary file describes the whole dataset, it is\n"
  "possible to load it directly without using a case file.\n\n"
  "The reader supports both Spy dataset types: flat mesh and AMR\n"
  "(Adaptive Mesh Refinement).\n\n"
  "It has parallel capabilities. Each processor is supposed to have\n"
  "access to the case file and to all the binary files. All the binary\n"
  "files have to be coherent: they describe the same fields of data.\n"
  "Each binary file may content multiple time stamp. The time stamp to\n"
  "read is specified with SetTimestamp().\n\n"
  "In parallel mode, there are two ways to distribute data over\n"
  "processors (controlled by SetDistributeFiles() ):\n"
  "- either by distributing blocks: all processors read all the files,\n"
  "  but only some number of blocks per files. Hence, load balancing is\n"
  "  good even if there is only one file.\n"
  "- or by distributing files: a file is read entirely by one processor.\n"
  "If there is only one file, all the other processors are not used at\n"
  "  all.\n\n"
  "@par Implementation Details:\n"
  "- All processors read the first binary file listed in the case file\n"
  "  to get information about the fields.\n"
  "- Each block of data is already surrounded by ghost cells in the\n"
  "  file, even on part of the block that don't have actual neighbor\n"
  "  cells. The reader removes those wrong ghost cells.\n"
  "- Each time step contains all the cell array name variables\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSpyPlotReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsIOSPCTH.vtkSpyPlotReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSpyPlotReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSpyPlotReader_StaticNew()
{
  return vtkSpyPlotReader::New();
}

PyObject *PyvtkSpyPlotReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSpyPlotReader_Type, PyvtkSpyPlotReader_Methods,
    "vtkSpyPlotReader",
 &PyvtkSpyPlotReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkCompositeDataSetAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSpyPlotReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSpyPlotReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSpyPlotReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSpyPlotReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

