// python wrapper for vtkMaterialInterfaceToProcMap
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkMaterialInterfaceToProcMap.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMaterialInterfaceToProcMap(PyObject *dict); }

static PyObject *
PyvtkMaterialInterfaceToProcMap_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Clear();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceToProcMap_Initialize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->Initialize(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_Initialize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    op->Initialize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_Initialize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkMaterialInterfaceToProcMap_Initialize_s1(self, args);
    case 2:
      return PyvtkMaterialInterfaceToProcMap_Initialize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Initialize");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceToProcMap_DeepCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeepCopy");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  vtkMaterialInterfaceToProcMap *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkMaterialInterfaceToProcMap"))
  {
    op->DeepCopy(*temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}


static PyObject *
PyvtkMaterialInterfaceToProcMap_GetProcOwnsPiece_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcOwnsPiece");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = op->GetProcOwnsPiece(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_GetProcOwnsPiece_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcOwnsPiece");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    int tempr = op->GetProcOwnsPiece(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_GetProcOwnsPiece(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkMaterialInterfaceToProcMap_GetProcOwnsPiece_s1(self, args);
    case 2:
      return PyvtkMaterialInterfaceToProcMap_GetProcOwnsPiece_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetProcOwnsPiece");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProcOwnsPiece");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    op->SetProcOwnsPiece(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProcOwnsPiece");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->SetProcOwnsPiece(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece_s1(self, args);
    case 1:
      return PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetProcOwnsPiece");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceToProcMap_WhoHasAPiece_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WhoHasAPiece");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    std::vector<int> tempr = op->WhoHasAPiece(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_WhoHasAPiece_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WhoHasAPiece");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::vector<int> tempr = op->WhoHasAPiece(temp0);

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_WhoHasAPiece(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return PyvtkMaterialInterfaceToProcMap_WhoHasAPiece_s1(self, args);
    case 1:
      return PyvtkMaterialInterfaceToProcMap_WhoHasAPiece_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "WhoHasAPiece");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceToProcMap_GetProcCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcCount");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceToProcMap *op = static_cast<vtkMaterialInterfaceToProcMap *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = op->GetProcCount(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceToProcMap_Methods[] = {
  {"Clear", PyvtkMaterialInterfaceToProcMap_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: void Clear()\n\n"},
  {"Initialize", PyvtkMaterialInterfaceToProcMap_Initialize, METH_VARARGS,
   "Initialize(self, nFragments:int) -> None\nC++: void Initialize(int nFragments)\nInitialize(self, nProcs:int, nFragments:int) -> None\nC++: void Initialize(int nProcs, int nFragments)\n\n"},
  {"DeepCopy", PyvtkMaterialInterfaceToProcMap_DeepCopy, METH_VARARGS,
   "DeepCopy(self, from_:vtkMaterialInterfaceToProcMap) -> None\nC++: void DeepCopy(const vtkMaterialInterfaceToProcMap &from)\n\n"},
  {"GetProcOwnsPiece", PyvtkMaterialInterfaceToProcMap_GetProcOwnsPiece, METH_VARARGS,
   "GetProcOwnsPiece(self, fragmentId:int) -> int\nC++: int GetProcOwnsPiece(int fragmentId)\nGetProcOwnsPiece(self, procId:int, fragmentId:int) -> int\nC++: int GetProcOwnsPiece(int procId, int fragmentId)\n\n"},
  {"SetProcOwnsPiece", PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece, METH_VARARGS,
   "SetProcOwnsPiece(self, procId:int, fragmentId:int) -> None\nC++: void SetProcOwnsPiece(int procId, int fragmentId)\nSetProcOwnsPiece(self, fragmentId:int) -> None\nC++: void SetProcOwnsPiece(int fragmentId)\n\n"},
  {"WhoHasAPiece", PyvtkMaterialInterfaceToProcMap_WhoHasAPiece, METH_VARARGS,
   "WhoHasAPiece(self, fragmentId:int, excludeProc:int) -> (int, ...)\nC++: std::vector<int> WhoHasAPiece(int fragmentId,\n    int excludeProc)\nWhoHasAPiece(self, fragmentId:int) -> (int, ...)\nC++: std::vector<int> WhoHasAPiece(int fragmentId)\n\n"},
  {"GetProcCount", PyvtkMaterialInterfaceToProcMap_GetProcCount, METH_VARARGS,
   "GetProcCount(self, fragmentId:int) -> int\nC++: int GetProcCount(int fragmentId)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMaterialInterfaceToProcMap_GetSets[] = {
  {
    /*name=*/pystr("proc_owns_piece"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetProcOwnsPiece\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("proc_owns_piece"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceToProcMap_SetProcOwnsPiece(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetProcOwnsPiece\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceToProcMap");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkMaterialInterfaceToProcMap *op = new vtkMaterialInterfaceToProcMap();

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceToProcMap", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceToProcMap");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkMaterialInterfaceToProcMap *op = new vtkMaterialInterfaceToProcMap(temp0);

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceToProcMap", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceToProcMap");

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkMaterialInterfaceToProcMap *op = new vtkMaterialInterfaceToProcMap(temp0, temp1);

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceToProcMap", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s4(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceToProcMap");

  vtkMaterialInterfaceToProcMap *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkMaterialInterfaceToProcMap"))
  {
    vtkMaterialInterfaceToProcMap *op = new vtkMaterialInterfaceToProcMap(*temp0);

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceToProcMap", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_Methods[] = {
  {"vtkMaterialInterfaceToProcMap", PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s2, METH_VARARGS,
   "@i"},
  {"vtkMaterialInterfaceToProcMap", PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s4, METH_VARARGS,
   "@W vtkMaterialInterfaceToProcMap"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s1(self, args);
    case 2:
      return PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_s3(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkMaterialInterfaceToProcMap");
  return nullptr;
}


static const char *PyvtkMaterialInterfaceToProcMap_Doc =

  "vtkMaterialInterfaceToProcMap() -> vtkMaterialInterfaceToProcMap\nC++: vtkMaterialInterfaceToProcMap()\nvtkMaterialInterfaceToProcMap(nFragments:int)\n    -> vtkMaterialInterfaceToProcMap\nC++: vtkMaterialInterfaceToProcMap(int nFragments)\nvtkMaterialInterfaceToProcMap(nProcs:int, nFragments:int)\n    -> vtkMaterialInterfaceToProcMap\nC++: vtkMaterialInterfaceToProcMap(int nProcs, int nFragments)\nvtkMaterialInterfaceToProcMap(other:vtkMaterialInterfaceToProcMap)\n    -> vtkMaterialInterfaceToProcMap\nC++: vtkMaterialInterfaceToProcMap(\n    const vtkMaterialInterfaceToProcMap &other)\n""\n"
  "vtkMaterialInterfaceToProcMap - no description provided.\n\n"
;

static PyObject *
PyvtkMaterialInterfaceToProcMap_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap(nullptr, args);
}

static void PyvtkMaterialInterfaceToProcMap_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkMaterialInterfaceToProcMap *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkMaterialInterfaceToProcMap_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMaterialInterfaceToProcMap_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersMaterialInterface.vtkMaterialInterfaceToProcMap", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkMaterialInterfaceToProcMap_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkMaterialInterfaceToProcMap_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkMaterialInterfaceToProcMap_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkMaterialInterfaceToProcMap_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkMaterialInterfaceToProcMap_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkMaterialInterfaceToProcMap(*static_cast<const vtkMaterialInterfaceToProcMap*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkMaterialInterfaceToProcMap_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMaterialInterfaceToProcMap_TypeNew(); }
#define DECLARED_PyvtkMaterialInterfaceToProcMap_TypeNew
#endif

PyObject *PyvtkMaterialInterfaceToProcMap_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkMaterialInterfaceToProcMap_Type,
    PyvtkMaterialInterfaceToProcMap_Methods,
    PyvtkMaterialInterfaceToProcMap_GetSets,
    PyvtkMaterialInterfaceToProcMap_vtkMaterialInterfaceToProcMap_Methods,
    &PyvtkMaterialInterfaceToProcMap_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMaterialInterfaceToProcMap(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMaterialInterfaceToProcMap_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkMaterialInterfaceToProcMap", o) != 0)
  {
    Py_DECREF(o);
  }

}

