/* GSettingsEngine.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GSettingsEngine.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GSETTINGS_CONFIGURATION_ENGINE_0_PROPERTY,
	GSETTINGS_CONFIGURATION_ENGINE_NUM_PROPERTIES
};
static GParamSpec* gsettings_configuration_engine_properties[GSETTINGS_CONFIGURATION_ENGINE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static gpointer gsettings_configuration_engine_parent_class = NULL;
static ConfigurationEngineIface * gsettings_configuration_engine_configuration_engine_parent_iface = NULL;

static void gsettings_configuration_engine_check_key_valid (GSettingsConfigurationEngine* self,
                                                     const gchar* schema,
                                                     const gchar* key,
                                                     GError** error);
static gboolean gsettings_configuration_engine_get_gs_bool (GSettingsConfigurationEngine* self,
                                                     const gchar* schema,
                                                     const gchar* key,
                                                     GError** error);
static void gsettings_configuration_engine_set_gs_bool (GSettingsConfigurationEngine* self,
                                                 const gchar* schema,
                                                 const gchar* key,
                                                 gboolean value,
                                                 GError** error);
static gint gsettings_configuration_engine_get_gs_int (GSettingsConfigurationEngine* self,
                                                const gchar* schema,
                                                const gchar* key,
                                                GError** error);
static void gsettings_configuration_engine_set_gs_int (GSettingsConfigurationEngine* self,
                                                const gchar* schema,
                                                const gchar* key,
                                                gint value,
                                                GError** error);
static gdouble gsettings_configuration_engine_get_gs_double (GSettingsConfigurationEngine* self,
                                                      const gchar* schema,
                                                      const gchar* key,
                                                      GError** error);
static void gsettings_configuration_engine_set_gs_double (GSettingsConfigurationEngine* self,
                                                   const gchar* schema,
                                                   const gchar* key,
                                                   gdouble value,
                                                   GError** error);
static gchar* gsettings_configuration_engine_get_gs_string (GSettingsConfigurationEngine* self,
                                                     const gchar* schema,
                                                     const gchar* key,
                                                     GError** error);
static void gsettings_configuration_engine_set_gs_string (GSettingsConfigurationEngine* self,
                                                   const gchar* schema,
                                                   const gchar* key,
                                                   const gchar* value,
                                                   GError** error);
static void gsettings_configuration_engine_reset_gs_to_default (GSettingsConfigurationEngine* self,
                                                         const gchar* schema,
                                                         const gchar* key,
                                                         GError** error);
static gchar* gsettings_configuration_engine_make_plugin_schema_name (const gchar* domain,
                                                               const gchar* id);
VALA_EXTERN gchar* plugins_pluggable_rep_clean_plugin_id (const gchar* id);
static gchar* gsettings_configuration_engine_make_gsettings_key (const gchar* gconf_key);
static gboolean gsettings_configuration_engine_real_get_plugin_bool (ConfigurationEngine* base,
                                                              const gchar* domain,
                                                              const gchar* id,
                                                              const gchar* key,
                                                              gboolean def);
static void gsettings_configuration_engine_real_set_plugin_bool (ConfigurationEngine* base,
                                                          const gchar* domain,
                                                          const gchar* id,
                                                          const gchar* key,
                                                          gboolean val);
static gdouble gsettings_configuration_engine_real_get_plugin_double (ConfigurationEngine* base,
                                                               const gchar* domain,
                                                               const gchar* id,
                                                               const gchar* key,
                                                               gdouble def);
static void gsettings_configuration_engine_real_set_plugin_double (ConfigurationEngine* base,
                                                            const gchar* domain,
                                                            const gchar* id,
                                                            const gchar* key,
                                                            gdouble val);
static gint gsettings_configuration_engine_real_get_plugin_int (ConfigurationEngine* base,
                                                         const gchar* domain,
                                                         const gchar* id,
                                                         const gchar* key,
                                                         gint def);
static void gsettings_configuration_engine_real_set_plugin_int (ConfigurationEngine* base,
                                                         const gchar* domain,
                                                         const gchar* id,
                                                         const gchar* key,
                                                         gint val);
static gchar* gsettings_configuration_engine_real_get_plugin_string (ConfigurationEngine* base,
                                                              const gchar* domain,
                                                              const gchar* id,
                                                              const gchar* key,
                                                              const gchar* def);
static void gsettings_configuration_engine_real_set_plugin_string (ConfigurationEngine* base,
                                                            const gchar* domain,
                                                            const gchar* id,
                                                            const gchar* key,
                                                            const gchar* val);
static void gsettings_configuration_engine_real_unset_plugin_key (ConfigurationEngine* base,
                                                           const gchar* domain,
                                                           const gchar* id,
                                                           const gchar* key);
static GType gsettings_configuration_engine_get_type_once (void);

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
gsettings_configuration_engine_check_key_valid (GSettingsConfigurationEngine* self,
                                                const gchar* schema,
                                                const gchar* key,
                                                GError** error)
{
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchema* settings_scheme = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettingsSchema* _tmp4_;
	GSettingsSchema* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	schema_source = _tmp1_;
	_tmp2_ = schema_source;
	_tmp3_ = g_settings_schema_source_lookup (_tmp2_, schema, TRUE);
	settings_scheme = _tmp3_;
	_tmp4_ = settings_scheme;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp5_ = g_strdup_printf ("schema '%s' is not installed", schema);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new_literal (CONFIGURATION_ERROR, CONFIGURATION_ERROR_ENGINE_ERROR, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_settings_schema_unref0 (settings_scheme);
			_g_settings_schema_source_unref0 (schema_source);
			return;
		} else {
			_g_settings_schema_unref0 (settings_scheme);
			_g_settings_schema_source_unref0 (schema_source);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = settings_scheme;
	if (!g_settings_schema_has_key (_tmp9_, key)) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp10_ = g_strdup_printf ("schema '%s' does not define key '%s'", schema, key);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (CONFIGURATION_ERROR, CONFIGURATION_ERROR_ENGINE_ERROR, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_settings_schema_unref0 (settings_scheme);
			_g_settings_schema_source_unref0 (schema_source);
			return;
		} else {
			_g_settings_schema_unref0 (settings_scheme);
			_g_settings_schema_source_unref0 (schema_source);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_settings_schema_unref0 (settings_scheme);
	_g_settings_schema_source_unref0 (schema_source);
}

static gboolean
gsettings_configuration_engine_get_gs_bool (GSettingsConfigurationEngine* self,
                                            const gchar* schema,
                                            const gchar* key,
                                            GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (schema != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			gboolean _tmp0_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gboolean _tmp1_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = g_settings_new (schema);
	schema_object = _tmp2_;
	_tmp3_ = schema_object;
	result = g_settings_get_boolean (_tmp3_, key);
	_g_object_unref0 (schema_object);
	return result;
}

static void
gsettings_configuration_engine_set_gs_bool (GSettingsConfigurationEngine* self,
                                            const gchar* schema,
                                            const gchar* key,
                                            gboolean value,
                                            GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (key != NULL);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = g_settings_new (schema);
	schema_object = _tmp0_;
	_tmp1_ = schema_object;
	g_settings_set_boolean (_tmp1_, key, value);
	_g_object_unref0 (schema_object);
}

static gint
gsettings_configuration_engine_get_gs_int (GSettingsConfigurationEngine* self,
                                           const gchar* schema,
                                           const gchar* key,
                                           GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (schema != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			gint _tmp0_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gint _tmp1_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = g_settings_new (schema);
	schema_object = _tmp2_;
	_tmp3_ = schema_object;
	result = g_settings_get_int (_tmp3_, key);
	_g_object_unref0 (schema_object);
	return result;
}

static void
gsettings_configuration_engine_set_gs_int (GSettingsConfigurationEngine* self,
                                           const gchar* schema,
                                           const gchar* key,
                                           gint value,
                                           GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (key != NULL);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = g_settings_new (schema);
	schema_object = _tmp0_;
	_tmp1_ = schema_object;
	g_settings_set_int (_tmp1_, key, value);
	_g_object_unref0 (schema_object);
}

static gdouble
gsettings_configuration_engine_get_gs_double (GSettingsConfigurationEngine* self,
                                              const gchar* schema,
                                              const gchar* key,
                                              GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (schema != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			gdouble _tmp0_ = -1.0;
			g_propagate_error (error, _inner_error0_);
			return _tmp0_;
		} else {
			gdouble _tmp1_ = -1.0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	_tmp2_ = g_settings_new (schema);
	schema_object = _tmp2_;
	_tmp3_ = schema_object;
	result = g_settings_get_double (_tmp3_, key);
	_g_object_unref0 (schema_object);
	return result;
}

static void
gsettings_configuration_engine_set_gs_double (GSettingsConfigurationEngine* self,
                                              const gchar* schema,
                                              const gchar* key,
                                              gdouble value,
                                              GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (key != NULL);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = g_settings_new (schema);
	schema_object = _tmp0_;
	_tmp1_ = schema_object;
	g_settings_set_double (_tmp1_, key, value);
	_g_object_unref0 (schema_object);
}

static gchar*
gsettings_configuration_engine_get_gs_string (GSettingsConfigurationEngine* self,
                                              const gchar* schema,
                                              const gchar* key,
                                              GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = g_settings_new (schema);
	schema_object = _tmp0_;
	_tmp1_ = schema_object;
	_tmp2_ = g_settings_get_string (_tmp1_, key);
	result = _tmp2_;
	_g_object_unref0 (schema_object);
	return result;
}

static void
gsettings_configuration_engine_set_gs_string (GSettingsConfigurationEngine* self,
                                              const gchar* schema,
                                              const gchar* key,
                                              const gchar* value,
                                              GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = g_settings_new (schema);
	schema_object = _tmp0_;
	_tmp1_ = schema_object;
	g_settings_set_string (_tmp1_, key, value);
	_g_object_unref0 (schema_object);
}

static void
gsettings_configuration_engine_reset_gs_to_default (GSettingsConfigurationEngine* self,
                                                    const gchar* schema,
                                                    const gchar* key,
                                                    GError** error)
{
	GSettings* schema_object = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (key != NULL);
	gsettings_configuration_engine_check_key_valid (self, schema, key, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONFIGURATION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = g_settings_new (schema);
	schema_object = _tmp0_;
	_tmp1_ = schema_object;
	g_settings_reset (_tmp1_, key);
	_g_object_unref0 (schema_object);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
gsettings_configuration_engine_make_plugin_schema_name (const gchar* domain,
                                                        const gchar* id)
{
	gchar* cleaned_id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = plugins_pluggable_rep_clean_plugin_id (id);
	cleaned_id = _tmp0_;
	_tmp1_ = cleaned_id;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("default");
		_g_free0 (cleaned_id);
		cleaned_id = _tmp2_;
	}
	_tmp3_ = cleaned_id;
	_tmp4_ = string_replace (_tmp3_, ".", "-");
	_g_free0 (cleaned_id);
	cleaned_id = _tmp4_;
	_tmp5_ = cleaned_id;
	_tmp6_ = g_strdup_printf ("io.elementary.photos.%s.%s", domain, _tmp5_);
	result = _tmp6_;
	_g_free0 (cleaned_id);
	return result;
}

static gchar*
gsettings_configuration_engine_make_gsettings_key (const gchar* gconf_key)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (gconf_key != NULL, NULL);
	_tmp0_ = string_replace (gconf_key, "_", "-");
	result = _tmp0_;
	return result;
}

static gboolean
gsettings_configuration_engine_real_get_plugin_bool (ConfigurationEngine* base,
                                                     const gchar* domain,
                                                     const gchar* id,
                                                     const gchar* key,
                                                     gboolean def)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (GSettingsConfigurationEngine*) base;
	g_return_val_if_fail (domain != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp3_ = _tmp2_;
		_tmp4_ = gsettings_configuration_engine_get_gs_bool (self, schema_name, _tmp3_, &_inner_error0_);
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
		result = _tmp1_;
		_g_free0 (schema_name);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("GSettingsEngine.vala:137: GSettingsConfigurationEngine: error: %s", _tmp7_);
		result = def;
		_g_error_free0 (err);
		_g_free0 (schema_name);
		return result;
	}
	__finally0:
	_g_free0 (schema_name);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

static void
gsettings_configuration_engine_real_set_plugin_bool (ConfigurationEngine* base,
                                                     const gchar* domain,
                                                     const gchar* id,
                                                     const gchar* key,
                                                     gboolean val)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GSettingsConfigurationEngine*) base;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp2_ = _tmp1_;
		gsettings_configuration_engine_set_gs_bool (self, schema_name, _tmp2_, val, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_critical ("GSettingsEngine.vala:148: GSettingsConfigurationEngine: error: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (schema_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (schema_name);
}

static gdouble
gsettings_configuration_engine_real_get_plugin_double (ConfigurationEngine* base,
                                                       const gchar* domain,
                                                       const gchar* id,
                                                       const gchar* key,
                                                       gdouble def)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	gdouble _tmp8_ = -1.0;
	GError* _inner_error0_ = NULL;
	gdouble result;
	self = (GSettingsConfigurationEngine*) base;
	g_return_val_if_fail (domain != NULL, 0.0);
	g_return_val_if_fail (id != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gdouble _tmp1_ = 0.0;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gdouble _tmp4_;
		_tmp2_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp3_ = _tmp2_;
		_tmp4_ = gsettings_configuration_engine_get_gs_double (self, schema_name, _tmp3_, &_inner_error0_);
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gdouble _tmp5_ = -1.0;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
		result = _tmp1_;
		_g_free0 (schema_name);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("GSettingsEngine.vala:158: GSettingsConfigurationEngine: error: %s", _tmp7_);
		result = def;
		_g_error_free0 (err);
		_g_free0 (schema_name);
		return result;
	}
	__finally0:
	_g_free0 (schema_name);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

static void
gsettings_configuration_engine_real_set_plugin_double (ConfigurationEngine* base,
                                                       const gchar* domain,
                                                       const gchar* id,
                                                       const gchar* key,
                                                       gdouble val)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GSettingsConfigurationEngine*) base;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp2_ = _tmp1_;
		gsettings_configuration_engine_set_gs_double (self, schema_name, _tmp2_, val, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_critical ("GSettingsEngine.vala:169: GSettingsConfigurationEngine: error: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (schema_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (schema_name);
}

static gint
gsettings_configuration_engine_real_get_plugin_int (ConfigurationEngine* base,
                                                    const gchar* domain,
                                                    const gchar* id,
                                                    const gchar* key,
                                                    gint def)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	gint _tmp8_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (GSettingsConfigurationEngine*) base;
	g_return_val_if_fail (domain != NULL, 0);
	g_return_val_if_fail (id != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gint _tmp1_ = 0;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gint _tmp4_;
		_tmp2_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp3_ = _tmp2_;
		_tmp4_ = gsettings_configuration_engine_get_gs_int (self, schema_name, _tmp3_, &_inner_error0_);
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp5_ = -1;
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
		result = _tmp1_;
		_g_free0 (schema_name);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("GSettingsEngine.vala:179: GSettingsConfigurationEngine: error: %s", _tmp7_);
		result = def;
		_g_error_free0 (err);
		_g_free0 (schema_name);
		return result;
	}
	__finally0:
	_g_free0 (schema_name);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

static void
gsettings_configuration_engine_real_set_plugin_int (ConfigurationEngine* base,
                                                    const gchar* domain,
                                                    const gchar* id,
                                                    const gchar* key,
                                                    gint val)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GSettingsConfigurationEngine*) base;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp2_ = _tmp1_;
		gsettings_configuration_engine_set_gs_int (self, schema_name, _tmp2_, val, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_critical ("GSettingsEngine.vala:190: GSettingsConfigurationEngine: error: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (schema_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (schema_name);
}

static gchar*
gsettings_configuration_engine_real_get_plugin_string (ConfigurationEngine* base,
                                                       const gchar* domain,
                                                       const gchar* id,
                                                       const gchar* key,
                                                       const gchar* def)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (GSettingsConfigurationEngine*) base;
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp3_ = _tmp2_;
		_tmp4_ = gsettings_configuration_engine_get_gs_string (self, schema_name, _tmp3_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp6_;
		_g_free0 (_tmp1_);
		_g_free0 (schema_name);
		return result;
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_critical ("GSettingsEngine.vala:200: GSettingsConfigurationEngine: error: %s", _tmp8_);
		_tmp9_ = g_strdup (def);
		result = _tmp9_;
		_g_error_free0 (err);
		_g_free0 (schema_name);
		return result;
	}
	__finally0:
	_g_free0 (schema_name);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
gsettings_configuration_engine_real_set_plugin_string (ConfigurationEngine* base,
                                                       const gchar* domain,
                                                       const gchar* id,
                                                       const gchar* key,
                                                       const gchar* val)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GSettingsConfigurationEngine*) base;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp2_ = _tmp1_;
		gsettings_configuration_engine_set_gs_string (self, schema_name, _tmp2_, val, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_critical ("GSettingsEngine.vala:211: GSettingsConfigurationEngine: error: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (schema_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (schema_name);
}

static void
gsettings_configuration_engine_real_unset_plugin_key (ConfigurationEngine* base,
                                                      const gchar* domain,
                                                      const gchar* id,
                                                      const gchar* key)
{
	GSettingsConfigurationEngine * self;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GSettingsConfigurationEngine*) base;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = gsettings_configuration_engine_make_plugin_schema_name (domain, id);
	schema_name = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = gsettings_configuration_engine_make_gsettings_key (key);
		_tmp2_ = _tmp1_;
		gsettings_configuration_engine_reset_gs_to_default (self, schema_name, _tmp2_, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CONFIGURATION_ERROR) {
				goto __catch0_configuration_error;
			}
			_g_free0 (schema_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_critical ("GSettingsEngine.vala:221: GSettingsConfigurationEngine: error: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (schema_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (schema_name);
}

GSettingsConfigurationEngine*
gsettings_configuration_engine_construct (GType object_type)
{
	GSettingsConfigurationEngine * self = NULL;
	self = (GSettingsConfigurationEngine*) g_object_new (object_type, NULL);
	return self;
}

GSettingsConfigurationEngine*
gsettings_configuration_engine_new (void)
{
	return gsettings_configuration_engine_construct (TYPE_GSETTINGS_CONFIGURATION_ENGINE);
}

static void
gsettings_configuration_engine_class_init (GSettingsConfigurationEngineClass * klass,
                                           gpointer klass_data)
{
	gsettings_configuration_engine_parent_class = g_type_class_peek_parent (klass);
}

static void
gsettings_configuration_engine_configuration_engine_interface_init (ConfigurationEngineIface * iface,
                                                                    gpointer iface_data)
{
	gsettings_configuration_engine_configuration_engine_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_plugin_bool = (gboolean (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, gboolean)) gsettings_configuration_engine_real_get_plugin_bool;
	iface->set_plugin_bool = (void (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, gboolean)) gsettings_configuration_engine_real_set_plugin_bool;
	iface->get_plugin_double = (gdouble (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, gdouble)) gsettings_configuration_engine_real_get_plugin_double;
	iface->set_plugin_double = (void (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, gdouble)) gsettings_configuration_engine_real_set_plugin_double;
	iface->get_plugin_int = (gint (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, gint)) gsettings_configuration_engine_real_get_plugin_int;
	iface->set_plugin_int = (void (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, gint)) gsettings_configuration_engine_real_set_plugin_int;
	iface->get_plugin_string = (gchar* (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, const gchar*)) gsettings_configuration_engine_real_get_plugin_string;
	iface->set_plugin_string = (void (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*, const gchar*)) gsettings_configuration_engine_real_set_plugin_string;
	iface->unset_plugin_key = (void (*) (ConfigurationEngine*, const gchar*, const gchar*, const gchar*)) gsettings_configuration_engine_real_unset_plugin_key;
}

static void
gsettings_configuration_engine_instance_init (GSettingsConfigurationEngine * self,
                                              gpointer klass)
{
}

static GType
gsettings_configuration_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GSettingsConfigurationEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsettings_configuration_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GSettingsConfigurationEngine), 0, (GInstanceInitFunc) gsettings_configuration_engine_instance_init, NULL };
	static const GInterfaceInfo configuration_engine_info = { (GInterfaceInitFunc) gsettings_configuration_engine_configuration_engine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gsettings_configuration_engine_type_id;
	gsettings_configuration_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "GSettingsConfigurationEngine", &g_define_type_info, 0);
	g_type_add_interface_static (gsettings_configuration_engine_type_id, TYPE_CONFIGURATION_ENGINE, &configuration_engine_info);
	return gsettings_configuration_engine_type_id;
}

GType
gsettings_configuration_engine_get_type (void)
{
	static volatile gsize gsettings_configuration_engine_type_id__once = 0;
	if (g_once_init_enter (&gsettings_configuration_engine_type_id__once)) {
		GType gsettings_configuration_engine_type_id;
		gsettings_configuration_engine_type_id = gsettings_configuration_engine_get_type_once ();
		g_once_init_leave (&gsettings_configuration_engine_type_id__once, gsettings_configuration_engine_type_id);
	}
	return gsettings_configuration_engine_type_id__once;
}

