/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <https://www.gnu.org/licenses/old-licenses/gpl-2.0>.
 */

/* THIS FILE IS AUTO-GENERATED; PLEASE DO NOT ALTER MANUALLY */

#include "../script_error.hpp"
#include "../template/template_error.sq.hpp"


template <> SQInteger PushClassName<ScriptError, ScriptType::GS>(HSQUIRRELVM vm) { sq_pushstring(vm, "GSError"); return 1; }

void SQGSError_Register(Squirrel &engine)
{
	DefSQClass<ScriptError, ScriptType::GS> SQGSError("GSError");
	SQGSError.PreRegister(engine, "GSObject");

	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_NONE,                     "ERR_CAT_NONE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_GENERAL,                  "ERR_CAT_GENERAL");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_VEHICLE,                  "ERR_CAT_VEHICLE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_STATION,                  "ERR_CAT_STATION");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_BRIDGE,                   "ERR_CAT_BRIDGE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_TUNNEL,                   "ERR_CAT_TUNNEL");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_TILE,                     "ERR_CAT_TILE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_SIGN,                     "ERR_CAT_SIGN");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_RAIL,                     "ERR_CAT_RAIL");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_ROAD,                     "ERR_CAT_ROAD");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_ORDER,                    "ERR_CAT_ORDER");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_MARINE,                   "ERR_CAT_MARINE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_WAYPOINT,                 "ERR_CAT_WAYPOINT");
	SQGSError.DefSQConst(engine, ScriptError::ERR_CAT_BIT_SIZE,                 "ERR_CAT_BIT_SIZE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_NONE,                         "ERR_NONE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_UNKNOWN,                      "ERR_UNKNOWN");
	SQGSError.DefSQConst(engine, ScriptError::ERR_PRECONDITION_FAILED,          "ERR_PRECONDITION_FAILED");
	SQGSError.DefSQConst(engine, ScriptError::ERR_PRECONDITION_STRING_TOO_LONG, "ERR_PRECONDITION_STRING_TOO_LONG");
	SQGSError.DefSQConst(engine, ScriptError::ERR_PRECONDITION_INVALID_COMPANY, "ERR_PRECONDITION_INVALID_COMPANY");
	SQGSError.DefSQConst(engine, ScriptError::ERR_NEWGRF_SUPPLIED_ERROR,        "ERR_NEWGRF_SUPPLIED_ERROR");
	SQGSError.DefSQConst(engine, ScriptError::ERR_GENERAL_BASE,                 "ERR_GENERAL_BASE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_NOT_ENOUGH_CASH,              "ERR_NOT_ENOUGH_CASH");
	SQGSError.DefSQConst(engine, ScriptError::ERR_LOCAL_AUTHORITY_REFUSES,      "ERR_LOCAL_AUTHORITY_REFUSES");
	SQGSError.DefSQConst(engine, ScriptError::ERR_ALREADY_BUILT,                "ERR_ALREADY_BUILT");
	SQGSError.DefSQConst(engine, ScriptError::ERR_AREA_NOT_CLEAR,               "ERR_AREA_NOT_CLEAR");
	SQGSError.DefSQConst(engine, ScriptError::ERR_OWNED_BY_ANOTHER_COMPANY,     "ERR_OWNED_BY_ANOTHER_COMPANY");
	SQGSError.DefSQConst(engine, ScriptError::ERR_NAME_IS_NOT_UNIQUE,           "ERR_NAME_IS_NOT_UNIQUE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_FLAT_LAND_REQUIRED,           "ERR_FLAT_LAND_REQUIRED");
	SQGSError.DefSQConst(engine, ScriptError::ERR_LAND_SLOPED_WRONG,            "ERR_LAND_SLOPED_WRONG");
	SQGSError.DefSQConst(engine, ScriptError::ERR_VEHICLE_IN_THE_WAY,           "ERR_VEHICLE_IN_THE_WAY");
	SQGSError.DefSQConst(engine, ScriptError::ERR_SITE_UNSUITABLE,              "ERR_SITE_UNSUITABLE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_TOO_CLOSE_TO_EDGE,            "ERR_TOO_CLOSE_TO_EDGE");
	SQGSError.DefSQConst(engine, ScriptError::ERR_STATION_TOO_SPREAD_OUT,       "ERR_STATION_TOO_SPREAD_OUT");
	SQGSError.DefSQConst(engine, ScriptError::ERR_BRIDGE_TOO_LOW,               "ERR_BRIDGE_TOO_LOW");

	ScriptError::RegisterErrorMap(STR_ERROR_NOT_ENOUGH_CASH_REQUIRES_CURRENCY,          ScriptError::ERR_NOT_ENOUGH_CASH);
	ScriptError::RegisterErrorMap(STR_ERROR_LOCAL_AUTHORITY_REFUSES_TO_ALLOW_THIS,      ScriptError::ERR_LOCAL_AUTHORITY_REFUSES);
	ScriptError::RegisterErrorMap(STR_ERROR_LOCAL_AUTHORITY_REFUSES_NOISE,              ScriptError::ERR_LOCAL_AUTHORITY_REFUSES);
	ScriptError::RegisterErrorMap(STR_ERROR_ALREADY_BUILT,                              ScriptError::ERR_ALREADY_BUILT);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_BRIDGE_FIRST,                 ScriptError::ERR_ALREADY_BUILT);
	ScriptError::RegisterErrorMap(STR_ERROR_TREE_ALREADY_HERE,                          ScriptError::ERR_ALREADY_BUILT);
	ScriptError::RegisterErrorMap(STR_ERROR_BUILDING_MUST_BE_DEMOLISHED,                ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_BRIDGE_FIRST,                 ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_RAILROAD,                     ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_AIRPORT_FIRST,                ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_CARGO_TRAM_STATION_FIRST,     ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_TRUCK_STATION_FIRST,          ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_PASSENGER_TRAM_STATION_FIRST, ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_BUS_STATION_FIRST,            ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_BUOY_IN_THE_WAY,                            ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_DOCK_FIRST,                   ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_GENERIC_OBJECT_IN_THE_WAY,                  ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_COMPANY_HEADQUARTERS_IN,                    ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_OBJECT_IN_THE_WAY,                          ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_REMOVE_ROAD_FIRST,                     ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_REMOVE_RAILROAD_TRACK,                 ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_BRIDGE_FIRST,                 ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_MUST_DEMOLISH_TUNNEL_FIRST,                 ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_EXCAVATION_WOULD_DAMAGE,                    ScriptError::ERR_AREA_NOT_CLEAR);
	ScriptError::RegisterErrorMap(STR_ERROR_AREA_IS_OWNED_BY_ANOTHER,                   ScriptError::ERR_OWNED_BY_ANOTHER_COMPANY);
	ScriptError::RegisterErrorMap(STR_ERROR_OWNED_BY,                                   ScriptError::ERR_OWNED_BY_ANOTHER_COMPANY);
	ScriptError::RegisterErrorMap(STR_ERROR_NAME_MUST_BE_UNIQUE,                        ScriptError::ERR_NAME_IS_NOT_UNIQUE);
	ScriptError::RegisterErrorMap(STR_ERROR_FLAT_LAND_REQUIRED,                         ScriptError::ERR_FLAT_LAND_REQUIRED);
	ScriptError::RegisterErrorMap(STR_ERROR_LAND_SLOPED_IN_WRONG_DIRECTION,             ScriptError::ERR_LAND_SLOPED_WRONG);
	ScriptError::RegisterErrorMap(STR_ERROR_TRAIN_IN_THE_WAY,                           ScriptError::ERR_VEHICLE_IN_THE_WAY);
	ScriptError::RegisterErrorMap(STR_ERROR_ROAD_VEHICLE_IN_THE_WAY,                    ScriptError::ERR_VEHICLE_IN_THE_WAY);
	ScriptError::RegisterErrorMap(STR_ERROR_SHIP_IN_THE_WAY,                            ScriptError::ERR_VEHICLE_IN_THE_WAY);
	ScriptError::RegisterErrorMap(STR_ERROR_AIRCRAFT_IN_THE_WAY,                        ScriptError::ERR_VEHICLE_IN_THE_WAY);
	ScriptError::RegisterErrorMap(STR_ERROR_SITE_UNSUITABLE,                            ScriptError::ERR_SITE_UNSUITABLE);
	ScriptError::RegisterErrorMap(STR_ERROR_TREE_WRONG_TERRAIN_FOR_TREE_TYPE,           ScriptError::ERR_SITE_UNSUITABLE);
	ScriptError::RegisterErrorMap(STR_ERROR_TOO_CLOSE_TO_EDGE_OF_MAP,                   ScriptError::ERR_TOO_CLOSE_TO_EDGE);
	ScriptError::RegisterErrorMap(STR_ERROR_STATION_TOO_SPREAD_OUT,                     ScriptError::ERR_STATION_TOO_SPREAD_OUT);
	ScriptError::RegisterErrorMap(STR_ERROR_BRIDGE_TOO_LOW_FOR_STATION,                 ScriptError::ERR_BRIDGE_TOO_LOW);
	ScriptError::RegisterErrorMap(STR_ERROR_BRIDGE_TOO_LOW_FOR_ROADSTOP,                ScriptError::ERR_BRIDGE_TOO_LOW);
	ScriptError::RegisterErrorMap(STR_ERROR_BRIDGE_TOO_LOW_FOR_BUOY,                    ScriptError::ERR_BRIDGE_TOO_LOW);
	ScriptError::RegisterErrorMap(STR_ERROR_BRIDGE_TOO_LOW_FOR_RAIL_WAYPOINT,           ScriptError::ERR_BRIDGE_TOO_LOW);
	ScriptError::RegisterErrorMap(STR_ERROR_BRIDGE_TOO_LOW_FOR_ROAD_WAYPOINT,           ScriptError::ERR_BRIDGE_TOO_LOW);

	ScriptError::RegisterErrorMapString(ScriptError::ERR_NONE,                         "ERR_NONE");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_UNKNOWN,                      "ERR_UNKNOWN");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_PRECONDITION_FAILED,          "ERR_PRECONDITION_FAILED");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_PRECONDITION_STRING_TOO_LONG, "ERR_PRECONDITION_STRING_TOO_LONG");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_PRECONDITION_INVALID_COMPANY, "ERR_PRECONDITION_INVALID_COMPANY");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_NEWGRF_SUPPLIED_ERROR,        "ERR_NEWGRF_SUPPLIED_ERROR");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_NOT_ENOUGH_CASH,              "ERR_NOT_ENOUGH_CASH");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_LOCAL_AUTHORITY_REFUSES,      "ERR_LOCAL_AUTHORITY_REFUSES");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_ALREADY_BUILT,                "ERR_ALREADY_BUILT");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_AREA_NOT_CLEAR,               "ERR_AREA_NOT_CLEAR");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_OWNED_BY_ANOTHER_COMPANY,     "ERR_OWNED_BY_ANOTHER_COMPANY");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_NAME_IS_NOT_UNIQUE,           "ERR_NAME_IS_NOT_UNIQUE");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_FLAT_LAND_REQUIRED,           "ERR_FLAT_LAND_REQUIRED");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_LAND_SLOPED_WRONG,            "ERR_LAND_SLOPED_WRONG");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_VEHICLE_IN_THE_WAY,           "ERR_VEHICLE_IN_THE_WAY");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_SITE_UNSUITABLE,              "ERR_SITE_UNSUITABLE");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_TOO_CLOSE_TO_EDGE,            "ERR_TOO_CLOSE_TO_EDGE");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_STATION_TOO_SPREAD_OUT,       "ERR_STATION_TOO_SPREAD_OUT");
	ScriptError::RegisterErrorMapString(ScriptError::ERR_BRIDGE_TOO_LOW,               "ERR_BRIDGE_TOO_LOW");

	SQGSError.DefSQStaticMethod(engine, &ScriptError::GetErrorCategory,   "GetErrorCategory",   ".");
	SQGSError.DefSQStaticMethod(engine, &ScriptError::GetLastError,       "GetLastError",       ".");
	SQGSError.DefSQStaticMethod(engine, &ScriptError::GetLastErrorString, "GetLastErrorString", ".");

	SQGSError.PostRegister(engine);
}
