/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "textautogenerateattachment.h"
#include "textautogeneratetextcore_memory_debug.h"
#include <QJsonObject>
using namespace Qt::Literals::StringLiterals;
using namespace TextAutoGenerateText;
TextAutoGenerateAttachment::TextAutoGenerateAttachment()
{
    qCDebug(TEXTAUTOGENERATETEXT_CORE_MEMORY_LOG) << " TextAutoGenerateAttachment created " << this;
}

TextAutoGenerateAttachment::~TextAutoGenerateAttachment()
{
    qCDebug(TEXTAUTOGENERATETEXT_CORE_MEMORY_LOG) << " TextAutoGenerateAttachment deleted " << this;
}

QByteArray TextAutoGenerateAttachment::content() const
{
    return mContent;
}

void TextAutoGenerateAttachment::setContent(const QByteArray &b)
{
    mContent = b;
}

QDebug operator<<(QDebug d, const TextAutoGenerateText::TextAutoGenerateAttachment &t)
{
    d.space() << "mContent:" << t.content();
    d.space() << "mAttachmentType:" << t.attachmentType();
    d.space() << "mMimeType:" << t.mimeType();
    d.space() << "mName:" << t.name();
    d.space() << "mShowAttachment:" << t.showAttachment();
    d.space() << "mAttachmentId:" << t.attachmentId();
    return d;
}

bool TextAutoGenerateAttachment::operator==(const TextAutoGenerateAttachment &other) const
{
    return (mContent == other.mContent) && (mAttachmentType == other.mAttachmentType) && (mMimeType == other.mMimeType) && (mName == other.mName)
        && (mShowAttachment == other.mShowAttachment) && (mAttachmentId == other.mAttachmentId);
}

bool TextAutoGenerateAttachment::isValid() const
{
    return (mAttachmentType != AttachmentType::Unknown) && !mContent.isEmpty();
}

TextAutoGenerateAttachment::AttachmentType TextAutoGenerateAttachment::attachmentType() const
{
    return mAttachmentType;
}

void TextAutoGenerateAttachment::setAttachmentType(AttachmentType newAttachmentType)
{
    mAttachmentType = newAttachmentType;
}

QJsonObject TextAutoGenerateAttachment::serialize(const TextAutoGenerateAttachment &attachment)
{
    QJsonObject o;
    o["type"_L1] = static_cast<int>(attachment.attachmentType());
    o["mimetype"_L1] = QString::fromLatin1(attachment.mimeType());
    o["content"_L1] = QString::fromLatin1(attachment.content());
    o["name"_L1] = attachment.name();
    o["showAttachment"_L1] = attachment.showAttachment();
    o["attachmentId"_L1] = QString::fromLatin1(attachment.attachmentId());
    return o;
}

TextAutoGenerateAttachment TextAutoGenerateAttachment::deserialize(const QJsonObject &o)
{
    TextAutoGenerateAttachment att;
    att.setAttachmentType(static_cast<TextAutoGenerateAttachment::AttachmentType>(o["type"_L1].toInt(static_cast<int>(AttachmentType::Unknown))));
    att.setMimeType(o["mimetype"_L1].toString().toLatin1());
    att.setContent(o["content"_L1].toString().toLatin1());
    att.setName(o["name"_L1].toString());
    att.setShowAttachment(o["showAttachment"_L1].toBool(true));
    att.setAttachmentId(o["attachmentId"_L1].toString().toLatin1());
    return att;
}

QByteArray TextAutoGenerateAttachment::mimeType() const
{
    return mMimeType;
}

void TextAutoGenerateAttachment::setMimeType(const QByteArray &newMimeType)
{
    mMimeType = newMimeType;
}

QString TextAutoGenerateAttachment::name() const
{
    return mName;
}

void TextAutoGenerateAttachment::setName(const QString &newName)
{
    mName = newName;
}

bool TextAutoGenerateAttachment::showAttachment() const
{
    return mShowAttachment;
}

void TextAutoGenerateAttachment::setShowAttachment(bool newShowAttachment)
{
    mShowAttachment = newShowAttachment;
}

QByteArray TextAutoGenerateAttachment::attachmentId() const
{
    return mAttachmentId;
}

void TextAutoGenerateAttachment::setAttachmentId(const QByteArray &newAttachmentId)
{
    mAttachmentId = newAttachmentId;
}

#include "moc_textautogenerateattachment.cpp"
