// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2007 Konrad Twardowski

#pragma once

#include "udialog.h"

#include <QCheckBox>
#include <QListWidget>
#include <QPlainTextEdit>

class PasswordPreferences;
class UCommandEdit;

class Preferences final: public UDialog {
public:
	inline static const int PAGE_MARGIN = 20_px;
	inline static const int RESTART_PAGE_INDEX = 3;

	explicit Preferences(QWidget *parent, const int pageIndex);
	virtual ~Preferences() = default;
	static void showDialog(const int pageIndex = -1);
private:
	Q_DISABLE_COPY(Preferences)
	bool m_oldProgressBarVisible;
	PasswordPreferences *m_passwordPreferences;
	QCheckBox *m_bootEntriesVisibleInMenu;
	QCheckBox *m_bootEntriesVisibleInWindow;
	QCheckBox *m_cancelDefault;
	QCheckBox *m_confirmAction;
	QCheckBox *m_countdownEnabled;
	QCheckBox *m_lockScreenBeforeHibernate;
	QCheckBox *m_noMinimizeToSystemTrayIcon;
	QCheckBox *m_progressBarEnabled;
	QCheckBox *m_systemTrayIconCustomColor;
	QCheckBox *m_systemTrayIconEnabled;
	QCheckBox *m_useThemeIconInSystemTray;
	QColor systemTrayIconActiveColor;
	QColor systemTrayIconNormalColor;
	QIcon m_fallbackIcon;
	#ifdef Q_OS_LINUX
	UCommandEdit *m_lockCommandEdit;
	UCommandEdit *m_setBootEntryCommandEdit;
	#endif // Q_OS_LINUX
	QList<QWidget *> m_pageListData = QList<QWidget *>();
	QListWidget *m_pageListWidget;
	QPlainTextEdit *m_bootEntries;
	QPushButton *m_systemTrayIconActiveColorButton;
	QPushButton *m_systemTrayIconNormalColorButton;
	QVBoxLayout *m_pageContainerLayout;
	QWidget *m_currentPageWidget = nullptr;
	static void addHeader(QVBoxLayout *layout, const QString &text);
	void addPage(QVBoxLayout *layout, const QString &text, const QString &iconName) {
		addPage(layout->parentWidget(), text, iconName);
	}
	void addPage(QWidget *widget, const QString &text, const QString &iconName);
	void apply();
	//QWidget *createActionsWidget();
	QVBoxLayout *createGeneralPage();
	QVBoxLayout *createRebootPage();
	QVBoxLayout *createSystemTrayPage();
	//QWidget *createTriggersWidget();
	static QVBoxLayout *newPageLayout();
	void setCurrentPage(const int index);
	void showRestartMessage();
	void updateSystemTrayIconPreview();

	// event handlers:
	void onFinish(int result);
	void onProgressBarEnabled(bool enabled) const;
};
