// @generated Code generated by gen-atomicwrapper.

// Copyright (c) 2020-2023 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package atomic

// String is an atomic type-safe wrapper for string values.
type String struct {
	_ nocmp // disallow non-atomic comparison

	v Value
}

var _zeroString string

// NewString creates a new String.
func NewString(val string) *String {
	x := &String{}
	if val != _zeroString {
		x.Store(val)
	}
	return x
}

// Load atomically loads the wrapped string.
func (x *String) Load() string {
	return unpackString(x.v.Load())
}

// Store atomically stores the passed string.
func (x *String) Store(val string) {
	x.v.Store(packString(val))
}

// CompareAndSwap is an atomic compare-and-swap for string values.
func (x *String) CompareAndSwap(old, new string) (swapped bool) {
	if x.v.CompareAndSwap(packString(old), packString(new)) {
		return true
	}

	if old == _zeroString {
		// If the old value is the empty value, then it's possible the
		// underlying Value hasn't been set and is nil, so retry with nil.
		return x.v.CompareAndSwap(nil, packString(new))
	}

	return false
}

// Swap atomically stores the given string and returns the old
// value.
func (x *String) Swap(val string) (old string) {
	return unpackString(x.v.Swap(packString(val)))
}
