{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Sorts items numerically.
-- 
-- To obtain the numbers to compare, this sorter evaluates a
-- t'GI.Gtk.Objects.Expression.Expression'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.NumericSorter
    ( 

-- * Exported types
    NumericSorter(..)                       ,
    IsNumericSorter                         ,
    toNumericSorter                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Sorter#g:method:changed"), [compare]("GI.Gtk.Objects.Sorter#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getExpression]("GI.Gtk.Objects.NumericSorter#g:method:getExpression"), [getOrder]("GI.Gtk.Objects.Sorter#g:method:getOrder"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSortOrder]("GI.Gtk.Objects.NumericSorter#g:method:getSortOrder").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setExpression]("GI.Gtk.Objects.NumericSorter#g:method:setExpression"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSortOrder]("GI.Gtk.Objects.NumericSorter#g:method:setSortOrder").

#if defined(ENABLE_OVERLOADING)
    ResolveNumericSorterMethod              ,
#endif

-- ** getExpression #method:getExpression#

#if defined(ENABLE_OVERLOADING)
    NumericSorterGetExpressionMethodInfo    ,
#endif
    numericSorterGetExpression              ,


-- ** getSortOrder #method:getSortOrder#

#if defined(ENABLE_OVERLOADING)
    NumericSorterGetSortOrderMethodInfo     ,
#endif
    numericSorterGetSortOrder               ,


-- ** new #method:new#

    numericSorterNew                        ,


-- ** setExpression #method:setExpression#

#if defined(ENABLE_OVERLOADING)
    NumericSorterSetExpressionMethodInfo    ,
#endif
    numericSorterSetExpression              ,


-- ** setSortOrder #method:setSortOrder#

#if defined(ENABLE_OVERLOADING)
    NumericSorterSetSortOrderMethodInfo     ,
#endif
    numericSorterSetSortOrder               ,




 -- * Properties


-- ** expression #attr:expression#
-- | The expression to evaluate on items to get a number to compare with.

#if defined(ENABLE_OVERLOADING)
    NumericSorterExpressionPropertyInfo     ,
#endif
    clearNumericSorterExpression            ,
    constructNumericSorterExpression        ,
    getNumericSorterExpression              ,
#if defined(ENABLE_OVERLOADING)
    numericSorterExpression                 ,
#endif
    setNumericSorterExpression              ,


-- ** sortOrder #attr:sortOrder#
-- | Whether the sorter will sort smaller numbers first.

#if defined(ENABLE_OVERLOADING)
    NumericSorterSortOrderPropertyInfo      ,
#endif
    constructNumericSorterSortOrder         ,
    getNumericSorterSortOrder               ,
#if defined(ENABLE_OVERLOADING)
    numericSorterSortOrder                  ,
#endif
    setNumericSorterSortOrder               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#endif

-- | Memory-managed wrapper type.
newtype NumericSorter = NumericSorter (SP.ManagedPtr NumericSorter)
    deriving (Eq)

instance SP.ManagedPtrNewtype NumericSorter where
    toManagedPtr (NumericSorter p) = p

foreign import ccall "gtk_numeric_sorter_get_type"
    c_gtk_numeric_sorter_get_type :: IO B.Types.GType

instance B.Types.TypedObject NumericSorter where
    glibType = c_gtk_numeric_sorter_get_type

instance B.Types.GObject NumericSorter

-- | Type class for types which can be safely cast to t'NumericSorter', for instance with `toNumericSorter`.
class (SP.GObject o, O.IsDescendantOf NumericSorter o) => IsNumericSorter o
instance (SP.GObject o, O.IsDescendantOf NumericSorter o) => IsNumericSorter o

instance O.HasParentTypes NumericSorter
type instance O.ParentTypes NumericSorter = '[Gtk.Sorter.Sorter, GObject.Object.Object]

-- | Cast to t'NumericSorter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNumericSorter :: (MIO.MonadIO m, IsNumericSorter o) => o -> m NumericSorter
toNumericSorter = MIO.liftIO . B.ManagedPtr.unsafeCastTo NumericSorter

-- | Convert t'NumericSorter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NumericSorter) where
    gvalueGType_ = c_gtk_numeric_sorter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NumericSorter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NumericSorter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NumericSorter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNumericSorterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNumericSorterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNumericSorterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNumericSorterMethod "changed" o = Gtk.Sorter.SorterChangedMethodInfo
    ResolveNumericSorterMethod "compare" o = Gtk.Sorter.SorterCompareMethodInfo
    ResolveNumericSorterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNumericSorterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNumericSorterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNumericSorterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNumericSorterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNumericSorterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNumericSorterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNumericSorterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNumericSorterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNumericSorterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNumericSorterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNumericSorterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNumericSorterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNumericSorterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNumericSorterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNumericSorterMethod "getExpression" o = NumericSorterGetExpressionMethodInfo
    ResolveNumericSorterMethod "getOrder" o = Gtk.Sorter.SorterGetOrderMethodInfo
    ResolveNumericSorterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNumericSorterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNumericSorterMethod "getSortOrder" o = NumericSorterGetSortOrderMethodInfo
    ResolveNumericSorterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNumericSorterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNumericSorterMethod "setExpression" o = NumericSorterSetExpressionMethodInfo
    ResolveNumericSorterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNumericSorterMethod "setSortOrder" o = NumericSorterSetSortOrderMethodInfo
    ResolveNumericSorterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNumericSorterMethod t NumericSorter, O.OverloadedMethod info NumericSorter p) => OL.IsLabel t (NumericSorter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNumericSorterMethod t NumericSorter, O.OverloadedMethod info NumericSorter p, R.HasField t NumericSorter p) => R.HasField t NumericSorter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNumericSorterMethod t NumericSorter, O.OverloadedMethodInfo info NumericSorter) => OL.IsLabel t (O.MethodProxy info NumericSorter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "expression"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Expression"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' numericSorter #expression
-- @
getNumericSorterExpression :: (MonadIO m, IsNumericSorter o) => o -> m (Maybe Gtk.Expression.Expression)
getNumericSorterExpression obj = MIO.liftIO $ B.Properties.getObjectPropertyIsGValueInstance obj "expression"

-- | Set the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' numericSorter [ #expression 'Data.GI.Base.Attributes.:=' value ]
-- @
setNumericSorterExpression :: (MonadIO m, IsNumericSorter o, Gtk.Expression.IsExpression a) => o -> a -> m ()
setNumericSorterExpression obj val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Just val')

-- | Construct a t'GValueConstruct' with valid value for the “@expression@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNumericSorterExpression :: (IsNumericSorter o, MIO.MonadIO m, Gtk.Expression.IsExpression a) => a -> m (GValueConstruct o)
constructNumericSorterExpression val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    MIO.liftIO $ B.Properties.constructObjectPropertyIsGValueInstance "expression" (P.Just val')

-- | Set the value of the “@expression@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #expression
-- @
clearNumericSorterExpression :: (MonadIO m, IsNumericSorter o) => o -> m ()
clearNumericSorterExpression obj = liftIO $ B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Nothing :: Maybe Gtk.Expression.Expression)

#if defined(ENABLE_OVERLOADING)
data NumericSorterExpressionPropertyInfo
instance AttrInfo NumericSorterExpressionPropertyInfo where
    type AttrAllowedOps NumericSorterExpressionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NumericSorterExpressionPropertyInfo = IsNumericSorter
    type AttrSetTypeConstraint NumericSorterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferTypeConstraint NumericSorterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferType NumericSorterExpressionPropertyInfo = Gtk.Expression.Expression
    type AttrGetType NumericSorterExpressionPropertyInfo = (Maybe Gtk.Expression.Expression)
    type AttrLabel NumericSorterExpressionPropertyInfo = "expression"
    type AttrOrigin NumericSorterExpressionPropertyInfo = NumericSorter
    attrGet = getNumericSorterExpression
    attrSet = setNumericSorterExpression
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructNumericSorterExpression
    attrClear = clearNumericSorterExpression
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NumericSorter.expression"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NumericSorter.html#g:attr:expression"
        })
#endif

-- VVV Prop "sort-order"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SortType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@sort-order@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' numericSorter #sortOrder
-- @
getNumericSorterSortOrder :: (MonadIO m, IsNumericSorter o) => o -> m Gtk.Enums.SortType
getNumericSorterSortOrder obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "sort-order"

-- | Set the value of the “@sort-order@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' numericSorter [ #sortOrder 'Data.GI.Base.Attributes.:=' value ]
-- @
setNumericSorterSortOrder :: (MonadIO m, IsNumericSorter o) => o -> Gtk.Enums.SortType -> m ()
setNumericSorterSortOrder obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "sort-order" val

-- | Construct a t'GValueConstruct' with valid value for the “@sort-order@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNumericSorterSortOrder :: (IsNumericSorter o, MIO.MonadIO m) => Gtk.Enums.SortType -> m (GValueConstruct o)
constructNumericSorterSortOrder val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "sort-order" val

#if defined(ENABLE_OVERLOADING)
data NumericSorterSortOrderPropertyInfo
instance AttrInfo NumericSorterSortOrderPropertyInfo where
    type AttrAllowedOps NumericSorterSortOrderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint NumericSorterSortOrderPropertyInfo = IsNumericSorter
    type AttrSetTypeConstraint NumericSorterSortOrderPropertyInfo = (~) Gtk.Enums.SortType
    type AttrTransferTypeConstraint NumericSorterSortOrderPropertyInfo = (~) Gtk.Enums.SortType
    type AttrTransferType NumericSorterSortOrderPropertyInfo = Gtk.Enums.SortType
    type AttrGetType NumericSorterSortOrderPropertyInfo = Gtk.Enums.SortType
    type AttrLabel NumericSorterSortOrderPropertyInfo = "sort-order"
    type AttrOrigin NumericSorterSortOrderPropertyInfo = NumericSorter
    attrGet = getNumericSorterSortOrder
    attrSet = setNumericSorterSortOrder
    attrPut = setNumericSorterSortOrder
    attrTransfer _ v = do
        return v
    attrConstruct = constructNumericSorterSortOrder
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NumericSorter.sortOrder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NumericSorter.html#g:attr:sortOrder"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NumericSorter
type instance O.AttributeList NumericSorter = NumericSorterAttributeList
type NumericSorterAttributeList = ('[ '("expression", NumericSorterExpressionPropertyInfo), '("sortOrder", NumericSorterSortOrderPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
numericSorterExpression :: AttrLabelProxy "expression"
numericSorterExpression = AttrLabelProxy

numericSorterSortOrder :: AttrLabelProxy "sortOrder"
numericSorterSortOrder = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NumericSorter = NumericSorterSignalList
type NumericSorterSignalList = ('[ '("changed", Gtk.Sorter.SorterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method NumericSorter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The expression to evaluate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "NumericSorter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_numeric_sorter_new" gtk_numeric_sorter_new :: 
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO (Ptr NumericSorter)

-- | Creates a new numeric sorter using the given /@expression@/.
-- 
-- Smaller numbers will be sorted first. You can call
-- 'GI.Gtk.Objects.NumericSorter.numericSorterSetSortOrder' to change this.
numericSorterNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Expression.IsExpression a) =>
    Maybe (a)
    -- ^ /@expression@/: The expression to evaluate
    -> m NumericSorter
    -- ^ __Returns:__ a new @GtkNumericSorter@
numericSorterNew expression = liftIO $ do
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- B.ManagedPtr.disownManagedPtr jExpression
            return jExpression'
    result <- gtk_numeric_sorter_new maybeExpression
    checkUnexpectedReturnNULL "numericSorterNew" result
    result' <- (wrapObject NumericSorter) result
    whenJust expression touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method NumericSorter::get_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "NumericSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNumericSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_numeric_sorter_get_expression" gtk_numeric_sorter_get_expression :: 
    Ptr NumericSorter ->                    -- self : TInterface (Name {namespace = "Gtk", name = "NumericSorter"})
    IO (Ptr Gtk.Expression.Expression)

-- | Gets the expression that is evaluated to obtain numbers from items.
numericSorterGetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsNumericSorter a) =>
    a
    -- ^ /@self@/: a @GtkNumericSorter@
    -> m (Maybe Gtk.Expression.Expression)
    -- ^ __Returns:__ a @GtkExpression@
numericSorterGetExpression self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_numeric_sorter_get_expression self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gtk.Expression.Expression) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NumericSorterGetExpressionMethodInfo
instance (signature ~ (m (Maybe Gtk.Expression.Expression)), MonadIO m, IsNumericSorter a) => O.OverloadedMethod NumericSorterGetExpressionMethodInfo a signature where
    overloadedMethod = numericSorterGetExpression

instance O.OverloadedMethodInfo NumericSorterGetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NumericSorter.numericSorterGetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NumericSorter.html#v:numericSorterGetExpression"
        })


#endif

-- method NumericSorter::get_sort_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "NumericSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNumericSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "SortType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_numeric_sorter_get_sort_order" gtk_numeric_sorter_get_sort_order :: 
    Ptr NumericSorter ->                    -- self : TInterface (Name {namespace = "Gtk", name = "NumericSorter"})
    IO CUInt

-- | Gets whether this sorter will sort smaller numbers first.
numericSorterGetSortOrder ::
    (B.CallStack.HasCallStack, MonadIO m, IsNumericSorter a) =>
    a
    -- ^ /@self@/: a @GtkNumericSorter@
    -> m Gtk.Enums.SortType
    -- ^ __Returns:__ the order of the numbers
numericSorterGetSortOrder self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_numeric_sorter_get_sort_order self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data NumericSorterGetSortOrderMethodInfo
instance (signature ~ (m Gtk.Enums.SortType), MonadIO m, IsNumericSorter a) => O.OverloadedMethod NumericSorterGetSortOrderMethodInfo a signature where
    overloadedMethod = numericSorterGetSortOrder

instance O.OverloadedMethodInfo NumericSorterGetSortOrderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NumericSorter.numericSorterGetSortOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NumericSorter.html#v:numericSorterGetSortOrder"
        })


#endif

-- method NumericSorter::set_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "NumericSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNumericSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpression`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_numeric_sorter_set_expression" gtk_numeric_sorter_set_expression :: 
    Ptr NumericSorter ->                    -- self : TInterface (Name {namespace = "Gtk", name = "NumericSorter"})
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO ()

-- | Sets the expression that is evaluated to obtain numbers from items.
-- 
-- Unless an expression is set on /@self@/, the sorter will always
-- compare items as invalid.
-- 
-- The expression must have a return type that can be compared
-- numerically, such as @/G_TYPE_INT/@ or @/G_TYPE_DOUBLE/@.
numericSorterSetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsNumericSorter a, Gtk.Expression.IsExpression b) =>
    a
    -- ^ /@self@/: a @GtkNumericSorter@
    -> Maybe (b)
    -- ^ /@expression@/: a @GtkExpression@
    -> m ()
numericSorterSetExpression self expression = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- unsafeManagedPtrCastPtr jExpression
            return jExpression'
    gtk_numeric_sorter_set_expression self' maybeExpression
    touchManagedPtr self
    whenJust expression touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data NumericSorterSetExpressionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsNumericSorter a, Gtk.Expression.IsExpression b) => O.OverloadedMethod NumericSorterSetExpressionMethodInfo a signature where
    overloadedMethod = numericSorterSetExpression

instance O.OverloadedMethodInfo NumericSorterSetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NumericSorter.numericSorterSetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NumericSorter.html#v:numericSorterSetExpression"
        })


#endif

-- method NumericSorter::set_sort_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "NumericSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNumericSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sort_order"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SortType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to sort smaller numbers first"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_numeric_sorter_set_sort_order" gtk_numeric_sorter_set_sort_order :: 
    Ptr NumericSorter ->                    -- self : TInterface (Name {namespace = "Gtk", name = "NumericSorter"})
    CUInt ->                                -- sort_order : TInterface (Name {namespace = "Gtk", name = "SortType"})
    IO ()

-- | Sets whether to sort smaller numbers before larger ones.
numericSorterSetSortOrder ::
    (B.CallStack.HasCallStack, MonadIO m, IsNumericSorter a) =>
    a
    -- ^ /@self@/: a @GtkNumericSorter@
    -> Gtk.Enums.SortType
    -- ^ /@sortOrder@/: whether to sort smaller numbers first
    -> m ()
numericSorterSetSortOrder self sortOrder = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let sortOrder' = (fromIntegral . fromEnum) sortOrder
    gtk_numeric_sorter_set_sort_order self' sortOrder'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data NumericSorterSetSortOrderMethodInfo
instance (signature ~ (Gtk.Enums.SortType -> m ()), MonadIO m, IsNumericSorter a) => O.OverloadedMethod NumericSorterSetSortOrderMethodInfo a signature where
    overloadedMethod = numericSorterSetSortOrder

instance O.OverloadedMethodInfo NumericSorterSetSortOrderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NumericSorter.numericSorterSetSortOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NumericSorter.html#v:numericSorterSetSortOrder"
        })


#endif


