{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A utility type for constructing container-type t'GVariant' instances.
-- 
-- This is an opaque structure and may only be accessed using the
-- following functions.
-- 
-- t'GI.GLib.Structs.VariantBuilder.VariantBuilder' is not threadsafe in any way.  Do not attempt to
-- access it from more than one thread.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.VariantBuilder
    ( 

-- * Exported types
    VariantBuilder(..)                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addValue]("GI.GLib.Structs.VariantBuilder#g:method:addValue"), [close]("GI.GLib.Structs.VariantBuilder#g:method:close"), [end]("GI.GLib.Structs.VariantBuilder#g:method:end"), [open]("GI.GLib.Structs.VariantBuilder#g:method:open"), [ref]("GI.GLib.Structs.VariantBuilder#g:method:ref"), [unref]("GI.GLib.Structs.VariantBuilder#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveVariantBuilderMethod             ,
#endif

-- ** addValue #method:addValue#

#if defined(ENABLE_OVERLOADING)
    VariantBuilderAddValueMethodInfo        ,
#endif
    variantBuilderAddValue                  ,


-- ** close #method:close#

#if defined(ENABLE_OVERLOADING)
    VariantBuilderCloseMethodInfo           ,
#endif
    variantBuilderClose                     ,


-- ** end #method:end#

#if defined(ENABLE_OVERLOADING)
    VariantBuilderEndMethodInfo             ,
#endif
    variantBuilderEnd                       ,


-- ** new #method:new#

    variantBuilderNew                       ,


-- ** open #method:open#

#if defined(ENABLE_OVERLOADING)
    VariantBuilderOpenMethodInfo            ,
#endif
    variantBuilderOpen                      ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    VariantBuilderRefMethodInfo             ,
#endif
    variantBuilderRef                       ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    VariantBuilderUnrefMethodInfo           ,
#endif
    variantBuilderUnref                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GLib.Structs.VariantType as GLib.VariantType

#else
import {-# SOURCE #-} qualified GI.GLib.Structs.VariantType as GLib.VariantType

#endif

-- | Memory-managed wrapper type.
newtype VariantBuilder = VariantBuilder (SP.ManagedPtr VariantBuilder)
    deriving (Eq)

instance SP.ManagedPtrNewtype VariantBuilder where
    toManagedPtr (VariantBuilder p) = p

foreign import ccall "g_variant_builder_get_type" c_g_variant_builder_get_type :: 
    IO GType

type instance O.ParentTypes VariantBuilder = '[]
instance O.HasParentTypes VariantBuilder

instance B.Types.TypedObject VariantBuilder where
    glibType = c_g_variant_builder_get_type

instance B.Types.GBoxed VariantBuilder

-- | Convert t'VariantBuilder' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe VariantBuilder) where
    gvalueGType_ = c_g_variant_builder_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr VariantBuilder)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr VariantBuilder)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed VariantBuilder ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList VariantBuilder
type instance O.AttributeList VariantBuilder = VariantBuilderAttributeList
type VariantBuilderAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method VariantBuilder::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a container type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "VariantBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_builder_new" g_variant_builder_new :: 
    Ptr GLib.VariantType.VariantType ->     -- type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    IO (Ptr VariantBuilder)

-- | Allocates and initialises a new t'GI.GLib.Structs.VariantBuilder.VariantBuilder'.
-- 
-- You should call 'GI.GLib.Structs.VariantBuilder.variantBuilderUnref' on the return value when it
-- is no longer needed.  The memory will not be automatically freed by
-- any other call.
-- 
-- In most cases it is easier to place a t'GI.GLib.Structs.VariantBuilder.VariantBuilder' directly on
-- the stack of the calling function and initialise it with
-- @/g_variant_builder_init_static()/@.
-- 
-- /Since: 2.24/
variantBuilderNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.VariantType.VariantType
    -- ^ /@type@/: a container type
    -> m VariantBuilder
    -- ^ __Returns:__ a t'GI.GLib.Structs.VariantBuilder.VariantBuilder'
variantBuilderNew type_ = liftIO $ do
    type_' <- unsafeManagedPtrGetPtr type_
    result <- g_variant_builder_new type_'
    checkUnexpectedReturnNULL "variantBuilderNew" result
    result' <- (wrapBoxed VariantBuilder) result
    touchManagedPtr type_
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method VariantBuilder::add_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariantBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariant" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_builder_add_value" g_variant_builder_add_value :: 
    Ptr VariantBuilder ->                   -- builder : TInterface (Name {namespace = "GLib", name = "VariantBuilder"})
    Ptr GVariant ->                         -- value : TVariant
    IO ()

-- | Adds /@value@/ to /@builder@/.
-- 
-- It is an error to call this function in any way that would create an
-- inconsistent value to be constructed.  Some examples of this are
-- putting different types of items into an array, putting the wrong
-- types or number of items in a tuple, putting more than one value into
-- a variant, etc.
-- 
-- If /@value@/ is a floating reference (see 'GI.GLib.Structs.Variant.variantRefSink'),
-- the /@builder@/ instance takes ownership of /@value@/.
-- 
-- /Since: 2.24/
variantBuilderAddValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    VariantBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.VariantBuilder.VariantBuilder'
    -> GVariant
    -- ^ /@value@/: a t'GVariant'
    -> m ()
variantBuilderAddValue builder value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    value' <- unsafeManagedPtrGetPtr value
    g_variant_builder_add_value builder' value'
    touchManagedPtr builder
    touchManagedPtr value
    return ()

#if defined(ENABLE_OVERLOADING)
data VariantBuilderAddValueMethodInfo
instance (signature ~ (GVariant -> m ()), MonadIO m) => O.OverloadedMethod VariantBuilderAddValueMethodInfo VariantBuilder signature where
    overloadedMethod = variantBuilderAddValue

instance O.OverloadedMethodInfo VariantBuilderAddValueMethodInfo VariantBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.VariantBuilder.variantBuilderAddValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-VariantBuilder.html#v:variantBuilderAddValue"
        })


#endif

-- method VariantBuilder::close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariantBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_builder_close" g_variant_builder_close :: 
    Ptr VariantBuilder ->                   -- builder : TInterface (Name {namespace = "GLib", name = "VariantBuilder"})
    IO ()

-- | Closes the subcontainer inside the given /@builder@/ that was opened by
-- the most recent call to 'GI.GLib.Structs.VariantBuilder.variantBuilderOpen'.
-- 
-- It is an error to call this function in any way that would create an
-- inconsistent value to be constructed (ie: too few values added to the
-- subcontainer).
-- 
-- /Since: 2.24/
variantBuilderClose ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    VariantBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.VariantBuilder.VariantBuilder'
    -> m ()
variantBuilderClose builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    g_variant_builder_close builder'
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data VariantBuilderCloseMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod VariantBuilderCloseMethodInfo VariantBuilder signature where
    overloadedMethod = variantBuilderClose

instance O.OverloadedMethodInfo VariantBuilderCloseMethodInfo VariantBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.VariantBuilder.variantBuilderClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-VariantBuilder.html#v:variantBuilderClose"
        })


#endif

-- method VariantBuilder::end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariantBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_builder_end" g_variant_builder_end :: 
    Ptr VariantBuilder ->                   -- builder : TInterface (Name {namespace = "GLib", name = "VariantBuilder"})
    IO (Ptr GVariant)

-- | Ends the builder process and returns the constructed value.
-- 
-- It is not permissible to use /@builder@/ in any way after this call
-- except for reference counting operations (in the case of a
-- heap-allocated t'GI.GLib.Structs.VariantBuilder.VariantBuilder') or by reinitialising it with
-- @/g_variant_builder_init()/@ (in the case of stack-allocated). This
-- means that for the stack-allocated builders there is no need to
-- call @/g_variant_builder_clear()/@ after the call to
-- 'GI.GLib.Structs.VariantBuilder.variantBuilderEnd'.
-- 
-- It is an error to call this function in any way that would create an
-- inconsistent value to be constructed (ie: insufficient number of
-- items added to a container with a specific number of children
-- required).  It is also an error to call this function if the builder
-- was created with an indefinite array or maybe type and no children
-- have been added; in this case it is impossible to infer the type of
-- the empty array.
-- 
-- /Since: 2.24/
variantBuilderEnd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    VariantBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.VariantBuilder.VariantBuilder'
    -> m GVariant
    -- ^ __Returns:__ a new, floating, t'GVariant'
variantBuilderEnd builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    result <- g_variant_builder_end builder'
    checkUnexpectedReturnNULL "variantBuilderEnd" result
    result' <- B.GVariant.newGVariantFromPtr result
    touchManagedPtr builder
    return result'

#if defined(ENABLE_OVERLOADING)
data VariantBuilderEndMethodInfo
instance (signature ~ (m GVariant), MonadIO m) => O.OverloadedMethod VariantBuilderEndMethodInfo VariantBuilder signature where
    overloadedMethod = variantBuilderEnd

instance O.OverloadedMethodInfo VariantBuilderEndMethodInfo VariantBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.VariantBuilder.variantBuilderEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-VariantBuilder.html#v:variantBuilderEnd"
        })


#endif

-- method VariantBuilder::open
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariantBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GVariantType of the container"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_builder_open" g_variant_builder_open :: 
    Ptr VariantBuilder ->                   -- builder : TInterface (Name {namespace = "GLib", name = "VariantBuilder"})
    Ptr GLib.VariantType.VariantType ->     -- type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    IO ()

-- | Opens a subcontainer inside the given /@builder@/.  When done adding
-- items to the subcontainer, 'GI.GLib.Structs.VariantBuilder.variantBuilderClose' must be called. /@type@/
-- is the type of the container: so to build a tuple of several values, /@type@/
-- must include the tuple itself.
-- 
-- It is an error to call this function in any way that would cause an
-- inconsistent value to be constructed (ie: adding too many values or
-- a value of an incorrect type).
-- 
-- Example of building a nested variant:
-- 
-- === /C code/
-- >
-- >GVariantBuilder builder;
-- >guint32 some_number = get_number ();
-- >g_autoptr (GHashTable) some_dict = get_dict ();
-- >GHashTableIter iter;
-- >const gchar *key;
-- >const GVariant *value;
-- >g_autoptr (GVariant) output = NULL;
-- >
-- >g_variant_builder_init (&builder, G_VARIANT_TYPE ("(ua{sv})"));
-- >g_variant_builder_add (&builder, "u", some_number);
-- >g_variant_builder_open (&builder, G_VARIANT_TYPE ("a{sv}"));
-- >
-- >g_hash_table_iter_init (&iter, some_dict);
-- >while (g_hash_table_iter_next (&iter, (gpointer *) &key, (gpointer *) &value))
-- >  {
-- >    g_variant_builder_open (&builder, G_VARIANT_TYPE ("{sv}"));
-- >    g_variant_builder_add (&builder, "s", key);
-- >    g_variant_builder_add (&builder, "v", value);
-- >    g_variant_builder_close (&builder);
-- >  }
-- >
-- >g_variant_builder_close (&builder);
-- >
-- >output = g_variant_builder_end (&builder);
-- 
-- 
-- /Since: 2.24/
variantBuilderOpen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    VariantBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.VariantBuilder.VariantBuilder'
    -> GLib.VariantType.VariantType
    -- ^ /@type@/: the t'GI.GLib.Structs.VariantType.VariantType' of the container
    -> m ()
variantBuilderOpen builder type_ = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    type_' <- unsafeManagedPtrGetPtr type_
    g_variant_builder_open builder' type_'
    touchManagedPtr builder
    touchManagedPtr type_
    return ()

#if defined(ENABLE_OVERLOADING)
data VariantBuilderOpenMethodInfo
instance (signature ~ (GLib.VariantType.VariantType -> m ()), MonadIO m) => O.OverloadedMethod VariantBuilderOpenMethodInfo VariantBuilder signature where
    overloadedMethod = variantBuilderOpen

instance O.OverloadedMethodInfo VariantBuilderOpenMethodInfo VariantBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.VariantBuilder.variantBuilderOpen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-VariantBuilder.html#v:variantBuilderOpen"
        })


#endif

-- method VariantBuilder::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GVariantBuilder allocated by g_variant_builder_new()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "VariantBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_builder_ref" g_variant_builder_ref :: 
    Ptr VariantBuilder ->                   -- builder : TInterface (Name {namespace = "GLib", name = "VariantBuilder"})
    IO (Ptr VariantBuilder)

-- | Increases the reference count on /@builder@/.
-- 
-- Don\'t call this on stack-allocated t'GI.GLib.Structs.VariantBuilder.VariantBuilder' instances or bad
-- things will happen.
-- 
-- /Since: 2.24/
variantBuilderRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    VariantBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.VariantBuilder.VariantBuilder' allocated by 'GI.GLib.Structs.VariantBuilder.variantBuilderNew'
    -> m VariantBuilder
    -- ^ __Returns:__ a new reference to /@builder@/
variantBuilderRef builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    result <- g_variant_builder_ref builder'
    checkUnexpectedReturnNULL "variantBuilderRef" result
    result' <- (wrapBoxed VariantBuilder) result
    touchManagedPtr builder
    return result'

#if defined(ENABLE_OVERLOADING)
data VariantBuilderRefMethodInfo
instance (signature ~ (m VariantBuilder), MonadIO m) => O.OverloadedMethod VariantBuilderRefMethodInfo VariantBuilder signature where
    overloadedMethod = variantBuilderRef

instance O.OverloadedMethodInfo VariantBuilderRefMethodInfo VariantBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.VariantBuilder.variantBuilderRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-VariantBuilder.html#v:variantBuilderRef"
        })


#endif

-- method VariantBuilder::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GVariantBuilder allocated by g_variant_builder_new()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_builder_unref" g_variant_builder_unref :: 
    Ptr VariantBuilder ->                   -- builder : TInterface (Name {namespace = "GLib", name = "VariantBuilder"})
    IO ()

-- | Decreases the reference count on /@builder@/.
-- 
-- In the event that there are no more references, releases all memory
-- associated with the t'GI.GLib.Structs.VariantBuilder.VariantBuilder'.
-- 
-- Don\'t call this on stack-allocated t'GI.GLib.Structs.VariantBuilder.VariantBuilder' instances or bad
-- things will happen.
-- 
-- /Since: 2.24/
variantBuilderUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    VariantBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.VariantBuilder.VariantBuilder' allocated by 'GI.GLib.Structs.VariantBuilder.variantBuilderNew'
    -> m ()
variantBuilderUnref builder = liftIO $ do
    builder' <- B.ManagedPtr.disownBoxed builder
    g_variant_builder_unref builder'
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data VariantBuilderUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod VariantBuilderUnrefMethodInfo VariantBuilder signature where
    overloadedMethod = variantBuilderUnref

instance O.OverloadedMethodInfo VariantBuilderUnrefMethodInfo VariantBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.VariantBuilder.variantBuilderUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-VariantBuilder.html#v:variantBuilderUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveVariantBuilderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVariantBuilderMethod "addValue" o = VariantBuilderAddValueMethodInfo
    ResolveVariantBuilderMethod "close" o = VariantBuilderCloseMethodInfo
    ResolveVariantBuilderMethod "end" o = VariantBuilderEndMethodInfo
    ResolveVariantBuilderMethod "open" o = VariantBuilderOpenMethodInfo
    ResolveVariantBuilderMethod "ref" o = VariantBuilderRefMethodInfo
    ResolveVariantBuilderMethod "unref" o = VariantBuilderUnrefMethodInfo
    ResolveVariantBuilderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVariantBuilderMethod t VariantBuilder, O.OverloadedMethod info VariantBuilder p) => OL.IsLabel t (VariantBuilder -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVariantBuilderMethod t VariantBuilder, O.OverloadedMethod info VariantBuilder p, R.HasField t VariantBuilder p) => R.HasField t VariantBuilder p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVariantBuilderMethod t VariantBuilder, O.OverloadedMethodInfo info VariantBuilder) => OL.IsLabel t (O.MethodProxy info VariantBuilder) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


