// Code generated by astool. DO NOT EDIT.

package propertyfocalpoint

import (
	float "code.superseriousbusiness.org/activity/streams/values/float"
	vocab "code.superseriousbusiness.org/activity/streams/vocab"
	"fmt"
	"net/url"
)

// TootFocalPointPropertyIterator is an iterator for a property. It is permitted
// to be a single default-valued value type.
type TootFocalPointPropertyIterator struct {
	xmlschemaFloatMember float64
	hasFloatMember       bool
	unknown              interface{}
	iri                  *url.URL
	alias                string
	myIdx                int
	parent               vocab.TootFocalPointProperty
}

// NewTootFocalPointPropertyIterator creates a new TootFocalPoint property.
func NewTootFocalPointPropertyIterator() *TootFocalPointPropertyIterator {
	return &TootFocalPointPropertyIterator{alias: ""}
}

// deserializeTootFocalPointPropertyIterator creates an iterator from an element
// that has been unmarshalled from a text or binary format.
func deserializeTootFocalPointPropertyIterator(i interface{}, aliasMap map[string]string) (*TootFocalPointPropertyIterator, error) {
	alias := ""
	if a, ok := aliasMap["http://joinmastodon.org/ns"]; ok {
		alias = a
	}
	if s, ok := i.(string); ok {
		u, err := url.Parse(s)
		// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
		// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
		if err == nil && len(u.Scheme) > 0 {
			this := &TootFocalPointPropertyIterator{
				alias: alias,
				iri:   u,
			}
			return this, nil
		}
	}
	if v, err := float.DeserializeFloat(i); err == nil {
		this := &TootFocalPointPropertyIterator{
			alias:                alias,
			hasFloatMember:       true,
			xmlschemaFloatMember: v,
		}
		return this, nil
	}
	this := &TootFocalPointPropertyIterator{
		alias:   alias,
		unknown: i,
	}
	return this, nil
}

// Get returns the value of this property. When IsXMLSchemaFloat returns false,
// Get will return any arbitrary value.
func (this TootFocalPointPropertyIterator) Get() float64 {
	return this.xmlschemaFloatMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return any arbitrary value.
func (this TootFocalPointPropertyIterator) GetIRI() *url.URL {
	return this.iri
}

// HasAny returns true if the value or IRI is set.
func (this TootFocalPointPropertyIterator) HasAny() bool {
	return this.IsXMLSchemaFloat() || this.iri != nil
}

// IsIRI returns true if this property is an IRI.
func (this TootFocalPointPropertyIterator) IsIRI() bool {
	return this.iri != nil
}

// IsXMLSchemaFloat returns true if this property is set and not an IRI.
func (this TootFocalPointPropertyIterator) IsXMLSchemaFloat() bool {
	return this.hasFloatMember
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this TootFocalPointPropertyIterator) JSONLDContext() map[string]string {
	m := map[string]string{"http://joinmastodon.org/ns": this.alias}
	var child map[string]string

	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this TootFocalPointPropertyIterator) KindIndex() int {
	if this.IsXMLSchemaFloat() {
		return 0
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this TootFocalPointPropertyIterator) LessThan(o vocab.TootFocalPointPropertyIterator) bool {
	// LessThan comparison for if either or both are IRIs.
	if this.IsIRI() && o.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	} else if this.IsIRI() {
		// IRIs are always less than other values, none, or unknowns
		return true
	} else if o.IsIRI() {
		// This other, none, or unknown value is always greater than IRIs
		return false
	}
	// LessThan comparison for the single value or unknown value.
	if !this.IsXMLSchemaFloat() && !o.IsXMLSchemaFloat() {
		// Both are unknowns.
		return false
	} else if this.IsXMLSchemaFloat() && !o.IsXMLSchemaFloat() {
		// Values are always greater than unknown values.
		return false
	} else if !this.IsXMLSchemaFloat() && o.IsXMLSchemaFloat() {
		// Unknowns are always less than known values.
		return true
	} else {
		// Actual comparison.
		return float.LessFloat(this.Get(), o.Get())
	}
}

// Name returns the name of this property: "TootFocalPoint".
func (this TootFocalPointPropertyIterator) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "TootFocalPoint"
	} else {
		return "TootFocalPoint"
	}
}

// Next returns the next iterator, or nil if there is no next iterator.
func (this TootFocalPointPropertyIterator) Next() vocab.TootFocalPointPropertyIterator {
	if this.myIdx+1 >= this.parent.Len() {
		return nil
	} else {
		return this.parent.At(this.myIdx + 1)
	}
}

// Prev returns the previous iterator, or nil if there is no previous iterator.
func (this TootFocalPointPropertyIterator) Prev() vocab.TootFocalPointPropertyIterator {
	if this.myIdx-1 < 0 {
		return nil
	} else {
		return this.parent.At(this.myIdx - 1)
	}
}

// Set sets the value of this property. Calling IsXMLSchemaFloat afterwards will
// return true.
func (this *TootFocalPointPropertyIterator) Set(v float64) {
	this.clear()
	this.xmlschemaFloatMember = v
	this.hasFloatMember = true
}

// SetIRI sets the value of this property. Calling IsIRI afterwards will return
// true.
func (this *TootFocalPointPropertyIterator) SetIRI(v *url.URL) {
	this.clear()
	this.iri = v
}

// clear ensures no value of this property is set. Calling IsXMLSchemaFloat
// afterwards will return false.
func (this *TootFocalPointPropertyIterator) clear() {
	this.unknown = nil
	this.iri = nil
	this.hasFloatMember = false
}

// serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this TootFocalPointPropertyIterator) serialize() (interface{}, error) {
	if this.IsXMLSchemaFloat() {
		return float.SerializeFloat(this.Get())
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// TootFocalPointProperty is the non-functional property "focalPoint". It is
// permitted to have one or more values, and of different value types.
type TootFocalPointProperty struct {
	properties []*TootFocalPointPropertyIterator
	alias      string
}

// DeserializeFocalPointProperty creates a "focalPoint" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeFocalPointProperty(m map[string]interface{}, aliasMap map[string]string) (vocab.TootFocalPointProperty, error) {
	alias := ""
	if a, ok := aliasMap["http://joinmastodon.org/ns"]; ok {
		alias = a
	}
	propName := "focalPoint"
	if len(alias) > 0 {
		propName = fmt.Sprintf("%s:%s", alias, "focalPoint")
	}
	i, ok := m[propName]

	if ok {
		this := &TootFocalPointProperty{
			alias:      alias,
			properties: []*TootFocalPointPropertyIterator{},
		}
		if list, ok := i.([]interface{}); ok {
			for _, iterator := range list {
				if p, err := deserializeTootFocalPointPropertyIterator(iterator, aliasMap); err != nil {
					return this, err
				} else if p != nil {
					this.properties = append(this.properties, p)
				}
			}
		} else {
			if p, err := deserializeTootFocalPointPropertyIterator(i, aliasMap); err != nil {
				return this, err
			} else if p != nil {
				this.properties = append(this.properties, p)
			}
		}
		// Set up the properties for iteration.
		for idx, ele := range this.properties {
			ele.parent = this
			ele.myIdx = idx
		}
		return this, nil
	}
	return nil, nil
}

// NewTootFocalPointProperty creates a new focalPoint property.
func NewTootFocalPointProperty() *TootFocalPointProperty {
	return &TootFocalPointProperty{alias: ""}
}

// AppendIRI appends an IRI value to the back of a list of the property
// "focalPoint"
func (this *TootFocalPointProperty) AppendIRI(v *url.URL) {
	this.properties = append(this.properties, &TootFocalPointPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendXMLSchemaFloat appends a float value to the back of a list of the
// property "focalPoint". Invalidates iterators that are traversing using Prev.
func (this *TootFocalPointProperty) AppendXMLSchemaFloat(v float64) {
	this.properties = append(this.properties, &TootFocalPointPropertyIterator{
		alias:                this.alias,
		hasFloatMember:       true,
		myIdx:                this.Len(),
		parent:               this,
		xmlschemaFloatMember: v,
	})
}

// At returns the property value for the specified index. Panics if the index is
// out of bounds.
func (this TootFocalPointProperty) At(index int) vocab.TootFocalPointPropertyIterator {
	return this.properties[index]
}

// Begin returns the first iterator, or nil if empty. Can be used with the
// iterator's Next method and this property's End method to iterate from front
// to back through all values.
func (this TootFocalPointProperty) Begin() vocab.TootFocalPointPropertyIterator {
	if this.Empty() {
		return nil
	} else {
		return this.properties[0]
	}
}

// Empty returns returns true if there are no elements.
func (this TootFocalPointProperty) Empty() bool {
	return this.Len() == 0
}

// End returns beyond-the-last iterator, which is nil. Can be used with the
// iterator's Next method and this property's Begin method to iterate from
// front to back through all values.
func (this TootFocalPointProperty) End() vocab.TootFocalPointPropertyIterator {
	return nil
}

// Insert inserts an IRI value at the specified index for a property "focalPoint".
// Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *TootFocalPointProperty) InsertIRI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &TootFocalPointPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertXMLSchemaFloat inserts a float value at the specified index for a
// property "focalPoint". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *TootFocalPointProperty) InsertXMLSchemaFloat(idx int, v float64) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &TootFocalPointPropertyIterator{
		alias:                this.alias,
		hasFloatMember:       true,
		myIdx:                idx,
		parent:               this,
		xmlschemaFloatMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this TootFocalPointProperty) JSONLDContext() map[string]string {
	m := map[string]string{"http://joinmastodon.org/ns": this.alias}
	for _, elem := range this.properties {
		child := elem.JSONLDContext()
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		for k, v := range child {
			m[k] = v
		}
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API method specifically needed only for alternate implementations
// for go-fed. Applications should not use this method. Panics if the index is
// out of bounds.
func (this TootFocalPointProperty) KindIndex(idx int) int {
	return this.properties[idx].KindIndex()
}

// Len returns the number of values that exist for the "focalPoint" property.
func (this TootFocalPointProperty) Len() (length int) {
	return len(this.properties)
}

// Less computes whether another property is less than this one. Mixing types
// results in a consistent but arbitrary ordering
func (this TootFocalPointProperty) Less(i, j int) bool {
	idx1 := this.KindIndex(i)
	idx2 := this.KindIndex(j)
	if idx1 < idx2 {
		return true
	} else if idx1 == idx2 {
		if idx1 == 0 {
			lhs := this.properties[i].Get()
			rhs := this.properties[j].Get()
			return float.LessFloat(lhs, rhs)
		} else if idx1 == -2 {
			lhs := this.properties[i].GetIRI()
			rhs := this.properties[j].GetIRI()
			return lhs.String() < rhs.String()
		}
	}
	return false
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this TootFocalPointProperty) LessThan(o vocab.TootFocalPointProperty) bool {
	l1 := this.Len()
	l2 := o.Len()
	l := l1
	if l2 < l1 {
		l = l2
	}
	for i := 0; i < l; i++ {
		if this.properties[i].LessThan(o.At(i)) {
			return true
		} else if o.At(i).LessThan(this.properties[i]) {
			return false
		}
	}
	return l1 < l2
}

// Name returns the name of this property ("focalPoint") with any alias.
func (this TootFocalPointProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "focalPoint"
	} else {
		return "focalPoint"
	}
}

// PrependIRI prepends an IRI value to the front of a list of the property
// "focalPoint".
func (this *TootFocalPointProperty) PrependIRI(v *url.URL) {
	this.properties = append([]*TootFocalPointPropertyIterator{{
		alias:  this.alias,
		iri:    v,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependXMLSchemaFloat prepends a float value to the front of a list of the
// property "focalPoint". Invalidates all iterators.
func (this *TootFocalPointProperty) PrependXMLSchemaFloat(v float64) {
	this.properties = append([]*TootFocalPointPropertyIterator{{
		alias:                this.alias,
		hasFloatMember:       true,
		myIdx:                0,
		parent:               this,
		xmlschemaFloatMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Remove deletes an element at the specified index from a list of the property
// "focalPoint", regardless of its type. Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *TootFocalPointProperty) Remove(idx int) {
	(this.properties)[idx].parent = nil
	copy((this.properties)[idx:], (this.properties)[idx+1:])
	(this.properties)[len(this.properties)-1] = &TootFocalPointPropertyIterator{}
	this.properties = (this.properties)[:len(this.properties)-1]
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this TootFocalPointProperty) Serialize() (interface{}, error) {
	s := make([]interface{}, 0, len(this.properties))
	for _, iterator := range this.properties {
		if b, err := iterator.serialize(); err != nil {
			return s, err
		} else {
			s = append(s, b)
		}
	}
	// Shortcut: if serializing one value, don't return an array -- pretty sure other Fediverse software would choke on a "type" value with array, for example.
	if len(s) == 1 {
		return s[0], nil
	}
	return s, nil
}

// Set sets a float value to be at the specified index for the property
// "focalPoint". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *TootFocalPointProperty) Set(idx int, v float64) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &TootFocalPointPropertyIterator{
		alias:                this.alias,
		hasFloatMember:       true,
		myIdx:                idx,
		parent:               this,
		xmlschemaFloatMember: v,
	}
}

// SetIRI sets an IRI value to be at the specified index for the property
// "focalPoint". Panics if the index is out of bounds.
func (this *TootFocalPointProperty) SetIRI(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &TootFocalPointPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
}

// Swap swaps the location of values at two indices for the "focalPoint" property.
func (this TootFocalPointProperty) Swap(i, j int) {
	this.properties[i], this.properties[j] = this.properties[j], this.properties[i]
}
