//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBTransactionChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/indexedDB/PBackgroundIDBCursorChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseFileChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBRequestChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBTransactionChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBTransactionChild::PBackgroundIDBTransactionChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBTransactionChild);
}

PBackgroundIDBTransactionChild::~PBackgroundIDBTransactionChild()
{
    MOZ_COUNT_DTOR(PBackgroundIDBTransactionChild);
}

auto PBackgroundIDBTransactionChild::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBTransactionChild::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBTransactionChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBTransactionChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBTransactionChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBTransactionChild::Manager() const -> PBackgroundIDBDatabaseChild*
{
    return static_cast<PBackgroundIDBDatabaseChild*>(IProtocol::Manager());
}

auto PBackgroundIDBTransactionChild::ManagedPBackgroundIDBCursorChild(nsTArray<PBackgroundIDBCursorChild*>& aArr) const -> void
{
    mManagedPBackgroundIDBCursorChild.ToArray(aArr);
}

auto PBackgroundIDBTransactionChild::ManagedPBackgroundIDBCursorChild() const -> const ManagedContainer<PBackgroundIDBCursorChild>&
{
    return mManagedPBackgroundIDBCursorChild;
}

auto PBackgroundIDBTransactionChild::ManagedPBackgroundIDBRequestChild(nsTArray<PBackgroundIDBRequestChild*>& aArr) const -> void
{
    mManagedPBackgroundIDBRequestChild.ToArray(aArr);
}

auto PBackgroundIDBTransactionChild::ManagedPBackgroundIDBRequestChild() const -> const ManagedContainer<PBackgroundIDBRequestChild>&
{
    return mManagedPBackgroundIDBRequestChild;
}

auto PBackgroundIDBTransactionChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundIDBCursorMsgStart,
        PBackgroundIDBRequestMsgStart
    };
    return sIds;
}

auto PBackgroundIDBTransactionChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundIDBCursorMsgStart:
        return (&(mManagedPBackgroundIDBCursorChild));
    case PBackgroundIDBRequestMsgStart:
        return (&(mManagedPBackgroundIDBRequestChild));
    default:
        return nullptr;
    }
}

auto PBackgroundIDBTransactionChild::OpenPBackgroundIDBCursorEndpoint(PBackgroundIDBCursorChild* aActor) -> ManagedEndpoint<PBackgroundIDBCursorParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBCursorChild actor");
        return ManagedEndpoint<PBackgroundIDBCursorParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBCursorChild actor");
        return ManagedEndpoint<PBackgroundIDBCursorParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBCursorParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBTransactionChild::BindPBackgroundIDBCursorEndpoint(
        ManagedEndpoint<PBackgroundIDBCursorChild> aEndpoint,
        PBackgroundIDBCursorChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBTransactionChild::OpenPBackgroundIDBRequestEndpoint(PBackgroundIDBRequestChild* aActor) -> ManagedEndpoint<PBackgroundIDBRequestParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBRequestChild actor");
        return ManagedEndpoint<PBackgroundIDBRequestParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBRequestChild actor");
        return ManagedEndpoint<PBackgroundIDBRequestParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBRequestParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBTransactionChild::BindPBackgroundIDBRequestEndpoint(
        ManagedEndpoint<PBackgroundIDBRequestChild> aEndpoint,
        PBackgroundIDBRequestChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBTransactionChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBTransaction::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBTransactionChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBTransactionChild::SendCommit(const mozilla::Maybe<int64_t>& lastRequest) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBTransaction::Msg_Commit(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), lastRequest);
    // Sentinel = 'lastRequest'
    ((&(writer__)))->WriteSentinel(458359966);


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBTransactionChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_Commit", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBTransactionChild::SendAbort(const nsresult& resultCode) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBTransaction::Msg_Abort(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), resultCode);
    // Sentinel = 'resultCode'
    ((&(writer__)))->WriteSentinel(388498459);


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBTransactionChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_Abort", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBTransactionChild::SendPBackgroundIDBCursorConstructor(
        PBackgroundIDBCursorChild* actor,
        const int64_t& requestId,
        const OpenCursorParams& params) -> PBackgroundIDBCursorChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundIDBCursorChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBCursorChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBTransaction::Msg_PBackgroundIDBCursorConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), requestId);
    // Sentinel = 'requestId'
    ((&(writer__)))->WriteSentinel(320799671);
    IPC::WriteParam((&(writer__)), params);
    // Sentinel = 'params'
    ((&(writer__)))->WriteSentinel(146997893);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBTransactionChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_PBackgroundIDBCursorConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundIDBCursorChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundIDBTransactionChild::SendPBackgroundIDBRequestConstructor(
        const int64_t& requestId,
        const RequestParams& params) -> PBackgroundIDBRequestChild*
{
    PBackgroundIDBRequestChild* actor = (static_cast<indexedDB::BackgroundTransactionChild*>(this))->AllocPBackgroundIDBRequestChild(requestId, params);
    return SendPBackgroundIDBRequestConstructor(std::move(actor), std::move(requestId), std::move(params));
}

auto PBackgroundIDBTransactionChild::SendPBackgroundIDBRequestConstructor(
        PBackgroundIDBRequestChild* actor,
        const int64_t& requestId,
        const RequestParams& params) -> PBackgroundIDBRequestChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundIDBRequestChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBRequestChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBTransaction::Msg_PBackgroundIDBRequestConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), requestId);
    // Sentinel = 'requestId'
    ((&(writer__)))->WriteSentinel(320799671);
    IPC::WriteParam((&(writer__)), params);
    // Sentinel = 'params'
    ((&(writer__)))->WriteSentinel(146997893);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBTransactionChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_PBackgroundIDBRequestConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundIDBRequestChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundIDBTransactionChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundIDBRequestMsgStart:
        static_cast<indexedDB::BackgroundTransactionChild*>(this)->DeallocPBackgroundIDBRequestChild(static_cast<PBackgroundIDBRequestChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundIDBTransactionChild::OnMessageReceived(const Message& msg__) -> PBackgroundIDBTransactionChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Reply_PBackgroundIDBCursorConstructor__ID:
        {
            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Reply_PBackgroundIDBRequestConstructor__ID:
        {
            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBTransactionChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundTransactionChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PBackgroundIDBTransaction::Msg_Complete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBTransaction", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBTransactionChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBTransaction::Msg_Complete", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__result = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__result) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& result = *maybe__result;
            // Sentinel = 'result'
            if ((!(((&(reader__)))->ReadSentinel(153223840)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundTransactionChild*>(this))->RecvComplete(std::move(result));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBTransactionChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBTransactionChild::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBTransactionChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundIDBTransaction'
    (aWriter)->WriteSentinel(2047740326);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBTransactionChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundIDBTransaction actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundIDBTransaction'
    if ((!((aReader)->ReadSentinel(2047740326)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundIDBTransaction actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundIDBTransactionMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundIDBTransaction)");

        return {};
    }
    return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBTransactionChild*>(actor);
}

} // namespace IPC
